/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.tree;

import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import com.ef_prime.rflow.core.common.tree.LazyGeneralTreeNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.ObjectUtils;

public class UIGeneralTreeNode
implements MutableTreeNode {
    private GeneralTreeNode element;
    private UIGeneralTreeNode parent;
    private List<MutableTreeNode> children = new ArrayList<MutableTreeNode>();

    public UIGeneralTreeNode(GeneralTreeNode generalTreeNode) {
        this.element = generalTreeNode;
    }

    public GeneralTreeNode getElement() {
        return this.element;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        GeneralTreeNode generalTreeNode = ((UIGeneralTreeNode)mutableTreeNode).getElement();
        this.element.insertChild(n, generalTreeNode);
        this.children.add(n, mutableTreeNode);
    }

    @Override
    public void remove(int n) {
        this.element.removeChild(n);
        this.children.remove(n);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        GeneralTreeNode generalTreeNode = ((UIGeneralTreeNode)mutableTreeNode).getElement();
        this.element.removeChild(generalTreeNode);
        this.children.remove(mutableTreeNode);
    }

    @Override
    public void removeFromParent() {
        GeneralTreeNode generalTreeNode = this.element.getParent();
        generalTreeNode.removeChild(this.element);
        this.parent.children.remove(this);
        this.parent = null;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.removeFromParent();
        GeneralTreeNode generalTreeNode = ((UIGeneralTreeNode)mutableTreeNode).getElement();
        generalTreeNode.addChild(this.element);
        this.parent.children.add(this);
        this.parent = (UIGeneralTreeNode)mutableTreeNode;
    }

    @Override
    public void setUserObject(Object object) {
        this.element.setObject(object);
    }

    @Override
    public Enumeration<? extends TreeNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.element.allowsChildren();
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return !this.element.allowsChildren();
    }

    public String toString() {
        return this.element.getDisplayString();
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UIGeneralTreeNode)) {
            return false;
        }
        return ObjectUtils.equals((Object)((UIGeneralTreeNode)object).element, (Object)this.element);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(Predicate<GeneralTreeNode> predicate) {
        if (this.getElement() instanceof LazyGeneralTreeNode) {
            LazyGeneralTreeNode lazyGeneralTreeNode = (LazyGeneralTreeNode)this.getElement();
            lazyGeneralTreeNode.removeChildren();
            lazyGeneralTreeNode.createChildren();
        }
        this.update(predicate);
    }

    public void update() {
        this.update(null);
    }

    public void update(Predicate<GeneralTreeNode> predicate) {
        ArrayDeque<UIGeneralTreeNode> arrayDeque = new ArrayDeque<UIGeneralTreeNode>();
        arrayDeque.add(this);
        while (!arrayDeque.isEmpty()) {
            UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)arrayDeque.removeFirst();
            uIGeneralTreeNode.children.clear();
            for (GeneralTreeNode generalTreeNode : uIGeneralTreeNode.getElement()) {
                if (predicate != null && !predicate.test(generalTreeNode)) continue;
                UIGeneralTreeNode uIGeneralTreeNode2 = new UIGeneralTreeNode(generalTreeNode);
                uIGeneralTreeNode.children.add(uIGeneralTreeNode2);
                uIGeneralTreeNode2.parent = uIGeneralTreeNode;
                arrayDeque.add(uIGeneralTreeNode2);
            }
        }
    }

    public static UIGeneralTreeNode build(GeneralTreeNode generalTreeNode) {
        return UIGeneralTreeNode.build(generalTreeNode, null);
    }

    public static UIGeneralTreeNode build(GeneralTreeNode generalTreeNode, Predicate<GeneralTreeNode> predicate) {
        UIGeneralTreeNode uIGeneralTreeNode = new UIGeneralTreeNode(generalTreeNode);
        uIGeneralTreeNode.update(predicate);
        return uIGeneralTreeNode;
    }
}

