/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.view;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class OptionView
extends LazyLoadView {
    private static final String OK = "OK";
    private static final String CANCEL = "CANCEL";
    private JDialog dialog;
    protected JComponent component;

    protected OptionView() {
        this((JComponent)null);
    }

    public OptionView(JComponent jComponent) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.component = jComponent;
    }

    @Override
    protected void loadContent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        if (this.component != null) {
            this.add((Component)this.component, "Center");
        }
        this.add((Component)this.createButtons(), "South");
    }

    protected JComponent createComponent() {
        throw new RuntimeException("Must override this method.");
    }

    protected JComponent createButtons() {
        Action[] actionArray;
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 10 0 0 0, fill, nogrid, alignx right"));
        String string = "w 120, alignx right";
        for (Action action : actionArray = this.createButtonActions()) {
            JButton jButton = new JButton(action);
            jPanel.add((Component)jButton, string);
        }
        return jPanel;
    }

    protected Action[] createButtonActions() {
        return new Action[]{new OkAction(), new CancelAction()};
    }

    protected void buttonPressed(Action action) {
        if (CANCEL.equals(action.getValue("ActionCommandKey"))) {
            this.close();
        }
    }

    protected void close() {
        if (this.dialog == null) {
            this.closeTab();
        } else {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public JDialog createDialog(Component component, String string, boolean bl, Dimension dimension) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        return this.createDialog(window, string, bl, dimension);
    }

    public JDialog createDialog(Window window, String string, boolean bl, Dimension dimension) {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new JDialog(window, string, bl ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add(this);
        if (dimension == null) {
            this.dialog.pack();
        } else {
            this.dialog.setSize(dimension);
        }
        this.dialog.setLocationRelativeTo(window);
        return this.dialog;
    }

    public void showDialog(Component component, String string, boolean bl, Dimension dimension) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        this.createDialog(component, string, bl, dimension);
        this.dialog.setVisible(true);
    }

    protected class OkAction
    extends AbstractAction {
        public OkAction() {
            this.putValue("Name", Messages.getString("Button.ok"));
            this.putValue("SmallIcon", Icons.getIcon("16/tick.png"));
            this.putValue("ActionCommandKey", OptionView.OK);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OptionView.this.buttonPressed(this);
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", Messages.getString("Button.cancel"));
            this.putValue("SmallIcon", Icons.getIcon("16/cross.png"));
            this.putValue("ActionCommandKey", OptionView.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OptionView.this.buttonPressed(this);
        }
    }
}

