/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.view;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.SwitchViewPanel;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PageEvent;
import com.ef_prime.rflow.ui.common.view.PageEventHandler;
import com.ef_prime.rflow.ui.common.view.PagesViewEvent;
import com.ef_prime.rflow.ui.common.view.PagesViewEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class PagesView
extends View
implements ActionListener,
PageEventHandler {
    private static final Logger LOGGER = Logger.getLogger(PagesView.class.getName());
    private Deque<Page> pageStack = new ArrayDeque<Page>();
    private SwitchViewPanel switchPanel;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton cancelButton;
    protected static final String BACK = "BACK";
    protected static final String NEXT = "NEXT";
    protected static final String CANCEL = "CANCEL";
    private JDialog dialog;
    public static final int RESULT_NONE = 0;
    public static final int RESULT_OK = 1;
    public static final int RESULT_CANCELED = 2;
    protected int result = 0;
    private EventSupport<PagesViewEvent, PagesViewEventHandler> eventSupport = new EventSupport();

    protected PagesView() {
        this((Page)null);
    }

    public PagesView(Page page) {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.switchPanel = new SwitchViewPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.switchPanel, "Center");
        this.addButtons();
        if (page == null) {
            page = this.buildInitialPage();
        }
        if (page != null) {
            this.setPage(page);
        }
    }

    protected void addButtons() {
        this.add(this.createButtons(), "South");
    }

    protected Page buildInitialPage() {
        return null;
    }

    public int getResult() {
        return this.result;
    }

    public void goNext() {
        this.next();
    }

    protected Page getCurrentPage() {
        return this.pageStack.peek();
    }

    protected void setPage(Page page) {
        if (!this.pageStack.isEmpty()) {
            this.pageStack.peek().removePageEventHandler(this);
        }
        page.addPageEventHandler(this);
        this.pageStack.push(page);
        this.switchPanel.set(this.createContent(page));
        this.refreshButtons();
    }

    public void refreshButtons() {
        if (this.backButton != null) {
            this.backButton.setVisible(this.pageStack.size() > 1);
        }
        if (this.nextButton != null) {
            if (this.getCurrentPage().hasNextPage()) {
                this.nextButton.setText(this.getNextButtonTitle());
                this.nextButton.setIcon(this.getNextButtonIcon());
            } else {
                this.nextButton.setText(this.getFinishButtonTitle());
                this.nextButton.setIcon(this.getFinishButtonIcon());
            }
            this.nextButton.setEnabled(this.getCurrentPage().canGoNext());
        }
    }

    protected Component createContent(Page page) {
        return page;
    }

    protected Component createButtons() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 10 0 0 0, fill", "[grow][][]"));
        String string = "w 120";
        this.backButton = this.createBackButton();
        this.nextButton = this.createNextButton();
        this.cancelButton = this.createCancelButton();
        jPanel.add((Component)this.backButton, "alignx right, " + string);
        jPanel.add((Component)this.nextButton, string);
        jPanel.add((Component)this.cancelButton, string);
        return jPanel;
    }

    protected JButton createButton(String string, String string2, String string3) {
        JButton jButton = new JButton(string);
        jButton.setIcon(Icons.getIcon(string2));
        jButton.setActionCommand(string3);
        jButton.addActionListener(this);
        return jButton;
    }

    protected JButton createBackButton() {
        return this.createButton(Messages.getString("Action.back"), "16/resultset_previous.png", BACK);
    }

    protected JButton createNextButton() {
        return this.createButton(this.getNextButtonTitle(), "16/resultset_next.png", NEXT);
    }

    protected JButton createCancelButton() {
        return this.createButton(Messages.getString("Button.cancel"), "16/cross.png", CANCEL);
    }

    protected String getNextButtonTitle() {
        return Messages.getString("Action.next");
    }

    protected String getFinishButtonTitle() {
        return Messages.getString("Button.ok") + " ";
    }

    protected Icon getNextButtonIcon() {
        return Icons.getIcon("16/resultset_next.png");
    }

    protected Icon getFinishButtonIcon() {
        return Icons.getIcon("16/tick.png");
    }

    @Override
    public Object getKey() {
        return this;
    }

    @Override
    public boolean isClosable() {
        return true;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals(BACK)) {
            this.back();
        } else if (string.equals(NEXT)) {
            this.next();
        } else if (string.equals(CANCEL)) {
            this.cancel();
        }
    }

    @Override
    public void onPageEvent(PageEvent pageEvent) {
        if (pageEvent.isStateChanged()) {
            this.refreshButtons();
        } else if (pageEvent.isNextRequested()) {
            this.next();
        }
    }

    protected void back() {
        Page page = this.pageStack.pop();
        page.removePageEventHandler(this);
        this.setPage(this.pageStack.pop());
    }

    protected void next() {
        this.getCurrentPage().dispatchPageEvent(2);
        if (this.getCurrentPage().hasNextPage()) {
            try {
                this.setPage(this.getCurrentPage().getNextPage());
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to load next page.", exception);
                UIUtility.showErrorDialog((Component)this, exception);
            }
        } else {
            if (!this.viewWillClose(1)) {
                return;
            }
            this.result = 1;
            this.close();
        }
    }

    protected void cancel() {
        if (!this.viewWillClose(2)) {
            return;
        }
        this.result = 2;
        this.close();
    }

    protected boolean viewWillClose(int n) {
        return this.getCurrentPage().viewWillClose(n);
    }

    protected void close() {
        this.getCurrentPage().closePage(this.result);
        this.dispatchPagesViewEvent(new PagesViewEvent(this));
        if (this.dialog == null) {
            this.closeTab();
        } else {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    protected void hideDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    protected void showDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
    }

    public void showDialog(Component component, String string, boolean bl, Dimension dimension) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        this.createDialog(component, string, bl, dimension);
        this.dialog.setVisible(true);
    }

    public JDialog createDialog(Component component, String string, boolean bl, Dimension dimension) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        return this.createDialog(window, string, bl, dimension);
    }

    public JDialog createDialog(Window window, String string, boolean bl, Dimension dimension) {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new JDialog(window, string, bl ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add(this);
        if (dimension == null || dimension.width == 0 || dimension.height == 0) {
            this.dialog.pack();
            if (dimension != null) {
                if (dimension.getWidth() != 0.0) {
                    this.dialog.setSize(new Dimension(dimension.width, this.dialog.getSize().height));
                } else if (dimension.getHeight() != 0.0) {
                    this.dialog.setSize(new Dimension(this.dialog.getSize().width, dimension.height));
                }
            }
        } else {
            this.dialog.setSize(dimension);
        }
        this.dialog.setLocationRelativeTo(window);
        return this.dialog;
    }

    public void addPagesViewEventHandler(PagesViewEventHandler pagesViewEventHandler) {
        this.eventSupport.addEventHandler(pagesViewEventHandler);
    }

    public void removePagesViewEventHandler(PagesViewEventHandler pagesViewEventHandler) {
        this.eventSupport.removeEventHandler(pagesViewEventHandler);
    }

    public void dispatchPagesViewEvent(PagesViewEvent pagesViewEvent) {
        this.eventSupport.dispatchEvent(pagesViewEvent);
    }
}

