/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.view;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PagesViewFactory {
    public static PagesView createCloseOnlyView(Page page) {
        return new CloseOnlyView(page);
    }

    public static PagesView createOkCancelView(Page page) {
        return PagesViewFactory.createOkCancelView(page, null, null);
    }

    public static PagesView createOkCancelView(Page page, String string, Icon icon) {
        return new OkCancelView(page, string, icon);
    }

    private static class CloseOnlyView
    extends PagesView {
        public CloseOnlyView(Page page) {
            super(page);
        }

        @Override
        protected JPanel createButtons() {
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 10 0 0 0, fill", "[grow]"));
            String string = "w 120";
            this.cancelButton = this.createCancelButton();
            jPanel.add((Component)this.cancelButton, "alignx right, " + string);
            return jPanel;
        }

        @Override
        protected JButton createCancelButton() {
            return this.createButton(Messages.getString("Button.close"), null, "CANCEL");
        }
    }

    private static class OkCancelView
    extends PagesView {
        private String okLabel;
        private Icon okIcon;

        public OkCancelView(Page page, String string, Icon icon) {
            super(page);
            if (string != null || icon != null) {
                this.okLabel = string;
                this.okIcon = icon;
                this.refreshButtons();
            }
        }

        @Override
        protected String getFinishButtonTitle() {
            if (this.okLabel != null) {
                return this.okLabel;
            }
            return super.getFinishButtonTitle();
        }

        @Override
        protected Icon getFinishButtonIcon() {
            return this.okIcon != null ? this.okIcon : super.getFinishButtonIcon();
        }

        @Override
        protected JPanel createButtons() {
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 10 0 0 0, fill", "[grow][]"));
            String string = "w 120";
            this.nextButton = this.createNextButton();
            this.cancelButton = this.createCancelButton();
            jPanel.add((Component)this.nextButton, "alignx right, " + string);
            jPanel.add((Component)this.cancelButton, string);
            return jPanel;
        }
    }
}

