/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.feature.history.FlowNodeFlavor;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.ui.OpTabPagesView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.MainFrame;
import com.ef_prime.rflow.ui.common.component.ColorMaskedIcon;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.TabbedPaneDnDHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPaneDnDHandler;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class RflowViewTabbedPane
extends ViewTabbedPane
implements PopupMenuListener {
    public static final String OPEN_GD = "OPEN_GD";
    private boolean active;

    public RflowViewTabbedPane() {
        this(true);
    }

    public RflowViewTabbedPane(boolean bl) {
        super(bl);
        this.setFocusable(false);
        this.actions.put(OPEN_GD, new OpenGraphicsDevice());
        this.menuActions.put(OPEN_GD, new OpenGraphicsDevice());
        this.setTabLayoutPolicy(0);
        this.refreshFont();
        this.addHierarchyListener(new DisplayableHandler());
        this.putClientProperty("substancelaf.colorizationFactor", 0.8);
    }

    @Override
    protected Icon getUnreadIcon(View view2) {
        return new ColorMaskedIcon(view2.getIcon(), Color.YELLOW, 0.4f);
    }

    @Override
    protected TabbedPaneDnDHandler createTabbedPaneDnDHandler() {
        return new RflowTabbedPaneDnDHandler();
    }

    public void setActive(boolean bl) {
        if (this.active != bl) {
            this.active = bl;
            this.refreshTabBackground();
        }
    }

    @Override
    public void refreshTabBackground() {
        UIUtility.invokeLater(() -> {
            int n = this.getSelectedIndex();
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (this.getViewAt(i).isUnread()) {
                    this.setBackgroundAt(i, Color.ORANGE);
                    continue;
                }
                if (i == n) {
                    this.setBackgroundAt(i, this.active ? null : Color.WHITE);
                    continue;
                }
                this.setBackgroundAt(i, Color.LIGHT_GRAY);
            }
        });
    }

    @Override
    protected void addPopupMenuActions(ActionMap actionMap, JPopupMenu jPopupMenu) {
        jPopupMenu.add(Rflow.actions().get("NEW_FLOW"));
        jPopupMenu.add(actionMap.get(OPEN_GD));
        jPopupMenu.addSeparator();
        super.addPopupMenuActions(actionMap, jPopupMenu);
        if (!Rflow.project().getSessionEntryHistory().isEmpty()) {
            JMenu jMenu = new JMenu(Messages.getString("Action.recently_closed_tabs"));
            jMenu.getPopupMenu().addPopupMenuListener(this);
            jPopupMenu.addSeparator();
            jPopupMenu.add(new UndoClosedTab(Rflow.project().getSessionEntryHistory().entriesIterator().next()));
            jPopupMenu.add(jMenu);
        }
    }

    @Override
    protected void refreshFont() {
        this.setFont(FontSupport.getFont(this.getFont(), (Key<Double>)Settings.BASIC_FONT_SIZE));
        super.refreshFont();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
        jPopupMenu.removeAll();
        Iterator<SessionEntry> iterator = Rflow.project().getSessionEntryHistory().entriesIterator();
        while (iterator.hasNext()) {
            SessionEntry sessionEntry = iterator.next();
            jPopupMenu.add(new ReopenClosedTab(sessionEntry));
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    private class OpenGraphicsDevice
    extends LoggableAction {
        public OpenGraphicsDevice() {
            super(Messages.getString("Action.new_graphics"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            R.receiver().passCommand(".newGraphics()");
        }
    }

    private class DisplayableHandler
    extends DisplayableListener {
        private SettingsListener settingsListener;

        private DisplayableHandler() {
        }

        @Override
        protected void didBecomeDisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener == null) {
                this.settingsListener = new SettingsListener();
                Rflow.settings().addEventHandler(this.settingsListener);
            }
        }

        @Override
        protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener != null) {
                Rflow.settings().removeEventHandler(this.settingsListener);
            }
        }
    }

    private class RflowTabbedPaneDnDHandler
    extends ViewTabbedPaneDnDHandler {
        private RflowTabbedPaneDnDHandler() {
        }

        @Override
        public ViewTabbedPane getTabbedPane() {
            return (ViewTabbedPane)super.getTabbedPane();
        }

        @Override
        protected boolean canImportAsTab(Transferable transferable) {
            boolean bl = super.canImportAsTab(transferable);
            if (bl) {
                return true;
            }
            List<FlowNode> list = FlowNodeFlavor.getFlowNodes(transferable);
            return list != null && list.size() == 1 && list.get(0).getModel() instanceof UINodeModel;
        }

        @Override
        protected boolean importTab(DropTargetDropEvent dropTargetDropEvent) {
            List<FlowNode> list;
            boolean bl = super.importTab(dropTargetDropEvent);
            if (bl) {
                return true;
            }
            if (this.getTargetIndex() >= 0 && (list = FlowNodeFlavor.getFlowNodes(dropTargetDropEvent.getTransferable())) != null && list.size() == 1 && list.get(0).getModel() instanceof UINodeModel) {
                Operation operation = ((UINodeModel)list.get(0).getModel()).getModel();
                OpTabPagesView opTabPagesView = new OpTabPagesView(operation.copy(), null);
                this.getTabbedPane().openView(opTabPagesView, ViewOpenType.OPEN_NEW, true, this.getTargetIndex());
                return true;
            }
            return false;
        }

        @Override
        protected boolean canImport(Transferable transferable) {
            if (RflowViewTabbedPane.this.getTabCount() != 0) {
                return false;
            }
            return MainFrame.topLevelCanImport(transferable);
        }

        @Override
        protected boolean importData(Transferable transferable) {
            if (RflowViewTabbedPane.this.getTabCount() != 0) {
                return false;
            }
            return MainFrame.handleTopLevelDrop(transferable);
        }
    }

    private class UndoClosedTab
    extends LoggableAction {
        private SessionEntry entry;

        public UndoClosedTab(SessionEntry sessionEntry) {
            this.entry = sessionEntry;
            this.putValue("Name", Messages.getString("Action.reopen_closed_tab") + " (" + sessionEntry.getTitle() + ")");
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (Rflow.mainView().openSessionEntry(this.entry, null)) {
                Rflow.project().getSessionEntryHistory().remove(this.entry);
            }
        }
    }

    private class ReopenClosedTab
    extends LoggableAction {
        private SessionEntry entry;

        public ReopenClosedTab(SessionEntry sessionEntry) {
            this.entry = sessionEntry;
            this.putValue("Name", sessionEntry.getTitle());
            this.putValue("SmallIcon", sessionEntry.getIcon());
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (Rflow.mainView().openSessionEntry(this.entry, null)) {
                Rflow.project().getSessionEntryHistory().remove(this.entry);
            }
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.BASIC_FONT_SIZE.equals(valueChangeEvent.getKey())) {
                RflowViewTabbedPane.this.refreshFont();
            }
        }
    }
}

