/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.view;

import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.ui.common.component.SingleExecutor;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ItemPreviewView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class View
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(View.class.getName());
    protected String title;
    private boolean isClosable;
    private boolean closeLocked;
    private boolean closeButtonHidden;
    private Icon icon = null;
    private String iconToolTip = null;
    private boolean isIconOnly;
    private boolean allowDuplicate;
    private boolean unread;
    private boolean tabDisabled;
    private boolean moving;
    private boolean wasDisplayable;
    private boolean wasShown;
    private WorkerPropertyChangeListener propertyChangeListener;
    private SingleExecutor singleExecutor;

    public View() {
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ViewAppearListener());
        this.addHierarchyListener(new ViewHierarchyListener());
    }

    public Object getKey() {
        return this;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean isClosable() {
        return this.isClosable;
    }

    public void setClosable(boolean bl) {
        this.isClosable = bl;
    }

    public boolean isCloseLocked() {
        return this.closeLocked;
    }

    public void setCloseLocked(boolean bl) {
        this.closeLocked = bl;
    }

    public boolean isCloseButtonHidden() {
        return this.closeButtonHidden;
    }

    public void setCloseButtonHidden(boolean bl) {
        this.closeButtonHidden = bl;
    }

    protected List<Action> getPopupMenuActions() {
        return null;
    }

    public boolean allowDuplicate() {
        return this.allowDuplicate;
    }

    public void setAllowDuplicate(boolean bl) {
        this.allowDuplicate = bl;
    }

    public boolean isUnread() {
        return this.unread;
    }

    public void setUnread(boolean bl) {
        if (!this.canBeUnreadWhenShowing() && bl && this.isShowing()) {
            return;
        }
        if (this.unread != bl) {
            this.unread = bl;
            this.updateTab();
            this.updateTabBackground();
            this.putClientProperty("substancelaf.unread", bl);
            this.putClientProperty("substancelaf.colorizationFactor", bl ? Double.valueOf(1.0) : null);
        }
    }

    protected boolean canBeUnreadWhenShowing() {
        return false;
    }

    public void setTabDisabled(boolean bl) {
        if (this.tabDisabled != bl) {
            this.tabDisabled = bl;
            this.updateTab();
        }
    }

    public boolean isTabDisabled() {
        return this.tabDisabled;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getIconToolTip() {
        return this.iconToolTip;
    }

    public void setIconToolTip(String string) {
        this.iconToolTip = string;
    }

    public boolean isIconOnly() {
        return this.isIconOnly;
    }

    public void setIconOnly(boolean bl) {
        this.isIconOnly = bl;
    }

    public Component getFirstFocusComponent() {
        return null;
    }

    public void focus() {
        Component component = this.getFirstFocusComponent();
        if (component != null) {
            component.requestFocusInWindow();
        } else {
            this.requestFocusInWindow();
        }
    }

    public void select(SearchResult searchResult) {
    }

    public void viewDidAppear() {
    }

    public void viewDidDisappear() {
    }

    public void loadView() {
    }

    public void unloadView() {
    }

    public boolean viewWillClose() {
        return true;
    }

    protected void viewDidBecomeDisplayable() {
    }

    protected void viewDidBecomeUndisplayable() {
    }

    protected void viewShown() {
    }

    protected void viewHidden() {
    }

    public boolean canRefreshView() {
        return false;
    }

    public void refreshView() {
    }

    public void closeTab() {
        this.closeTab(false);
    }

    public void closeTab(boolean bl) {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        viewTabbedPane.closeTabAt(viewTabbedPane.getIndexOfView(this.getRootView()), !bl);
    }

    public ViewTabbedPane getParentTabbedPane() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof ViewTabbedPane)) continue;
            return (ViewTabbedPane)container;
        }
        return null;
    }

    public void clearPreview() {
        ItemPreviewView itemPreviewView = this.getParentPreviewView();
        if (itemPreviewView == null) {
            return;
        }
        itemPreviewView.clearView();
    }

    private ItemPreviewView getParentPreviewView() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof ItemPreviewView)) continue;
            return (ItemPreviewView)container;
        }
        return null;
    }

    public View getRootView() {
        View view2 = this;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof ViewTabbedPane) {
                return view2;
            }
            view2 = container instanceof View ? (View)container : null;
        }
        return null;
    }

    public void toFront() {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        int n = viewTabbedPane.getIndexOfView(this.getRootView());
        if (n >= 0) {
            viewTabbedPane.setSelectedIndex(n);
        }
    }

    public void startMoving() {
        this.moving = true;
    }

    public void endMoving() {
        this.moving = false;
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (View.this.wasDisplayable ^ View.this.isDisplayable()) {
                    View.this.wasDisplayable = View.this.isDisplayable();
                    if (View.this.wasDisplayable) {
                        View.this.viewDidBecomeDisplayable();
                    } else {
                        View.this.viewDidBecomeUndisplayable();
                    }
                }
                if (View.this.wasShown ^ View.this.isShowing()) {
                    View.this.wasShown = View.this.isShowing();
                    if (View.this.wasShown) {
                        View.this.viewShown();
                    } else {
                        View.this.viewHidden();
                    }
                }
            }
        });
    }

    public void updateTab() {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        int n = viewTabbedPane.getIndexOfView(this.getRootView());
        if (n >= 0) {
            viewTabbedPane.updateTab(n);
        }
    }

    public void busyStatedChanged(boolean bl) {
        this.updateTabBusy(bl);
    }

    public void updateTabBusy(boolean bl) {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        int n = viewTabbedPane.getIndexOfView(this.getRootView());
        if (n >= 0) {
            viewTabbedPane.updateTabBusy(n, bl);
        }
    }

    protected void updateTabBackground() {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        viewTabbedPane.refreshTabBackground();
    }

    protected <R, V> void doBusyWork(SwingWorker<R, V> swingWorker) {
        swingWorker.addPropertyChangeListener(this.getWorkerPropertyChangeListener());
        if (this.singleExecutor == null) {
            this.singleExecutor = new SingleExecutor();
        }
        this.singleExecutor.submit(swingWorker);
    }

    protected final WorkerPropertyChangeListener getWorkerPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new WorkerPropertyChangeListener();
        }
        return this.propertyChangeListener;
    }

    public SingleExecutor getExecutor() {
        if (this.singleExecutor == null) {
            this.singleExecutor = new SingleExecutor();
        }
        return this.singleExecutor;
    }

    protected void killExecutor() {
        if (this.singleExecutor != null) {
            this.singleExecutor.kill();
        }
    }

    public void refresh() {
        this.doBusyWork(this.createRefreshWorker());
    }

    protected SwingWorker<?, String> createRefreshWorker() {
        return new ViewRefreshWorker();
    }

    protected Object refreshWork() throws Exception {
        return null;
    }

    protected void refreshWorkDone(Object object) {
    }

    protected void refreshFailed(Exception exception) {
        if (exception instanceof ExecutionException) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private class ViewAppearListener
    implements ComponentListener {
        private ViewAppearListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            View.this.viewDidDisappear();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            View.this.setUnread(false);
            View.this.viewDidAppear();
        }
    }

    private class ViewHierarchyListener
    implements HierarchyListener {
        private ViewHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (View.this.moving) {
                return;
            }
            if (UIUtility.isDisplayablityChanged(hierarchyEvent)) {
                if (View.this.isDisplayable()) {
                    if (!View.this.wasDisplayable) {
                        View.this.wasDisplayable = true;
                        View.this.viewDidBecomeDisplayable();
                    }
                } else if (View.this.wasDisplayable) {
                    View.this.wasDisplayable = false;
                    View.this.killExecutor();
                    View.this.viewDidBecomeUndisplayable();
                }
            }
            if (UIUtility.isShowingChanged(hierarchyEvent)) {
                if (View.this.isShowing()) {
                    if (!View.this.wasShown) {
                        View.this.wasShown = true;
                        View.this.viewShown();
                    }
                } else if (View.this.wasShown) {
                    View.this.wasShown = false;
                    View.this.viewHidden();
                }
            }
        }
    }

    private class WorkerPropertyChangeListener
    implements PropertyChangeListener {
        private WorkerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.STARTED) {
                    View.this.busyStatedChanged(true);
                } else if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                    View.this.busyStatedChanged(false);
                }
            }
        }
    }

    protected class ViewRefreshWorker
    extends SwingWorker<Object, String> {
        protected ViewRefreshWorker() {
        }

        @Override
        protected Object doInBackground() throws Exception {
            return View.this.refreshWork();
        }

        @Override
        protected void done() {
            Object t;
            boolean bl = false;
            try {
                t = this.get();
                bl = true;
            }
            catch (Exception exception) {
                View.this.refreshFailed(exception);
                return;
            }
            if (bl) {
                View.this.refreshWorkDone(t);
            }
        }
    }
}

