/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CloseButton;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.TabbedPaneDnDHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewSelectionEvent;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPaneDnDHandler;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;

public class ViewTabbedPane
extends JTabbedPane
implements ChangeListener,
ContainerListener {
    protected TabActions actions = new TabActions();
    protected TabActions menuActions = new TabActions();
    protected TabbedPaneDnDHandler dnDHandler;
    private final ViewSelectionEvent selectionEvent = new ViewSelectionEvent(this);
    private Deque<Object> selectionHistory = new ArrayDeque<Object>();

    public ViewTabbedPane() {
        this(true);
    }

    public ViewTabbedPane(boolean bl) {
        this.setTabLayoutPolicy(1);
        this.getModel().addChangeListener(this);
        this.addContainerListener(this);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseWheelListener(mouseHandler);
        this.actions.installActions(this, false);
        if (bl) {
            this.installDnDHandler();
        }
    }

    protected TabbedPaneDnDHandler createTabbedPaneDnDHandler() {
        return new ViewTabbedPaneDnDHandler();
    }

    protected void installDnDHandler() {
        this.dnDHandler = this.createTabbedPaneDnDHandler();
        if (this.dnDHandler != null) {
            this.dnDHandler.install(this);
        }
    }

    protected Icon getUnreadIcon(View view2) {
        return view2.getIcon();
    }

    protected void refreshFont() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getTabComponentAt(i);
            if (!(component instanceof Tab)) continue;
            Tab tab = (Tab)component;
            tab.refreshFont();
        }
    }

    public Object getLastSelectionKey() {
        if (this.selectionHistory.size() > 1) {
            return Utility.getFromLast(this.selectionHistory, 2);
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.dnDHandler != null) {
            this.dnDHandler.drawTarget(graphics);
        }
    }

    public void requestFocusOnView() {
        View view2 = this.getSelectedView();
        if (view2 != null) {
            view2.focus();
        }
    }

    public void clear() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.closeTabAt(i, false);
        }
    }

    public TabActions getActions() {
        return this.actions;
    }

    public void openView(View view2) {
        this.openView(view2, ViewOpenType.OPEN_NEW, false);
    }

    public void openView(View view2, ViewOpenType viewOpenType, boolean bl) {
        this.openView(view2, viewOpenType, bl, -1);
    }

    public void openView(View view2, ViewOpenType viewOpenType, boolean bl, int n) {
        int n2;
        boolean bl2 = false;
        if (viewOpenType == ViewOpenType.OPEN_OR_MOVE && (n2 = this.getIndexOfKey(view2.getKey())) >= 0) {
            if (n2 == this.getSelectedIndex()) {
                return;
            }
            n = n2;
            bl2 = true;
            bl = true;
            this.closeTabAt(this.getSelectedIndex(), false);
        }
        if (!(bl2 || viewOpenType != ViewOpenType.OPEN && viewOpenType != ViewOpenType.OPEN_OR_MOVE)) {
            View view3;
            n2 = n;
            if (n2 < 0) {
                n2 = this.getSelectedIndex();
            }
            if ((view3 = this.getViewAt(n2)) != null && view3.isClosable()) {
                n = n2;
                this.addNewView(view2, n);
                this.closeTabAt(n + 1, false);
                bl2 = true;
            }
        }
        if (!bl2) {
            n2 = this.getIndexOfKey(view2.getKey());
            if (viewOpenType == ViewOpenType.OPEN_NEW && n2 >= 0) {
                n = n2;
            } else {
                if (n < 0 || n >= this.getTabCount()) {
                    n = this.getTabCount();
                }
                this.addNewView(view2, n);
            }
        }
        if (bl) {
            this.setSelectedIndex(n);
        }
    }

    private void addNewView(View view2, int n) {
        this.insertTab(null, null, view2, null, n);
        this.setTabComponentAt(n, new Tab(view2));
        view2.loadView();
    }

    public void closeTabAt(int n) {
        this.closeTabAt(n, true);
    }

    public void closeTabAt(int n, boolean bl) {
        if (n < 0 || n >= this.getTabCount()) {
            return;
        }
        View view2 = this.getViewAt(n);
        if (view2.isCloseLocked()) {
            return;
        }
        if (!(bl && !view2.isClosable() || bl && !view2.viewWillClose() || !view2.isDisplayable())) {
            this.removeTabAt(n);
            view2.unloadView();
        }
    }

    public int getIndexOfView(View view2) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            View view3 = (View)this.getComponentAt(i);
            if (view3 != view2) continue;
            return i;
        }
        return -1;
    }

    public int getIndexOfKey(Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            View view2 = (View)this.getComponentAt(i);
            Object object2 = view2.getKey();
            if (object2 == null || !object2.equals(object)) continue;
            return i;
        }
        return -1;
    }

    public View getViewAt(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            return null;
        }
        return (View)this.getComponentAt(n);
    }

    public View[] getViews() {
        View[] viewArray = new View[this.getTabCount()];
        for (int i = 0; i < viewArray.length; ++i) {
            viewArray[i] = this.getViewAt(i);
        }
        return viewArray;
    }

    public View getSelectedView() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getViewAt(n);
    }

    public void updateTab(int n) {
        final Tab tab = (Tab)this.getTabComponentAt(n);
        if (tab != null) {
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tab.update();
                }
            });
        }
    }

    public void updateTabBusy(int n, final boolean bl) {
        final Tab tab = (Tab)this.getTabComponentAt(n);
        if (tab != null) {
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tab.setBusy(bl);
                }
            });
        }
    }

    public void setValueError(int n, final ValueError valueError) {
        final Tab tab = (Tab)this.getTabComponentAt(n);
        if (tab != null) {
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tab.setValueError(valueError);
                }
            });
        }
    }

    public void refreshTabBackground() {
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = ViewTabbedPane.this.getSelectedIndex();
                for (int i = 0; i < ViewTabbedPane.this.getTabCount(); ++i) {
                    if (ViewTabbedPane.this.getViewAt(i).isUnread()) {
                        ViewTabbedPane.this.setBackgroundAt(i, Color.ORANGE);
                        continue;
                    }
                    if (i == n) {
                        ViewTabbedPane.this.setBackgroundAt(i, Color.WHITE);
                        continue;
                    }
                    ViewTabbedPane.this.setBackgroundAt(i, Color.LIGHT_GRAY);
                }
            }
        });
    }

    protected void fireViewSelectionChanged() {
        EventManager.getInstance().dispatchEvent(this.selectionEvent);
    }

    private void saveViewToHistory(View view2) {
        if (view2 != null && view2.getKey() != null) {
            Object object = view2.getKey();
            if (this.selectionHistory.isEmpty() || !ObjectUtils.equals((Object)this.selectionHistory.getLast(), (Object)object)) {
                this.selectionHistory.add(object);
            }
            if (this.selectionHistory.size() > 10) {
                this.selectionHistory.removeFirst();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.saveViewToHistory(this.getSelectedView());
        this.actions.setIndex(this.getSelectedIndex());
        this.refreshTabBackground();
        this.fireViewSelectionChanged();
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.fireViewSelectionChanged();
    }

    @Override
    public void revalidate() {
        super.revalidate();
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.updateTab(i);
        }
    }

    protected void addPopupMenuActions(ActionMap actionMap, JPopupMenu jPopupMenu) {
        jPopupMenu.add(actionMap.get("ViewTabbedPane.CLOSE"));
        jPopupMenu.addSeparator();
        if (Rflow.develSettings().getValue(DevelSettings.KEY_TAB_FLOAT).booleanValue()) {
            jPopupMenu.add(actionMap.get("ViewTabbedPane.FLOAT"));
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(actionMap.get("ViewTabbedPane.REFRESH"));
    }

    public class TabActions
    extends Actions {
        public static final String CLOSE = "ViewTabbedPane.CLOSE";
        public static final String REFRESH = "ViewTabbedPane.REFRESH";
        public static final String PREVIOUS_TAB = "ViewTabbedPane.PREVIOUS_TAB";
        public static final String NEXT_TAB = "ViewTabbedPane.NEXT_TAB";
        public static final String FLOAT = "ViewTabbedPane.FLOAT";
        private int index;

        public TabActions() {
            this.put(CLOSE, new Close());
            this.put(REFRESH, new Refresh());
            this.put(PREVIOUS_TAB, new PreviousTab());
            this.put(NEXT_TAB, new NextTab());
            this.put(FLOAT, new Float());
        }

        public void setIndex(int n) {
            this.index = n;
            if (n >= 0) {
                View view2 = ViewTabbedPane.this.getViewAt(n);
                boolean bl = view2 != null;
                this.get(CLOSE).setEnabled(bl && view2.isClosable());
                this.get(REFRESH).setEnabled(bl && view2.canRefreshView());
            } else {
                this.get(CLOSE).setEnabled(false);
                this.get(REFRESH).setEnabled(false);
            }
        }

        public boolean isTabSelected() {
            return this.index >= 0;
        }

        public JPopupMenu createPopupMenu() {
            List<Action> list;
            View view2;
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (this.index >= 0 && (view2 = ViewTabbedPane.this.getViewAt(this.index)) != null && (list = view2.getPopupMenuActions()) != null && !list.isEmpty()) {
                for (Action action : list) {
                    jPopupMenu.add(action);
                }
                jPopupMenu.addSeparator();
            }
            ViewTabbedPane.this.addPopupMenuActions(this, jPopupMenu);
            UIUtility.cleanUpPopupMenu(jPopupMenu);
            return jPopupMenu;
        }

        private void nextTab(boolean bl) {
            int n = ViewTabbedPane.this.getSelectedIndex();
            n = bl ? --n : ++n;
            if (n < 0) {
                n = 0;
            } else if (n >= ViewTabbedPane.this.getTabCount()) {
                n = ViewTabbedPane.this.getTabCount() - 1;
            }
            ViewTabbedPane.this.setSelectedIndex(n);
        }

        private class Close
        extends LoggableAction {
            public Close() {
                super(Messages.getString("Action.close_tab"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (TabActions.this.isTabSelected()) {
                    ViewTabbedPane.this.closeTabAt(TabActions.this.index);
                }
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                super(Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (!TabActions.this.isTabSelected()) {
                    return;
                }
                View view2 = ViewTabbedPane.this.getViewAt(TabActions.this.index);
                if (view2 != null) {
                    view2.refreshView();
                    view2.updateTab();
                }
            }
        }

        private class PreviousTab
        extends LoggableAction {
            public PreviousTab() {
                this.putValue("Name", Messages.getString("Action.previous_tab"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, PlatformUtility.getAltMask()));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                TabActions.this.nextTab(true);
            }
        }

        private class NextTab
        extends LoggableAction {
            public NextTab() {
                this.putValue("Name", Messages.getString("Action.next_tab"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, PlatformUtility.getAltMask()));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                TabActions.this.nextTab(false);
            }
        }

        private class Float
        extends LoggableAction
        implements WindowListener {
            public Float() {
                this.putValue("Name", Messages.getString("Action.float"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                if (!TabActions.this.isTabSelected()) {
                    return;
                }
                View view2 = ViewTabbedPane.this.getViewAt(TabActions.this.index);
                if (view2 != null) {
                    view2.startMoving();
                    try {
                        ViewTabbedPane.this.closeTabAt(TabActions.this.index);
                        Window window = SwingUtilities.windowForComponent(ViewTabbedPane.this);
                        JDialog jDialog = new JDialog(window);
                        jDialog.setLayout(new BorderLayout());
                        jDialog.setTitle(view2.getTitle());
                        jDialog.add((Component)view2, "Center");
                        jDialog.setSize(view2.getSize());
                        jDialog.setDefaultCloseOperation(2);
                        jDialog.setLocationRelativeTo(window);
                        jDialog.addWindowListener(this);
                        jDialog.setVisible(true);
                    }
                    finally {
                        view2.endMoving();
                    }
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JDialog jDialog = (JDialog)windowEvent.getSource();
                View view2 = (View)jDialog.getContentPane().getComponent(0);
                ViewTabbedPane.this.openView(view2, ViewOpenType.OPEN_NEW, true);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = ViewTabbedPane.this.indexAtLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (n < 0) {
                return;
            }
            final View view2 = ViewTabbedPane.this.getViewAt(n);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    view2.focus();
                }
            });
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = ViewTabbedPane.this.indexAtLocation(point.x, point.y);
            if (UIUtility.isMiddleMouseButton(mouseEvent)) {
                if (n >= 0) {
                    ViewTabbedPane.this.closeTabAt(n, true);
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                ViewTabbedPane.this.menuActions.setIndex(n);
                JPopupMenu jPopupMenu = ViewTabbedPane.this.menuActions.createPopupMenu();
                jPopupMenu.show(ViewTabbedPane.this, point.x, point.y);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (ViewTabbedPane.this.getTabCount() == 0) {
                return;
            }
            if (mouseWheelEvent.getScrollType() != 0) {
                return;
            }
            Rectangle rectangle = ViewTabbedPane.this.getUI().getTabBounds(ViewTabbedPane.this, 0);
            if (mouseWheelEvent.getPoint().y > rectangle.y + rectangle.height) {
                return;
            }
            int n = ViewTabbedPane.this.getSelectedIndex();
            n = mouseWheelEvent.getWheelRotation() > 0 ? ++n : --n;
            if (n >= 0 && n < ViewTabbedPane.this.getTabCount()) {
                ViewTabbedPane.this.setSelectedIndex(n);
            }
        }
    }

    protected class Tab
    extends JPanel {
        private View view;
        private JXBusyLabel busyLabel;
        private JLabel label;
        private CloseButton closeButton;
        private boolean busy;
        private ValueError error;
        private CloseButtonAction closeButtonAction = new CloseButtonAction();

        public Tab(View view2) {
            this.view = view2;
            this.setOpaque(false);
            this.setFocusable(false);
            this.busyLabel = new JXBusyLabel(new Dimension(16, 16));
            this.label = new JLabel();
            this.refreshFont();
            this.setLayout((LayoutManager)new MigLayout("insets 0, gap 0 0, hidemode 2"));
            this.add((Component)this.busyLabel);
            this.add((Component)this.label, "hmin 18, wmin 50, wmax 150");
            if (view2.isClosable()) {
                this.label.setBorder(new EmptyBorder(0, 0, 0, 4));
                this.closeButton = new CloseButton(14, Color.LIGHT_GRAY, Color.GRAY);
                this.closeButton.setFocusable(false);
                this.closeButton.addActionListener(this.closeButtonAction);
                this.add(this.closeButton);
            }
            this.update();
            this.setBusy(false);
        }

        public void refreshFont() {
            this.label.setFont(ViewTabbedPane.this.getFont());
        }

        public void setBold(boolean bl) {
            int n = bl ? 1 : 0;
            this.label.setFont(this.label.getFont().deriveFont(n));
            this.repaint();
        }

        public void setBusy(boolean bl) {
            this.busy = bl;
            this.update();
        }

        public void setValueError(ValueError valueError) {
            Color color;
            this.error = valueError;
            Color color2 = color = valueError == null ? null : WidgetConstants.getErrorColor(valueError);
            if (color != null) {
                if (valueError.isError()) {
                    color = new Color(255, 70, 70);
                } else if (valueError.getLevel() == 2) {
                    color = new Color(130, 130, 130);
                }
            }
            this.putClientProperty("substancelaf.tabstripcolor", color);
            this.update();
        }

        public void update() {
            String string;
            this.busyLabel.setVisible(this.busy);
            this.busyLabel.setBusy(this.busy);
            this.label.setText(this.view.isIconOnly() ? null : this.view.getTitle());
            int n = ViewTabbedPane.this.getIndexOfView(this.view);
            if (n >= 0) {
                string = this.view.getIconToolTip();
                if (this.error != null) {
                    string = UIUtility.convertToHTML(this.error.getMessage(true, true));
                } else if (string == null && (this.view.isIconOnly() || this.label.getPreferredSize().width > 150)) {
                    string = this.view.getTitle();
                }
                if (StringUtils.isEmpty((CharSequence)string)) {
                    string = null;
                }
                ViewTabbedPane.this.setToolTipTextAt(n, string);
                this.label.setEnabled(ViewTabbedPane.this.isEnabledAt(n) && !this.view.isTabDisabled());
            }
            if (this.busy) {
                this.label.setIcon(null);
            } else {
                this.label.setIcon(this.view.getIcon());
            }
            string = (MigLayout)this.getLayout();
            if (this.view.isIconOnly()) {
                string.setComponentConstraints((Component)this.label, (Object)"hmin 18, wmax 150");
            } else {
                string.setComponentConstraints((Component)this.label, (Object)"hmin 18, wmin 50, wmax 150");
            }
            if (this.closeButton != null) {
                this.closeButton.setVisible(!this.view.isCloseButtonHidden());
            }
            this.revalidate();
            this.repaint();
        }

        private class CloseButtonAction
        extends LoggableAction {
            private CloseButtonAction() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ViewTabbedPane viewTabbedPane = Tab.this.view.getParentTabbedPane();
                if (viewTabbedPane != null) {
                    viewTabbedPane.closeTabAt(viewTabbedPane.indexOfTabComponent(Tab.this), true);
                }
            }
        }
    }
}

