/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.feature.backup;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.backup.BackupChangedEvent;
import com.ef_prime.rflow.core.feature.backup.BackupEntry;
import com.ef_prime.rflow.core.feature.backup.FlowBackupManager;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LockFile;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.FileUtils;

public class BackupView
extends View
implements SimpleEventHandler,
ActiveViewEventHandler {
    private static final Logger LOGGER = Logger.getLogger(BackupView.class.getName());
    private JList<BackupEntry> list;
    private List<BackupEntry> entries;
    private FlowModel model;
    private RestoreActions actions = new RestoreActions();
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public BackupView() {
        this.setTitle(Messages.getString("View.Backup.title"));
        this.setIconOnly(true);
        this.setIcon(Icons.getIcon("16/site_backup_and_restore.png"));
        this.list = new JList(new DefaultListModel());
        this.list.setCellRenderer(new DateRenderer());
        this.list.addMouseListener(new MouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add(jScrollPane);
        this.list.addListSelectionListener(this.actions);
        this.actions.installActions(this, false, 1);
        EventManager.getInstance().registerEventHandler(BackupChangedEvent.class, this);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
    }

    private FlowModel model() {
        return this.model;
    }

    @Override
    protected List<BackupEntry> refreshWork() {
        if (Rflow.project() == null || Rflow.project().isUnloading()) {
            return null;
        }
        List<BackupEntry> list = null;
        try {
            FlowModel flowModel = this.model();
            if (flowModel != null && FlowBackupManager.getLockFile(flowModel).canObtainLock()) {
                list = FlowBackupManager.readEntries(flowModel);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to read backup entries.", iOException);
        }
        return list;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        this.entries = (List)Utility.cast(object);
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        defaultListModel.removeAllElements();
        if (this.entries != null) {
            for (BackupEntry backupEntry : this.entries) {
                defaultListModel.addElement(backupEntry);
            }
        }
    }

    private BackupEntry[] getSelectedEntries() {
        List<BackupEntry> list = this.list.getSelectedValuesList();
        BackupEntry[] backupEntryArray = new BackupEntry[list.size()];
        for (int i = 0; i < backupEntryArray.length; ++i) {
            backupEntryArray[i] = list.get(i);
        }
        return backupEntryArray;
    }

    public static void showDialog(Component component) {
        BackupView backupView = new BackupView();
        JOptionPane jOptionPane = new JOptionPane(backupView, -1);
        jOptionPane.setOptions(new String[]{Messages.getString("Button.close")});
        JDialog jDialog = jOptionPane.createDialog(component, backupView.getTitle());
        backupView.refresh();
        jDialog.setResizable(true);
        jDialog.setModal(false);
        jDialog.setVisible(true);
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(BackupChangedEvent.class)) {
            this.refresh();
        }
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        FlowModel flowModel = activeViewEvent.getActiveFileEdit(FlowModel.class);
        if (this.model != flowModel) {
            this.model = flowModel;
            this.refresh();
        }
    }

    private class RestoreActions
    extends Actions
    implements ListSelectionListener {
        public RestoreActions() {
            this.put(new Restore());
            this.put(new Refresh());
            this.put(new Protect());
            this.put(new Remove());
            this.put(new Unprotect());
            this.put(new Rename());
        }

        private BackupEntry getSelectedEntryOrNull() {
            if (BackupView.this.model == null) {
                return null;
            }
            int n = BackupView.this.list.getSelectedIndex();
            if (n < 0) {
                return null;
            }
            return BackupView.this.list.getModel().getElementAt(n);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int[] nArray = BackupView.this.list.getSelectedIndices();
            boolean bl = nArray.length == 0;
            boolean bl2 = nArray.length == 1;
            BackupEntry backupEntry = null;
            if (bl2) {
                backupEntry = BackupView.this.list.getModel().getElementAt(nArray[0]);
            }
            this.get(Restore.class).setEnabled(backupEntry != null);
            this.get(Protect.class).setEnabled(backupEntry != null && !backupEntry.isProtected());
            this.get(Unprotect.class).setEnabled(backupEntry != null && backupEntry.isProtected());
            this.get(Rename.class).setEnabled(backupEntry != null && backupEntry.isProtected());
            this.get(Remove.class).setEnabled(!bl);
        }

        private class Restore
        extends LoggableAction {
            public Restore() {
                this.putValue("Name", Messages.getString("Action.restore"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                block6: {
                    int[] nArray = BackupView.this.list.getSelectedIndices();
                    if (nArray == null || nArray.length != 1) {
                        return;
                    }
                    BackupEntry backupEntry = BackupView.this.list.getModel().getElementAt(nArray[0]);
                    try {
                        FlowModel flowModel;
                        block7: {
                            flowModel = BackupView.this.model();
                            if (flowModel == null) break block6;
                            if (flowModel.isDirtyAfterRestore()) {
                                try {
                                    FlowBackupManager.backupCurrentFlow(flowModel, false);
                                }
                                catch (Exception exception) {
                                    LOGGER.log(Level.SEVERE, "Failed to backup current flow.", exception);
                                    int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.confirm_backup_fail"), Messages.getString("Message.confirm"), 2, 2);
                                    if (n == 0) break block7;
                                    return;
                                }
                            }
                        }
                        FlowBackupManager.restoreFromBackupFile(FileEditManager.getInstance(), flowModel, FlowBackupManager.getFile(flowModel, backupEntry));
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Failed to restore from a backup file.", exception);
                    }
                }
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                BackupView.this.refresh();
            }
        }

        private class Protect
        extends LoggableAction {
            public Protect() {
                this.putValue("Name", Messages.getString("Action.protect"));
            }

            protected void protect(BackupEntry backupEntry) {
                if (backupEntry.isProtected()) {
                    return;
                }
                if (backupEntry.isTemporary()) {
                    try {
                        FlowModel flowModel = BackupView.this.model();
                        FileUtils.moveFile((File)new File(FlowBackupManager.getTempBackupFolder(flowModel), backupEntry.getFileName()), (File)new File(FlowBackupManager.getBackupFolder(flowModel), backupEntry.getFileName()));
                    }
                    catch (IOException iOException) {
                        UIUtility.showErrorDialog((Component)Rflow.mainFrame(), iOException);
                        return;
                    }
                }
                backupEntry.setTemporary(false);
                backupEntry.setTag("");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                BackupEntry backupEntry = RestoreActions.this.getSelectedEntryOrNull();
                if (backupEntry == null) {
                    return;
                }
                FlowModel flowModel = BackupView.this.model();
                LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
                try {
                    lockFile.lock();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Failed to obtain backup lock.", iOException);
                    return;
                }
                try {
                    this.protect(backupEntry);
                }
                finally {
                    lockFile.release();
                }
                try {
                    FlowBackupManager.writeConfig(flowModel, BackupView.this.entries);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Failed to write the config file", exception);
                }
                BackupView.this.list.repaint();
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                FlowModel flowModel = BackupView.this.model();
                if (flowModel == null) {
                    return;
                }
                LockFile lockFile = FlowBackupManager.getLockFile(flowModel);
                try {
                    lockFile.lock();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Failed to obtain backup lock.", iOException);
                    return;
                }
                BackupEntry[] backupEntryArray = BackupView.this.getSelectedEntries();
                try {
                    String string;
                    try {
                        string = BackupView.this.format.format(FlowBackupManager.getDate(FlowBackupManager.getFile(flowModel, backupEntryArray[0])));
                    }
                    catch (IOException | ParseException exception) {
                        string = backupEntryArray[0].getFileName();
                    }
                    if (!UIUtility.confirmDelete(Rflow.mainFrame(), backupEntryArray.length, string)) {
                        return;
                    }
                }
                finally {
                    lockFile.release();
                }
                try {
                    FlowBackupManager.removeBackupFile(flowModel, backupEntryArray);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Failed to remove backup file.", iOException);
                }
                BackupView.this.refresh();
            }
        }

        private class Unprotect
        extends Protect {
            public Unprotect() {
                this.putValue("Name", Messages.getString("Action.unprotect"));
            }

            @Override
            protected void protect(BackupEntry backupEntry) {
                if (!backupEntry.isProtected()) {
                    return;
                }
                backupEntry.setTag(null);
            }
        }

        private class Rename
        extends Protect {
            public Rename() {
                this.putValue("Name", Messages.getString("Action.rename"));
            }

            @Override
            protected void protect(BackupEntry backupEntry) {
                if (!backupEntry.isProtected()) {
                    return;
                }
                String string = UIUtility.showInputDialog(Rflow.mainFrame(), Messages.getString("Action.rename"), "", backupEntry.getTag());
                if (string == null) {
                    return;
                }
                backupEntry.setTag(string);
            }
        }
    }

    private class DateRenderer
    extends DefaultListCellRenderer {
        private Icon lock = Icons.getIcon("16/lock.png");
        private Icon normal = Icons.getIcon("16/page_white.png");
        private Icon temp = Icons.getIcon("16/document_empty.png");

        private DateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            BackupEntry backupEntry = (BackupEntry)object;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                object2 = BackupView.this.model();
                if (object2 != null) {
                    String string = BackupView.this.format.format(FlowBackupManager.getDate(FlowBackupManager.getFile((FlowModel)object2, backupEntry)));
                    stringBuilder.append(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (backupEntry.isTemporary()) {
                stringBuilder.append(" ");
                stringBuilder.append("(temp)");
            }
            if (backupEntry.isProtected()) {
                stringBuilder.append(" ");
                stringBuilder.append(backupEntry.getTag());
            }
            object2 = null;
            object2 = backupEntry.isProtected() ? this.lock : (backupEntry.isTemporary() ? this.temp : this.normal);
            this.setIcon((Icon)object2);
            this.setText(stringBuilder.toString());
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = BackupView.this.list.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                BackupView.this.actions.doAction(RestoreActions.Restore.class);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = BackupView.this.list.locationToIndex(point);
            if (n < 0) {
                return;
            }
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                if (!BackupView.this.list.getSelectionModel().isSelectedIndex(n)) {
                    BackupView.this.list.setSelectedIndex(n);
                }
                this.createJPopupMenu().show(BackupView.this.list, point.x, point.y);
            }
        }

        private JPopupMenu createJPopupMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            ActionMap actionMap = BackupView.this.getActionMap();
            jPopupMenu.add(actionMap.get(RestoreActions.Restore.class));
            jPopupMenu.add(actionMap.get(RestoreActions.Protect.class));
            jPopupMenu.add(actionMap.get(RestoreActions.Unprotect.class));
            jPopupMenu.add(actionMap.get(RestoreActions.Rename.class));
            jPopupMenu.add(actionMap.get(RestoreActions.Remove.class));
            jPopupMenu.addSeparator();
            jPopupMenu.add(actionMap.get(RestoreActions.Refresh.class));
            UIUtility.cleanUpPopupMenu(jPopupMenu);
            return jPopupMenu;
        }
    }
}

