/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.feature.history;

import com.ef_prime.rflow.core.feature.history.HistoryManager;
import com.ef_prime.rflow.core.feature.history.TaskTreeTableNode;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.node.ui.OpWizardAction;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.PanelTableCellRenderer;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.task.TaskTransferable;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class HistoryTableView
extends View {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_STATE = 1;
    private static final int COLUMN_RESULT = 2;
    private JXTreeTable treeTable;
    private HistoryActions actions;
    private ResultTableCellRenderer resultRenderer;

    public HistoryTableView(TreeTableModel treeTableModel) {
        this.setTitle("History");
        this.setIcon(Icons.getIcon("16/clock_history_frame.png"));
        this.setIconOnly(true);
        this.treeTable = new JXTreeTable(treeTableModel);
        this.treeTable.setBackground(Color.WHITE);
        this.treeTable.setShowGrid(true);
        this.treeTable.setGridColor(UIColor.TABLE_GRID);
        this.treeTable.setDefaultRenderer(Object.class, (TableCellRenderer)new HistoryTableCellRenderer());
        this.treeTable.setTreeCellRenderer((TreeCellRenderer)new HistoryTreeCellRenderer());
        this.treeTable.setColumnMargin(0);
        this.treeTable.setDragEnabled(true);
        this.treeTable.setTransferHandler((TransferHandler)new HistoryTransferHandler());
        MouseHandler mouseHandler = new MouseHandler();
        UIUtility.insertMouseListener((Component)this.treeTable, mouseHandler);
        UIUtility.insertMouseMotionListener((Component)this.treeTable, mouseHandler);
        this.treeTable.getColumn(1).setMaxWidth(28);
        this.treeTable.getColumn(1).setMinWidth(28);
        this.treeTable.getColumn(1).setCellRenderer(new StateTableCellRenderer());
        this.resultRenderer = new ResultTableCellRenderer();
        this.treeTable.getColumn(2).setCellRenderer(this.resultRenderer);
        JScrollPane jScrollPane = new JScrollPane((Component)this.treeTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(jScrollPane);
        this.actions = new HistoryActions();
        this.actions.installActions((JComponent)this.treeTable, false, 1);
        this.treeTable.getSelectionModel().addListSelectionListener(this.actions);
    }

    private List<Task> getSelectedHistories() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        int[] nArray = this.treeTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((Task)this.treeTable.getValueAt(nArray[i], 0));
        }
        return arrayList;
    }

    private static class HistoryTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final Icon ICON_RUNNING = Icons.getIcon("16/update.png");
        private static final Icon ICON_ERROR = Icons.getIcon("16/cancel.png");
        private static final Icon ICON_CANCEL = Icons.getIcon("16/control_pause.png");
        private static final Icon ICON_WARNING = Icons.getIcon("16/error.png");
        private static final Icon ICON_DONE = Icons.getIcon("16/accept.png");

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                this.setBackground(Color.WHITE);
            }
            Task task = (Task)object;
            String string = null;
            Icon icon = null;
            switch (n2) {
                case 0: {
                    string = task.getTitle();
                    break;
                }
                case 1: {
                    if (task.getState() == 2) {
                        icon = ICON_RUNNING;
                        break;
                    }
                    if (task.isError()) {
                        icon = ICON_ERROR;
                        break;
                    }
                    if (task.isCancelled()) {
                        icon = ICON_CANCEL;
                        break;
                    }
                    if (task.isWarning()) {
                        icon = ICON_WARNING;
                        break;
                    }
                    if (!task.isDone() || task.isCancelled()) break;
                    icon = ICON_DONE;
                    break;
                }
            }
            this.setText(string);
            this.setIcon(icon);
            return this;
        }
    }

    private static class HistoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private HistoryTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!bl) {
                this.setBackground(Color.WHITE);
            }
            TaskTreeTableNode taskTreeTableNode = (TaskTreeTableNode)((Object)object);
            Task task = taskTreeTableNode.getTask();
            this.setIcon(task.getIcon());
            this.setText(task.getTitle());
            return this;
        }
    }

    private class HistoryTransferHandler
    extends TransferHandler {
        private HistoryTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            List<Task> list = HistoryTableView.this.getSelectedHistories();
            if (list.isEmpty()) {
                return null;
            }
            return new TaskTransferable(list);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private ResultTableCellRenderer renderer;
        private boolean isRollOver;

        public MouseHandler() {
            this.renderer = new ResultTableCellRenderer();
            HistoryTableView.this.treeTable.add((Component)this.renderer);
            this.renderer.setBounds(-this.renderer.getWidth(), -this.renderer.getHeight(), 0, 0);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ItemName itemName = this.getResult(mouseEvent);
            JXTable jXTable = (JXTable)mouseEvent.getSource();
            if (itemName == null) {
                HistoryTableView.this.resultRenderer.clearRollOver();
                if (this.isRollOver) {
                    this.isRollOver = false;
                    jXTable.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                HistoryTableView.this.resultRenderer.setRollOverIndex(this.getRow(mouseEvent), this.getResultIndex(mouseEvent));
                if (!this.isRollOver) {
                    this.isRollOver = true;
                    jXTable.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isRollOver) {
                mouseEvent.consume();
            }
        }

        private int getRow(MouseEvent mouseEvent) {
            JXTable jXTable = (JXTable)mouseEvent.getSource();
            return jXTable.rowAtPoint(mouseEvent.getPoint());
        }

        private int getResultIndex(MouseEvent mouseEvent) {
            JXTable jXTable = (JXTable)mouseEvent.getSource();
            int n = jXTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jXTable.columnAtPoint(mouseEvent.getPoint());
            if (n < 0 || n2 < 0) {
                return -1;
            }
            if (jXTable.convertColumnIndexToModel(n2) != 2) {
                return -1;
            }
            Task task = (Task)jXTable.getValueAt(n, n2);
            this.renderer.getTableCellRendererComponent((JTable)jXTable, task, jXTable.isCellSelected(n, n2), false, n, n2);
            Rectangle rectangle = jXTable.getCellRect(n, n2, false);
            Point point = new Point(mouseEvent.getPoint().x - rectangle.x, mouseEvent.getPoint().y - rectangle.y);
            this.renderer.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.renderer.validate();
            int n3 = this.renderer.getResultIndexAtPoint(point);
            this.renderer.setBounds(-rectangle.width, -rectangle.height, 0, 0);
            return n3;
        }

        private ItemName getResult(MouseEvent mouseEvent) {
            int n = this.getResultIndex(mouseEvent);
            if (n < 0) {
                return null;
            }
            JXTable jXTable = (JXTable)mouseEvent.getSource();
            Task task = (Task)jXTable.getValueAt(this.getRow(mouseEvent), 0);
            return task.getResults().get(n);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            int n;
            ItemName itemName = this.getResult(mouseEvent);
            if (itemName != null) {
                itemName.requestFocus();
                mouseEvent.consume();
                return;
            }
            int n2 = 960;
            if (UIUtility.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiersEx() & n2) == 0 && !HistoryTableView.this.treeTable.isRowSelected(n = HistoryTableView.this.treeTable.rowAtPoint(point = mouseEvent.getPoint()))) {
                HistoryTableView.this.treeTable.setRowSelectionInterval(n, n);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                int n = HistoryTableView.this.treeTable.rowAtPoint(point);
                if (n >= 0 && Arrays.binarySearch(HistoryTableView.this.treeTable.getSelectedRows(), n) < 0) {
                    HistoryTableView.this.treeTable.setRowSelectionInterval(n, n);
                }
                JPopupMenu jPopupMenu = this.createPopup();
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            } else if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                HistoryTableView.this.actions.doAction(HistoryActions.EditAsNewJob.class);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(HistoryTableView.this.actions.get(HistoryActions.Run.class));
            jPopupMenu.addSeparator();
            jPopupMenu.add(HistoryTableView.this.actions.get(HistoryActions.Cancel.class));
            jPopupMenu.addSeparator();
            jPopupMenu.add(HistoryTableView.this.actions.get(HistoryActions.Remove.class));
            jPopupMenu.addSeparator();
            jPopupMenu.add(HistoryTableView.this.actions.get(HistoryActions.EditAsNewJob.class));
            UIUtility.cleanUpPopupMenu(jPopupMenu);
            return jPopupMenu;
        }
    }

    private static class StateTableCellRenderer
    extends PanelTableCellRenderer {
        private static final Icon ICON_RUNNING = Icons.getIcon("16/update.png");
        private static final Icon ICON_ERROR = Icons.getIcon("16/cancel.png");
        private static final Icon ICON_CANCEL = Icons.getIcon("16/control_pause.png");
        private static final Icon ICON_WARNING = Icons.getIcon("16/error.png");
        private static final Icon ICON_DONE = Icons.getIcon("16/accept.png");
        private JLabel label;

        public StateTableCellRenderer() {
            this.setLayout((LayoutManager)new MigLayout("insets 0, alignx center, aligny center"));
            this.label = new JLabel();
            this.label.setHorizontalTextPosition(0);
            this.add(this.label);
        }

        @Override
        protected Component configureTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Task task = (Task)object;
            Icon icon = null;
            if (task.getState() == 2) {
                icon = ICON_RUNNING;
            } else if (task.isError()) {
                icon = ICON_ERROR;
            } else if (task.isCancelled()) {
                icon = ICON_CANCEL;
            } else if (task.isWarning()) {
                icon = ICON_WARNING;
            } else if (task.isDone() && !task.isCancelled()) {
                icon = ICON_DONE;
            }
            this.label.setIcon(icon);
            return this;
        }
    }

    private class ResultTableCellRenderer
    extends PanelTableCellRenderer {
        private JLabel[] labels;
        private int rollOverRow;
        private int rollOverIndex;

        public ResultTableCellRenderer() {
            this.setLayout((LayoutManager)new MigLayout("insets 0, aligny center, gapx 10"));
            this.labels = new JLabel[10];
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i] = new JLabel();
                this.add((Component)this.labels[i], "wmax 100");
            }
            this.clearRollOver();
        }

        @Override
        protected Component configureTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Task task = (Task)object;
            List<ItemName> list = task.getResults();
            for (int i = 0; i < this.labels.length; ++i) {
                if (i < list.size()) {
                    ItemName itemName = list.get(i);
                    this.labels[i].setIcon(Icons.getIcon("16/page_white.png"));
                    if (i == this.rollOverIndex && n == this.rollOverRow) {
                        this.labels[i].setText("<html><body style=\"white-space: nowrap\"><font color=\"#0033cc\"><u>" + itemName.getName() + "</u><font></body></html>");
                    } else {
                        String string = task.isDoneOrCanceled() ? "#000000" : "#808080";
                        this.labels[i].setText("<html><body style=\"white-space: nowrap\"><font color=\"" + string + "\">" + itemName.getName() + "</font></body></html>");
                    }
                    this.labels[i].setVisible(true);
                    continue;
                }
                this.labels[i].setVisible(false);
            }
            return this;
        }

        public int getResultIndexAtPoint(Point point) {
            for (int i = 0; i < this.labels.length; ++i) {
                JLabel jLabel = this.labels[i];
                if (!jLabel.isVisible()) {
                    return -1;
                }
                if (!jLabel.contains(point.x - jLabel.getX(), point.y - jLabel.getY())) continue;
                return i;
            }
            return -1;
        }

        public void setRollOverIndex(int n, int n2) {
            if (this.rollOverRow == n && this.rollOverIndex == n2) {
                return;
            }
            this.rollOverRow = n;
            this.rollOverIndex = n2;
            HistoryTableView.this.treeTable.repaint();
        }

        public void clearRollOver() {
            this.setRollOverIndex(-1, -1);
        }
    }

    private class HistoryActions
    extends Actions
    implements ListSelectionListener {
        public HistoryActions() {
            this.put(new Run());
            this.put(new Remove());
            this.put(new Cancel());
            this.put(new EditAsNewJob());
        }

        private NodeModelTask getSelectedNodeModelTask() {
            List<Task> list = HistoryTableView.this.getSelectedHistories();
            if (list.size() != 1) {
                return null;
            }
            Task task = list.get(0);
            if (!(task instanceof NodeModelTask)) {
                return null;
            }
            NodeModelTask nodeModelTask = (NodeModelTask)task;
            if (!(nodeModelTask.getModel() instanceof UINodeModel)) {
                return null;
            }
            return nodeModelTask;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            NodeModelTask nodeModelTask = this.getSelectedNodeModelTask();
            this.get(EditAsNewJob.class).setEnabled(nodeModelTask != null);
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", "Run");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<Task> list = HistoryTableView.this.getSelectedHistories();
                for (Task task : list) {
                    task = task.copy();
                    task.reset();
                    TaskQueue.getInstance().addTask(task);
                }
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", "Remove");
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<Task> list = HistoryTableView.this.getSelectedHistories();
                for (int i = list.size() - 1; i >= 0; --i) {
                    Task task = list.get(i);
                    HistoryManager.getInstance().remove(task);
                }
            }
        }

        private class Cancel
        extends LoggableAction {
            public Cancel() {
                this.putValue("Name", "Cancel");
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<Task> list = HistoryTableView.this.getSelectedHistories();
                for (Task task : list) {
                    TaskQueue.getInstance().cancel(task);
                }
            }
        }

        private class EditAsNewJob
        extends LoggableAction {
            public EditAsNewJob() {
                this.putValue("Name", "Edit as New Job");
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeModelTask nodeModelTask = HistoryActions.this.getSelectedNodeModelTask();
                Operation operation = ((UINodeModel)nodeModelTask.getModel()).getModel();
                OpWizardAction opWizardAction = new OpWizardAction(operation, null);
                opWizardAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }
}

