/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.feature.history;

import com.ef_prime.rflow.core.feature.history.HistoryManager;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskError;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.node.ui.OpWizardAction;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LazyLoadingTreeNode;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemSelectable;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEvent;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.task.TaskTransferable;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ItemPreviewView;
import com.google.common.base.Joiner;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class HistoryView
extends View
implements TreeSelectionListener,
TreeModelListener,
ItemSelectable {
    private JTree tree;
    private HistoryActions actions;
    private EventSupport<ItemSelectionEvent, ItemSelectionEventHandler> eventSupport = new EventSupport();

    public HistoryView(DefaultTreeModel defaultTreeModel) {
        this.setTitle("History");
        this.setIcon(Icons.getIcon("16/clock_history_frame.png"));
        this.setIconOnly(true);
        this.tree = new HistoryTree(defaultTreeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new HistoryRenderer());
        this.tree.addMouseListener(new MouseHandler());
        this.tree.addTreeSelectionListener(this);
        this.tree.getModel().addTreeModelListener(this);
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new HistoryTransferHandler());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setBorder(null);
        this.add((Component)ItemPreviewView.createHorizontalSplitPane(jScrollPane, this));
        this.actions = new HistoryActions();
        this.actions.installActions(this.tree, false, 1);
        this.tree.addTreeSelectionListener(this.actions);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        ItemSelectionEvent itemSelectionEvent = new ItemSelectionEvent(this.getSelectedItem(), false, false);
        this.eventSupport.dispatchEvent(itemSelectionEvent);
        EventManager.getInstance().dispatchEvent(itemSelectionEvent);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.tree.repaint();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().getPathCount() == 1) {
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray == null) {
                return;
            }
            Task task = (Task)objectArray[objectArray.length - 1];
            this.tree.scrollPathToVisible(treeModelEvent.getTreePath().pathByAddingChild(task));
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    private List<Task> getSelectedHistories() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                Task task = (Task)treePathArray[i].getLastPathComponent();
                arrayList.add(task);
            }
        }
        return arrayList;
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get("RUN"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get("CANCEL"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get("REMOVE"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get("EDIT_AS_NEW_JOB"));
        UIUtility.cleanUpPopupMenu(jPopupMenu);
        return jPopupMenu;
    }

    @Override
    public Item getSelectedItem() {
        List<Task> list = this.getSelectedHistories();
        return list.isEmpty() ? null : new TaskTransferable(list);
    }

    @Override
    public void addItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.addEventHandler(itemSelectionEventHandler);
    }

    @Override
    public void removeItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.removeEventHandler(itemSelectionEventHandler);
    }

    private static class HistoryTree
    extends JTree
    implements TreeWillExpandListener {
        public HistoryTree(DefaultTreeModel defaultTreeModel) {
            super(defaultTreeModel);
            this.addTreeWillExpandListener(this);
        }

        @Override
        public DefaultTreeModel getModel() {
            return (DefaultTreeModel)super.getModel();
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                TaskError taskError;
                Task task = (Task)treePath.getLastPathComponent();
                if (task.isError() && (taskError = task.getError()) != null) {
                    return taskError.getTitle() + " : " + taskError.getDescription();
                }
                if (task.isWarning()) {
                    return "Warning : " + Joiner.on((char)'\n').join(task.getWarnings());
                }
            }
            return null;
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            JTree jTree = (JTree)treeExpansionEvent.getSource();
            if (jTree.hasBeenExpanded(treeExpansionEvent.getPath())) {
                return;
            }
            final MutableTreeNode mutableTreeNode = (MutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            if (!(mutableTreeNode instanceof LazyLoadingTreeNode)) {
                return;
            }
            SwingWorker<List<? extends MutableTreeNode>, Void> swingWorker = new SwingWorker<List<? extends MutableTreeNode>, Void>(){

                @Override
                protected List<? extends MutableTreeNode> doInBackground() throws Exception {
                    return ((LazyLoadingTreeNode)((Object)mutableTreeNode)).getNewChildren();
                }

                @Override
                protected void done() {
                    List list;
                    try {
                        list = (List)this.get();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    catch (ExecutionException executionException) {
                        return;
                    }
                    for (int i = mutableTreeNode.getChildCount() - 1; i >= 0; --i) {
                        mutableTreeNode.remove(i);
                    }
                    for (MutableTreeNode mutableTreeNode2 : list) {
                        mutableTreeNode.insert(mutableTreeNode2, mutableTreeNode.getChildCount());
                    }
                    this.getModel().nodeStructureChanged(mutableTreeNode);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            };
            this.setCursor(Cursor.getPredefinedCursor(3));
            swingWorker.execute();
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }
    }

    private static class HistoryRenderer
    extends DefaultTreeCellRenderer {
        private static final ImageIcon RUNNING = Icons.getIcon("16/update.png");

        public HistoryRenderer() {
            this.setFont(new Font("Monospaced", 0, 12));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Task task = (Task)object;
            this.setText(task.getTitle());
            ImageIcon imageIcon = (ImageIcon)task.getIcon();
            if (task.getState() == 2) {
                imageIcon = RUNNING;
            }
            String string = null;
            if (task.isError()) {
                string = "16/cancel.png";
            } else if (task.isCancelled()) {
                string = "16/control_pause.png";
            } else if (task.isWarning()) {
                string = "16/error.png";
            } else if (task.isDone() && !task.isCancelled()) {
                string = "16/accept.png";
            }
            if (string == null) {
                this.setIcon(imageIcon);
            } else {
                this.setIcon(Icons.getOverlaidIcon(imageIcon, string));
            }
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                TreePath treePath = HistoryView.this.tree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (treePath != null && !HistoryView.this.tree.getSelectionModel().isPathSelected(treePath)) {
                    HistoryView.this.tree.setSelectionPath(treePath);
                }
                JPopupMenu jPopupMenu = HistoryView.this.createPopup();
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            } else if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                HistoryView.this.actions.doAction("EDIT_AS_NEW_JOB");
            }
        }
    }

    private class HistoryTransferHandler
    extends TransferHandler {
        private HistoryTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            List<Task> list = HistoryView.this.getSelectedHistories();
            if (list.isEmpty()) {
                return null;
            }
            return new TaskTransferable(list);
        }
    }

    private class HistoryActions
    extends Actions
    implements TreeSelectionListener {
        private static final String RUN = "RUN";
        private static final String REMOVE = "REMOVE";
        private static final String CANCEL = "CANCEL";
        private static final String EDIT_AS_NEW_JOB = "EDIT_AS_NEW_JOB";

        public HistoryActions() {
            this.put(RUN, new Run());
            this.put(REMOVE, new Remove());
            this.put(CANCEL, new Cancel());
            this.put(EDIT_AS_NEW_JOB, new EditAsNewJob());
        }

        private NodeModelTask getSelectedNodeModelTask() {
            List<Task> list = HistoryView.this.getSelectedHistories();
            if (list.size() != 1) {
                return null;
            }
            Task task = list.get(0);
            if (!(task instanceof NodeModelTask)) {
                return null;
            }
            NodeModelTask nodeModelTask = (NodeModelTask)task;
            if (!(nodeModelTask.getModel() instanceof UINodeModel)) {
                return null;
            }
            return nodeModelTask;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            NodeModelTask nodeModelTask = this.getSelectedNodeModelTask();
            this.get(EDIT_AS_NEW_JOB).setEnabled(nodeModelTask != null);
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", "Run");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<Task> list = HistoryView.this.getSelectedHistories();
                for (Task task : list) {
                    task = task.copy();
                    task.reset();
                    TaskQueue.getInstance().addTask(task);
                }
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", "Remove");
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<Task> list = HistoryView.this.getSelectedHistories();
                for (int i = list.size() - 1; i >= 0; --i) {
                    Task task = list.get(i);
                    HistoryManager.getInstance().remove(task);
                }
            }
        }

        private class Cancel
        extends LoggableAction {
            public Cancel() {
                this.putValue("Name", "Cancel");
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<Task> list = HistoryView.this.getSelectedHistories();
                for (Task task : list) {
                    TaskQueue.getInstance().cancel(task);
                }
            }
        }

        private class EditAsNewJob
        extends LoggableAction {
            public EditAsNewJob() {
                this.putValue("Name", "Edit as New Job");
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeModelTask nodeModelTask = HistoryActions.this.getSelectedNodeModelTask();
                Operation operation = ((UINodeModel)nodeModelTask.getModel()).getModel();
                OpWizardAction opWizardAction = new OpWizardAction(operation, null);
                opWizardAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }
}

