/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.feature.search;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchCursorEvent;
import com.ef_prime.rflow.core.feature.search.SearchNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchStateChangedEvent;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.ActiveViewerListener;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.ClearableTextField;
import com.ef_prime.rflow.ui.common.component.FloatLayout;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowScrollPane;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.component.ShapeIconFactory;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewSelectionEvent;
import com.ef_prime.rflow.ui.feature.search.RegexHelp;
import com.ef_prime.rflow.ui.flow.FlowBrowseView;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.HighlightChangedEvent;
import com.ef_prime.rflow.ui.flow.rendering.NodeRendering;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import com.ef_prime.rflow.ui.view.FlowNodePreviewView;
import com.ef_prime.rflow.ui.view.MainView;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.math.NumberUtils;

public class SearchExplorer
extends View
implements NodeModelChangeListener,
ItemListener,
SimpleEventHandler,
ActiveViewerListener,
ActiveViewEventHandler {
    private static final Logger LOGGER = Logger.getLogger(SearchExplorer.class.getName());
    private static final String ROOT = "";
    private final Color EMPTY_FILL_COLOR = new Color(250, 250, 250);
    private final Color FILL_COLOR;
    private ClearableTextField searchField;
    private ClearableTextField replaceField;
    private JCheckBox checkObject;
    private JCheckBox checkMatchCase;
    private JCheckBox checkRegex;
    private JCheckBox checkSearchAll;
    private JCheckBox checkScriptSearch;
    private RflowTree tree;
    private SearchTreeSelectionHandler treeSelectionHandler = new SearchTreeSelectionHandler();
    private HighlightChangedHandler highlightChangedHandler = new HighlightChangedHandler();
    private SearchContext context;
    private Map<FlowNode, SearchNode> searchNodeMap = new HashMap<FlowNode, SearchNode>();
    private Integer inNodeSelectionIndex;
    private boolean inNodeSelectionIndexBefore;
    private View lastSelectionView;
    private FlowNode currentNode;
    private int hitCount;
    private boolean lockNodeModelChanged;
    private boolean lockSearchCursorChanged;
    private ExecutorService executorService;
    private Future<?> executionFuture;
    private NodeRendering nodeRendering;
    private FlowModel model;

    public SearchExplorer() {
        this.setTitle(Messages.getString("Action.find_replace"));
        this.setIconOnly(true);
        this.setIcon(Icons.getIcon("16/magnifier.png"));
        this.setFocusable(true);
        SearchActions searchActions = new SearchActions();
        searchActions.installActions(this, false);
        searchActions.installAcceleratorKeys(this, 2, "PREVIOUS", "NEXT");
        this.searchField = new ClearableTextField("Enter search word");
        this.searchField.getActionMap().put("REFRESH", searchActions.get("REFRESH"));
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "REFRESH");
        FontSupport.setCodeFont((Component)((Object)this.searchField));
        SearchFieldHandler searchFieldHandler = new SearchFieldHandler();
        this.searchField.addFocusListener(searchFieldHandler);
        this.searchField.getDocument().addDocumentListener(searchFieldHandler);
        this.replaceField = new ClearableTextField(Messages.getString("View.FindReplace.replace_prompt"));
        FontSupport.setCodeFont((Component)((Object)this.replaceField));
        this.replaceField.setToolTipText(null);
        this.replaceField.getDocument().addDocumentListener(new ReplaceFieldHandler());
        this.checkObject = new JCheckBox(searchActions.get("CHECK_WHOLEWORD"));
        this.checkMatchCase = new JCheckBox(searchActions.get(SearchActions.CheckMatchCase.class));
        this.checkRegex = new JCheckBox(searchActions.get("CHECK_REGEX"));
        this.checkSearchAll = new JCheckBox(searchActions.get("CHECK_SEARCHALL"));
        this.checkScriptSearch = new JCheckBox(searchActions.get(SearchActions.CheckScriptSearch.class));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx, insets 5, gap 5 5"));
        jPanel.add((Component)((Object)this.searchField), "growx, wrap");
        jPanel.add((Component)((Object)this.replaceField), "growx");
        JPanel jPanel2 = new JPanel(new FloatLayout(0, 2));
        jPanel2.add(this.checkObject);
        jPanel2.add(this.checkMatchCase);
        jPanel2.add(this.checkRegex);
        jPanel2.add(new RegexHelp());
        jPanel2.add(this.checkSearchAll);
        jPanel2.add(this.checkScriptSearch);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        JButton jButton = new JButton(searchActions.get("PREVIOUS"));
        JButton jButton2 = new JButton(searchActions.get("NEXT"));
        JButton jButton3 = new JButton(searchActions.get("REPLACE"));
        JButton jButton4 = new JButton(searchActions.get("REPLACE_AND_FIND"));
        JButton jButton5 = new JButton(searchActions.get("REPLACE_ALL"));
        jButton.setHideActionText(true);
        jButton2.setHideActionText(true);
        JButton jButton6 = new JButton(searchActions.get("NEXT"));
        int n = NumberUtils.max((int)jButton3.getPreferredSize().width, (int)jButton4.getPreferredSize().width, (int)jButton5.getPreferredSize().width);
        n = Math.max(n, jButton6.getPreferredSize().width);
        JButton jButton7 = new JButton(searchActions.get("CLEAR"));
        SearchNode searchNode = SearchNode.createContainerNode(ROOT);
        this.tree = new RflowTree(new DefaultTreeModel(searchNode, true));
        this.tree.setFontFamily("Monospaced");
        this.tree.setCellRenderer(new SearchTreeRenderer());
        UIUtility.insertMouseListener(this.tree, new SearchTreeMouseHandler());
        this.tree.addTreeSelectionListener(this.treeSelectionHandler);
        this.FILL_COLOR = this.tree.getBackground();
        this.tree.setBackground(this.EMPTY_FILL_COLOR);
        RflowScrollPane rflowScrollPane = new RflowScrollPane(this.tree);
        rflowScrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx, insets 5, gap 5 5"));
        jPanel4.add((Component)jButton, "w 24!,h 24!, split 5");
        jPanel4.add((Component)jButton2, "w 24!,h 24!");
        jPanel4.add((Component)jButton3, "h 24!");
        jPanel4.add((Component)jButton4, "h 24!");
        jPanel4.add((Component)jButton5, "h 24!");
        jPanel4.add((Component)jButton7, "h 24!, alignx right, wrap");
        jPanel4.add((Component)rflowScrollPane, "span 2, growx");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel4, "Center");
        FlowNode.addNodeModelChangeListener(this);
        EventManager.getInstance().registerEventHandler(ViewSelectionEvent.class, this);
        EventManager.getInstance().registerEventHandler(SearchCursorEvent.class, this);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
        EventManager.getInstance().registerEventHandler(HighlightChangedEvent.class, this.highlightChangedHandler);
    }

    public void setSearchWord(String string) {
        this.searchField.setText(string);
    }

    public void requestFocusOnSearchField() {
        this.toFront();
        this.searchField.requestFocusInWindow();
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    private SearchNode getRootNode() {
        return (SearchNode)this.getTreeModel().getRoot();
    }

    private void fireSearchStateChanged() {
        this.updateReplaceButton();
        EventManager.getInstance().dispatchEvent(this.createStateChangedEvent());
    }

    public SearchStateChangedEvent createStateChangedEvent() {
        return new SearchStateChangedEvent(new HashMap<FlowNode, SearchNode>(this.searchNodeMap));
    }

    private SearchContext createSearchContext(String string) {
        if (this.model == null) {
            return null;
        }
        FlowNode flowNode = this.currentNode;
        if (flowNode == null) {
            flowNode = this.model.getLayout().getGraph().getParentNode();
        }
        return new SearchContext(flowNode, string, this.checkObject.isSelected(), this.checkMatchCase.isSelected(), this.checkRegex.isSelected(), this.checkSearchAll.isSelected(), this.checkScriptSearch.isSelected());
    }

    private void refresh(String string) {
        if (this.executionFuture != null) {
            this.executionFuture.cancel(true);
        }
        if (this.context != null) {
            this.context = null;
            this.getTreeModel().setRoot(SearchNode.createContainerNode(ROOT));
            this.tree.setBackground(this.EMPTY_FILL_COLOR);
            this.setTotalHitCount(null);
            this.searchNodeMap.clear();
            this.fireSearchStateChanged();
        }
        if (!string.isEmpty() && this.model != null) {
            this.context = this.createSearchContext(string);
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)ThreadUtility.threadFactory("Search-%d", true));
            }
            this.executionFuture = this.executorService.submit(new SearchWorker(this.context));
        }
    }

    private void setTotalHitCount(Integer n) {
        this.hitCount = 0;
        if (this.getRootNode() == null) {
            return;
        }
        if (n == null) {
            this.getRootNode().setTitle(ROOT);
        } else {
            this.hitCount = n;
            if (this.getRootNode().isFlowNode()) {
                String string = this.getRootNode().getFlowNode().getTitle();
                this.getRootNode().setTitle(string + " [" + n + "]");
            } else {
                this.getRootNode().setTitle(" [" + n + "]");
            }
        }
        this.getTreeModel().nodeChanged(this.getRootNode());
        boolean bl = n != null && n > 0;
        this.getActionMap().get("NEXT").setEnabled(bl);
        this.getActionMap().get("PREVIOUS").setEnabled(bl);
        this.getActionMap().get("REPLACE_ALL").setEnabled(bl);
        this.updateReplaceButton();
    }

    private void openNode(final SearchNode searchNode, final int n, boolean bl) {
        FlowNodeView flowNodeView;
        if (!searchNode.isFlowNode() || searchNode.getFlowNode().getGraph() == null) {
            return;
        }
        FlowNode flowNode = searchNode.getFlowNode().getParentNode();
        if (flowNode == null) {
            return;
        }
        this.lockSearchCursorChanged = true;
        MainView mainView = Rflow.mainView();
        View view2 = mainView.openViewer(flowNode, bl ? ViewOpenType.OPEN_NEW : ViewOpenType.OPEN);
        boolean bl2 = false;
        if (view2 instanceof FlowBrowseView && (flowNodeView = ((FlowBrowseView)view2).getFlowNodeView()) instanceof SubflowNodeView) {
            for (FlowViewer flowViewer : ((SubflowNodeView)flowNodeView).getViewers()) {
                FlowNodePreviewView flowNodePreviewView;
                if (!flowViewer.getGraph().contains((Vertex)searchNode.getFlowNode())) continue;
                Set<FlowNode> set = flowViewer.getPickedState().getPickedVertices();
                if (set.size() != 1 || !set.contains(searchNode.getFlowNode())) {
                    flowViewer.getPickedState().setPicked((ArchetypeVertex)searchNode.getFlowNode());
                }
                if ((flowNodePreviewView = ((FlowBrowseView)view2).getPreviewView()) == null) continue;
                this.lastSelectionView = flowNodePreviewView.getView();
                if (this.lastSelectionView == null) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            this.lockSearchCursorChanged = false;
            return;
        }
        if (searchNode.getHitCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SearchExplorer.this.lastSelectionView != null) {
                        SearchExplorer.this.lastSelectionView.select(searchNode.getSearchResult(n));
                    }
                    SearchExplorer.this.updateReplaceButton();
                    SearchExplorer.this.lockSearchCursorChanged = false;
                }
            });
        }
    }

    private SearchNode canReplace() {
        TreePath treePath = this.tree.getSelectionPath();
        SearchNode searchNode = treePath == null ? (SearchNode)this.getTreeModel().getRoot() : (SearchNode)treePath.getLastPathComponent();
        if (this.lastSelectionView != null && this.lastSelectionView.isDisplayable() && this.lastSelectionView.isShowing() && searchNode.isFlowNode() && this.inNodeSelectionIndex != null && !this.inNodeSelectionIndexBefore && this.inNodeSelectionIndex >= 0 && this.inNodeSelectionIndex < searchNode.getResultCount() && searchNode.getSearchResult(this.inNodeSelectionIndex).isEnabled() && searchNode.getSearchResult(this.inNodeSelectionIndex).canReplace()) {
            return searchNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceCurrentMatch(boolean bl) {
        SearchNode searchNode = this.canReplace();
        if (searchNode != null) {
            boolean bl2;
            this.lockNodeModelChanged = true;
            this.lockSearchCursorChanged = true;
            try {
                bl2 = searchNode.getFlowNode().getModel().replace(this.context, this.replaceField.getText(), searchNode.getSearchResults(), this.inNodeSelectionIndex);
                if (bl2) {
                    FlowNode.fireNodeModelChanged(searchNode.getFlowNode());
                    EventManager.getInstance().dispatchEvent(RequestNodeModelNotifyEvent.getInstance());
                }
            }
            finally {
                this.lockNodeModelChanged = false;
                this.lockSearchCursorChanged = false;
            }
            if (bl2) {
                SearchResult searchResult = searchNode.getSearchResult(this.inNodeSelectionIndex);
                searchResult.setEnabled(false);
            }
            if (bl) {
                this.nextMatch(false);
            }
            if (bl2) {
                if (searchNode.getHitCount() == 0) {
                    this.refreshTree();
                } else {
                    this.setTotalHitCount(--this.hitCount);
                    this.getTreeModel().nodeChanged(searchNode);
                    this.fireSearchStateChanged();
                }
            } else {
                this.fireSearchStateChanged();
            }
        } else {
            this.nextMatch(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAll() {
        int n = JOptionPane.showConfirmDialog(this, Messages.getString("View.FindReplace.confirm_replace_all"), Messages.getString("Error.title.warning"), 0, 2);
        if (n != 0) {
            return;
        }
        this.lockNodeModelChanged = true;
        this.lockSearchCursorChanged = true;
        try {
            Enumeration<TreeNode> enumeration = this.getRootNode().preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                SearchNode searchNode = (SearchNode)enumeration.nextElement();
                if (searchNode.getHitCount() <= 0) continue;
                for (int i = 0; i < searchNode.getResultCount(); ++i) {
                    boolean bl;
                    SearchResult searchResult = searchNode.getSearchResult(i);
                    if (!searchResult.isEnabled() || !(bl = searchNode.getFlowNode().getModel().replace(this.context, this.replaceField.getText(), searchNode.getSearchResults(), i))) continue;
                    searchResult.setEnabled(false);
                }
            }
            EventManager.getInstance().dispatchEvent(RequestNodeModelNotifyEvent.getInstance());
            this.refreshTree();
        }
        finally {
            this.lockNodeModelChanged = false;
            this.lockSearchCursorChanged = false;
        }
    }

    private void nextMatch(boolean bl) {
        TreePath treePath = this.tree.getSelectionPath();
        SearchNode searchNode = treePath == null ? this.getRootNode() : (SearchNode)treePath.getLastPathComponent();
        boolean bl2 = false;
        while (true) {
            Object object;
            if (searchNode.getHitCount() > 0) {
                if (this.inNodeSelectionIndex == null) {
                    this.inNodeSelectionIndex = bl ? searchNode.getResultCount() - 1 : 0;
                } else if (bl) {
                    this.inNodeSelectionIndex = this.inNodeSelectionIndex - 1;
                    this.inNodeSelectionIndexBefore = false;
                } else if (this.inNodeSelectionIndexBefore) {
                    this.inNodeSelectionIndexBefore = false;
                } else {
                    this.inNodeSelectionIndex = this.inNodeSelectionIndex + 1;
                }
                while (this.inNodeSelectionIndex >= 0 && this.inNodeSelectionIndex < searchNode.getResultCount()) {
                    object = searchNode.getSearchResult(this.inNodeSelectionIndex);
                    if (!((SearchResult)object).isEnabled()) {
                        this.inNodeSelectionIndex = this.inNodeSelectionIndex + (bl ? -1 : 1);
                        continue;
                    }
                    TreePath treePath2 = new TreePath(this.getTreeModel().getPathToRoot(searchNode));
                    this.treeSelectionHandler.enabled = false;
                    this.tree.setSelectionPath(treePath2);
                    this.treeSelectionHandler.enabled = true;
                    this.tree.scrollPathToVisible(treePath2);
                    this.openNode(searchNode, this.inNodeSelectionIndex, false);
                    this.updateReplaceButton();
                    return;
                }
            }
            this.inNodeSelectionIndex = null;
            this.inNodeSelectionIndexBefore = false;
            this.lastSelectionView = null;
            object = (SearchNode)(bl ? searchNode.getPreviousNode() : searchNode.getNextNode());
            if (object == null) {
                searchNode = this.getRootNode();
                if (bl) {
                    searchNode = (SearchNode)searchNode.getLastLeaf();
                }
                if (bl2) {
                    return;
                }
                bl2 = true;
                continue;
            }
            searchNode = object;
        }
    }

    private void delete() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            SearchNode searchNode = (SearchNode)treePath.getLastPathComponent();
            if (searchNode.getParent() == null) continue;
            this.getTreeModel().removeNodeFromParent(searchNode);
        }
        this.refreshTree();
    }

    private void refreshTree() {
        this.searchNodeMap.clear();
        SearchNode searchNode = (SearchNode)this.getRootNode().getLastLeaf();
        int n = 0;
        while (searchNode != null) {
            SearchNode searchNode2 = searchNode;
            searchNode = (SearchNode)searchNode.getPreviousNode();
            n += searchNode2.getHitCount();
            this.searchNodeMap.put(searchNode2.getFlowNode(), searchNode2);
        }
        this.setTotalHitCount(n);
        this.fireSearchStateChanged();
    }

    private void updateReplaceButton() {
        Action action = this.getActionMap().get("REPLACE");
        Action action2 = this.getActionMap().get("REPLACE_AND_FIND");
        boolean bl = this.canReplace() != null;
        action.setEnabled(bl);
        action2.setEnabled(bl);
    }

    private void updateSearchFieldPrompt() {
        String string = ROOT;
        if (this.currentNode == null || this.checkSearchAll.isSelected()) {
            if (this.model != null) {
                string = this.model.getTitle();
            }
        } else {
            string = this.currentNode.getTitle();
        }
        this.searchField.setPrompt(Messages.getString("View.FindReplace.find_prompt") + ": " + string);
        this.searchField.setToolTipText(null);
    }

    private void updateClearButton() {
        boolean bl = !this.searchField.getText().isEmpty() || !this.replaceField.getText().isEmpty() || this.checkObject.isSelected() || this.checkMatchCase.isSelected() || this.checkRegex.isSelected() || this.checkSearchAll.isSelected();
        this.getActionMap().get("CLEAR").setEnabled(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateSearchFieldPrompt();
        this.refresh(this.searchField.getText());
        this.updateClearButton();
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        this.refreshNode(flowNode);
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        this.refreshNode(flowNode);
    }

    private void refreshNode(FlowNode flowNode) {
        if (this.lockNodeModelChanged) {
            return;
        }
        SearchNode searchNode = this.searchNodeMap.get(flowNode);
        if (searchNode != null && this.executorService != null) {
            this.executorService.execute(new SingleSearchWorker(searchNode));
        }
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (SearchCursorEvent.class.equals(simpleEvent.getClass())) {
            if (this.lockSearchCursorChanged) {
                return;
            }
            SearchCursorEvent searchCursorEvent = (SearchCursorEvent)simpleEvent;
            TreePath treePath = new TreePath(searchCursorEvent.getNode().getPath());
            this.tree.setSelectionPath(treePath);
            this.inNodeSelectionIndex = searchCursorEvent.getIndex();
            this.inNodeSelectionIndexBefore = searchCursorEvent.isBeforeIndex();
            this.lastSelectionView = searchCursorEvent.getView();
            this.updateReplaceButton();
        }
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view2;
        FlowModel flowModel = activeViewEvent.getActiveFileEdit(FlowModel.class);
        if (this.model != flowModel) {
            this.model = flowModel;
            this.nodeRendering = this.model == null ? null : new NodeRendering(this.model.getState());
            this.searchField.clearText();
            this.currentNode = null;
            this.refresh(ROOT);
        }
        if ((view2 = activeViewEvent.getActiveView()) instanceof FlowBrowseView) {
            this.currentNode = ((FlowBrowseView)view2).getNode();
        } else if (this.model != null && this.model.contains(activeViewEvent.getActiveNode())) {
            this.currentNode = activeViewEvent.getActiveNode();
        }
        this.updateSearchFieldPrompt();
    }

    @Override
    public void activeViewerChanged(FlowViewer flowViewer) {
        this.updateReplaceButton();
    }

    private class SearchTreeSelectionHandler
    implements TreeSelectionListener {
        private boolean enabled = true;

        private SearchTreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!this.enabled || SearchExplorer.this.model == null) {
                return;
            }
            SearchExplorer.this.inNodeSelectionIndex = null;
            SearchExplorer.this.inNodeSelectionIndexBefore = false;
            SearchExplorer.this.lastSelectionView = null;
            TreePath[] treePathArray = SearchExplorer.this.tree.getSelectionPaths();
            ArrayDeque<SearchNode> arrayDeque = new ArrayDeque<SearchNode>();
            if (treePathArray != null) {
                for (TreePath treePath : treePathArray) {
                    arrayDeque.add((SearchNode)treePath.getLastPathComponent());
                }
            }
            HashSet hashSet = new HashSet();
            while (!arrayDeque.isEmpty()) {
                SearchNode searchNode = (SearchNode)arrayDeque.removeFirst();
                if (searchNode.isFlowNode()) {
                    if (hashSet.contains(searchNode.getFlowNode())) continue;
                    if (!searchNode.getFlowNode().isRootNode() && searchNode.containsHit()) {
                        hashSet.add(searchNode.getFlowNode());
                    }
                }
                if (searchNode.getChildCount() <= 0) continue;
                Enumeration<TreeNode> enumeration = searchNode.children();
                while (enumeration.hasMoreElements()) {
                    arrayDeque.add((SearchNode)enumeration.nextElement());
                }
            }
            EventManager.getInstance().removeEventHandler(HighlightChangedEvent.class, SearchExplorer.this.highlightChangedHandler);
            SearchExplorer.this.model.getState().clearTaskHighlightNode();
            EventManager.getInstance().registerEventHandler(HighlightChangedEvent.class, SearchExplorer.this.highlightChangedHandler);
            if (!hashSet.isEmpty()) {
                SearchExplorer.this.model.getState().addTaskHighlightNode(hashSet);
            }
            SearchExplorer.this.tree.repaint();
            SearchExplorer.this.updateReplaceButton();
        }
    }

    private class HighlightChangedHandler
    implements SimpleEventHandler {
        private HighlightChangedHandler() {
        }

        @Override
        public void onEvent(SimpleEvent simpleEvent) {
            HighlightChangedEvent highlightChangedEvent;
            if (simpleEvent.getClass().equals(HighlightChangedEvent.class) && !SearchExplorer.this.lockSearchCursorChanged && !(highlightChangedEvent = (HighlightChangedEvent)simpleEvent).getState().isTaskHighlight()) {
                SearchExplorer.this.tree.clearSelection();
            }
        }
    }

    private class SearchActions
    extends Actions {
        private static final String CHECK_WHOLEWORD = "CHECK_WHOLEWORD";
        private static final String CHECK_REGEX = "CHECK_REGEX";
        private static final String CHECK_SEARCHALL = "CHECK_SEARCHALL";
        private static final String REFRESH = "REFRESH";
        private static final String PREVIOUS = "PREVIOUS";
        private static final String NEXT = "NEXT";
        private static final String REPLACE = "REPLACE";
        private static final String REPLACE_AND_FIND = "REPLACE_AND_FIND";
        private static final String REPLACE_ALL = "REPLACE_ALL";
        private static final String DELETE = "DELETE";
        private static final String CLEAR = "CLEAR";

        public SearchActions() {
            this.put(CHECK_WHOLEWORD, new CheckWholeWord());
            this.put(new CheckMatchCase());
            this.put(CHECK_REGEX, new CheckRegex());
            this.put(CHECK_SEARCHALL, new CheckSearchAll());
            this.put(new CheckScriptSearch());
            this.put(REFRESH, new Refresh());
            this.put(PREVIOUS, new Previous());
            this.put(NEXT, new Next());
            this.put(REPLACE, new Replace());
            this.put(REPLACE_AND_FIND, new ReplaceAndFind());
            this.put(REPLACE_ALL, new ReplaceAll());
            this.put(DELETE, new Delete());
            this.put(CLEAR, new Clear());
            this.get(PREVIOUS).setEnabled(false);
            this.get(NEXT).setEnabled(false);
            this.get(REPLACE).setEnabled(false);
            this.get(REPLACE_AND_FIND).setEnabled(false);
            this.get(REPLACE_ALL).setEnabled(false);
            this.get(CLEAR).setEnabled(false);
        }

        private class CheckWholeWord
        extends CheckAction {
            public CheckWholeWord() {
                this.putValue("Name", Messages.getString("View.FindReplace.whole_word"));
            }
        }

        private class CheckMatchCase
        extends CheckAction {
            public CheckMatchCase() {
                this.putValue("Name", Messages.getString("View.FindReplace.match_case"));
            }
        }

        private class CheckRegex
        extends CheckAction {
            public CheckRegex() {
                this.putValue("Name", Messages.getString("View.FindReplace.regex"));
            }
        }

        private class CheckSearchAll
        extends CheckAction {
            public CheckSearchAll() {
                this.putValue("Name", Messages.getString("View.FindReplace.search_all"));
            }
        }

        private class CheckScriptSearch
        extends CheckAction {
            public CheckScriptSearch() {
                this.putValue("Name", Messages.getString("View.FindReplace.script_search"));
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.refresh(SearchExplorer.this.searchField.getText());
            }
        }

        private class Previous
        extends LoggableAction {
            public Previous() {
                this.putValue("Name", Messages.getString("Action.previous_match"));
                this.putValue("SmallIcon", ShapeIconFactory.create(1, 12, Color.BLACK));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 64));
                UIUtility.setShortDescription(this);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.nextMatch(true);
            }
        }

        private class Next
        extends LoggableAction {
            public Next() {
                this.putValue("Name", Messages.getString("Action.next_match"));
                this.putValue("SmallIcon", ShapeIconFactory.create(0, 12, Color.BLACK));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
                UIUtility.setShortDescription(this);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.nextMatch(false);
            }
        }

        private class Replace
        extends LoggableAction {
            public Replace() {
                this.putValue("Name", Messages.getString("Action.replace"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.replaceCurrentMatch(false);
            }
        }

        private class ReplaceAndFind
        extends LoggableAction {
            public ReplaceAndFind() {
                this.putValue("Name", Messages.getString("Action.replace_and_find"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.replaceCurrentMatch(true);
            }
        }

        private class ReplaceAll
        extends LoggableAction {
            public ReplaceAll() {
                this.putValue("Name", Messages.getString("Action.replace_all"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.replaceAll();
            }
        }

        private class Delete
        extends LoggableAction {
            public Delete() {
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.delete();
            }
        }

        private class Clear
        extends LoggableAction {
            public Clear() {
                this.putValue("Name", Messages.getString("Action.clear"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.searchField.clearText();
                SearchExplorer.this.replaceField.clearText();
                SearchExplorer.this.checkObject.setSelected(false);
                SearchExplorer.this.checkMatchCase.setSelected(false);
                SearchExplorer.this.checkRegex.setSelected(false);
                SearchExplorer.this.checkSearchAll.setSelected(false);
            }
        }

        private abstract class CheckAction
        extends LoggableAction {
            private CheckAction() {
            }

            @Override
            public void prepareLog(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                this.putValue("logparameter", jCheckBox.isSelected() ? "on" : "off");
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SearchExplorer.this.updateSearchFieldPrompt();
                SearchExplorer.this.refresh(SearchExplorer.this.searchField.getText());
                SearchExplorer.this.updateClearButton();
            }
        }
    }

    private class SearchFieldHandler
    implements DocumentListener,
    FocusListener {
        private SearchFieldHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SearchExplorer.this.refresh(SearchExplorer.ROOT);
            SearchExplorer.this.updateClearButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SearchExplorer.this.refresh(SearchExplorer.ROOT);
            SearchExplorer.this.updateClearButton();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            SearchExplorer.this.refresh(SearchExplorer.ROOT);
            SearchExplorer.this.updateClearButton();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string = SearchExplorer.this.searchField.getText();
            if (SearchExplorer.this.context == null && string.isEmpty()) {
                return;
            }
            if (SearchExplorer.this.context != null && SearchExplorer.this.context.equals(SearchExplorer.this.createSearchContext(string))) {
                return;
            }
            SearchExplorer.this.refresh(string);
        }
    }

    private class ReplaceFieldHandler
    implements DocumentListener {
        private ReplaceFieldHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SearchExplorer.this.updateClearButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SearchExplorer.this.updateClearButton();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            SearchExplorer.this.updateClearButton();
        }
    }

    private class SearchTreeRenderer
    extends DefaultTreeCellRenderer {
        private SearchTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            SearchNode searchNode = (SearchNode)object;
            if (searchNode.isFlowNode()) {
                if (SearchExplorer.this.nodeRendering != null) {
                    this.setIcon(SearchExplorer.this.nodeRendering.getSmallIcon((Vertex)searchNode.getFlowNode()));
                }
            } else {
                this.setIcon(null);
            }
            this.setEnabled(searchNode.containsHit());
            return this;
        }
    }

    private class SearchTreeMouseHandler
    extends MouseAdapter {
        private SearchTreeMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            if (mouseEvent.getClickCount() == 2 && UIUtility.isLeftMouseButton(mouseEvent)) {
                SearchNode searchNode = (SearchNode)treePath.getLastPathComponent();
                SearchExplorer.this.inNodeSelectionIndex = 0;
                boolean bl = (mouseEvent.getModifiers() & UIUtility.MENU_KEY_MASK) == UIUtility.MENU_KEY_MASK;
                SearchExplorer.this.openNode(searchNode, SearchExplorer.this.inNodeSelectionIndex, bl);
                mouseEvent.consume();
                SearchExplorer.this.treeSelectionHandler.enabled = false;
                jTree.setSelectionPath(treePath);
                SearchExplorer.this.treeSelectionHandler.enabled = true;
            }
        }
    }

    private class SearchWorker
    extends SwingWorker<Void, Void> {
        private SearchContext context;
        private SearchNode root;
        private int hitCount;

        public SearchWorker(SearchContext searchContext) {
            this.context = searchContext;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (this.context == null) {
                return null;
            }
            try {
                SearchExplorer.this.searchNodeMap.clear();
                if (SearchExplorer.this.model == null) {
                    return null;
                }
                FlowNode flowNode = this.context.isSearchAll() ? SearchExplorer.this.model.getLayout().getGraph().getParentNode() : this.context.getSearchRootNode();
                this.root = this.search(null, flowNode);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Exception while searching.", exception);
                throw exception;
            }
            return null;
        }

        private SearchNode search(SearchNode searchNode, FlowNode flowNode) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NodeModel nodeModel = flowNode.getModel();
            SearchNode searchNode2 = null;
            SearchResult[] searchResultArray = nodeModel.search(this.context);
            if (searchResultArray != null) {
                searchNode2 = SearchNode.createHitFlowNode(flowNode, searchResultArray);
                if (searchNode != null) {
                    searchNode.add(searchNode2);
                }
                this.hitCount += searchNode2.getHitCount();
                SearchExplorer.this.searchNodeMap.put(flowNode, searchNode2);
            }
            if (nodeModel.isSubflow()) {
                if (searchNode2 == null) {
                    searchNode2 = SearchNode.createNoHitFlowNode(flowNode);
                    if (searchNode != null) {
                        searchNode.add(searchNode2);
                    }
                }
                SubflowNodeModel subflowNodeModel = (SubflowNodeModel)nodeModel;
                for (ViewLayout viewLayout : subflowNodeModel.getLayouts()) {
                    Set set = (Set)Utility.cast(viewLayout.getGraph().getVertices());
                    List<FlowNode> list = FlowUtil.smartSort(set, viewLayout.getLayout());
                    for (FlowNode flowNode2 : list) {
                        this.search(searchNode2, flowNode2);
                    }
                }
                if (searchNode2.getHitCount() == 0 && searchNode2.getChildCount() == 0) {
                    searchNode2.removeFromParent();
                }
            }
            if (searchNode2 == null) {
                searchNode2 = SearchNode.createNoHitFlowNode(flowNode);
            }
            return searchNode2;
        }

        @Override
        protected void done() {
            SearchExplorer.this.getTreeModel().setRoot(this.root);
            SearchExplorer.this.tree.setBackground(SearchExplorer.this.FILL_COLOR);
            SearchExplorer.this.setTotalHitCount(this.hitCount);
            SearchExplorer.this.fireSearchStateChanged();
            SearchExplorer.this.getTreeModel().reload();
        }
    }

    private class SingleSearchWorker
    extends SwingWorker<Void, Void> {
        private SearchNode node;

        public SingleSearchWorker(SearchNode searchNode) {
            this.node = searchNode;
        }

        @Override
        protected Void doInBackground() throws Exception {
            SearchResult[] searchResultArray = this.node.getFlowNode().getModel().search(SearchExplorer.this.context);
            this.node.setSearchResults(searchResultArray);
            return null;
        }

        @Override
        protected void done() {
            SearchExplorer.this.getTreeModel().nodeChanged(this.node);
            SearchExplorer.this.refreshTree();
        }
    }
}

