/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.flow.CacheRunHandler;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.flow.CacheEvent;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.UIUtility;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CacheHandler
extends CacheRunHandler
implements GraphEventListener,
NodeModelChangeListener,
NodeBreakpointChangeListener {
    private CacheEvent event = new CacheEvent();

    public CacheHandler(FlowModel flowModel) {
        super(flowModel);
    }

    @Override
    protected void cacheVaildChanged() {
        Rflow.mainView().repaintFlow();
        EventManager.getInstance().dispatchEvent(this.event);
    }

    @Override
    protected void cacheStateChanged() {
        Rflow.mainView().repaintFlow();
        Rflow.getInstance().getActions().updateActionState();
        this.getFlowModel().setDirty(true);
        EventManager.getInstance().dispatchEvent(this.event);
    }

    public void edgeAdded(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (flowGraph.isAdjusting()) {
            return;
        }
        FlowEdge flowEdge = (FlowEdge)graphEvent.getGraphElement();
        this.checkCache(flowEdge.getDest());
    }

    public void edgeRemoved(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (flowGraph.isAdjusting()) {
            return;
        }
        FlowEdge flowEdge = (FlowEdge)graphEvent.getGraphElement();
        this.checkCache(flowEdge.getDest());
    }

    public void vertexAdded(GraphEvent graphEvent) {
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (flowGraph.isAdjusting()) {
            return;
        }
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        boolean bl = Rflow.settings().getValue(Settings.USE_CACHE_BACKUP);
        FlowViewer flowViewer = Rflow.mainView().getViewer(flowNode.getGraph());
        if (this.isCacheEmpty()) {
            return;
        }
        if (flowNode.isCacheData() && flowNode.getCacheData().isValid()) {
            try {
                this.removeCache(flowNode, false, bl);
            }
            catch (OperationFailedException operationFailedException) {
                UIUtility.showErrorDialog((Component)((Object)flowViewer), operationFailedException.getMessage(), operationFailedException.isWarning());
            }
            if (bl && flowViewer != null) {
                flowViewer.fireUndoableEditUpdate(flowViewer.undoableEditFactory.createAndSetClearCache(flowNode, this, false, false));
            }
        }
        if (flowNode.getModel().isSubflow()) {
            SubflowNodeModel subflowNodeModel = (SubflowNodeModel)flowNode.getModel();
            Set<FlowNode> set = FlowUtil.getAllDescendants(subflowNodeModel);
            for (FlowNode flowNode2 : set) {
                if (!flowNode2.isCacheData() || !flowNode2.getCacheData().isValid()) continue;
                try {
                    this.removeCache(flowNode2, false, bl);
                }
                catch (OperationFailedException operationFailedException) {
                    UIUtility.showErrorDialog((Component)((Object)flowViewer), operationFailedException.getMessage(), operationFailedException.isWarning());
                }
                if (!bl || flowViewer == null) continue;
                flowViewer.fireUndoableEditUpdate(flowViewer.undoableEditFactory.createAndSetClearCache(flowNode2, this, false, false));
            }
        }
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        if (this.isCacheEmpty()) {
            return;
        }
        this.checkCache(flowNode);
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        if (this.isCacheEmpty()) {
            return;
        }
        this.checkCache(flowNode);
    }

    @Override
    public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        if (this.isCacheEmpty()) {
            return;
        }
        if (n != 2 && n2 != 2) {
            return;
        }
        this.checkCache(flowNode);
    }

    private void checkCache(FlowNode flowNode) {
        if (!this.getState().isinCacheScope(flowNode)) {
            return;
        }
        boolean bl = Rflow.settings().getValue(Settings.USE_CACHE_BACKUP);
        for (FlowNode flowNode2 : new ArrayList<FlowNode>(this.getState().getCacheNodes())) {
            FlowViewer flowViewer;
            List<FlowNode> list;
            if (flowNode2.getGraph() == null || !flowNode2.getCacheData().isValid() || !(list = FlowUtil.getStream(flowNode2, true, false, true)).contains(flowNode)) continue;
            try {
                this.removeCache(flowNode2, false, bl);
            }
            catch (OperationFailedException operationFailedException) {
                UIUtility.showErrorDialog((Component)Rflow.mainFrame(), operationFailedException.getMessage(), operationFailedException.isWarning());
            }
            if (!bl || (flowViewer = Rflow.mainView().getViewer(flowNode.getGraph())) == null) continue;
            flowViewer.fireUndoableEditUpdate(flowViewer.undoableEditFactory.createAndSetClearCache(flowNode2, this, false, false));
        }
    }

    private boolean isCacheEmpty() {
        return this.getState().getCacheNodes().isEmpty();
    }
}

