/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.SubflowState;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.NamedCompoundEdit;
import com.ef_prime.rflow.ui.flow.CacheHandler;
import com.ef_prime.rflow.ui.util.UIUtility;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Component;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DefaultUndoableEdits {

    public static class ClearCacheEdit
    extends AbstractUndoableEdit {
        private CacheHandler cacheHandler;
        private FlowNode node;
        private boolean removeMark;
        private boolean significant;

        public ClearCacheEdit(CacheHandler cacheHandler, FlowNode flowNode, boolean bl, boolean bl2) {
            this.cacheHandler = cacheHandler;
            this.node = flowNode;
            this.removeMark = bl;
            this.significant = bl2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.cacheHandler.restoreCache(this.node, this.removeMark && !this.node.getCacheData().isValid());
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                this.cacheHandler.removeCache(this.node, this.removeMark, true);
            }
            catch (OperationFailedException operationFailedException) {
                UIUtility.showErrorDialog((Component)Rflow.mainFrame(), operationFailedException.getMessage(), operationFailedException.isWarning());
            }
        }

        public FlowNode getNode() {
            return this.node;
        }

        public void setInsignificant() {
            this.significant = false;
        }

        @Override
        public boolean isSignificant() {
            return this.significant;
        }

        @Override
        public String getPresentationName() {
            if (this.isSignificant()) {
                return !this.removeMark ? Messages.getString("Action.cache_clear") : Messages.getString("Action.cache_unmark");
            }
            return super.getPresentationName();
        }
    }

    public static class NewNodeEdit
    extends NamedCompoundEdit {
        public NewNodeEdit() {
            super(Messages.getString("Action.new_node"));
        }

        public FlowNode getNode() {
            for (UndoableEdit undoableEdit : this.edits) {
                if (!(undoableEdit instanceof AddNodeEdit)) continue;
                AddNodeEdit addNodeEdit = (AddNodeEdit)undoableEdit;
                return addNodeEdit.getNode();
            }
            return null;
        }
    }

    public static class AddNodeEdit
    extends AbstractUndoableEdit {
        private ViewLayout viewLayout;
        private SubflowState state;
        private FlowNode node;

        public AddNodeEdit(ViewLayout viewLayout, SubflowState subflowState, FlowNode flowNode) {
            this.viewLayout = viewLayout;
            this.state = subflowState;
            this.node = flowNode;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.viewLayout.getGraph().removeVertex((Vertex)this.node);
            this.state.pick((ArchetypeVertex)this.node, false);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.viewLayout.getGraph().addVertex((Vertex)this.node);
            this.state.setPicked((ArchetypeVertex)this.node);
        }

        @Override
        public String getPresentationName() {
            return Messages.getString("Action.new_node");
        }

        public FlowNode getNode() {
            return this.node;
        }
    }
}

