/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.flow.FlowSessionEntry;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.NodeOptionView;
import com.ef_prime.rflow.node.NodePropertyChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.FileEditUIUtilty;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.flow.FlowActions;
import com.ef_prime.rflow.ui.flow.FlowErrorEvent;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.FlowViewerEvent;
import com.ef_prime.rflow.ui.flow.FlowViewerEventHandler;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileEditView;
import com.ef_prime.rflow.ui.view.FlowNodePreviewView;
import com.ef_prime.rflow.ui.view.HierarchyView;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;

public class FlowBrowseView
extends FileEditView
implements MenuActionProvider,
FlowNodeSelectionEventHandler,
FlowViewerEventHandler,
ChangeEventHandler,
ValueChangeEventHandler {
    private FlowNode node;
    private LinkedList<FlowNode> history = new LinkedList();
    private int historyIndex;
    private JPanel navigationBar;
    private AddressBar addressBar;
    private FlowNodeView flowNodeView;
    private final NodeChangedListener changedListener = new NodeChangedListener();
    private BrowseActions browseActions = new BrowseActions();
    private HierarchyView hierarchyView;
    private MultiSplitLayout layout;
    private JXMultiSplitPane flowSplitPane;
    private HierarchyViewHandler hierarchyViewHandler;
    private FlowNodePreviewView previewView;
    private boolean dividerHasBecomeVisible;

    public FlowBrowseView(FlowNode flowNode) {
        super((FileEdit)flowNode.getFlowModel().orElse(null));
        Set<FileEditView> set;
        this.setAllowDuplicate(true);
        this.setLayout(new BorderLayout());
        this.hierarchyView = new HierarchyView(flowNode.getFlowModel().orElse(null), () -> this.getNode());
        this.previewView = new FlowNodePreviewView();
        this.previewView.addEventHandler(this);
        MultiSplitLayout.Leaf leaf = new MultiSplitLayout.Leaf("subflow");
        MultiSplitLayout.Leaf leaf2 = new MultiSplitLayout.Leaf("hierarchy");
        MultiSplitLayout.Leaf leaf3 = new MultiSplitLayout.Leaf("preview");
        MultiSplitLayout.RowSplit rowSplit = new MultiSplitLayout.RowSplit(new MultiSplitLayout.Node[]{leaf, new MultiSplitLayout.Divider(), leaf2});
        leaf.setWeight(1.0);
        leaf2.setWeight(0.0);
        MultiSplitLayout.ColSplit colSplit = new MultiSplitLayout.ColSplit(new MultiSplitLayout.Node[]{rowSplit, new MultiSplitLayout.Divider(), leaf3});
        rowSplit.setWeight(0.5);
        leaf3.setWeight(0.5);
        this.layout = new MultiSplitLayout((MultiSplitLayout.Node)colSplit);
        this.flowSplitPane = new JXMultiSplitPane(this.layout);
        this.flowSplitPane.setFocusable(false);
        this.flowSplitPane.add((Component)this.hierarchyView, (Object)"hierarchy");
        this.flowSplitPane.add((Component)this.previewView, (Object)"preview");
        this.layout.setLayoutByWeight(true);
        this.layout.setFloatingDividers(false);
        this.layout.layoutByWeight((Container)this.flowSplitPane);
        this.flowSplitPane.addComponentListener((ComponentListener)new HierarchySplitSetter());
        this.add((Component)this.flowSplitPane, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.browseActions.get(BrowseActions.Back.class)).setFocusable(false);
        jToolBar.add(this.browseActions.get(BrowseActions.Forward.class)).setFocusable(false);
        this.addressBar = null;
        AbstractButton abstractButton = this.configureToolBarButton(new JButton(this.browseActions.get(BrowseActions.Save.class)));
        AbstractButton abstractButton2 = this.configureToolBarButton(new JButton(this.browseActions.get(BrowseActions.Property.class)));
        BrowseActions.HierarchyAction hierarchyAction = (BrowseActions.HierarchyAction)this.browseActions.get(BrowseActions.HierarchyAction.class);
        JToggleButton jToggleButton = new JToggleButton();
        this.configureToolBarButton(jToggleButton);
        jToggleButton.setSelected(this.isHierarchyVisible());
        jToggleButton.setAction(hierarchyAction);
        jToggleButton.addItemListener(hierarchyAction);
        this.navigationBar = new JPanel((LayoutManager)new MigLayout("fillx, inset 0, gapx 0", "[][grow][][][]"));
        this.navigationBar.add(jToolBar);
        this.navigationBar.add((Component)(this.addressBar == null ? new JPanel() : this.addressBar), "growx");
        this.navigationBar.add(abstractButton);
        this.navigationBar.add(abstractButton2);
        this.navigationBar.add(jToggleButton);
        this.add((Component)this.navigationBar, "North");
        this.load(flowNode);
        Optional<FlowModel> optional = this.getFlowModel();
        this.browseActions.get(BrowseActions.Save.class).setEnabled(optional.isPresent() ? optional.get().isDirty() : false);
        if (optional.isPresent() && (set = Rflow.mainView().getViews(optional.get())).isEmpty()) {
            optional.get().setPrimaryView(this);
        }
    }

    @Override
    protected void loadContent() {
    }

    protected AbstractButton configureToolBarButton(AbstractButton abstractButton) {
        abstractButton.setHideActionText(true);
        abstractButton.setFocusable(false);
        abstractButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        return abstractButton;
    }

    public void load(FlowNode flowNode) {
        if (this.node == flowNode || !this.canLoad(flowNode)) {
            return;
        }
        this.loadInternal(flowNode);
        FileEditSupplier fileEditSupplier = flowNode.getFileEditSupplier();
        if (fileEditSupplier != null) {
            fileEditSupplier.addFileEditEventHandler(this);
        }
        while (this.history.size() > this.historyIndex + 1) {
            this.history.removeLast();
        }
        this.history.add(flowNode);
        this.historyIndex = this.history.size() - 1;
        this.browseActions.updateState();
    }

    private boolean canLoad(FlowNode flowNode) {
        if (flowNode == null || flowNode.getGraph() == null) {
            return false;
        }
        return this.node == null || this.getFlowModel().equals(flowNode.getFlowModel());
    }

    public boolean loadViableParentNode() {
        FlowNode flowNode;
        if (this.node == null) {
            return false;
        }
        for (flowNode = this.node.getParentNode(); flowNode != null && flowNode.getGraph() == null; flowNode = flowNode.getParentNode()) {
        }
        if (flowNode != null) {
            this.load(flowNode);
            return true;
        }
        return false;
    }

    private void unloadFlowNodeView() {
        FlowViewer[] flowViewerArray;
        if (this.node != null && (flowViewerArray = this.node.getFileEditSupplier()) != null) {
            flowViewerArray.removeFileEditEventHandler(this);
        }
        if (this.flowNodeView == null) {
            return;
        }
        UIUtility.removeFromParent(this.flowNodeView);
        this.flowNodeView.unloadView();
        if (this.flowNodeView instanceof SubflowNodeView) {
            for (FlowViewer flowViewer : flowViewerArray = ((SubflowNodeView)this.flowNodeView).getViewers()) {
                flowViewer.getPickedState().removeSelectionEventHandler(this);
                flowViewer.removeFlowViewerEventHandler(this);
            }
        }
    }

    private void loadInternal(FlowNode flowNode) {
        Object object;
        EventHandler[] eventHandlerArray;
        this.node = flowNode;
        this.setFileEdit(flowNode.getFlowModel().orElse(null));
        this.unloadFlowNodeView();
        NodeModelController nodeModelController = NodeModelManager.getModelController(flowNode.getModel().getClass());
        this.flowNodeView = nodeModelController.createView(flowNode, false);
        boolean bl = this.flowNodeView instanceof SubflowNodeView;
        if (bl) {
            eventHandlerArray = ((SubflowNodeView)this.flowNodeView).getViewers();
            for (FlowViewer flowViewer : eventHandlerArray) {
                flowViewer.getPickedState().addSelectionEventHandler(this);
                flowViewer.addFlowViewerEventHandler(this);
            }
        }
        this.flowSplitPane.add((Component)this.flowNodeView, (Object)"subflow");
        if (this.flowNodeView != null) {
            this.flowNodeView.loadView();
        }
        this.previewView.setSelectedNode(null);
        eventHandlerArray = flowNode.getPath(true);
        this.navigationBar.remove(1);
        if (flowNode.getGraph() != null && eventHandlerArray.length > 1) {
            this.addressBar = new AddressBar((FlowNode[])eventHandlerArray);
            this.navigationBar.add(this.addressBar, new CC().growX(), 1);
        } else {
            this.addressBar = null;
            this.navigationBar.add(new JPanel(), new CC().growX(), 1);
        }
        if (bl && flowNode.getModel() instanceof SubflowNodeModel) {
            this.hierarchyView.select(flowNode);
        }
        if (bl && this.historyIndex >= 0 && this.historyIndex < this.history.size()) {
            object = this.flowNodeView.getActiveViewer();
            for (FlowNode flowNode2 = this.history.get(this.historyIndex); flowNode2 != null; flowNode2 = flowNode2.getParentNode()) {
                if (!((FlowViewer)object).getGraph().contains((Vertex)flowNode2)) continue;
                ((FlowViewer)object).getPickedState().setPicked((ArchetypeVertex)flowNode2);
                break;
            }
        }
        this.layout.displayNode("preview", bl);
        this.layout.displayNode("hierarchy", bl && this.isHierarchyVisible());
        if (!this.dividerHasBecomeVisible && bl) {
            if (this.isShowing()) {
                object = (MultiSplitLayout.ColSplit)this.layout.getModel();
                MultiSplitLayout.Divider divider = (MultiSplitLayout.Divider)object.getChildren().get(1);
                Rectangle rectangle = divider.getBounds();
                rectangle.y = this.getHeight() / 2 - rectangle.height / 2;
                divider.setBounds(rectangle);
            }
            this.dividerHasBecomeVisible = true;
        }
        this.revalidate();
        this.repaint();
        this.updateTab();
        Rflow.mainView().activeFlowNodeChanged(flowNode);
    }

    public void clearHistory() {
        this.history.clear();
        this.historyIndex = 0;
        this.browseActions.updateState();
    }

    public FlowNode getNode() {
        return this.node;
    }

    public Optional<FlowModel> getFlowModel() {
        if (this.getNode() == null) {
            return Optional.empty();
        }
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit instanceof FlowModel) {
            return Optional.of((FlowModel)fileEdit);
        }
        return this.getNode().getFlowModel();
    }

    public FlowNodeView getFlowNodeView() {
        return this.flowNodeView;
    }

    public FlowNodePreviewView getPreviewView() {
        return this.previewView;
    }

    public boolean isPrimary() {
        Optional<FlowModel> optional = this.getFlowModel();
        return optional.isPresent() ? optional.get().getPrimaryView() == this : false;
    }

    @Override
    public Object getKey() {
        return this.getNode();
    }

    private boolean showFlowFileTitle() {
        return this.isPrimary() && Rflow.mainView().usePrimaryFlowTab();
    }

    @Override
    public String getTitle() {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (optional.get().isDirty() && (this.showFlowFileTitle() && this.isPrimary() || this.getNode().getModel().isSubflow())) {
            stringBuilder.append("*");
        }
        if (this.showFlowFileTitle()) {
            stringBuilder.append(optional.get().getTitle());
        } else {
            stringBuilder.append(this.getNode().getTitle());
        }
        return stringBuilder.toString();
    }

    @Override
    public Icon getIcon() {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return this.getNode().getSmallIcon();
        }
        FlowState flowState = optional.get().getState();
        if (flowState.isError(this.getNode())) {
            return FileResource.getIcon("img/error_16.png");
        }
        if (this.showFlowFileTitle()) {
            return FileResource.getIcon("img/doc_16.png");
        }
        return this.getNode().getSmallIcon();
    }

    @Override
    public String getIconToolTip() {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return null;
        }
        FlowState flowState = optional.get().getState();
        String string = flowState.getErrorMessageHtml(this.getNode());
        if (string != null) {
            return string;
        }
        if (this.node == null) {
            return null;
        }
        FlowNode[] flowNodeArray = this.node.getPath(true);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < flowNodeArray.length; ++i) {
            stringBuilder.append(flowNodeArray[i].getTitle());
            if (i == flowNodeArray.length - 1) continue;
            stringBuilder.append(" > ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void loadView() {
        FlowNode.addNodeModelChangeListener(this.changedListener);
        FlowNode.addNodePropertyChangeListener(this.changedListener);
        EventManager.getInstance().registerEventHandler(FlowErrorEvent.class, this.changedListener);
        Rflow.settings().addEventHandler(this);
    }

    @Override
    public void unloadView() {
        FlowNode.removeNodeModelChangeListener(this.changedListener);
        FlowNode.removeNodePropertyChangeListener(this.changedListener);
        EventManager.getInstance().removeEventHandler(FlowErrorEvent.class, this.changedListener);
        if (this.hierarchyView != null) {
            this.hierarchyView.removeComponentListener(this.hierarchyViewHandler);
            this.hierarchyViewHandler = null;
        }
        this.unloadFlowNodeView();
        Rflow.settings().removeEventHandler(this);
    }

    @Override
    public SessionEntry getSessionEntry(boolean bl) {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return null;
        }
        FlowModel flowModel = optional.get();
        if (flowModel.isNewFlow()) {
            return FlowSessionEntry.createNewFlow(this.getViewPosition(), this.isShowing(), flowModel.getFlowDataDir().getName(), this.node, this.isPrimary());
        }
        return FlowSessionEntry.create(this.getViewPosition(), this.isShowing(), flowModel.getWorkingFile(), this.node, Rflow.project(), this.isPrimary());
    }

    public FlowViewer getActiveViewer() {
        FlowViewer flowViewer;
        if (this.flowNodeView == null) {
            return null;
        }
        if (this.previewView.isActive() && (flowViewer = this.previewView.getActiveViewer()) != null) {
            return flowViewer;
        }
        return this.flowNodeView.getActiveViewer();
    }

    private boolean isHierarchyVisible() {
        Boolean bl;
        Optional<FlowModel> optional = this.getFlowModel();
        Boolean bl2 = this.node == null ? null : (bl = optional.isPresent() ? optional.get().getState().isHierarchyVisible() : null);
        if (bl == null) {
            bl = Rflow.settings().getValue(Settings.SHOW_HIERARCHY);
        }
        return bl;
    }

    private MultiSplitLayout.Split getFlowHierarchySplit() {
        MultiSplitLayout.Split split = (MultiSplitLayout.Split)this.layout.getModel();
        return (MultiSplitLayout.Split)split.getChildren().get(0);
    }

    public void goToParentView() {
        FlowNode flowNode = this.node.getParentNode();
        if (flowNode == null) {
            return;
        }
        this.closeTab();
        Rflow.mainView().openViewer(flowNode, ViewOpenType.OPEN_NEW);
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        super.fileEditStateChanged(fileEditEvent);
        Optional<FlowModel> optional = this.getFlowModel();
        if (optional.isPresent() && fileEditEvent.getResource() == optional.get()) {
            if (this.addressBar != null) {
                this.addressBar.updateTitle();
            }
            if (fileEditEvent.isDirtyChanged()) {
                this.browseActions.get(BrowseActions.Save.class).setEnabled(optional.get().isDirty());
            }
        } else if (fileEditEvent.isDirtyChanged()) {
            this.updateTab();
        }
    }

    @Override
    public boolean doSave(boolean bl) {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return false;
        }
        RflowActions rflowActions = Rflow.getInstance().getActions();
        return bl ? rflowActions.save_as(optional.get()) : rflowActions.save(optional.get());
    }

    @Override
    public boolean viewWillClose() {
        int n;
        Set<FileEditView> set;
        if (!Rflow.project().isUnloading() && this.getImportantViewCount(set = Rflow.mainView().getViews(this.getFileEdit())) <= 1 && this.isImportantView() && set.size() > 1 && (n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.confirm_opened_node"), Messages.getString("Message.confirm"), 2, 3)) != 0) {
            return false;
        }
        return super.viewWillClose();
    }

    @Override
    public boolean askSave(boolean bl) {
        Optional<FlowModel> optional;
        int n;
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit == null || Rflow.project().isNewProjectSaveMode()) {
            return true;
        }
        boolean bl2 = bl ? true : (n = this.getImportantViewCount((Set<FileEditView>)((Object)(optional = Rflow.mainView().getViews(this.getFileEdit()))))) == 1 && this.isImportantView() || n == 0 && optional.size() <= 1;
        optional = this.getFlowModel();
        if (bl2 &= optional.isPresent()) {
            Set<FlowNode> set = FlowUtil.getAllNodes(((FlowModel)optional.get()).getLayout().getGraph());
            HashSet<FileEdit> hashSet = new HashSet<FileEdit>();
            for (FlowNode flowNode : set) {
                FileEdit fileEdit2;
                FileEditSupplier fileEditSupplier = flowNode.getFileEditSupplier();
                if (fileEditSupplier == null || hashSet.contains(fileEdit2 = fileEditSupplier.getFileEdit())) continue;
                long l = 0L;
                if (!bl) {
                    l = fileEdit2.getProtectKeys().stream().filter(object -> !(object instanceof FlowNode) || !optional.equals(((FlowNode)object).getFlowModel())).count();
                }
                if (l == 0L && !FileEditUIUtilty.confirmAndSave(fileEdit2)) {
                    return false;
                }
                hashSet.add(fileEdit2);
            }
        }
        if (!fileEdit.isDirty()) {
            return true;
        }
        return bl2 ? this.showSaveConfirmDialog(bl) : true;
    }

    private int getImportantViewCount(Set<FileEditView> set) {
        int n = 0;
        for (FileEditView fileEditView : set) {
            if (!(fileEditView instanceof FlowBrowseView) || !((FlowBrowseView)fileEditView).isImportantView()) continue;
            ++n;
        }
        return n;
    }

    @Override
    protected Object getProtectKey() {
        return this.getFileEdit();
    }

    @Override
    protected boolean shouldUnloadResource() {
        Set<FileEditView> set = Rflow.mainView().getViews(this.getFileEdit());
        return this.getImportantViewCount(set) == 0;
    }

    private boolean isImportantView() {
        if (this.getNode() == null || this.getNode().getGraph() == null) {
            return false;
        }
        if (Rflow.mainView().usePrimaryFlowTab()) {
            return this.isPrimary();
        }
        if (Rflow.mainView().keepRootFlow()) {
            return this.getNode() != null && this.getNode().isRootNode();
        }
        return this.getNode() != null && this.getNode().getModel().isSubflow();
    }

    @Override
    public void itemChanged(ItemEvent itemEvent) {
    }

    @Override
    public Action getAction(String string) {
        View view2;
        Action action = super.getAction(string);
        if (action != null) {
            return action;
        }
        Object object = null;
        if (this.previewView.isActive() && (view2 = this.previewView.getView()) instanceof MenuActionProvider) {
            object = (MenuActionProvider)((Object)view2);
        }
        if (object == null && (view2 = this.getFlowNodeView()) instanceof MenuActionProvider) {
            object = view2;
        }
        if (object != null) {
            return object.getAction(string);
        }
        return null;
    }

    @Override
    public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
        this.previewView.setSelectedNode(flowNodeSelectionEvent.getState().getPickedVertices());
    }

    @Override
    public void handleFlowViewerEvent(FlowViewerEvent flowViewerEvent) {
        View view2;
        if (flowViewerEvent.getType() == 0 && (view2 = this.previewView.getView()) instanceof NodeOptionView) {
            ((NodeOptionView)view2).initFocus();
        }
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        if (this.flowNodeView instanceof SubflowNodeView) {
            FlowViewer[] flowViewerArray;
            Set<FlowNode> set = this.previewView.getNodes();
            FlowNode flowNode = set != null && !set.isEmpty() ? set.iterator().next() : null;
            for (FlowViewer flowViewer : flowViewerArray = ((SubflowNodeView)this.flowNodeView).getViewers()) {
                if (this.previewView.isActive() && flowNode != null && flowViewer.getGraph().contains((Vertex)flowNode)) {
                    flowViewer.getPickedState().setActiveNodes(set);
                    continue;
                }
                flowViewer.getPickedState().setActiveNodes(null);
            }
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (valueChangeEvent.getKey() == Settings.NODE_OPEN_MODE) {
            this.updateTab();
        }
    }

    private class NodeChangedListener
    implements NodeModelChangeListener,
    NodePropertyChangeListener,
    SimpleEventHandler {
        private NodeChangedListener() {
        }

        @Override
        public void nodeModelChanged(FlowNode flowNode) {
            if (FlowBrowseView.this.getNode() == flowNode && FlowBrowseView.this.addressBar != null) {
                FlowBrowseView.this.addressBar.updateLastNodeTitle();
            }
        }

        @Override
        public void subflowNodeModelChanged(FlowNode flowNode) {
        }

        @Override
        public void nodePropertyChanged(FlowNode flowNode) {
            if (FlowBrowseView.this.getNode() == flowNode && FlowBrowseView.this.addressBar != null) {
                FlowBrowseView.this.addressBar.updateLastNodeTitle();
                FlowBrowseView.this.updateTab();
            }
        }

        @Override
        public void onEvent(SimpleEvent simpleEvent) {
            FlowErrorEvent flowErrorEvent;
            if (simpleEvent.getClass().equals(FlowErrorEvent.class) && (flowErrorEvent = (FlowErrorEvent)simpleEvent).getNode() == FlowBrowseView.this.getNode()) {
                FlowBrowseView.this.updateTab();
            }
        }
    }

    private class BrowseActions
    extends Actions {
        public BrowseActions() {
            this.put(new Back());
            this.put(new Forward());
            this.put(new Save());
            this.put(new Property());
            this.put(new HierarchyAction());
        }

        private void go(boolean bl) {
            int n = FlowBrowseView.this.historyIndex + (bl ? 1 : -1);
            if (n < 0 || n >= FlowBrowseView.this.history.size()) {
                return;
            }
            FlowNode flowNode = FlowBrowseView.this.history.get(n);
            if (FlowBrowseView.this.canLoad(flowNode)) {
                FlowBrowseView.this.loadInternal(flowNode);
            }
            FlowBrowseView.this.historyIndex = n;
            this.updateState();
        }

        public void updateState() {
            int n = FlowBrowseView.this.historyIndex - 1;
            boolean bl = n >= 0;
            this.get(Back.class).setEnabled(bl);
            this.get(Back.class).putValue("ShortDescription", bl ? FlowBrowseView.this.history.get(n).getTitle() : Messages.getString("Action.back"));
            int n2 = FlowBrowseView.this.historyIndex + 1;
            boolean bl2 = n2 < FlowBrowseView.this.history.size();
            this.get(Forward.class).setEnabled(bl2);
            this.get(Forward.class).putValue("ShortDescription", bl2 ? FlowBrowseView.this.history.get(n2).getTitle() : Messages.getString("Action.forward"));
        }

        private class Back
        extends LoggableAction {
            public Back() {
                this.putValue("Name", Messages.getString("Action.back"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_previous.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                BrowseActions.this.go(false);
            }
        }

        private class Forward
        extends LoggableAction {
            public Forward() {
                this.putValue("Name", Messages.getString("Action.forward"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                BrowseActions.this.go(true);
            }
        }

        private class Save
        extends LoggableAction {
            public Save() {
                this.putValue("Name", Messages.getString("Action.save"));
                this.putValue("SmallIcon", Icons.getIcon("16/diskette.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UIUtility.MENU_KEY_MASK));
                this.putValue("ShortDescription", this.getValue("Name"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FlowBrowseView.this.getFlowModel().ifPresent(flowModel -> Rflow.getInstance().getActions().save((FlowModel)flowModel));
            }
        }

        private class Property
        extends LoggableAction {
            public Property() {
                this.putValue("Name", Messages.getStringWithDots("View.FlowProperties.title"));
                this.putValue("SmallIcon", Icons.getIcon("16/cog.png"));
                this.putValue("ShortDescription", this.getValue("Name"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FlowBrowseView.this.getFlowModel().ifPresent(flowModel -> FlowActions.editFlowProperties(flowModel));
            }
        }

        private class HierarchyAction
        extends AbstractAction
        implements ItemListener {
            public HierarchyAction() {
                this.putValue("Name", Messages.getString("Action.show_hierarchy"));
                this.putValue("ShortDescription", this.getValue("Name"));
                this.putValue("SmallIcon", Icons.getIcon("16/tree_list.png"));
            }

            @Override
            public void itemStateChanged(java.awt.event.ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                FlowBrowseView.this.layout.displayNode("hierarchy", bl);
                Rflow.settings().putValue(Settings.SHOW_HIERARCHY, bl);
                FlowBrowseView.this.getFlowModel().ifPresent(flowModel -> {
                    flowModel.getState().setHierarchyVisible(bl);
                    FlowBrowseView.this.flowSplitPane.revalidate();
                    FlowBrowseView.this.flowSplitPane.repaint();
                });
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        }
    }

    private class HierarchySplitSetter
    extends ComponentAdapter {
        private HierarchySplitSetter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FlowBrowseView.this.getFlowModel().ifPresent(flowModel -> {
                MultiSplitLayout.Split split = FlowBrowseView.this.getFlowHierarchySplit();
                MultiSplitLayout.Node node = (MultiSplitLayout.Node)split.getChildren().get(1);
                Integer n = flowModel.getState().getHierarchySplit();
                if (n <= 0) {
                    n = Rflow.settings().getValue(Settings.HIERARCHY_SPLIT);
                }
                if (n > 0) {
                    Rectangle rectangle = new Rectangle(node.getBounds());
                    rectangle.x = FlowBrowseView.this.flowSplitPane.getWidth() - rectangle.width - n;
                    node.setBounds(rectangle);
                    FlowBrowseView.this.layout.setFloatingDividers(false);
                    FlowBrowseView.this.layout.setLayoutByWeight(false);
                    FlowBrowseView.this.flowSplitPane.revalidate();
                    FlowBrowseView.this.flowSplitPane.repaint();
                }
                if (FlowBrowseView.this.hierarchyView != null) {
                    FlowBrowseView.this.hierarchyViewHandler = new HierarchyViewHandler();
                    FlowBrowseView.this.hierarchyView.addComponentListener(FlowBrowseView.this.hierarchyViewHandler);
                }
                componentEvent.getComponent().removeComponentListener(this);
            });
        }
    }

    private class AddressBar
    extends JPanel
    implements ComponentListener {
        private FlowNode[] path;
        private JButton[] buttons;
        private JScrollPane addressBarPane;
        private ButtonAction buttonAction = new ButtonAction();

        public AddressBar(FlowNode[] flowNodeArray) {
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("0").gridGap("0", "0")));
            jPanel.setBackground(Color.WHITE);
            jPanel.putClientProperty("substancelaf.colorizationFactor", 1);
            this.path = flowNodeArray;
            this.buttons = new JButton[flowNodeArray.length];
            for (int i = 0; i < flowNodeArray.length; ++i) {
                if (i != 0) {
                    jPanel.add(new RightTriangle());
                }
                JButton jButton = new JButton();
                jButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
                jButton.setActionCommand(Integer.toString(i));
                jButton.addActionListener(this.buttonAction);
                jButton.setFocusable(false);
                jPanel.add((Component)jButton, "wmax 150");
                this.buttons[i] = jButton;
                this.updateTitle(i);
                if (i != flowNodeArray.length - 1) continue;
                jButton.setEnabled(false);
            }
            this.addressBarPane = new JScrollPane(jPanel, 21, 31);
            this.addressBarPane.setBorder(null);
            this.addressBarPane.setBorder(new LineBorder(new Color(220, 220, 220)));
            this.setLayout(new BorderLayout());
            this.add(this.addressBarPane);
            this.addComponentListener(this);
        }

        public void updateLastNodeTitle() {
            int n = this.path.length - 1;
            this.updateTitle(n);
        }

        public void updateTitle() {
            for (int i = 0; i < this.path.length; ++i) {
                this.updateTitle(i);
            }
        }

        private void updateTitle(int n) {
            Object object = this.path[n].getTitle();
            if (((String)object).isEmpty()) {
                object = " ";
            }
            Optional<FlowModel> optional = FlowBrowseView.this.getFlowModel();
            if (n == 0 && optional.isPresent() && optional.get().isDirty()) {
                object = "*" + (String)object;
            }
            this.buttons[n].setText((String)object);
            if (this.buttons[n].getPreferredSize().width > 150) {
                this.buttons[n].setToolTipText((String)object);
            } else {
                this.buttons[n].setToolTipText(null);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            JScrollBar jScrollBar = this.addressBarPane.getHorizontalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        private class ButtonAction
        extends LoggableAction {
            private ButtonAction() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                FlowNode flowNode = AddressBar.this.path[n];
                boolean bl = (actionEvent.getModifiers() & 2) == 2;
                ViewOpenType viewOpenType = Rflow.mainView().getViewOpenType(flowNode, FlowBrowseView.this.getNode(), bl);
                if (Rflow.develSettings().isAddressBarOpenOrMove() && viewOpenType == ViewOpenType.OPEN) {
                    viewOpenType = ViewOpenType.OPEN_OR_MOVE;
                }
                Rflow.mainView().openViewer(flowNode, viewOpenType, FlowBrowseView.this.flowNodeView);
            }
        }
    }

    private class HierarchyViewHandler
    extends ComponentAdapter {
        private HierarchyViewHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (FlowBrowseView.this.layout == null) {
                return;
            }
            MultiSplitLayout.Split split = FlowBrowseView.this.getFlowHierarchySplit();
            MultiSplitLayout.Leaf leaf = (MultiSplitLayout.Leaf)split.getChildren().get(2);
            int n = leaf.getBounds().width;
            if (n <= 0) {
                return;
            }
            Rflow.settings().putValue(Settings.HIERARCHY_SPLIT, n);
            FlowBrowseView.this.getFlowModel().ifPresent(flowModel -> flowModel.getState().setHierarchySplit(n));
        }
    }

    private static class RightTriangle
    extends JPanel {
        private static final int SIZE = 8;
        private static final Polygon POLYGON = new Polygon(new int[]{0, 0, (int)(4.0 * Math.sqrt(3.0))}, new int[]{0, 8, 4}, 3);
        private Rectangle bounds;

        public RightTriangle() {
            this.setPreferredSize(new Dimension(20, 20));
            this.bounds = POLYGON.getBounds();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics = graphics.create();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(Color.DARK_GRAY);
            graphics.translate(dimension.width / 2 - this.bounds.width / 2, dimension.height / 2 - this.bounds.height / 2);
            graphics.fillPolygon(POLYGON);
            graphics.dispose();
        }
    }
}

