/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.app.r.console.CommandPack;
import com.ef_prime.rflow.core.app.r.console.CommandPackListener;
import com.ef_prime.rflow.core.app.r.console.Executor;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskPack;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RActions;
import com.ef_prime.rflow.ui.app.r.console.RConsoleView;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.EventManager;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class FlowExecutor
extends Executor
implements CommandListener,
CommandPackListener {
    private static final Logger LOGGER = Logger.getLogger(FlowExecutor.class.getName());
    private RInterface r = R.getInterface();
    private long startTime;

    public FlowExecutor(FlowModel flowModel) {
        super(flowModel);
    }

    public void run(NodeTask nodeTask, FlowRunOption flowRunOption) {
        this.runTask(nodeTask, flowRunOption);
    }

    public void runNode(FlowNode flowNode, FlowNode flowNode2, FlowRunOption flowRunOption) throws OperationFailedException {
        if (flowNode == null) {
            return;
        }
        NodeTaskEntry nodeTaskEntry = new NodeTaskEntry(flowNode, flowNode2);
        this.runTask(nodeTaskEntry, flowRunOption);
    }

    public List<Task> prepareTasks(NodeTask nodeTask, FlowRunOption flowRunOption) {
        RPackage[] rPackageArray;
        EventManager.getInstance().dispatchEvent(RequestNodeModelNotifyEvent.getInstance());
        boolean bl = false;
        RConsoleView rConsoleView = Rflow.getInstance().getConsole();
        if (rConsoleView.isDebugWaitingForInput()) {
            int n = JOptionPane.showConfirmDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Message.quit_debug_before_running"), Messages.getString("Message.confirm"), 1, 2);
            switch (n) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        NodeTaskPack nodeTaskPack = new NodeTaskPack(nodeTask, flowRunOption, this.getFlowModel().getExecutor());
        ArrayList<Task> arrayList = new ArrayList<Task>();
        while (true) {
            try {
                while ((rPackageArray = nodeTaskPack.next()) != null) {
                    arrayList.add((Task)rPackageArray);
                }
            }
            catch (CommandBuildFailedException commandBuildFailedException) {
                LOGGER.log(Level.SEVERE, "Failed to build command", commandBuildFailedException);
                continue;
            }
            break;
        }
        rPackageArray = RPackage.getRPackages(nodeTask, Rflow.settings().getValue(Settings.AUTO_ATTACH_CACHED_PACKAGES));
        if (rPackageArray.length > 0) {
            RActions.getInstance().askInstallMissingPackages(rPackageArray);
            RActions.getInstance().attachPackagesIfNeeded(rPackageArray);
        }
        if (bl) {
            rConsoleView.quitBrowse(true);
        }
        return arrayList;
    }

    private void runTask(NodeTask nodeTask, FlowRunOption flowRunOption) {
        List<Task> list = this.prepareTasks(nodeTask, flowRunOption);
        for (Task task : list) {
            TaskQueue.getInstance().addTask(task);
        }
    }

    @Override
    protected void addCommandListener(Command command, final NodeTaskEntry nodeTaskEntry, FlowRunOption flowRunOption) {
        if (flowRunOption.isInsideBoxMode()) {
            return;
        }
        super.addCommandListener(command, nodeTaskEntry, flowRunOption);
        command.addCommandListener(new CommandAdapter(){

            @Override
            public void commandFinished(Command command) {
                FlowExecutor.this.r.client().fireItemStructureChanged();
                FlowExecutor.this.setExecutingNode(null, true);
                if (nodeTaskEntry.getStartNode() == null) {
                    FlowExecutor.this.getFlowModel().getState().setFlagNode(nodeTaskEntry.getNode().getModel() == TunnelNodeModel.outModel ? nodeTaskEntry.getNode().getParentNode() : nodeTaskEntry.getNode());
                }
            }

            @Override
            public void commandCanceled(Command command) {
                FlowExecutor.this.setExecutingNode(null, false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FlowExecutor.this.getFlowModel().getState().clearFlagNode();
                    }
                });
            }
        });
    }

    @Override
    protected void addCommandListener(Command command, final FlowNode flowNode, FlowRunOption flowRunOption) {
        if (flowNode == null || flowRunOption.isInsideBoxMode()) {
            return;
        }
        command.addCommandListener(new CommandAdapter(){

            @Override
            public void commandStart(Command command) {
                FlowExecutor.this.setExecutingNode(flowNode, true);
            }

            @Override
            public void commandFinished(Command command) {
                FlowExecutor.this.setExecutingNode(null, false);
            }
        });
    }

    @Override
    protected void addTaskEventHandler(Task task, final NodeTaskEntry nodeTaskEntry) {
        super.addTaskEventHandler(task, nodeTaskEntry);
        task.addTaskEventHandler(new TaskEventHandler(){
            private boolean started = false;

            @Override
            public void taskStateChanged(TaskEvent taskEvent) {
                if (taskEvent.isRunning()) {
                    if (!this.started) {
                        FlowExecutor.this.atCommandStart();
                        this.started = true;
                    }
                } else if (taskEvent.isCanceled()) {
                    FlowExecutor.this.setExecutingNode(null, false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FlowExecutor.this.getFlowModel().getState().clearFlagNode();
                        }
                    });
                } else if (taskEvent.isDone()) {
                    FlowExecutor.this.atCommandFinished();
                    if (!taskEvent.getTask().isCancelled()) {
                        FlowExecutor.this.setExecutingNode(null, true);
                        FlowExecutor.this.getFlowModel().getState().setFlagNode(nodeTaskEntry.getNode().getModel() == TunnelNodeModel.outModel ? nodeTaskEntry.getNode().getParentNode() : nodeTaskEntry.getNode());
                    }
                    FlowExecutor.this.r.client().fireItemStructureChanged();
                }
            }
        });
    }

    @Override
    protected void addNodeTaskEventHandler(Task task, final FlowNode flowNode, FlowRunOption flowRunOption) {
        if (flowNode != null) {
            task.addTaskEventHandler(new TaskEventHandler(){

                @Override
                public void taskStateChanged(TaskEvent taskEvent) {
                    if (taskEvent.isRunning()) {
                        FlowExecutor.this.setExecutingNode(flowNode, true);
                    } else if (taskEvent.isDone()) {
                        FlowExecutor.this.setExecutingNode(null, false);
                    }
                }
            });
        }
    }

    private void setExecutingNode(final FlowNode flowNode, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getFlowModel().getState().setExecutingNode(flowNode);
            Rflow.mainView().repaintFlow();
        } else if (bl) {
            try {
                if (!Thread.currentThread().isInterrupted()) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FlowExecutor.this.getFlowModel().getState().setExecutingNode(flowNode);
                            Rflow.mainView().repaintFlow();
                        }
                    });
                }
            }
            catch (Exception exception) {
                this.getFlowModel().getState().setExecutingNode(null);
                Rflow.mainView().repaintFlow();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlowExecutor.this.getFlowModel().getState().setExecutingNode(flowNode);
                    Rflow.mainView().repaintFlow();
                }
            });
        }
    }

    private void atCommandStart() {
        this.startTime = System.currentTimeMillis();
    }

    public static String doneMesssage(long l, long l2) {
        String string = DurationFormatUtils.formatPeriod((long)l, (long)l2, (String)"H:mm:ss");
        String string2 = Messages.getString("Flow.elapsed_time") + ": " + string;
        return Messages.getString("Flow.done") + "\n" + string2;
    }

    private void atCommandFinished() {
        TrayIcon trayIcon;
        if (Platform.isWindowsFamily() && (trayIcon = Rflow.getInstance().getTrayIcon()) != null) {
            final long l = this.startTime;
            final long l2 = System.currentTimeMillis();
            new TrayMessage().doAction();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    trayIcon.displayMessage("R AnalyticFlow", FlowExecutor.doneMesssage(l, l2), TrayIcon.MessageType.INFO);
                }
            });
        }
    }

    @Override
    public void commandCanceled(Command command) {
    }

    @Override
    public void commandFinished(Command command) {
        this.atCommandFinished();
    }

    @Override
    public void commandStart(Command command) {
        this.atCommandStart();
    }

    @Override
    public void errorOccurred(Command command) {
    }

    @Override
    public void commandDiscarded(Command command) {
    }

    @Override
    public void commandPending(CommandPack commandPack) {
    }

    @Override
    public void commandCanceled(CommandPack commandPack) {
    }

    @Override
    public void commandFinished(CommandPack commandPack) {
        this.atCommandFinished();
    }

    @Override
    public void commandStart(CommandPack commandPack) {
        this.atCommandStart();
    }

    @Override
    public void errorOccurred(CommandPack commandPack) {
    }

    @Override
    public void commandDiscarded(CommandPack commandPack) {
    }

    private class TrayMessage
    extends LoggableAction {
        private TrayMessage() {
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }
    }
}

