/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodePropertyChangeListener;
import com.ef_prime.rflow.node.NodePropertyView;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.flow.FlowErrorEvent;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileEditView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class FlowNodeView
extends FileEditView {
    private static final Logger LOGGER = Logger.getLogger(FlowNodeView.class.getName());
    private FlowNode node;
    private boolean preview;
    private JPanel centerPanel;
    private Component centerView;
    protected JToolBar toolBar;
    protected ViewActions viewActions = new ViewActions();
    private final NodeChangedListener changedListener = new NodeChangedListener();

    public FlowNodeView(FlowNode flowNode, boolean bl) {
        super((FileEdit)flowNode.getFlowModel().orElse(null));
        this.node = flowNode;
        this.preview = bl;
        this.setAllowDuplicate(true);
        this.setLayout(new BorderLayout());
        this.centerView = this.createCenterView();
        if (this.centerView != null) {
            this.centerPanel = new JPanel(new BorderLayout());
            this.centerPanel.add(this.createCenterTabbedPane(this.centerView), "Center");
            if (this.isToolBar()) {
                this.toolBar = new JToolBar();
                this.toolBar.setFloatable(false);
                this.configureToolBar(this.toolBar);
                this.centerPanel.add((Component)this.toolBar, "North");
            }
            this.add((Component)this.centerPanel, "Center");
        }
        this.viewActions.updateState();
    }

    @Override
    protected void loadContent() {
    }

    protected abstract Component createCenterView();

    protected abstract boolean isToolBar();

    protected Component createCenterTabbedPane(Component component) {
        if (this.getNode().isRootNode()) {
            return component;
        }
        View view2 = new View();
        view2.add(component);
        view2.setTitle(this.getTabTitle());
        view2.setIcon(this.getTabIcon());
        view2.setIconOnly(this.getTabIconOnly());
        ViewTabbedPane viewTabbedPane = new ViewTabbedPane(false);
        viewTabbedPane.openView(view2);
        viewTabbedPane.openView(new NodePropertyView(this.getNode()));
        return viewTabbedPane;
    }

    protected void rebuildView() {
        this.centerView = this.createCenterView();
        if (this.centerView == null) {
            UIUtility.removeFromParent(this.centerPanel);
        } else {
            if (this.centerPanel == null) {
                this.centerPanel = new JPanel(new BorderLayout());
                this.add((Component)this.centerPanel, "Center");
            }
            BorderLayout borderLayout = (BorderLayout)this.centerPanel.getLayout();
            UIUtility.removeFromParent(borderLayout.getLayoutComponent(this.centerPanel, "Center"));
            this.centerPanel.add(this.createCenterTabbedPane(this.centerView), "Center");
        }
        this.revalidate();
        this.repaint();
    }

    protected String getTabTitle() {
        return this.getTitle();
    }

    protected Icon getTabIcon() {
        return this.getIcon();
    }

    protected boolean getTabIconOnly() {
        return true;
    }

    protected void configureToolBar(JToolBar jToolBar) {
        jToolBar.add(this.createToolBarButton(this.viewActions.get("RUN_SELECTED")));
    }

    protected JButton createToolBarButton(Action action) {
        JButton jButton = new JButton(action);
        String string = (String)action.getValue("Name");
        if (string == null) {
            jButton.setHideActionText(true);
        }
        jButton.setFocusable(false);
        return jButton;
    }

    protected JPanel getCenterPanel() {
        return this.centerPanel;
    }

    protected Component getCenterView() {
        return this.centerView;
    }

    protected Component getCenterTabbedPane() {
        if (this.centerPanel == null) {
            return null;
        }
        return ((BorderLayout)this.centerPanel.getLayout()).getLayoutComponent("Center");
    }

    public FlowNode getNode() {
        return this.node;
    }

    public Optional<FlowModel> getFlowModel() {
        return this.getNode().getFlowModel();
    }

    public boolean isPreview() {
        return this.preview;
    }

    @Override
    public Object getKey() {
        return this.getNode();
    }

    @Override
    public String getTitle() {
        return this.getNode().getTitle();
    }

    @Override
    public Icon getIcon() {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return this.getNode().getSmallIcon();
        }
        FlowState flowState = optional.get().getState();
        return flowState.isError(this.getNode()) ? FileResource.getIcon("img/error_16.png") : this.getNode().getSmallIcon();
    }

    @Override
    public String getIconToolTip() {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return null;
        }
        FlowState flowState = optional.get().getState();
        return flowState.getErrorMessageHtml(this.getNode());
    }

    @Override
    public void loadView() {
        FlowNode.addNodeModelChangeListener(this.changedListener);
        FlowNode.addNodePropertyChangeListener(this.changedListener);
        EventManager.getInstance().registerEventHandler(FlowErrorEvent.class, this.changedListener);
    }

    @Override
    public void unloadView() {
        FlowNode.removeNodeModelChangeListener(this.changedListener);
        FlowNode.removeNodePropertyChangeListener(this.changedListener);
        EventManager.getInstance().removeEventHandler(FlowErrorEvent.class, this.changedListener);
    }

    @Override
    protected Object getProtectKey() {
        return null;
    }

    public void startEditing() {
    }

    public FlowViewer getActiveViewer() {
        return null;
    }

    public void goToParentView() {
        FlowNode flowNode = this.node.getParentNode();
        if (flowNode == null) {
            return;
        }
        this.closeTab();
        Rflow.mainView().openViewer(flowNode, ViewOpenType.OPEN_NEW);
    }

    protected void modelHasBeenChanged() {
        this.viewActions.updateState();
    }

    @Override
    public void itemChanged(ItemEvent itemEvent) {
    }

    @Override
    public boolean doSave(boolean bl) {
        Optional<FlowModel> optional = this.getFlowModel();
        if (!optional.isPresent()) {
            return false;
        }
        RflowActions rflowActions = Rflow.getInstance().getActions();
        return bl ? rflowActions.save_as(optional.get()) : rflowActions.save(optional.get());
    }

    protected class ViewActions
    extends Actions {
        public static final String RUN = "RUN";
        public static final String RUN_CLEAR = "RUN_CLEAR";
        public static final String RUN_SELECTED = "RUN_SELECTED";

        public ViewActions() {
            this.put(RUN, new Run());
            this.put(RUN_CLEAR, new RunClear());
            this.put(RUN_SELECTED, new RunSelected());
        }

        public void updateState() {
            this.get(RUN_SELECTED).setEnabled(!FlowNodeView.this.getNode().getModel().isDisabled());
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run_flow"));
                this.putValue("SmallIcon", Icons.getIcon("16/go.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                try {
                    Optional<FlowModel> optional = FlowNodeView.this.getFlowModel();
                    if (optional.isPresent()) {
                        optional.get().getExecutor().runNode(FlowNodeView.this.getNode(), null, FlowRunOption.createRunNodeOption());
                    }
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run flow.", operationFailedException);
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), operationFailedException.getMessage());
                }
            }
        }

        private class RunClear
        extends LoggableAction {
            public RunClear() {
                this.putValue("Name", Messages.getString("Action.run_clear"));
                this.putValue("SmallIcon", Icons.getOverlaidIcon(Icons.getIcon("16/go.png"), "16/asterisk_yellow.png", 8, 0, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                try {
                    Optional<FlowModel> optional = FlowNodeView.this.getFlowModel();
                    if (optional.isPresent()) {
                        optional.get().getExecutor().runNode(FlowNodeView.this.getNode(), null, FlowRunOption.createClearAndRunNodeOption());
                    }
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run flow.", operationFailedException);
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), operationFailedException.getMessage());
                }
            }
        }

        private class RunSelected
        extends LoggableAction {
            public RunSelected() {
                this.putValue("Name", Messages.getString("Action.run_node"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                try {
                    Optional<FlowModel> optional = FlowNodeView.this.getFlowModel();
                    if (optional.isPresent()) {
                        optional.get().getExecutor().runNode(FlowNodeView.this.getNode(), FlowNodeView.this.getNode(), FlowRunOption.createRunSelectedNodeOption(false));
                    }
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run node.", operationFailedException);
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), operationFailedException.getMessage());
                }
            }
        }
    }

    private class NodeChangedListener
    implements NodeModelChangeListener,
    NodePropertyChangeListener,
    SimpleEventHandler {
        private NodeChangedListener() {
        }

        @Override
        public void nodeModelChanged(FlowNode flowNode) {
            if (flowNode == FlowNodeView.this.getNode()) {
                FlowNodeView.this.modelHasBeenChanged();
            }
        }

        @Override
        public void subflowNodeModelChanged(FlowNode flowNode) {
            if (flowNode == FlowNodeView.this.getNode()) {
                FlowNodeView.this.modelHasBeenChanged();
            }
        }

        @Override
        public void nodePropertyChanged(FlowNode flowNode) {
            if (FlowNodeView.this.getNode() == flowNode) {
                FlowNodeView.this.updateTab();
            }
        }

        @Override
        public void onEvent(SimpleEvent simpleEvent) {
            FlowErrorEvent flowErrorEvent;
            if (simpleEvent.getClass().equals(FlowErrorEvent.class) && (flowErrorEvent = (FlowErrorEvent)simpleEvent).getNode() == FlowNodeView.this.getNode()) {
                FlowNodeView.this.updateTab();
            }
        }
    }
}

