/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.SubflowState;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.NamedCompoundEdit;
import com.ef_prime.rflow.ui.flow.FlowPickSupport;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class FlowPickingGraphMousePlugin
extends PickingGraphMousePlugin
implements MouseWheelListener {
    private static final Color LENS_COLOR = new Color(0xFF9900);
    private boolean dragStarted = false;
    private Point2D dragStartPoint = null;
    private Map<Vertex, Point2D> beforeMap = new HashMap<Vertex, Point2D>();
    private boolean nodeMoved;
    private FlowNode draggedCommentNode;
    private NodeComment beforeDragComment;
    private Point graphDown;

    public FlowPickingGraphMousePlugin(int n, int n2) {
        super(n, n2);
        this.setLensColor(Color.ORANGE);
        this.lensPaintable = new LensPaintable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        Object object;
        Cloneable cloneable;
        Point2D point2D;
        Object object2;
        FlowViewer flowViewer;
        if (this.down == null || mouseEvent.isConsumed()) {
            return;
        }
        if (!this.locked) {
            flowViewer = (FlowViewer)mouseEvent.getSource();
            object2 = flowViewer.getGraph().getVertices();
            if (this.draggedCommentNode != null || this.vertex != null) {
                point2D = mouseEvent.getPoint();
                cloneable = flowViewer.inverseTransform(point2D);
                var6_6 = flowViewer.getGraphLayout();
                subflowState = flowViewer.getPickedState();
                if (this.draggedCommentNode != null) {
                    object = this.draggedCommentNode.getComment();
                    if (!this.dragStarted) {
                        this.beforeMap.put((Vertex)this.draggedCommentNode, (Point2D)((NodeComment)object).getOffset().clone());
                        this.beforeDragComment = this.draggedCommentNode.getComment().copy();
                        this.dragStartPoint = this.down;
                    }
                    int n = (int)(this.down.getX() - this.dragStartPoint.getX());
                    int n2 = (int)(this.down.getY() - this.dragStartPoint.getY());
                    Point2D point2D2 = this.beforeMap.get(this.draggedCommentNode);
                    if (point2D2 == null) {
                        return;
                    }
                    var12_20 = ((FlowLayout)((Object)var6_6)).getPointOnGrid((int)point2D2.getX() + n, (int)point2D2.getY() + n2);
                    ((NodeComment)object).getOffset().move(((Point)var12_20).x, ((Point)var12_20).y);
                    flowViewer.fireStateChanged();
                } else {
                    Point2D point2D3;
                    if (!this.dragStarted) {
                        for (FlowNode flowNode : subflowState.getPickedVertices()) {
                            Vertex vertex = (Vertex)flowNode;
                            if (!object2.contains(vertex)) continue;
                            this.beforeMap.put(vertex, (Point2D)var6_6.getLocation((ArchetypeVertex)vertex).clone());
                        }
                        this.dragStartPoint = this.graphDown;
                    }
                    double d = cloneable.getX() - this.dragStartPoint.getX();
                    double d2 = cloneable.getY() - this.dragStartPoint.getY();
                    var12_20 = this.beforeMap.get(this.vertex);
                    if (var12_20 == null) {
                        return;
                    }
                    int n = (int)var12_20.getX() + (int)d;
                    int n3 = (int)var12_20.getY() + (int)d2;
                    boolean bl = true;
                    ((FlowLayout)((Object)var6_6)).beginNodesMove();
                    try {
                        if (flowViewer.isUseGrid()) {
                            bl = ((FlowLayout)((Object)var6_6)).forceMoveOnGrid(this.vertex, n, n3);
                        } else {
                            var6_6.forceMove(this.vertex, (double)n, (double)n3);
                        }
                        if (bl) {
                            point2D3 = var6_6.getLocation((ArchetypeVertex)this.vertex);
                            double d3 = point2D3.getX() - var12_20.getX();
                            double d4 = point2D3.getY() - var12_20.getY();
                            for (Vertex vertex : this.beforeMap.keySet()) {
                                if (vertex == this.vertex) continue;
                                Point2D point2D4 = this.beforeMap.get(vertex);
                                var6_6.forceMove(vertex, point2D4.getX() + d3, point2D4.getY() + d4);
                            }
                            this.nodeMoved = true;
                            flowViewer.getFlowModel().setDirty(true);
                        }
                    }
                    finally {
                        ((FlowLayout)((Object)var6_6)).endNodesMove();
                    }
                    point2D3 = flowViewer.inverseViewTransform(mouseEvent.getPoint());
                    FlowNode flowNode = (FlowNode)flowViewer.getPickSupport().getVertex(point2D3.getX(), point2D3.getY(), this.vertex);
                    if (flowNode != null && this.beforeMap.size() == 1 && flowNode != ((FlowNode)this.vertex).getPreviousNode() && ((FlowNode)this.vertex).inDegree() == 0 && ((FlowNode)this.vertex).getModel().isConnectable() && flowNode.getModel().isConnectable()) {
                        flowViewer.setTransparentConnection(flowNode, Lists.newArrayList((Object[])new FlowNode[]{(FlowNode)this.vertex}));
                    } else {
                        flowViewer.setTransparentConnection(null, null);
                    }
                }
                this.down = point2D;
                this.dragStarted = true;
            } else if (this.edge == null && (mouseEvent.getModifiers() == this.addToSelectionModifiers || mouseEvent.getModifiers() == this.modifiers)) {
                point2D = mouseEvent.getPoint();
                cloneable = flowViewer.inverseTransform(point2D);
                var6_6 = new Point((int)cloneable.getX(), (int)cloneable.getY());
                this.rect.setFrameFromDiagonal(this.graphDown, (Point2D)var6_6);
                subflowState = flowViewer.getPickedState();
                subflowState.clearRectangleSelectionNodes();
                for (Object e : flowViewer.getGraph().getVertices()) {
                    FlowNode flowNode = (FlowNode)e;
                    if (!this.rect.contains(flowViewer.getGraphLayout().getLocation((ArchetypeVertex)flowNode))) continue;
                    subflowState.addRectangleSelectionNode(flowNode);
                }
            }
            if (this.vertex != null) {
                mouseEvent.consume();
            }
        }
        flowViewer = (FlowViewer)mouseEvent.getSource();
        flowViewer.getPickedState().clearInsertTargetEdge();
        if (this.vertex != null && flowViewer.getPickedState().getPickedVertices().size() == 1 && this.vertex.getIncidentEdges().isEmpty() && ((FlowNode)this.vertex).getModel().isInsertionEnabled() && ((FlowNode)this.vertex).getModel().isConnectable()) {
            object2 = flowViewer.getRenderer().getVertexShapeFunction().getShape(this.vertex);
            point2D = flowViewer.getGraphLayout().getLocation((ArchetypeVertex)this.vertex);
            point2D = flowViewer.layoutTransform(point2D);
            object2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape((Shape)object2);
            cloneable = object2.getBounds2D();
            for (SubflowState subflowState : flowViewer.getGraph().getEdges()) {
                object = (FlowEdge)((Object)subflowState);
                Shape shape = flowViewer.getRenderer().getEdgeShapes().get(object);
                if (shape == null || !shape.intersects((Rectangle2D)cloneable)) continue;
                flowViewer.getPickedState().setInsertTargetEdge((FlowEdge)((Object)object));
                break;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        if (mouseEvent.getClickCount() > 1 || mouseEvent.isConsumed()) {
            return;
        }
        FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
        flowViewer.getPickedState().clearInsertTargetEdge();
        this.draggedCommentNode = null;
        flowViewer.getPickedState().clearConnectTargetNode();
        this.down = mouseEvent.getPoint();
        Point2D point2D = flowViewer.inverseTransform(this.down);
        this.graphDown = new Point((int)point2D.getX(), (int)point2D.getY());
        FlowPickSupport flowPickSupport = flowViewer.getPickSupport();
        FlowState flowState = flowViewer.getState();
        SubflowState subflowState = flowViewer.getPickedState();
        if (flowPickSupport == null || flowState == null) {
            return;
        }
        FlowLayout flowLayout = flowViewer.getGraphLayout();
        Point2D point2D2 = flowViewer.inverseViewTransform(mouseEvent.getPoint());
        if (UIUtility.isLeftMouseButton(mouseEvent) && (object2 = flowViewer.getPickSupport().getCommentIcon(point2D2.getX(), point2D2.getY())) != null) {
            NodeComment nodeComment = ((FlowNode)object2).getComment();
            if (nodeComment.getState().equals("opened")) {
                flowViewer.setCommentState((FlowNode)object2, "closed");
            } else if (nodeComment.getState().equals("closed")) {
                flowViewer.setCommentState((FlowNode)object2, "opened");
            }
            flowViewer.getState().setPoppedComment(null);
            return;
        }
        if (UIUtility.isLeftMouseButton(mouseEvent) && (object = ((FlowViewer)(object2 = (FlowViewer)mouseEvent.getSource())).getPickSupport().getComment(point2D2.getX(), point2D2.getY())) != null) {
            this.draggedCommentNode = object;
        }
        if (this.draggedCommentNode == null && mouseEvent.getModifiers() == this.modifiers) {
            this.vertex = flowPickSupport.getVertex(point2D2.getX(), point2D2.getY());
            if (this.vertex != null) {
                object2 = flowViewer.layoutTransform(flowViewer.getGraphLayout().getLocation((ArchetypeVertex)this.vertex));
                object = new Point((int)(point2D2.getX() - ((Point2D)object2).getX()), (int)(point2D2.getY() - ((Point2D)object2).getY()));
                if (((FlowNode)this.vertex).getModel().mousePressed(flowViewer, (FlowNode)this.vertex, (Point)object)) {
                    return;
                }
                if (!subflowState.isPicked(this.vertex)) {
                    subflowState.setPicked((ArchetypeVertex)this.vertex);
                }
                Point2D point2D3 = flowLayout.getLocation((ArchetypeVertex)this.vertex);
                Point2D point2D4 = flowViewer.inverseLayoutTransform(point2D2);
                this.offsetx = (float)(point2D4.getX() - point2D3.getX());
                this.offsety = (float)(point2D4.getY() - point2D3.getY());
            } else {
                this.edge = flowPickSupport.getEdge(point2D2.getX(), point2D2.getY());
                if (this.edge != null) {
                    subflowState.setPicked((ArchetypeEdge)this.edge);
                } else {
                    this.startRectangle(flowViewer);
                    subflowState.clear();
                }
            }
        } else if (mouseEvent.getModifiers() == this.addToSelectionModifiers) {
            this.vertex = flowPickSupport.getVertex(point2D2.getX(), point2D2.getY());
            if (this.vertex != null) {
                boolean bl = subflowState.pick((ArchetypeVertex)this.vertex, !subflowState.isPicked(this.vertex));
                if (bl) {
                    this.vertex = null;
                } else {
                    object = flowLayout.getLocation((ArchetypeVertex)this.vertex);
                    Point2D point2D5 = flowViewer.inverseLayoutTransform(point2D2);
                    this.offsetx = (float)(point2D5.getX() - ((Point2D)object).getX());
                    this.offsety = (float)(point2D5.getY() - ((Point2D)object).getY());
                }
            } else {
                this.edge = flowPickSupport.getEdge(point2D2.getX(), point2D2.getY());
                if (this.edge != null) {
                    subflowState.pick((ArchetypeEdge)this.edge, !subflowState.isPicked(this.edge));
                } else {
                    this.startRectangle(flowViewer);
                }
            }
        }
        if (this.draggedCommentNode != null || this.vertex != null || this.edge != null) {
            mouseEvent.consume();
        }
    }

    private void startRectangle(FlowViewer flowViewer) {
        ((LensPaintable)this.lensPaintable).setViewer(flowViewer);
        flowViewer.addPostRenderPaintable(this.lensPaintable);
        this.rect.setFrameFromDiagonal(this.graphDown, this.graphDown);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.getClickCount() > 1 || mouseEvent.isConsumed()) {
            return;
        }
        FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
        FlowEdge flowEdge = flowViewer.getPickedState().getInsertTargetEdge();
        CompoundEdit compoundEdit = null;
        if (flowEdge != null && this.vertex != null && ((FlowNode)this.vertex).getModel().isInsertionEnabled() && ((FlowNode)this.vertex).getModel().isConnectable()) {
            flowViewer.getGraph().removeEdge((Edge)flowEdge);
            object = (FlowEdge)flowViewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowEdge.getSource(), this.vertex));
            FlowEdge flowEdge2 = (FlowEdge)flowViewer.getGraph().addEdge((Edge)new FlowEdge(this.vertex, (Vertex)flowEdge.getDest()));
            compoundEdit = new NamedCompoundEdit(Messages.getString("Action.insert"));
            compoundEdit.addEdit(flowViewer.undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{flowEdge}));
            compoundEdit.addEdit(flowViewer.undoableEditFactory.createAddEdgeEdit(new FlowEdge[]{object, flowEdge2}));
        }
        flowViewer.getPickedState().clearInsertTargetEdge();
        if (this.vertex != null && flowViewer.getPickedState().getConnectTargetNode() != null) {
            flowViewer.dropOnConnection((FlowNode)this.vertex, this.beforeMap.get(this.vertex));
            this.beforeMap.clear();
        }
        if (!this.beforeMap.isEmpty()) {
            if (this.draggedCommentNode == null) {
                if (this.nodeMoved) {
                    object = flowViewer.undoableEditFactory.createMoveNodeEdit(new HashMap<Vertex, Point2D>(this.beforeMap));
                    if (compoundEdit == null) {
                        flowViewer.fireUndoableEditUpdate((UndoableEdit)object);
                    } else {
                        compoundEdit.addEdit((UndoableEdit)object);
                    }
                }
            } else if (this.beforeDragComment != null) {
                flowViewer.fireUndoableEditUpdate(flowViewer.undoableEditFactory.createNodeCommentChangeEdit(this.draggedCommentNode, this.beforeDragComment));
                FlowNode.fireNodeCommentChanged(this.draggedCommentNode, this.beforeDragComment, this.draggedCommentNode.getComment());
            }
        }
        if (compoundEdit != null) {
            compoundEdit.end();
            flowViewer.fireUndoableEditUpdate(compoundEdit);
        }
        this.dragStarted = false;
        this.nodeMoved = false;
        this.beforeMap.clear();
        this.draggedCommentNode = null;
        this.beforeDragComment = null;
        flowViewer.getPickedState().clearConnectTargetNode();
        flowViewer.getPickedState().clearRectangleSelectionNodes();
        object = mouseEvent.getPoint();
        if (this.down != null && this.vertex == null && !this.heyThatsTooClose(this.down, (Point2D)object, 5.0)) {
            if (mouseEvent.getModifiers() == this.modifiers) {
                this.pickContainedVertices(flowViewer, true);
            } else if (mouseEvent.getModifiers() == this.addToSelectionModifiers) {
                this.pickContainedVertices(flowViewer, false);
            }
        }
        this.down = null;
        this.vertex = null;
        this.edge = null;
        this.rect.setFrame(0.0, 0.0, 0.0, 0.0);
        flowViewer.removePostRenderPaintable(this.lensPaintable);
    }

    private boolean heyThatsTooClose(Point2D point2D, Point2D point2D2, double d) {
        return Math.abs(point2D.getX() - point2D2.getX()) < d && Math.abs(point2D.getY() - point2D2.getY()) < d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pickContainedVertices(FlowViewer flowViewer, boolean bl) {
        FlowLayout flowLayout = flowViewer.getGraphLayout();
        SubflowState subflowState = flowViewer.getPickedState();
        if (subflowState == null) {
            return;
        }
        subflowState.startAdjusting();
        try {
            if (bl) {
                subflowState.clearPickedVertices();
            }
            while (true) {
                try {
                    for (Vertex vertex : flowLayout.getGraph().getVertices()) {
                        if (!this.rect.contains(flowLayout.getLocation((ArchetypeVertex)vertex))) continue;
                        subflowState.pick((ArchetypeVertex)vertex, true);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
        finally {
            subflowState.endAdjusting();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.down != null) {
            SwingUtilities.invokeLater(() -> this.mouseDragged(mouseWheelEvent));
        }
    }

    private class LensPaintable
    implements VisualizationViewer.Paintable {
        private FlowViewer viewer;

        private LensPaintable() {
        }

        public void setViewer(FlowViewer flowViewer) {
            this.viewer = flowViewer;
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(LENS_COLOR);
            Rectangle2D rectangle2D = this.viewer != null ? this.viewer.getLayoutTransformer().getTransform().createTransformedShape(FlowPickingGraphMousePlugin.this.rect) : FlowPickingGraphMousePlugin.this.rect;
            graphics2D.draw(rectangle2D);
            graphics2D.setColor(color);
        }

        public boolean useTransform() {
            return true;
        }
    }
}

