/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.r.RReadObject;
import com.ef_prime.rflow.core.app.r.RReadTable;
import com.ef_prime.rflow.core.app.r.RScript;
import com.ef_prime.rflow.core.app.r.RScriptFile;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackageListChangeEvent;
import com.ef_prime.rflow.core.app.r.base.RPackageListChangeEventHandler;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BusyListener;
import com.ef_prime.rflow.core.app.r.console.CommandPlan;
import com.ef_prime.rflow.core.app.r.console.Executor;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.feature.history.FlowNodeFlavor;
import com.ef_prime.rflow.core.flow.ErrorLevel;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowGraphEvent;
import com.ef_prime.rflow.core.flow.FlowGraphEventHandler;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowSegment;
import com.ef_prime.rflow.core.flow.FlowSettings;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.FlowStateEvent;
import com.ef_prime.rflow.core.flow.FlowStateEventHandler;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.NodeSelectionInfo;
import com.ef_prime.rflow.core.flow.RScriptExporter;
import com.ef_prime.rflow.core.flow.SubflowState;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeCommentListener;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.NodePropertyChangeListener;
import com.ef_prime.rflow.node.NodePropertyView;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.base.CommentNodeModel;
import com.ef_prime.rflow.node.base.ForNodeModel;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.node.base.FunctionNodeModel;
import com.ef_prime.rflow.node.base.IfNodeModel;
import com.ef_prime.rflow.node.base.ListNodeModel;
import com.ef_prime.rflow.node.base.LoopNodeModel;
import com.ef_prime.rflow.node.base.LoopType;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpPopupMenu;
import com.ef_prime.rflow.node.ui.OpTreeNode;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.CodeBar;
import com.ef_prime.rflow.ui.base.FileEditUIUtilty;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.FileFilterFactory;
import com.ef_prime.rflow.ui.common.component.Flavors;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.NamedCompoundEdit;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.flow.AdjustedPluggableGraphMouse;
import com.ef_prime.rflow.ui.flow.DefaultUndoableEdits;
import com.ef_prime.rflow.ui.flow.FlowActions;
import com.ef_prime.rflow.ui.flow.FlowBrowseView;
import com.ef_prime.rflow.ui.flow.FlowPickSupport;
import com.ef_prime.rflow.ui.flow.FlowPickingGraphMousePlugin;
import com.ef_prime.rflow.ui.flow.FlowUndoManager;
import com.ef_prime.rflow.ui.flow.FlowUndoableEditSupport;
import com.ef_prime.rflow.ui.flow.FlowViewerEvent;
import com.ef_prime.rflow.ui.flow.FlowViewerEventHandler;
import com.ef_prime.rflow.ui.flow.HighlightChangedEvent;
import com.ef_prime.rflow.ui.flow.LayoutDataFlavor;
import com.ef_prime.rflow.ui.flow.LayoutTransferable;
import com.ef_prime.rflow.ui.flow.RScriptExportView;
import com.ef_prime.rflow.ui.flow.RScriptizeView;
import com.ef_prime.rflow.ui.flow.UndoableEditFactory;
import com.ef_prime.rflow.ui.flow.rendering.FlowRenderer;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.event.GraphEventType;
import edu.uci.ics.jung.graph.impl.AbstractElement;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowViewer
extends VisualizationViewer
implements NodeModelChangeListener,
NodeBreakpointChangeListener,
NodePropertyChangeListener,
NodeCommentListener,
MenuActionProvider,
UndoableEditListener,
FileEditEventHandler,
FlowStateEventHandler,
RPackageListChangeEventHandler,
SimpleEventHandler {
    private static final Logger LOGGER = Logger.getLogger(FlowViewer.class.getName());
    public static final int COPY_TYPE_NONE = 0;
    public static final int COPY_TYPE_NORMAL = 1;
    public static final int COPY_TYPE_FULL = 2;
    public static final int X_GAP = 80;
    private static final AlphaComposite SRCOVER_05 = AlphaComposite.getInstance(3, 0.5f);
    UndoableEditFactory undoableEditFactory;
    private boolean useGrid;
    private boolean repaintEnabled = true;
    private Point lastClickedPoint = null;
    private FlowUndoableEditSupport undoableEditSupport = new FlowUndoableEditSupport(this);
    private static Queue<GraphEventListener> graphEventListers = new ConcurrentLinkedQueue<GraphEventListener>();
    private static Queue<FlowGraphEventHandler> flowGraphEventListers = new ConcurrentLinkedQueue<FlowGraphEventHandler>();
    private GraphEventHandler graphEventHandler = new GraphEventHandler();
    private CodeBar codeBar;
    private EdgeConnectionHandler edgeConnectionHandler = new EdgeConnectionHandler();
    private FlowModel flowModel;
    private ViewLayout model;
    private FirstGuide firstGuide;
    private boolean isChildView;
    private EventSupport<FlowViewerEvent, FlowViewerEventHandler> flowViewerEventSupport = new EventSupport();
    private ViewerActions viewerActions;
    private TransparentGraph transparentGraph = new TransparentGraph();

    public FlowViewer(FlowModel flowModel) {
        super((Layout)new FlowLayout(new FlowGraph()), (Renderer)new PluggableRenderer());
        this.flowModel = flowModel;
        this.setPickedState((PickedState)new SubflowState());
        this.getPickedState().addChangeEventHandler(new ChangeEventHandler(){

            @Override
            public void handleChanged(ChangeEvent changeEvent) {
                FlowViewer.this.repaint();
            }
        });
        this.setRenderer((Renderer)new FlowRenderer(flowModel.getState(), this.getPickedState()));
        this.setBackground(Color.WHITE);
        this.setPickSupport((PickSupport)new FlowPickSupport());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FlowViewer.this.focusViewer();
                FlowViewer.this.clearFirstGuide();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FlowViewer.this.lastClickedPoint = null;
            }
        });
        this.addMouseListener(this.edgeConnectionHandler);
        this.addMouseMotionListener(this.edgeConnectionHandler);
        AdjustedPluggableGraphMouse adjustedPluggableGraphMouse = new AdjustedPluggableGraphMouse();
        adjustedPluggableGraphMouse.add((GraphMousePlugin)new FlowPickingGraphMousePlugin(16, 0x10 | UIUtility.MENU_KEY_MASK));
        this.setGraphMouse((VisualizationViewer.GraphMouse)adjustedPluggableGraphMouse);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setToolTipFunction(new ToolTipHandler(flowModel.getState()));
        this.setDropTarget(new DropTarget((Component)((Object)this), new DropTargetHandler()));
        this.viewerActions = new ViewerActions(this);
        this.viewerActions.installActions((JComponent)((Object)this), false, 0);
        this.getInputMap().put(KeyStroke.getKeyStroke(47, UIUtility.MENU_KEY_MASK), "DISABLE");
        this.updateFlowSetting();
        this.setLayout(null);
    }

    public void focusViewer() {
        this.requestFocusInWindow();
    }

    public FlowModel getFlowModel() {
        return this.flowModel;
    }

    public ViewerActions getViewerActions() {
        return this.viewerActions;
    }

    public Action getViewerAction(Object object) {
        return this.viewerActions.get(object);
    }

    public void setChildView(boolean bl) {
        this.isChildView = bl;
    }

    public boolean isChildView() {
        return this.isChildView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModel(ViewLayout viewLayout) {
        this.setRepaintEnabled(false);
        try {
            this.unloadModel();
            this.model = viewLayout;
            this.model.getGraph().addListener(this.graphEventHandler, (GraphEventType)GraphEventType.ALL_SINGLE_EVENTS);
            this.model.getGraph().addListener(this.getPickedState(), (GraphEventType)GraphEventType.VERTEX_REMOVAL);
            this.model.getGraph().addGraphEventHandler(this.graphEventHandler);
            this.getPickedState().addSelectionEventHandler(this.flowModel.getState());
            this.model.getLayout().initialize(this.model.getSize());
            this.setGraphLayout((Layout)this.model.getLayout());
            this.layoutTransformer.setToIdentity();
            Point point = this.model.getOffset();
            if (point != null) {
                this.layoutTransformer.translate((double)point.x, (double)point.y);
            }
            this.undoableEditFactory = new UndoableEditFactory(this.model, this.getPickedState());
            this.addUndoableEditListener(this.model.getUndoManager());
            this.addUndoableEditListener(this);
            this.updateFlowSetting();
            R.queryQueue().addQuery(() -> this.checkSyntaxError());
            this.getPickedState().addSelectionEventHandler(this.viewerActions);
            Rflow.getInstance().getConsole().addBusyListener(this.viewerActions);
            FlowNode.addNodeBreakpointChangeListener(this.viewerActions);
            FlowNode.addNodeModelChangeListener(this.viewerActions);
            FlowNode.addNodeModelChangeListener(this);
            FlowNode.addNodePropertyChangeListener(this);
            FlowNode.addNodeCommentListener(this);
            FlowNode.addNodeBreakpointChangeListener(this);
            EventManager.getInstance().registerEventHandler(FlowStateEvent.class, this);
            EventManager.getInstance().registerEventHandler(HighlightChangedEvent.class, this);
            EventManager.getInstance().registerEventHandler(RPackageListChangeEvent.class, this);
            for (FlowNode flowNode : FlowUtil.getAllNodes(this.getGraph())) {
                FileEditSupplier fileEditSupplier = flowNode.getFileEditSupplier();
                if (fileEditSupplier == null) continue;
                fileEditSupplier.addFileEditEventHandler(this);
            }
            if (this.model.getGraph().getVertices().size() == 0) {
                this.showFirstGuide();
            }
        }
        finally {
            this.setRepaintEnabled(true);
        }
    }

    public void unloadModel() {
        if (this.model != null) {
            this.model.getGraph().removeListener(this.graphEventHandler, (GraphEventType)GraphEventType.ALL_SINGLE_EVENTS);
            this.model.getGraph().removeListener(this.getPickedState(), (GraphEventType)GraphEventType.VERTEX_REMOVAL);
            this.model.getGraph().removeGraphEventHandler(this.graphEventHandler);
            this.getPickedState().removeSelectionEventHandler(this.flowModel.getState());
            this.removeUndoableEditListener(this.model.getUndoManager());
            this.model = null;
        }
        this.removeUndoableEditListener(this);
        this.getPickedState().removeSelectionEventHandler(this.viewerActions);
        Rflow.getInstance().getConsole().removeBusyListener(this.viewerActions);
        FlowNode.removeNodeBreakpointChangeListener(this.viewerActions);
        FlowNode.removeNodeModelChangeListener(this.viewerActions);
        FlowNode.removeNodeModelChangeListener(this);
        FlowNode.removeNodePropertyChangeListener(this);
        FlowNode.removeNodeCommentListener(this);
        FlowNode.removeNodeBreakpointChangeListener(this);
        EventManager.getInstance().removeEventHandler(FlowStateEvent.class, this);
        EventManager.getInstance().removeEventHandler(HighlightChangedEvent.class, this);
        for (FlowNode flowNode : FlowUtil.getAllNodes(this.getGraph())) {
            FileEditSupplier fileEditSupplier = flowNode.getFileEditSupplier();
            if (fileEditSupplier == null) continue;
            fileEditSupplier.removeFileEditEventHandler(this);
        }
    }

    public void updateFlowSetting() {
        FlowSettings flowSettings = this.getFlowModel().getFlowSetting();
        this.getGraphLayout().setGridDistance(flowSettings.getValue(FlowSettings.GRID_DISTANCE2));
        this.setUseGrid(flowSettings.getValue(FlowSettings.USE_GRID));
    }

    private void showFirstGuide() {
        if (this.firstGuide == null) {
            this.firstGuide = new FirstGuide();
        }
        this.firstGuide.refreshFont();
        this.addPreRenderPaintable(this.firstGuide);
    }

    private void clearFirstGuide() {
        if (this.firstGuide != null) {
            this.removePreRenderPaintable(this.firstGuide);
            this.firstGuide = null;
        }
    }

    public void setCodeBar(CodeBar codeBar) {
        this.codeBar = codeBar;
    }

    public CodeBar getCodeBar() {
        return this.codeBar;
    }

    public synchronized void setRepaintEnabled(boolean bl) {
        this.repaintEnabled = bl;
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        if (this.getGraph() == flowNode.getGraph()) {
            this.repaint();
        }
    }

    @Override
    public void nodePropertyChanged(FlowNode flowNode) {
        if (this.getGraph() == flowNode.getGraph()) {
            this.repaint();
        }
    }

    @Override
    public void nodeCommentChanged(FlowNode flowNode, NodeComment nodeComment, NodeComment nodeComment2) {
        if (this.getGraph() == flowNode.getGraph()) {
            this.repaint();
        }
    }

    @Override
    public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        if (this.getGraph() == flowNode.getGraph()) {
            this.repaint();
        }
    }

    public void setGraphLayout(Layout layout) {
        this.setGraphLayout(layout, false);
    }

    public FlowGraph getGraph() {
        return this.getGraphLayout().getGraph();
    }

    public FlowRenderer getRenderer() {
        return (FlowRenderer)super.getRenderer();
    }

    public FlowLayout getGraphLayout() {
        return (FlowLayout)super.getGraphLayout();
    }

    public SubflowState getPickedState() {
        return (SubflowState)super.getPickedState();
    }

    public FlowPickSupport getPickSupport() {
        return (FlowPickSupport)super.getPickSupport();
    }

    public FlowState getState() {
        return this.flowModel.getState();
    }

    public void setUseGrid(boolean bl) {
        this.useGrid = bl;
    }

    public boolean isUseGrid() {
        return this.useGrid;
    }

    public FlowUndoableEditSupport getUndoableEditSupport() {
        return this.undoableEditSupport;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }

    void fireUndoableEditUpdate(UndoableEdit undoableEdit) {
        this.undoableEditSupport.postEdit(undoableEdit);
        if (undoableEdit.isSignificant()) {
            this.getFlowModel().setDirty(true);
        }
    }

    public static void addGraphEventListener(GraphEventListener graphEventListener) {
        graphEventListers.add(graphEventListener);
    }

    public static void removeGraphEventListener(GraphEventListener graphEventListener) {
        graphEventListers.remove(graphEventListener);
    }

    public static void addFlowGraphEventHandler(FlowGraphEventHandler flowGraphEventHandler) {
        flowGraphEventListers.add(flowGraphEventHandler);
    }

    public static void removeFlowGraphEventHandler(FlowGraphEventHandler flowGraphEventHandler) {
        flowGraphEventListers.remove(flowGraphEventHandler);
    }

    public boolean cache(FlowNode[] flowNodeArray, boolean bl) {
        for (FlowNode flowNode : flowNodeArray) {
            if (!bl && flowNode.isCacheData() || bl && flowNode.isCacheData() && flowNode.getCacheData().isValid()) continue;
            try {
                this.getFlowModel().getCacheHandler().markCache(flowNode);
                if (!bl) continue;
                FlowRunOption flowRunOption = new FlowRunOption().setClearObjects(true).setUseCache(true);
                this.getFlowModel().getExecutor().runNode(flowNode, null, flowRunOption);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to set cache.", iOException);
                UIUtility.showErrorDialog((Component)((Object)this), Messages.getString("Error.create_cache"), iOException);
                return false;
            }
            catch (OperationFailedException operationFailedException) {
                LOGGER.log(Level.SEVERE, "Failed to run flow.", operationFailedException);
                UIUtility.showErrorDialog((Component)((Object)this), operationFailedException);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(FlowNode[] flowNodeArray, boolean bl, boolean bl2, String string) {
        this.undoableEditSupport.beginUpdate(new NamedCompoundEdit(string));
        try {
            for (FlowNode flowNode : flowNodeArray) {
                if (!flowNode.isCacheData() || !bl && !flowNode.getCacheData().isValid()) continue;
                try {
                    this.getFlowModel().getCacheHandler().removeCache(flowNode, bl, bl2);
                }
                catch (OperationFailedException operationFailedException) {
                    UIUtility.showErrorDialog((Component)((Object)this), operationFailedException.getMessage(), operationFailedException.isWarning());
                }
                if (!bl2) continue;
                this.fireUndoableEditUpdate(this.undoableEditFactory.createAndSetClearCache(flowNode, this.getFlowModel().getCacheHandler(), bl, true));
            }
        }
        finally {
            this.undoableEditSupport.endUpdate();
        }
    }

    public void createNode(Class<? extends NodeModel> clazz, Point2D point2D, boolean bl) {
        NodeModelController nodeModelController = NodeModelManager.getModelController(clazz);
        NodeModel nodeModel = nodeModelController.createNewModel();
        FlowNode flowNode = this.addNode(new FlowNode(nodeModel), point2D, bl);
        this.getPickedState().setPicked((ArchetypeVertex)flowNode);
        if (nodeModelController.canEditOnViewer()) {
            nodeModelController.editOnViewer(this, flowNode);
        }
    }

    private void createOneLinerNode(Point2D point2D, boolean bl) {
        NodeModelController nodeModelController = NodeModelManager.getModelController(FreeNodeModel.class);
        NodeModel nodeModel = nodeModelController.createNewModel();
        FlowNode flowNode = this.addNode(new FlowNode(nodeModel), point2D, bl);
        if (this.getCodeBar() != null) {
            nodeModelController.editOnViewer(this, flowNode);
        } else {
            this.flowViewerEventSupport.dispatchEvent(new FlowViewerEvent(this, 0));
        }
    }

    private void createLoopNode(LoopType loopType, Point2D point2D) {
        LoopNodeModel loopNodeModel = new LoopNodeModel(loopType);
        this.addNode(new FlowNode(loopNodeModel), point2D, true);
    }

    public void openNode(FlowNode flowNode, boolean bl, boolean bl2) {
        if (flowNode == null) {
            return;
        }
        NodeModelController nodeModelController = NodeModelManager.getModelController(flowNode.getModel().getClass());
        if (nodeModelController == null) {
            return;
        }
        if (nodeModelController.canEditOnViewer()) {
            nodeModelController.editOnViewer(this, flowNode);
            return;
        }
        FlowNode flowNode2 = this.getGraph().getParentNode();
        if (this.isChildView) {
            flowNode2 = flowNode2.getParentNode();
        }
        ViewOpenType viewOpenType = Rflow.mainView().getViewOpenType(flowNode, flowNode2, bl2);
        if (!this.isChildView || !Rflow.develSettings().isOpenWithPreview()) {
            Rflow.mainView().openViewer(flowNode, viewOpenType);
        } else {
            View view2 = Rflow.mainView().openViewer(flowNode.getParentNode(), viewOpenType);
            if (view2 instanceof FlowBrowseView && (view2 = ((FlowBrowseView)view2).getFlowNodeView()) instanceof SubflowNodeView) {
                SubflowNodeView subflowNodeView = (SubflowNodeView)view2;
                for (FlowViewer flowViewer : subflowNodeView.getViewers()) {
                    if (!flowViewer.getGraph().contains((Vertex)flowNode)) continue;
                    flowViewer.getPickedState().setPicked((ArchetypeVertex)flowNode);
                    break;
                }
            }
        }
    }

    public void editProperty(FlowNode flowNode) {
        NodePropertyView nodePropertyView = new NodePropertyView(flowNode);
        PagesView pagesView = PagesViewFactory.createCloseOnlyView(new Page(nodePropertyView));
        pagesView.showDialog(Rflow.mainFrame(), nodePropertyView.getTitle(), false, new Dimension(500, 400));
    }

    public void undo() {
        if (this.model.getUndoManager() != null) {
            if (this.model.getUndoManager().canUndo()) {
                this.model.getUndoManager().undo();
            }
            this.viewerActions.updateUndoState();
        }
    }

    public void redo() {
        if (this.model.getUndoManager() != null) {
            if (this.model.getUndoManager().canRedo()) {
                this.model.getUndoManager().redo();
            }
            this.viewerActions.updateUndoState();
        }
    }

    public void delete() {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>(this.getPickedState().getPickedVertices());
        if (!hashSet.isEmpty()) {
            int n;
            if (Rflow.mainView().getTaskExplorer().isNode(hashSet) && (n = JOptionPane.showConfirmDialog((Component)((Object)this), Messages.getString("Message.confirm_task_remove") + "\n" + Messages.getString("Message.confirm_delete"), Messages.getString("Message.confirm"), 2, 3)) != 0) {
                return;
            }
            if (Rflow.mainView().isTab(hashSet) && (n = JOptionPane.showConfirmDialog((Component)((Object)this), Messages.getString("Message.opening_node_on_delete") + "\n" + Messages.getString("Message.confirm_delete"), Messages.getString("Message.confirm"), 2, 3)) != 0) {
                return;
            }
            for (FlowNode flowNode : hashSet) {
                Set<FlowNode> set = FlowUtil.getAllDescendants(flowNode);
                set.add(flowNode);
                for (FlowNode flowNode2 : set) {
                    FileEditSupplier fileEditSupplier = flowNode2.getFileEditSupplier();
                    FileEdit fileEdit = fileEditSupplier == null ? null : fileEditSupplier.getFileEdit();
                    if (fileEdit == null || fileEdit.getProtectCount() != 1 || FileEditUIUtilty.confirmAndSave(fileEdit)) continue;
                    return;
                }
            }
            this.deleteNode(hashSet.toArray(new FlowNode[0]));
            return;
        }
        Set<FlowEdge> set = this.getPickedState().getPickedEdges();
        if (!set.isEmpty()) {
            this.deleteEdge(set.toArray(new FlowEdge[set.size()]));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(FlowNode[] flowNodeArray) {
        if ((flowNodeArray = (FlowNode[])Arrays.stream(flowNodeArray).filter(flowNode -> flowNode.getModel().isModifiable()).toArray(FlowNode[]::new)).length == 0) {
            return;
        }
        this.undoableEditSupport.beginUpdate(new NamedCompoundEdit(Messages.getString("Action.remove_node")));
        try {
            Object object;
            NodeSelectionInfo[] nodeSelectionInfoArray = FlowUtil.getNodeSelectionInfos(flowNodeArray, false);
            HashSet<FlowEdge> hashSet = new HashSet<FlowEdge>();
            for (FlowNode object2 : flowNodeArray) {
                object = object2.getIncidentEdges().iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    hashSet.add((FlowEdge)((Object)e));
                }
                this.getGraph().removeVertex((Vertex)object2);
            }
            this.getPickedState().pick(flowNodeArray, false);
            this.fireUndoableEditUpdate(this.undoableEditFactory.createDeleteEdit(flowNodeArray, hashSet.toArray(new FlowEdge[0])));
            for (NodeSelectionInfo nodeSelectionInfo : nodeSelectionInfoArray) {
                if (nodeSelectionInfo.getIn() == null || nodeSelectionInfo.getOut() == null || !FlowUtil.isEdgeAddable(object = new FlowEdge((Vertex)nodeSelectionInfo.getIn(), (Vertex)nodeSelectionInfo.getOut()))) continue;
                this.getGraph().addEdge((Edge)object);
                this.fireUndoableEditUpdate(this.undoableEditFactory.createAddEdgeEdit(new FlowEdge[]{object}));
            }
        }
        finally {
            this.undoableEditSupport.endUpdate();
        }
    }

    private void deleteEdge(FlowEdge[] flowEdgeArray) {
        this.getPickedState().clear();
        for (FlowEdge flowEdge : flowEdgeArray) {
            this.getGraph().removeEdge((Edge)flowEdge);
        }
        this.repaint();
        this.fireUndoableEditUpdate(this.undoableEditFactory.createDeleteEdit(null, flowEdgeArray));
    }

    public void cut() {
        this.copy_internal(true);
    }

    public void copy() {
        this.copy_internal(false);
    }

    private void copy_internal(boolean bl) {
        this.lastClickedPoint = null;
        ViewLayout viewLayout = this.getSubLayout(this.getPickedState().getPickedVertices(), new Point(0, 0), 1);
        if (viewLayout != null) {
            String string = null;
            FlowSegment flowSegment = FlowUtil.getFlowSegment(this.getPickedState().getPickedVertices());
            if (FlowUtil.isExecutable(flowSegment)) {
                string = RScriptExporter.buildScript(this.getFlowModel().getExecutor(), new NodeTaskEntry(flowSegment.getEnd(), flowSegment.getStart()));
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new LayoutTransferable(viewLayout, string), null);
            if (bl) {
                this.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paste(Point point) {
        Clipboard clipboard;
        if (point == null) {
            point = this.lastClickedPoint != null ? this.lastClickedPoint : new Point(50, 50);
        }
        if ((clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()).isDataFlavorAvailable(LayoutDataFlavor.getInstance())) {
            ViewLayout viewLayout;
            try {
                viewLayout = (ViewLayout)clipboard.getData(LayoutDataFlavor.getInstance());
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Failed to get flow nodes data from clipboard", exception);
                return;
            }
            double d = Double.MAX_VALUE;
            Point2D point2D = new Point2D.Double(0.0, 0.0);
            for (Object e : viewLayout.getGraph().getVertices()) {
                Point2D point2D2 = viewLayout.getLocation((Vertex)e);
                double d2 = point2D2.distanceSq(0.0, 0.0);
                if (!(d > d2)) continue;
                d = d2;
                point2D = point2D2;
            }
            Object object = new Point();
            ((Point2D)object).setLocation(this.inverseTransform(point));
            object = this.getGraphLayout().getPointOnGrid(((Point)object).getX(), ((Point)object).getY());
            ((Point)object).translate((int)(point2D.getX() + 0.5), (int)(point2D.getY() + 0.5));
            int n = 50 % this.getGraphLayout().getGridDistance();
            int n2 = n == 0 ? 50 : 50 - n + this.getGraphLayout().getGridDistance();
            block6: while (true) {
                for (Object e : this.getGraph().getVertices()) {
                    Point2D point2D3 = this.getGraphLayout().getLocation((ArchetypeVertex)((Vertex)e));
                    if ((int)point2D3.getX() != ((Point)object).x || (int)point2D3.getY() != ((Point)object).y) continue;
                    ((Point)object).setLocation(((Point)object).getX(), ((Point)object).getY() + (double)n2);
                    continue block6;
                }
                break;
            }
            ((Point)object).translate(-((int)(point2D.getX() + 0.5)), -((int)(point2D.getY() + 0.5)));
            point.setLocation(this.transform((Point2D)object));
            Set<FlowNode> set = this.addSubLayout(viewLayout, point, true, true, null, null);
            this.getPickedState().startAdjusting();
            try {
                this.getPickedState().clearPickedVertices();
                this.getPickedState().pick((Collection<FlowNode>)set, true);
            }
            finally {
                this.getPickedState().endAdjusting();
            }
        }
        this.pasteScript(point);
    }

    private void pasteScript(Point point) {
        String string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            string = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (!"\n".equals(IOUtils.LINE_SEPARATOR)) {
                string = StringUtils.replace((String)string, (String)IOUtils.LINE_SEPARATOR, (String)"\n");
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get strings from clipboard", exception);
            return;
        }
        if (string.isEmpty()) {
            return;
        }
        FlowNode flowNode = new FlowNode(new FreeNodeModel(string));
        this.addNode(flowNode, point, false);
    }

    public void selectAll() {
        this.getPickedState().pick(this.getGraph().getVertices(), true);
    }

    public FlowNode addNode(FlowNode flowNode, Point2D point2D, boolean bl) {
        flowNode = this.convertNode(flowNode);
        this.getGraphLayout().initLocation((Vertex)flowNode);
        this.getGraph().addVertex((Vertex)flowNode);
        DefaultUndoableEdits.NewNodeEdit newNodeEdit = new DefaultUndoableEdits.NewNodeEdit();
        newNodeEdit.addEdit(this.undoableEditFactory.createAddNodeEdit(flowNode));
        boolean bl2 = point2D == null;
        FlowNode flowNode2 = null;
        if (bl) {
            flowNode2 = this.connectNode(flowNode, newNodeEdit, false);
            if (point2D == null && flowNode2 != null) {
                point2D = this.transform(this.getGraphLayout().getLocation((ArchetypeVertex)flowNode2));
                point2D.setLocation(point2D.getX() + 100.0, point2D.getY());
            }
        }
        if (point2D == null) {
            point2D = new Point(50, 50);
        }
        point2D = this.inverseTransform(point2D);
        if (this.isUseGrid()) {
            this.getGraphLayout().forceMoveOnGrid((Vertex)flowNode, point2D.getX(), point2D.getY());
        } else {
            this.getGraphLayout().forceMove((Vertex)flowNode, point2D.getX(), point2D.getY());
        }
        if (bl2) {
            while (this.intersects((Vertex)flowNode)) {
                point2D.setLocation(point2D.getX(), point2D.getY() + 80.0);
                this.getGraphLayout().forceMove((Vertex)flowNode, point2D.getX(), point2D.getY());
            }
        }
        this.repaint();
        newNodeEdit.end();
        this.fireUndoableEditUpdate(newNodeEdit);
        return flowNode;
    }

    public Set<FlowNode> addSubLayout(ViewLayout viewLayout, Point point) {
        return this.addSubLayout(viewLayout, point, false, true, null, null);
    }

    public Set<FlowNode> addSubLayout(ViewLayout viewLayout, Point point, boolean bl, boolean bl2, Map<FlowNode, FlowNode> map, Point point2) {
        Object object;
        Object object2;
        if (point == null) {
            int n = this.getSize().height / 2 - viewLayout.getSize().height / 2;
            point = new Point(0, n);
        }
        if (map == null) {
            map = new HashMap<FlowNode, FlowNode>();
        }
        FlowGraph flowGraph = viewLayout.getGraph();
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>(flowGraph.getVertices().size());
        for (Object object3 : flowGraph.getVertices()) {
            FlowNode flowNode = (FlowNode)object3;
            if (bl && !flowNode.getModel().isModifiable()) continue;
            object2 = bl2 ? flowNode.copy() : flowNode;
            object2 = this.convertNode((FlowNode)object2);
            this.getGraphLayout().initLocation((Vertex)object2);
            this.getGraph().addVertex((Vertex)object2);
            hashSet.add((FlowNode)object2);
            map.put(flowNode, (FlowNode)object2);
            if (point2 == null) {
                object = viewLayout.getOffsetLocation((Vertex)flowNode);
            } else {
                object = viewLayout.getLocation((Vertex)flowNode);
                object = new Point2D.Double((double)point2.x + ((Point2D)object).getX(), (double)point2.y + ((Point2D)object).getY());
            }
            Point2D point2D = new Point2D.Double(((Point2D)object).getX() + point.getX(), ((Point2D)object).getY() + point.getY());
            point2D = this.inverseTransform(point2D);
            this.getGraphLayout().forceMove((Vertex)object2, point2D.getX(), point2D.getY());
        }
        HashSet hashSet2 = new HashSet(flowGraph.getEdges().size());
        for (FlowNode flowNode : flowGraph.getEdges()) {
            object2 = (FlowEdge)((Object)flowNode);
            if (bl && (!((FlowEdge)((Object)object2)).getSource().getModel().isModifiable() || !((FlowEdge)((Object)object2)).getDest().getModel().isModifiable())) continue;
            if (bl2) {
                object = (FlowEdge)this.getGraph().addEdge((Edge)new FlowEdge((Vertex)map.get(((FlowEdge)((Object)object2)).getSource()), (Vertex)map.get(((FlowEdge)((Object)object2)).getDest())));
                hashSet2.add(object);
                continue;
            }
            hashSet2.add((FlowEdge)this.getGraph().addEdge((Edge)object2));
        }
        if (hashSet.size() > 0) {
            this.fireUndoableEditUpdate(this.undoableEditFactory.createAddSublayoutEdit(hashSet.toArray(new FlowNode[0]), hashSet2.toArray(new FlowEdge[0])));
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public ViewLayout getSubLayout(Collection<FlowNode> collection, Point point, int n) {
        void var13_20;
        Object object;
        Point2D point2D;
        FlowGraph flowGraph;
        if (collection.size() < 1) {
            return null;
        }
        boolean bl = n == 1 || n == 2;
        HashMap<FlowNode, Object> hashMap = new HashMap<FlowNode, Object>();
        if (bl) {
            Object object2;
            flowGraph = new FlowGraph();
            for (FlowNode object32 : collection) {
                object2 = n == 2 ? object32.fullCopy() : object32.copy();
                flowGraph.addVertex((Vertex)object2);
                hashMap.put(object32, object2);
            }
            for (Object e : this.getGraph().getEdges()) {
                object2 = (FlowEdge)((Object)e);
                if (!collection.containsAll(object2.getIncidentVertices())) continue;
                flowGraph.addEdge((Edge)new FlowEdge((Vertex)hashMap.get(((FlowEdge)((Object)object2)).getSource()), (Vertex)hashMap.get(((FlowEdge)((Object)object2)).getDest())));
            }
        } else {
            flowGraph = this.getGraph();
        }
        FlowLayout flowLayout = this.getGraphLayout();
        Rectangle rectangle = flowLayout.getVertexRect(collection);
        int n2 = flowLayout.getGridDistance();
        Point point2 = new Point(rectangle.x - rectangle.x % n2, rectangle.y - rectangle.y % n2);
        FlowLayout flowLayout2 = new FlowLayout(flowGraph);
        for (FlowNode flowNode : collection) {
            point2D = flowLayout.getLocation((ArchetypeVertex)flowNode);
            if (point2D == null) continue;
            FlowNode flowNode2 = bl ? (Vertex)hashMap.get(flowNode) : flowNode;
            flowLayout2.addVertex((Vertex)flowNode2, point2D.getX() - point2.getX(), point2D.getY() - point2.getY());
        }
        if (point != null) {
            rectangle.grow(point.x, point.y);
            object = new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight());
            Point point3 = new Point(point.x, point.y);
        } else {
            object = this.getSize();
            point2D = this.inverseTransform(new Point2D.Float(0.0f, 0.0f));
            Point point4 = new Point(point2.x - (int)point2D.getX(), point2.y - (int)point2D.getY());
        }
        return new ViewLayout(flowLayout2, (Dimension)object, (Point)var13_20);
    }

    private FlowNode convertNode(FlowNode flowNode) {
        if (flowNode.getModel() instanceof UINodeModel) {
            Operation operation = ((UINodeModel)flowNode.getModel()).getModel();
            if (operation instanceof RScript) {
                try {
                    FreeNodeModel freeNodeModel = new FreeNodeModel(operation.getRScript(false, false, PreviewOption.OFF));
                    flowNode = new FlowNode(freeNodeModel);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Internal Error", exception);
                }
            } else {
                operation.configureForFlow();
            }
        }
        return flowNode;
    }

    private void connectNode(FlowNode flowNode) {
        NamedCompoundEdit namedCompoundEdit = new NamedCompoundEdit(Messages.getString("Action.new_edge"));
        this.connectNode(flowNode, namedCompoundEdit, true);
        namedCompoundEdit.end();
        this.fireUndoableEditUpdate(namedCompoundEdit);
    }

    private FlowNode connectNode(FlowNode flowNode, CompoundEdit compoundEdit, boolean bl) {
        FlowNode flowNode2;
        SubflowState subflowState = this.getPickedState();
        if (subflowState.getPickedVertices().size() == 1 && !subflowState.isPicked((Vertex)flowNode) && flowNode.getModel().isConnectable() && (flowNode2 = subflowState.getPickedVertices().iterator().next()).getModel().isConnectable()) {
            this.connectNode(flowNode2, flowNode, compoundEdit, bl);
            subflowState.setPicked((ArchetypeVertex)flowNode);
            return flowNode2;
        }
        subflowState.setPicked((ArchetypeVertex)flowNode);
        return null;
    }

    private void connectNode(FlowNode flowNode, FlowNode flowNode2) {
        NamedCompoundEdit namedCompoundEdit = new NamedCompoundEdit(Messages.getString("Action.new_edge"));
        this.connectNode(flowNode, flowNode2, namedCompoundEdit, true);
        namedCompoundEdit.end();
        this.fireUndoableEditUpdate(namedCompoundEdit);
    }

    private void connectNode(FlowNode flowNode, FlowNode flowNode2, CompoundEdit compoundEdit, boolean bl) {
        if (flowNode2.getPredecessors().contains(flowNode)) {
            return;
        }
        FlowEdge flowEdge = new FlowEdge((Vertex)flowNode, (Vertex)flowNode2);
        if (this.makeEdgeAddable(flowEdge, compoundEdit)) {
            this.getGraph().addEdge((Edge)flowEdge);
            this.repaint();
            compoundEdit.addEdit(this.undoableEditFactory.createAddEdgeEdit(new FlowEdge[]{flowEdge}));
        } else if (bl) {
            UIUtility.showWarningDialog((Component)((Object)this), Messages.getString("Error.unable_to_add"));
        }
    }

    private boolean makeEdgeAddable(FlowEdge flowEdge, CompoundEdit compoundEdit) {
        Object object;
        FlowNode flowNode = flowEdge.getSource();
        if (flowNode.getModel() == TunnelNodeModel.outModel || !flowNode.getModel().isConnectable()) {
            return false;
        }
        FlowNode flowNode2 = flowEdge.getDest();
        if (flowNode2.getModel() == TunnelNodeModel.inModel || !flowNode2.getModel().isConnectable()) {
            return false;
        }
        if (flowNode.getGraph() == null || flowNode2.getGraph() == null) {
            return false;
        }
        boolean bl = FlowUtil.checkLoop(flowNode, flowNode2);
        if (!bl && flowNode2.getSuccessors().contains(flowNode)) {
            object = (FlowEdge)flowNode2.findEdge((Vertex)flowNode);
            if (object == null) {
                return false;
            }
            flowNode2.getGraph().removeEdge((Edge)object);
            compoundEdit.addEdit(this.undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{object}));
        } else if (!bl) {
            return false;
        }
        if (flowNode2.inDegree() > 0) {
            object = flowNode2.getGraph();
            HashSet<FlowEdge> hashSet = new HashSet<FlowEdge>();
            for (Object e : flowNode2.getInEdges()) {
                FlowEdge flowEdge2 = (FlowEdge)((Object)e);
                object.removeEdge((Edge)flowEdge2);
                hashSet.add(flowEdge2);
            }
            compoundEdit.addEdit(this.undoableEditFactory.createDeleteEdit(null, hashSet.toArray(new FlowEdge[0])));
        }
        return true;
    }

    private boolean intersects(Vertex vertex) {
        Point2D point2D = this.layoutTransform(this.getGraphLayout().getLocation((ArchetypeVertex)vertex));
        if (point2D == null) {
            return false;
        }
        Shape shape = this.getRenderer().getVertexShapeFunction().getShape(vertex);
        shape = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(shape);
        Rectangle rectangle = shape.getBounds();
        for (Object e : this.getGraph().getVertices()) {
            Rectangle rectangle2;
            Vertex vertex2 = (Vertex)e;
            if (vertex.equals((Object)vertex2)) continue;
            Shape shape2 = this.getRenderer().getVertexShapeFunction().getShape(vertex2);
            Point2D point2D2 = this.layoutTransform(this.getGraphLayout().getLocation((ArchetypeVertex)vertex2));
            if (point2D2 == null || !rectangle.intersects(rectangle2 = (shape2 = AffineTransform.getTranslateInstance(point2D2.getX(), point2D2.getY()).createTransformedShape(shape2)).getBounds())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importScript(Point point) {
        Object object;
        String string = null;
        FileFilter[] fileFilterArray = new FileFilter[]{FileFilterFactory.createRFileFilter()};
        File file = UIUtility.chooseOpenFile(Messages.getString("Message.open"), WorkingDirectory.getWorkingDirectory(), fileFilterArray, (Component)((Object)this));
        if (file != null) {
            try {
                object = FileUtils.lineIterator((File)file, (String)Charset.defaultCharset().name());
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    while (object.hasNext()) {
                        String string2 = object.nextLine();
                        stringBuilder.append(string2);
                        stringBuilder.append("\n");
                    }
                    string = stringBuilder.toString();
                }
                finally {
                    object.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string == null || string.isEmpty()) {
            return;
        }
        object = new FlowNode(new FreeNodeModel(string));
        this.addNode((FlowNode)object, point, false);
    }

    private void checkSyntaxError() {
        Deque<Vertex> deque = this.getGraph().getVertexList();
        while (!deque.isEmpty()) {
            FlowNode flowNode = (FlowNode)deque.poll();
            this.flowModel.getState().checkRSyntax(flowNode);
            this.flowModel.getState().checkValueError(flowNode);
            if (!flowNode.getModel().isSubflow()) continue;
            SubflowNodeModel subflowNodeModel = (SubflowNodeModel)flowNode.getModel();
            for (FlowGraph flowGraph : subflowNodeModel.getGraphs()) {
                deque.addAll(flowGraph.getVertexList());
            }
        }
        this.repaint();
    }

    public void editComment(final FlowNode flowNode) {
        final NodeComment nodeComment = flowNode.getComment();
        Point2D point2D = this.getGraphLayout().getLocation((ArchetypeVertex)flowNode);
        if (point2D == null) {
            return;
        }
        point2D = this.layoutTransform(point2D);
        final NodeComment nodeComment2 = flowNode.getComment().copy();
        nodeComment.createComment();
        nodeComment.edit((JComponent)((Object)this), point2D);
        nodeComment.setEditing(true);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                nodeComment.setEditing(false);
                NodeComment nodeComment3 = flowNode.getComment();
                if (!nodeComment2.equals(nodeComment3)) {
                    FlowViewer.this.fireUndoableEditUpdate(FlowViewer.this.undoableEditFactory.createNodeCommentChangeEdit(flowNode, nodeComment2));
                    FlowNode.fireNodeCommentChanged(flowNode, nodeComment2, flowNode.getComment());
                }
                if (StringUtils.isBlank((CharSequence)nodeComment3.getText())) {
                    nodeComment3.removeComment();
                }
                focusEvent.getComponent().removeFocusListener(this);
            }
        };
        nodeComment.getCommentComponent().addFocusListener(focusAdapter);
    }

    public void setCommentState(FlowNode flowNode, String string) {
        NodeComment nodeComment = flowNode.getComment();
        if (!nodeComment.getState().equals(string)) {
            NodeComment nodeComment2 = flowNode.getComment().copy();
            nodeComment.setState(string);
            this.fireUndoableEditUpdate(this.undoableEditFactory.createNodeCommentChangeEdit(flowNode, nodeComment2));
            FlowNode.fireNodeCommentChanged(flowNode, nodeComment2, flowNode.getComment());
        }
    }

    public void setTransparentConnection(FlowNode flowNode, List<FlowNode> list) {
        this.transparentGraph.clear();
        if (flowNode == null || list == null) {
            this.getPickedState().clearConnectTargetNode();
            return;
        }
        this.getPickedState().setConnectTargetNode(flowNode);
        this.transparentGraph.addNodes(list);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            FlowNode flowNode2 = list.get(i);
            if (i == 0) {
                this.transparentGraph.addEdge(new DummyEdge((Vertex)flowNode, (Vertex)flowNode2));
                object = this.getGraphLayout().getLocation((ArchetypeVertex)flowNode);
                this.transparentGraph.setLocation(flowNode2, new Point((int)((Point2D)object).getX() + 80, (int)((Point2D)object).getY()));
                continue;
            }
            object = list.get(i - 1);
            this.transparentGraph.addEdge(new DummyEdge((Vertex)object, (Vertex)flowNode2));
            Point2D point2D = this.getGraphLayout().getLocation((ArchetypeVertex)object);
            this.transparentGraph.setLocation(flowNode2, new Point((int)point2D.getX() + 80, (int)point2D.getY()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropOnConnection(FlowNode flowNode, Point2D point2D) {
        SubflowState subflowState = this.getPickedState();
        if (subflowState.getConnectTargetNode() == null) {
            return;
        }
        subflowState.setPicked((ArchetypeVertex)subflowState.getConnectTargetNode());
        Point2D point2D2 = this.getGraphLayout().getLocation((ArchetypeVertex)subflowState.getConnectTargetNode());
        this.getUndoableEditSupport().beginUpdate(new NamedCompoundEdit(Messages.getString("Action.move_node")));
        try {
            this.getGraphLayout().forceMove((Vertex)flowNode, point2D2.getX() + 80.0, point2D2.getY());
            HashMap<Vertex, Point2D> hashMap = new HashMap<Vertex, Point2D>(1);
            hashMap.put((Vertex)flowNode, point2D);
            this.fireUndoableEditUpdate(this.undoableEditFactory.createMoveNodeEdit(hashMap));
            this.connectNode(flowNode);
            subflowState.setPicked((ArchetypeVertex)flowNode);
        }
        finally {
            this.getUndoableEditSupport().endUpdate();
        }
        this.getPickedState().clearConnectTargetNode();
        this.transparentGraph.clear();
        this.repaint();
    }

    public ViewLayout getViewLayout() {
        return this.getViewLayout(0);
    }

    public ViewLayout getViewLayout(int n) {
        if (0 == n) {
            return this.model;
        }
        if (this.getGraph().getVertices().size() == 0) {
            return new ViewLayout(new FlowLayout(new FlowGraph()), this.getSize(), new Point());
        }
        return this.getSubLayout(this.getGraph().getVertices(), null, n);
    }

    public Rectangle getPaintedArea() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        if (this.getGraph().getVertices().size() > 0) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            for (Object e : this.getGraph().getVertices()) {
                Rectangle rectangle;
                FlowNode flowNode = (FlowNode)e;
                Point2D point2D = this.getGraphLayout().getLocation((ArchetypeVertex)flowNode);
                int n5 = (int)point2D.getX();
                int n6 = (int)point2D.getY();
                arrayList.clear();
                Rectangle rectangle2 = this.getRenderer().getNodeRendering().getGlassShape((Vertex)flowNode).getBounds();
                rectangle2.translate(n5, n6);
                arrayList.add(rectangle2);
                NodeComment nodeComment = flowNode.getComment();
                if (nodeComment.exists() && nodeComment.isCommentOpened()) {
                    arrayList.add(nodeComment.getCommentRect(n5, n6));
                }
                if ((rectangle = this.getRenderer().getLabelRect((Vertex)flowNode, n5, n6)) != null) {
                    arrayList.add(rectangle);
                }
                for (Rectangle rectangle3 : arrayList) {
                    if (rectangle3.x < n) {
                        n = rectangle3.x;
                    }
                    if (rectangle3.y < n2) {
                        n2 = rectangle3.y;
                    }
                    if (rectangle3.x + rectangle3.width > n3) {
                        n3 = rectangle3.x + rectangle3.width;
                    }
                    if (rectangle3.y + rectangle3.height <= n4) continue;
                    n4 = rectangle3.y + rectangle3.height;
                }
            }
            return new Rectangle(n, n2, n3 - n, n4 - n2);
        }
        return new Rectangle();
    }

    public void paintToGraphics(Graphics2D graphics2D) {
        this.renderGraph(graphics2D);
    }

    protected void renderGraph(Graphics2D graphics2D) {
        Object object;
        Point2D point2D;
        Point2D point2D2;
        Vertex vertex;
        Object object2;
        if (!this.repaintEnabled) {
            return;
        }
        FlowLayout flowLayout = this.getGraphLayout();
        graphics2D.setRenderingHints(this.renderingHints);
        Dimension dimension = this.getSize();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.viewTransformer.getTransform());
        graphics2D.setTransform(affineTransform2);
        for (VisualizationViewer.Paintable object32 : this.preRenderers) {
            if (object32.useTransform()) {
                object32.paint((Graphics)graphics2D);
                continue;
            }
            graphics2D.setTransform(affineTransform);
            object32.paint((Graphics)graphics2D);
            graphics2D.setTransform(affineTransform2);
        }
        this.locationMap.clear();
        this.getRenderer().clearArrowOnlyEdges();
        try {
            for (Edge edge : flowLayout.getGraph().getEdges()) {
                object2 = (Vertex)edge.getEndpoints().getFirst();
                vertex = (Vertex)edge.getEndpoints().getSecond();
                point2D2 = this.getLocation((Vertex)object2);
                point2D = this.getLocation(vertex);
                if (point2D2 == null || point2D == null) continue;
                this.renderer.paintEdge((Graphics)graphics2D, edge, (int)point2D2.getX(), (int)point2D2.getY(), (int)point2D.getX(), (int)point2D.getY());
            }
            graphics2D.setComposite(SRCOVER_05);
            for (DummyEdge dummyEdge : this.transparentGraph.getEdges()) {
                Point2D point2D3;
                object2 = dummyEdge.getSource();
                vertex = dummyEdge.getDest();
                point2D2 = this.transparentGraph.getLocation((FlowNode)object2);
                point2D = this.transparentGraph.getLocation((FlowNode)vertex);
                Point2D point2D4 = point2D2 == null ? this.getLocation((Vertex)object2) : this.transform(point2D2);
                Point2D point2D5 = point2D3 = point2D == null ? this.getLocation(vertex) : this.transform(point2D);
                if (point2D4 == null || point2D3 == null) continue;
                this.renderer.paintEdge((Graphics)graphics2D, (Edge)dummyEdge, (int)point2D4.getX(), (int)point2D4.getY(), (int)point2D3.getX(), (int)point2D3.getY());
            }
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.repaint();
        }
        if (this.edgeConnectionHandler.getSrcNode() != null && !this.edgeConnectionHandler.isLoop()) {
            if (this.edgeConnectionHandler.getDestNode() != null) {
                object = new FlowEdge((Vertex)this.edgeConnectionHandler.getSrcNode(), (Vertex)this.edgeConnectionHandler.getDestNode());
                this.flowModel.getState().setCreatingEdge((FlowEdge)((Object)object));
                Point2D point2D6 = this.getLocation((Vertex)this.edgeConnectionHandler.getSrcNode());
                object2 = this.getLocation((Vertex)this.edgeConnectionHandler.getDestNode());
                if (point2D6 != null && object2 != null) {
                    this.renderer.paintEdge((Graphics)graphics2D, (Edge)object, (int)point2D6.getX(), (int)point2D6.getY(), (int)((Point2D)object2).getX(), (int)((Point2D)object2).getY());
                }
            } else {
                object = this.getLocation((Vertex)this.edgeConnectionHandler.getSrcNode());
                Point point = this.getMousePosition();
                if (object != null && point != null) {
                    ((FlowRenderer)this.renderer).drawEdge(graphics2D, this.edgeConnectionHandler.getSrcNode(), (int)((Point2D)object).getX(), (int)((Point2D)object).getY(), point.x, point.y);
                }
            }
        }
        try {
            object = flowLayout.getGraph().getVertexIterator();
            while (object.hasNext()) {
                Vertex vertex2 = (Vertex)object.next();
                object2 = this.getLocation(vertex2);
                if (object2 == null) continue;
                this.getRenderer().paintVertexSpaces(graphics2D, vertex2, (int)((Point2D)object2).getX(), (int)((Point2D)object2).getY());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.repaint();
        }
        try {
            object = flowLayout.getGraph().getVertexIterator();
            while (object.hasNext()) {
                Vertex vertex3 = (Vertex)object.next();
                object2 = this.getLocation(vertex3);
                if (object2 == null) continue;
                this.renderer.paintVertex((Graphics)graphics2D, vertex3, (int)((Point2D)object2).getX(), (int)((Point2D)object2).getY());
            }
            graphics2D.setComposite(SRCOVER_05);
            for (FlowNode flowNode : this.transparentGraph.getNodes()) {
                object2 = this.transform(this.transparentGraph.getLocation(flowNode));
                if (object2 == null) continue;
                this.renderer.paintVertex((Graphics)graphics2D, (Vertex)flowNode, (int)((Point2D)object2).getX(), (int)((Point2D)object2).getY());
            }
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.repaint();
        }
        try {
            for (Edge edge : this.getRenderer().getArrowOnlyEdges()) {
                object2 = (Vertex)edge.getEndpoints().getFirst();
                vertex = (Vertex)edge.getEndpoints().getSecond();
                point2D2 = this.getLocation((Vertex)object2);
                point2D = this.getLocation(vertex);
                if (point2D2 == null || point2D == null) continue;
                this.getRenderer().paintArrowOnlyEdge(graphics2D, edge, (int)point2D2.getX(), (int)point2D2.getY(), (int)point2D.getX(), (int)point2D.getY());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.repaint();
        }
        try {
            object = flowLayout.getGraph().getVertexIterator();
            while (object.hasNext()) {
                Vertex vertex4 = (Vertex)object.next();
                object2 = this.getLocation(vertex4);
                if (object2 == null) continue;
                this.getRenderer().paintPostRenderings(graphics2D, (FlowNode)vertex4, (int)((Point2D)object2).getX(), (int)((Point2D)object2).getY());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.repaint();
        }
        try {
            object = flowLayout.getGraph().getVertexIterator();
            while (object.hasNext()) {
                Vertex vertex5 = (Vertex)object.next();
                object2 = this.getLocation(vertex5);
                if (object2 == null) continue;
                this.getRenderer().paintPostRenderings2(graphics2D, (FlowNode)vertex5, (int)((Point2D)object2).getX(), (int)((Point2D)object2).getY());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.repaint();
        }
        for (VisualizationViewer.Paintable paintable : this.postRenderers) {
            if (paintable.useTransform()) {
                paintable.paint((Graphics)graphics2D);
                continue;
            }
            graphics2D.setTransform(affineTransform);
            paintable.paint((Graphics)graphics2D);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.setTransform(affineTransform);
    }

    private Point2D getLocation(Vertex vertex) {
        Point2D point2D = (Point2D)this.locationMap.get(vertex);
        if (point2D == null) {
            point2D = this.getGraphLayout().getLocation((ArchetypeVertex)vertex);
            point2D = this.layoutTransformer.transform(point2D);
            this.locationMap.put(vertex, point2D);
        }
        return point2D;
    }

    public void addFlowViewerEventHandler(FlowViewerEventHandler flowViewerEventHandler) {
        this.flowViewerEventSupport.addEventHandler(flowViewerEventHandler);
    }

    public void removeFlowViewerEventHandler(FlowViewerEventHandler flowViewerEventHandler) {
        this.flowViewerEventSupport.removeEventHandler(flowViewerEventHandler);
    }

    @Override
    public Action getAction(String string) {
        switch (string) {
            case "MENU_ACTION_UNDO": {
                return this.viewerActions.get("UNDO");
            }
            case "MENU_ACTION_REDO": {
                return this.viewerActions.get("REDO");
            }
            case "MENU_ACTION_COPY": {
                return this.viewerActions.get("COPY");
            }
            case "MENU_ACTION_CUT": {
                return this.viewerActions.get("CUT");
            }
            case "MENU_ACTION_PASTE": {
                return this.viewerActions.get("PASTE");
            }
        }
        return null;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.clearFirstGuide();
        this.viewerActions.updateUndoState();
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        if (fileEditEvent.isDirtyChanged()) {
            this.repaint();
        }
    }

    @Override
    public void flowStateChanged(FlowStateEvent flowStateEvent) {
        this.repaint();
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(HighlightChangedEvent.class)) {
            this.repaint();
        }
    }

    @Override
    public void rPackageListChanged(RPackageListChangeEvent rPackageListChangeEvent) {
        this.getFlowModel().refreshRPackageStates();
        this.repaint();
    }

    private class GraphEventHandler
    implements GraphEventListener,
    FlowGraphEventHandler {
        private GraphEventHandler() {
        }

        public void edgeAdded(GraphEvent graphEvent) {
            this.update();
            for (GraphEventListener graphEventListener : graphEventListers) {
                graphEventListener.edgeAdded(graphEvent);
            }
            this.fireSubflowNodeChanged((FlowEdge)graphEvent.getGraphElement());
        }

        public void edgeRemoved(GraphEvent graphEvent) {
            this.update();
            for (GraphEventListener graphEventListener : graphEventListers) {
                graphEventListener.edgeRemoved(graphEvent);
            }
            this.fireSubflowNodeChanged((FlowEdge)graphEvent.getGraphElement());
        }

        public void vertexAdded(GraphEvent graphEvent) {
            Object object;
            FileEditSupplier fileEditSupplier2;
            this.update();
            FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
            if (!flowGraph.isAdjusting() && (fileEditSupplier2 = ((FlowNode)(object = (FlowNode)graphEvent.getGraphElement())).getFileEditSupplier()) != null) {
                fileEditSupplier2.addFileEditEventHandler(FlowViewer.this);
            }
            for (GraphEventListener graphEventListener : graphEventListers) {
                graphEventListener.vertexAdded(graphEvent);
            }
        }

        public void vertexRemoved(GraphEvent graphEvent) {
            Object object;
            FileEditSupplier fileEditSupplier2;
            this.update();
            FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
            if (!flowGraph.isAdjusting() && (fileEditSupplier2 = ((FlowNode)(object = (FlowNode)graphEvent.getGraphElement())).getFileEditSupplier()) != null) {
                fileEditSupplier2.removeFileEditEventHandler(FlowViewer.this);
            }
            for (GraphEventListener graphEventListener : graphEventListers) {
                graphEventListener.vertexRemoved(graphEvent);
            }
        }

        private void fireSubflowNodeChanged(FlowEdge flowEdge) {
            FlowNode flowNode = flowEdge.getSource();
            if (flowNode.getGraph() != null && !flowNode.getGraph().isRootGraph()) {
                FlowNode.fireSubflowNodeModelChanged(flowNode.getParentNode());
            }
        }

        private void update() {
            FlowViewer.this.getFlowModel().setDirty(true);
            FlowViewer.this.repaint();
        }

        @Override
        public void nodeWillBeRemoved(FlowGraphEvent flowGraphEvent) {
            for (FlowGraphEventHandler flowGraphEventHandler : flowGraphEventListers) {
                flowGraphEventHandler.nodeWillBeRemoved(flowGraphEvent);
            }
        }
    }

    private class EdgeConnectionHandler
    extends MouseAdapter {
        private FlowNode srcNode;
        private FlowNode destNode;
        private boolean edgeMode;

        private EdgeConnectionHandler() {
        }

        public FlowNode getSrcNode() {
            return this.srcNode;
        }

        public FlowNode getDestNode() {
            return this.destNode;
        }

        public boolean isLoop() {
            return this.srcNode != null && this.srcNode == this.destNode;
        }

        public void startEdgeConnection(FlowNode flowNode) {
            if (flowNode != null && flowNode.getModel().isConnectable()) {
                this.srcNode = flowNode;
                this.destNode = null;
                this.edgeMode = true;
            }
        }

        private void updateDest(MouseEvent mouseEvent) {
            FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
            Point2D point2D = flowViewer.inverseViewTransform(mouseEvent.getPoint());
            FlowNode flowNode = (FlowNode)flowViewer.getPickSupport().getVertex(point2D.getX(), point2D.getY());
            this.destNode = flowNode != null && flowNode.getModel().isConnectable() ? flowNode : null;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FlowNode flowNode = null;
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
                Point2D point2D = flowViewer.inverseViewTransform(mouseEvent.getPoint());
                flowNode = (FlowNode)flowViewer.getPickSupport().getVertex(point2D.getX(), point2D.getY());
                if (flowNode != null && flowNode.getModel().isConnectable()) {
                    this.srcNode = flowNode;
                    this.destNode = flowNode;
                    mouseEvent.consume();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.srcNode != null) {
                this.updateDest(mouseEvent);
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.srcNode != null) {
                if (this.destNode != null && !this.isLoop() && this.srcNode.getGraph() != null && this.destNode.getGraph() != null) {
                    new CreateEdge().doAction(this.edgeMode ? "EdgeMode" : "RightDrag");
                    FlowViewer.this.connectNode(this.srcNode, this.destNode);
                    FlowViewer.this.getPickedState().setPicked((ArchetypeVertex)this.destNode);
                }
                if (!this.isLoop()) {
                    mouseEvent.consume();
                }
            }
            this.srcNode = null;
            this.destNode = null;
            this.edgeMode = false;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.edgeMode) {
                this.updateDest(mouseEvent);
                FlowViewer.this.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.edgeMode) {
                FlowViewer.this.repaint();
            }
        }

        private class CreateEdge
        extends LoggableAction {
            private CreateEdge() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
            }
        }
    }

    static class TransparentGraph {
        private List<FlowNode> nodes = new ArrayList<FlowNode>();
        private List<DummyEdge> edges = new ArrayList<DummyEdge>();
        private Map<FlowNode, Point> location = new HashMap<FlowNode, Point>(2);

        TransparentGraph() {
        }

        public void clear() {
            this.nodes.clear();
            this.edges.clear();
            this.location.clear();
        }

        public void addNode(FlowNode flowNode) {
            this.nodes.add(flowNode);
        }

        public void addNodes(Collection<FlowNode> collection) {
            this.nodes.addAll(collection);
        }

        public void addEdge(DummyEdge dummyEdge) {
            this.edges.add(dummyEdge);
        }

        public void setLocation(FlowNode flowNode, Point point) {
            this.location.put(flowNode, point);
        }

        public List<FlowNode> getNodes() {
            return this.nodes;
        }

        public List<DummyEdge> getEdges() {
            return this.edges;
        }

        public Point getLocation(FlowNode flowNode) {
            return this.location.get(flowNode);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private final OnNodeActions onNodeActionManager = new OnNodeActions();
        private final OnCommentActions onCommentActions = new OnCommentActions();
        private final OnBreakpointActions onBreakpointActions = new OnBreakpointActions();

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
            Point2D point2D = flowViewer.inverseViewTransform(mouseEvent.getPoint());
            FlowNode flowNode = (FlowNode)flowViewer.getPickSupport().getVertex(point2D.getX(), point2D.getY());
            if (flowNode != null) {
                Point2D point2D2 = flowViewer.layoutTransform(flowViewer.getGraphLayout().getLocation((ArchetypeVertex)flowNode));
                Point point = new Point((int)(point2D.getX() - point2D2.getX()), (int)(point2D.getY() - point2D2.getY()));
                flowNode.getModel().mouseClicked(flowViewer, flowNode, point);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                FlowViewer.this.lastClickedPoint = mouseEvent.getPoint();
                FlowViewer.this.viewerActions.setPoint(mouseEvent.getPoint());
                FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
                Point2D point2D = flowViewer.inverseViewTransform(mouseEvent.getPoint());
                FlowNode flowNode = flowViewer.getPickSupport().getComment(point2D.getX(), point2D.getY());
                if (flowNode != null) {
                    flowViewer.getPickedState().setPicked((ArchetypeVertex)flowNode);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            FlowNode flowNode;
            FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
            Point2D point2D = flowViewer.inverseViewTransform(mouseEvent.getPoint());
            FlowNode flowNode2 = flowViewer.getPickSupport().getBreakpointIcon(point2D.getX(), point2D.getY());
            if (flowNode2 != null) {
                if (UIUtility.isRightMouseButton(mouseEvent)) {
                    this.onBreakpointActions.showPopup(flowViewer, flowNode2, (int)point2D.getX(), (int)point2D.getY());
                    return;
                }
                if (UIUtility.isLeftMouseButton(mouseEvent)) {
                    flowNode2.setBreakpointState(flowNode2.isFirstBreakpointEnabled() ? 1 : 2);
                    return;
                }
            }
            if ((flowNode = flowViewer.getPickSupport().getCommentIcon(point2D.getX(), point2D.getY())) != null && UIUtility.isRightMouseButton(mouseEvent)) {
                NodeComment nodeComment = flowNode.getComment();
                this.onCommentActions.showPopup(flowViewer, flowNode, nodeComment, (int)point2D.getX(), (int)point2D.getY());
                return;
            }
            FlowNode flowNode3 = flowViewer.getPickSupport().getComment(point2D.getX(), point2D.getY());
            if (flowNode3 != null) {
                NodeComment nodeComment = flowNode3.getComment();
                Point2D point2D2 = FlowViewer.this.getGraphLayout().getLocation((ArchetypeVertex)flowNode3);
                if (point2D2 == null) {
                    return;
                }
                point2D2 = flowViewer.layoutTransform(point2D2);
                if (UIUtility.isMiddleMouseButton(mouseEvent)) {
                    flowViewer.setCommentState(flowNode3, "closed");
                } else if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    FlowViewer.this.editComment(flowNode3);
                } else if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    Rectangle rectangle = nodeComment.getCloseButtonRect((int)point2D2.getX(), (int)point2D2.getY());
                    if (rectangle.contains(point2D)) {
                        flowViewer.setCommentState(flowNode3, "closed");
                    }
                } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                    this.onCommentActions.showPopup(flowViewer, flowNode3, nodeComment, (int)point2D.getX(), (int)point2D.getY());
                }
                return;
            }
            FlowNode flowNode4 = (FlowNode)flowViewer.getPickSupport().getVertex(point2D.getX(), point2D.getY());
            Edge edge = flowViewer.getPickSupport().getEdge(point2D.getX(), point2D.getY());
            if (flowNode4 != null) {
                this.onNodeActionManager.setState(flowViewer, flowNode4);
                if (UIUtility.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.getModifiers() == 17) {
                        flowViewer.getPickedState().selectInterval(flowNode4);
                    } else if (mouseEvent.getClickCount() == 2) {
                        boolean bl = (mouseEvent.getModifiers() & UIUtility.MENU_KEY_MASK) == UIUtility.MENU_KEY_MASK;
                        FlowViewer.this.openNode(flowNode4, false, bl);
                    } else if (mouseEvent.getModifiers() == 24) {
                        LoggableAction loggableAction = (LoggableAction)this.onNodeActionManager.get("CREATE_EDGE");
                        loggableAction.doAction("Alt+LeftClick");
                    }
                } else if (UIUtility.isMiddleMouseButton(mouseEvent)) {
                    LoggableAction loggableAction = (LoggableAction)this.onNodeActionManager.get("CREATE_EDGE");
                    loggableAction.doAction("MiddleClick");
                } else if (UIUtility.isRightMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
                    if (!FlowViewer.this.getPickedState().isPicked((Vertex)flowNode4)) {
                        FlowViewer.this.getPickedState().setPicked((ArchetypeVertex)flowNode4);
                    }
                    this.onNodeActionManager.showPopup((Component)((Object)flowViewer), flowViewer, flowNode4, (int)point2D.getX(), (int)point2D.getY());
                }
            } else if (edge != null) {
                if (UIUtility.isRightMouseButton(mouseEvent)) {
                    FlowViewer.this.getPickedState().setPicked((ArchetypeEdge)edge);
                    JMenuItem jMenuItem = new JMenuItem(new RemoveEdge(flowViewer));
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show((Component)((Object)flowViewer), (int)point2D.getX(), (int)point2D.getY());
                }
            } else if (UIUtility.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 2) {
                    FlowViewer.this.viewerActions.setPoint(mouseEvent.getPoint());
                    LoggableAction loggableAction = (LoggableAction)FlowViewer.this.viewerActions.get("CREATE_SCRIPT_NODE");
                    loggableAction.doAction("DoubleClick");
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
                LoggableAction loggableAction = (LoggableAction)FlowViewer.this.viewerActions.get("CREATE_SCRIPT_NODE");
                loggableAction.putValue("logparameter", "ContextMenu");
                FlowViewer.this.viewerActions.showOnGroundPopup(mouseEvent.getPoint());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Object object;
            FlowViewer flowViewer = (FlowViewer)mouseEvent.getSource();
            Point2D point2D = flowViewer.inverseViewTransform(mouseEvent.getPoint());
            FlowPickSupport flowPickSupport = flowViewer.getPickSupport();
            FlowState flowState = FlowViewer.this.flowModel.getState();
            FlowNode flowNode = flowPickSupport.getCommentIcon(point2D.getX(), point2D.getY());
            flowState.setPoppedComment(flowNode);
            if (flowNode != null) {
                if (flowState.getPopup() == null) {
                    object = FlowViewer.this.getLocation((Vertex)flowNode);
                    int n = (int)((Point2D)object).getX();
                    int n2 = (int)((Point2D)object).getY();
                    NodeComment nodeComment = flowNode.getComment();
                    CommentPopup commentPopup = new CommentPopup(flowNode, nodeComment);
                    Rectangle rectangle = nodeComment.getCommentRect(n, n2);
                    Point point = new Point();
                    SwingUtilities.convertPointToScreen(point, (Component)((Object)flowViewer));
                    Popup popup = PopupFactory.getSharedInstance().getPopup((Component)((Object)flowViewer), commentPopup, rectangle.x + point.x, rectangle.y + point.y);
                    flowState.setPopup(popup);
                }
            } else {
                flowState.setPopup(null);
            }
            object = flowPickSupport.getComment(point2D.getX(), point2D.getY());
            flowState.setRollOverCommentNode((FlowNode)object);
            FlowNode flowNode2 = (FlowNode)flowPickSupport.getVertex(point2D.getX(), point2D.getY());
            flowState.setRollOverNode(flowNode2);
        }

        private class RemoveEdge
        extends LoggableAction {
            private FlowViewer viewer;

            public RemoveEdge(FlowViewer flowViewer) {
                super(Messages.getString("Action.remove_edge"));
                this.viewer = flowViewer;
            }

            @Override
            public void action(ActionEvent actionEvent) {
                this.viewer.getPickedState().clearPickedVertices();
                this.viewer.delete();
            }
        }

        private class CommentPopup
        extends JPanel
        implements MouseListener {
            private CellRendererPane cellRendererPane = new CellRendererPane();
            private FlowNode node;
            private NodeComment comment;

            public CommentPopup(FlowNode flowNode, NodeComment nodeComment) {
                this.node = flowNode;
                this.comment = nodeComment;
                this.setPreferredSize(nodeComment.getCommentComponent().getPreferredSize());
                this.addMouseListener(this);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                JTextComponent jTextComponent = this.comment.getCommentComponent();
                Dimension dimension = jTextComponent.getPreferredSize();
                this.cellRendererPane.paintComponent(graphics, jTextComponent, this, 0, 0, dimension.width, dimension.height, true);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FlowViewer.this.flowModel.getState().setPopup(null);
                FlowViewer.this.flowModel.getState().setPoppedComment(null);
                FlowViewer.this.flowModel.getState().setRollOverCommentNode(this.node);
                FlowViewer.this.setCommentState(this.node, "opened");
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        }
    }

    private static class ToolTipHandler
    implements ToolTipFunction {
        private FlowState state;

        ToolTipHandler(FlowState flowState) {
            this.state = flowState;
        }

        public String getToolTipText(Vertex vertex) {
            FlowNode flowNode = (FlowNode)vertex;
            String string = this.state.getErrorMessageHtml(flowNode);
            if (string == null && flowNode.getModel().getNodeMode() == NodeModel.NodeMode.UPDATE) {
                return UIUtility.convertToHTML(Messages.getString("Message.node_update"));
            }
            if (string == null && flowNode.getModel().getErrorLevel().isHigherThan(ErrorLevel.NONE)) {
                List<FlowError> list = flowNode.getModel().getErrors();
                return FlowError.errorsToHtml(list);
            }
            return string;
        }

        public String getToolTipText(Edge edge) {
            return null;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return null;
        }
    }

    private class DropTargetHandler
    extends DropTargetAdapter {
        private RollOverHandler rollOverHandler = new RollOverHandler();

        private DropTargetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (FlowNodeFlavor.isFlowNodeFlavorSupported(transferable)) {
                List<FlowNode> list = FlowNodeFlavor.getFlowNodesCopied(transferable);
                if (list == null) {
                    dropTargetDropEvent.rejectDrop();
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                ViewLayout viewLayout = new ViewLayout(list);
                Point point = dropTargetDropEvent.getLocation();
                point = FlowViewer.this.getGraphLayout().getPointOnGrid(point.x, point.y);
                SubflowState subflowState = FlowViewer.this.getPickedState();
                subflowState.startAdjusting();
                try {
                    Cloneable cloneable;
                    subflowState.clearPickedVertices();
                    if (subflowState.getConnectTargetNode() != null) {
                        subflowState.setPicked((ArchetypeVertex)subflowState.getConnectTargetNode());
                        cloneable = FlowViewer.this.getGraphLayout().getLocation((ArchetypeVertex)subflowState.getConnectTargetNode());
                        cloneable = FlowViewer.this.transform((Point2D)cloneable);
                        point.x = (int)((Point2D)cloneable).getX() + 80;
                        point.y = (int)((Point2D)cloneable).getY();
                    }
                    FlowViewer.this.getUndoableEditSupport().beginUpdate(new NamedCompoundEdit(Messages.getString("Action.new_node")));
                    try {
                        cloneable = new HashMap();
                        Set<FlowNode> set = FlowViewer.this.addSubLayout(viewLayout, point, false, true, (Map<FlowNode, FlowNode>)((Object)cloneable), null);
                        FlowEdge flowEdge = subflowState.getInsertTargetEdge();
                        if (flowEdge != null) {
                            FlowViewer.this.getGraph().removeEdge((Edge)flowEdge);
                            FlowEdge flowEdge2 = (FlowEdge)FlowViewer.this.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowEdge.getSource(), (Vertex)cloneable.get(list.get(0))));
                            FlowEdge flowEdge3 = (FlowEdge)FlowViewer.this.getGraph().addEdge((Edge)new FlowEdge((Vertex)cloneable.get(list.get(list.size() - 1)), (Vertex)flowEdge.getDest()));
                            FlowViewer.this.fireUndoableEditUpdate(FlowViewer.this.undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{flowEdge}));
                            FlowViewer.this.fireUndoableEditUpdate(FlowViewer.this.undoableEditFactory.createAddEdgeEdit(new FlowEdge[]{flowEdge2, flowEdge3}));
                        } else {
                            FlowNode flowNode = (FlowNode)cloneable.get(list.get(0));
                            if (flowNode.getModel().isConnectable()) {
                                FlowViewer.this.connectNode(flowNode);
                            }
                        }
                        subflowState.pick(set, true);
                    }
                    finally {
                        FlowViewer.this.getUndoableEditSupport().endUpdate();
                    }
                    FlowViewer.this.getPickedState().clearConnectTargetNode();
                    FlowViewer.this.transparentGraph.clear();
                    dropTargetDropEvent.dropComplete(true);
                }
                finally {
                    subflowState.endAdjusting();
                }
                return;
            }
            if (Flavors.isFileFlavorSupported(transferable)) {
                dropTargetDropEvent.acceptDrop(0x40000000);
                List<File> list = Flavors.getFiles(transferable);
                if (list == null || list.size() > 1) {
                    dropTargetDropEvent.rejectDrop();
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                File file = list.get(0);
                if (FlowModel.isRflow(file.getName())) {
                    dropTargetDropEvent.dropComplete(true);
                    Rflow.getInstance().getActions().openFlow(file, false);
                } else {
                    NodeModel nodeModel = this.createNodeModel(file = WorkingDirectory.toAbstractPath(file), transferable);
                    if (nodeModel == null) {
                        dropTargetDropEvent.rejectDrop();
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    dropTargetDropEvent.dropComplete(true);
                    FlowNode flowNode = new FlowNode(nodeModel);
                    FlowViewer.this.addNode(flowNode, dropTargetDropEvent.getLocation(), false);
                    FlowViewer.this.getPickedState().setPicked((ArchetypeVertex)flowNode);
                }
                return;
            }
            if (Flavors.isStringFlavorSupported(transferable)) {
                String string = Flavors.getString(transferable);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    dropTargetDropEvent.rejectDrop();
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                if (!IOUtils.LINE_SEPARATOR.equals("\n")) {
                    string = StringUtils.replace((String)string, (String)IOUtils.LINE_SEPARATOR, (String)"\n");
                }
                FlowNode flowNode = new FlowNode(new FreeNodeModel(string));
                FlowViewer.this.addNode(flowNode, dropTargetDropEvent.getLocation(), false);
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.dropComplete(false);
            FlowViewer.this.getPickedState().clearConnectTargetNode();
            FlowViewer.this.transparentGraph.clear();
        }

        private NodeModel createNodeModel(File file, Transferable transferable) {
            FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
            if (fileInfo.getFile() == null) {
                return null;
            }
            Class clazz = null;
            switch (fileInfo.getExtension().toLowerCase()) {
                case "csv": 
                case "txt": {
                    clazz = RReadTable.class;
                    break;
                }
                case "r": {
                    clazz = RScriptFile.class;
                    break;
                }
                case "rdata": 
                case "rds": {
                    clazz = RReadObject.class;
                    break;
                }
                default: {
                    String string = RUtility.path(file.getPath());
                    String string2 = RUtility.makeName(FilenameUtils.removeExtension((String)file.getName()));
                    return new FreeNodeModel(RUtility.assignFunction(string2, "file", "", string));
                }
            }
            Object object = OpManager.getInstance().getInstance(clazz.getName());
            if (object == null) {
                return null;
            }
            ((Operation)object).importTransferable(transferable);
            return new UINodeModel((Operation)object);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            FlowViewer.this.getPickedState().clearConnectTargetNode();
            FlowViewer.this.transparentGraph.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            boolean bl = true;
            boolean bl2 = true;
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List<File> list = Flavors.getFiles(transferable);
                if (list == null || list.size() > 1) {
                    dropTargetDragEvent.rejectDrag();
                } else {
                    dropTargetDragEvent.acceptDrag(1);
                }
            } else if (FlowNodeFlavor.isFlowNodeFlavorSupported(transferable)) {
                Point2D point2D = FlowViewer.this.inverseViewTransform(dropTargetDragEvent.getLocation());
                FlowNode flowNode = (FlowNode)FlowViewer.this.getPickSupport().getVertex(point2D.getX(), point2D.getY());
                this.rollOverHandler.setRollOver(flowNode);
                if (flowNode != null && flowNode.getModel().isConnectable()) {
                    FlowViewer.this.setTransparentConnection(flowNode, FlowNodeFlavor.getFlowNodes(transferable));
                    bl = false;
                } else {
                    int n = 40;
                    Rectangle rectangle = new Rectangle(dropTargetDragEvent.getLocation().x - n / 2, dropTargetDragEvent.getLocation().y - n / 2, n, n);
                    for (Object e : FlowViewer.this.getGraph().getEdges()) {
                        FlowEdge flowEdge = (FlowEdge)((Object)e);
                        Shape shape = FlowViewer.this.getRenderer().getEdgeShapes().get((Object)flowEdge);
                        if (shape == null || !shape.intersects(rectangle)) continue;
                        FlowViewer.this.getPickedState().setInsertTargetEdge(flowEdge);
                        bl2 = false;
                        break;
                    }
                }
            }
            if (bl) {
                FlowViewer.this.getPickedState().clearConnectTargetNode();
                FlowViewer.this.transparentGraph.clear();
            }
            if (bl2) {
                FlowViewer.this.getPickedState().clearInsertTargetEdge();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            FlowViewer.this.getPickedState().clearConnectTargetNode();
            FlowViewer.this.transparentGraph.clear();
            FlowViewer.this.getPickedState().clearInsertTargetEdge();
            this.rollOverHandler.stop();
        }

        private class RollOverHandler
        implements ActionListener {
            private Timer rollOverTimer = new Timer(500, this);
            private FlowNode rollOverNode = null;

            public RollOverHandler() {
                this.rollOverTimer.setRepeats(false);
            }

            public void stop() {
                if (this.rollOverTimer.isRunning()) {
                    this.rollOverTimer.stop();
                }
                this.rollOverNode = null;
            }

            public void setRollOver(FlowNode flowNode) {
                if (flowNode == null) {
                    this.stop();
                    return;
                }
                if (this.rollOverTimer.isRunning()) {
                    if (flowNode == this.rollOverNode) {
                        return;
                    }
                    this.rollOverTimer.stop();
                }
                this.rollOverNode = flowNode;
                if (FlowViewer.this.getPickedState().isPicked((Vertex)this.rollOverNode)) {
                    return;
                }
                this.rollOverTimer.start();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.rollOverNode == null) {
                    return;
                }
                FlowViewer.this.getPickedState().setPicked((ArchetypeVertex)this.rollOverNode);
                this.rollOverNode = null;
            }
        }
    }

    public static class ViewerActions
    extends Actions
    implements FlowNodeSelectionEventHandler,
    BusyListener,
    NodeBreakpointChangeListener,
    PopupMenuListener,
    NodeModelChangeListener {
        public static final String UNDO = "UNDO";
        public static final String REDO = "REDO";
        public static final String CUT = "CUT";
        public static final String COPY = "COPY";
        public static final String EDIT_NODE = "EDIT_NODE";
        public static final String REMOVE_NODE = "REMOVE_NODE";
        public static final String RUN = "RUN";
        public static final String RUN_CLEAR = "RUN_CLEAR";
        public static final String RUN_SELECTED = "RUN_SELECTED";
        public static final String ADD_TO_TASK = "ADD_TO_TASK";
        public static final String EXPORT_SCRIPT = "EXPORT_SCRIPT";
        public static final String CLEAN_CACHE = "CLEAN_CACHE";
        public static final String MOVE_UP = "MOVE_UP";
        public static final String MOVE_DOWN = "MOVE_DOWN";
        public static final String MOVE_LEFT = "MOVE_LEFT";
        public static final String MOVE_RIGHT = "MOVE_RIGHT";
        private static final String CREATE_SCRIPT_NODE = "CREATE_SCRIPT_NODE";
        private static final String CREATE_SUBFLOW_NODE = "CREATE_SUBFLOW_NODE";
        private static final String CREATE_IF_NODE = "CREATE_IF_NODE";
        private static final String CREATE_FOR_NODE = "CREATE_FOR_NODE";
        private static final String CREATE_WHILE_NODE = "CREATE_WHILE_NODE";
        private static final String CREATE_REPEAT_NODE = "CREATE_REPEAT_NODE";
        private static final String CREATE_FUNCTION_NODE = "CREATE_FUNCTION_NODE";
        private static final String CREATE_COMMENT_NODE = "CREATE_COMMENT_NODE";
        private static final String INSERT_SOURCE = "INSERT_SOURCE";
        private static final String INSERT_CLIPBOARD = "INSERT_CLIPBOARD";
        private static final String PASTE = "PASTE";
        private static final String SELECT_ALL = "SELECT_ALL";
        private static final String PROPERTY = "PROPERTY";
        private static final String DISABLE = "DISABLE";
        private static final String ENABLE = "ENABLE";
        public static final String EDGE_MODE = "EDGE_MODE";
        private Point p;
        private FlowViewer viewer;
        private boolean notBusy = true;

        public ViewerActions(FlowViewer flowViewer) {
            this.viewer = flowViewer;
            this.put(UNDO, new UndoAction());
            this.put(REDO, new RedoAction());
            this.put(CUT, new CutAction());
            this.put(COPY, new CopyAction());
            this.put(EDIT_NODE, new EditNodeAction());
            this.put(REMOVE_NODE, new RemoveNodeAction());
            this.put(SELECT_ALL, new SelectAllAction());
            this.put(RUN, new RunAction());
            this.put(RUN_CLEAR, new RunClearAction());
            this.put(RUN_SELECTED, new RunSelectedAction());
            this.put(ADD_TO_TASK, new AddToTaskAction());
            this.put(EXPORT_SCRIPT, new ExportScriptAction());
            this.put(CLEAN_CACHE, new CleanCacheAction());
            this.put(MOVE_UP, new MoveNodeAction(0));
            this.put(MOVE_DOWN, new MoveNodeAction(1));
            this.put(MOVE_LEFT, new MoveNodeAction(2));
            this.put(MOVE_RIGHT, new MoveNodeAction(3));
            this.put(CREATE_SCRIPT_NODE, new CreateScriptNodeAction());
            this.put(CREATE_SUBFLOW_NODE, new CreateSubflowNodeAction());
            this.put(CREATE_IF_NODE, new CreateIfNodeAction());
            this.put(CREATE_FOR_NODE, new CreateForNode());
            this.put(CREATE_WHILE_NODE, new CreateLoopNodeAction(LoopType.WHILE, Messages.getString("Action.box_while")));
            this.put(CREATE_REPEAT_NODE, new CreateLoopNodeAction(LoopType.REPEAT, Messages.getString("Action.box_repeat")));
            this.put(CREATE_FUNCTION_NODE, new CreateFunctionNodeAction());
            this.put(INSERT_SOURCE, new InsertSourceAction());
            this.put(INSERT_CLIPBOARD, new InsertClipBoardAction());
            this.put(PASTE, new PasteAction());
            this.put(PROPERTY, new PropertyAction());
            this.put(CREATE_COMMENT_NODE, new CreateCommentNodeAction());
            this.put(DISABLE, new Disable());
            this.put(ENABLE, new Enable());
            this.put(new FlowPropertiesAction());
            this.put(EDGE_MODE, new EdgeMode());
            this.get(UNDO).setEnabled(false);
            this.get(REDO).setEnabled(false);
            this.get(CUT).setEnabled(false);
            this.get(COPY).setEnabled(false);
            this.get(REMOVE_NODE).setEnabled(false);
            this.get(EDIT_NODE).setEnabled(false);
            this.get(RUN).setEnabled(false);
            this.get(RUN_CLEAR).setEnabled(false);
            this.get(RUN_SELECTED).setEnabled(false);
            this.get(EDGE_MODE).setEnabled(false);
        }

        private FlowViewer getViewer() {
            return this.viewer;
        }

        private void runSelected(boolean bl) throws OperationFailedException {
            FlowSegment flowSegment;
            FlowViewer flowViewer = this.getViewer();
            if (flowViewer != null && (flowSegment = FlowUtil.getFlowSegment(flowViewer.getPickedState().getPickedVertices())) != null) {
                FlowRunOption flowRunOption = FlowRunOption.createRunSelectedNodeOption(bl);
                flowViewer.getFlowModel().getExecutor().runNode(flowSegment.getEnd(), flowSegment.getStart(), flowRunOption);
            }
        }

        private Set<FlowNode> getSelectedNodes() {
            FlowViewer flowViewer = this.getViewer();
            if (flowViewer == null) {
                return Collections.EMPTY_SET;
            }
            return flowViewer.getPickedState().getPickedVertices();
        }

        public void setPoint(Point point) {
            this.p = point;
        }

        public void showOnGroundPopup(Point point) {
            this.setPoint(point);
            this.updateUndoState();
            this.get(INSERT_SOURCE).setEnabled(!Rflow.getInstance().isBusy());
            JMenu jMenu = new JMenu(Messages.getString("Action.import_r_scripts_from"));
            jMenu.add(this.get(INSERT_SOURCE));
            jMenu.add(this.get(INSERT_CLIPBOARD));
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.get(CREATE_SCRIPT_NODE));
            jPopupMenu.add(OpPopupMenu.createOnFlowMenu(opTreeNode -> new CreateUINodeAction((OpTreeNode)opTreeNode)));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(CREATE_SUBFLOW_NODE));
            JMenu jMenu2 = new JMenu(Messages.getString("Menu.create_special_box"));
            jMenu2.add(this.get(CREATE_FUNCTION_NODE));
            jMenu2.add(this.get(CREATE_IF_NODE));
            jMenu2.add(this.get(CREATE_FOR_NODE));
            jMenu2.add(this.get(CREATE_WHILE_NODE));
            jMenu2.add(this.get(CREATE_REPEAT_NODE));
            jPopupMenu.add(jMenu2);
            jPopupMenu.add(this.get(CREATE_COMMENT_NODE));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(UNDO));
            jPopupMenu.add(this.get(REDO));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(PASTE));
            jPopupMenu.add(this.get(SELECT_ALL));
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenu);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(FlowPropertiesAction.class));
            FlowViewer flowViewer = this.getViewer();
            if (flowViewer == null) {
                return;
            }
            if (flowViewer != null && !flowViewer.getGraph().isRootGraph()) {
                jPopupMenu.add(this.get(PROPERTY));
            }
            jPopupMenu.addPopupMenuListener(this);
            jPopupMenu.show((Component)((Object)flowViewer), point.x, point.y);
        }

        private void update() {
            Object object;
            Object object2;
            Object object3;
            Object object5;
            SubflowState subflowState = this.viewer.getPickedState();
            boolean bl = subflowState.getPickedVertices().size() > 0;
            this.get(CUT).setEnabled(bl);
            this.get(COPY).setEnabled(bl);
            this.get(REMOVE_NODE).setEnabled(bl || subflowState.getPickedEdges().size() > 0);
            boolean bl2 = bl && subflowState.getPickedVertices().size() == 1;
            NodeModelController nodeModelController = null;
            if (bl2) {
                object5 = subflowState.getSelectedNode();
                nodeModelController = NodeModelManager.getModelController(((FlowNode)object5).getModel().getClass());
            }
            this.get(EDIT_NODE).setEnabled(bl2 && (nodeModelController.canOpen() || nodeModelController.canEditOnViewer()));
            object5 = null;
            object5 = bl2 && !nodeModelController.canOpen() && nodeModelController.canEditOnViewer() ? Messages.getString("Action.edit") : Messages.getString("Action.open");
            this.get(EDIT_NODE).putValue("Name", object5);
            boolean bl3 = true;
            boolean bl4 = true;
            for (FlowNode object42 : subflowState.getPickedVertices()) {
                if (!object42.isExecutable()) {
                    bl3 = false;
                }
                if (!object42.getModel().isDisabled()) {
                    bl4 = false;
                }
                if (bl3 || bl4) continue;
                break;
            }
            this.get(ADD_TO_TASK).setEnabled(bl && bl3);
            boolean bl5 = false;
            if (bl2 && !bl4) {
                bl5 = subflowState.getSelectedNode().isExecutable();
            }
            this.get(EDGE_MODE).setEnabled(bl2);
            FlowSegment flowSegment = FlowUtil.getFlowSegment(subflowState.getPickedVertices());
            boolean bl6 = FlowUtil.isExecutable(flowSegment) && !bl4;
            this.get(RUN).setEnabled(bl5 && this.notBusy);
            this.get(RUN_CLEAR).setEnabled(bl5 && this.notBusy);
            this.get(RUN_SELECTED).setEnabled(bl6 && this.notBusy);
            this.get(EXPORT_SCRIPT).setEnabled(bl6);
            Object object4 = Messages.getString("Action.run_clear");
            Object object6 = Messages.getString("Action.run_flow");
            Object object7 = Messages.getString("Action.run_selection");
            String string = Messages.getString("Action.cache_notice");
            String string2 = Messages.getString("Action.breakpoint_notice");
            if (bl5) {
                FlowRunOption flowRunOption;
                CommandPlan commandPlan;
                object3 = subflowState.getSelectedNode();
                object2 = this.viewer.getFlowModel().getExecutor();
                CommandPlan commandPlan2 = ((Executor)object2).getCommandPlan((FlowNode)object3, null, (FlowRunOption)(object = FlowRunOption.createRunNodeOption()));
                if (commandPlan2.isLoadCache()) {
                    object6 = (String)object6 + string;
                }
                if (commandPlan2.isBrowse()) {
                    object6 = (String)object6 + string2;
                }
                if ((commandPlan = ((Executor)object2).getCommandPlan((FlowNode)object3, null, flowRunOption = FlowRunOption.createClearAndRunNodeOption())).isLoadCache()) {
                    object4 = (String)object4 + string;
                }
                if (commandPlan.isBrowse()) {
                    object4 = (String)object4 + string2;
                }
            }
            if (bl6) {
                object3 = this.viewer.getFlowModel().getExecutor();
                object2 = FlowRunOption.createRunSelectedNodeOption(false);
                object = ((Executor)object3).getCommandPlan(flowSegment.getEnd(), flowSegment.getStart(), (FlowRunOption)object2);
                if (((CommandPlan)object).isBrowse()) {
                    object7 = (String)object7 + string2;
                }
            }
            this.get(RUN).putValue("Name", object6);
            this.get(RUN_CLEAR).putValue("Name", object4);
            this.get(RUN_SELECTED).putValue("Name", object7);
        }

        private void updateUndoState() {
            FlowUndoManager flowUndoManager = this.viewer.getViewLayout().getUndoManager();
            this.get(UNDO).setEnabled(flowUndoManager.canUndo());
            this.get(REDO).setEnabled(flowUndoManager.canRedo());
            this.get(UNDO).putValue("Name", flowUndoManager.getUndoPresentationName());
            this.get(REDO).putValue("Name", flowUndoManager.getRedoPresentationName());
        }

        @Override
        public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
            this.update();
        }

        @Override
        public void busyStateChanged(int n) {
            this.notBusy = n == 0;
            this.update();
        }

        @Override
        public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
            this.update();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                boolean bl = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) || clipboard.isDataFlavorAvailable(LayoutDataFlavor.getInstance());
                this.get(PASTE).setEnabled(bl);
            }
            catch (Exception exception) {
                this.get(PASTE).setEnabled(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.get(PASTE).setEnabled(true);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.get(PASTE).setEnabled(true);
        }

        @Override
        public void nodeModelChanged(FlowNode flowNode) {
            if (this.viewer.getGraph() == null) {
                return;
            }
            if (this.viewer.getGraph() == flowNode.getGraph() || this.viewer.getGraph().getParentNode() == flowNode) {
                this.update();
            }
        }

        @Override
        public void subflowNodeModelChanged(FlowNode flowNode) {
            if (this.viewer.getGraph() == null) {
                return;
            }
            if (this.viewer.getGraph() == flowNode.getGraph() || this.viewer.getGraph().getParentNode() == flowNode) {
                this.update();
            }
        }

        private class UndoAction
        extends ViewerAction {
            UndoAction() {
                this.putValue("Name", Messages.getString("Action.undo"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.undo();
            }
        }

        private class RedoAction
        extends ViewerAction {
            RedoAction() {
                this.putValue("Name", Messages.getString("Action.redo"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.redo();
            }
        }

        private class CutAction
        extends ViewerAction {
            CutAction() {
                this.putValue("Name", Messages.getString("Action.cut"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.cut();
            }
        }

        private class CopyAction
        extends ViewerAction {
            CopyAction() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.copy();
            }
        }

        private class EditNodeAction
        extends ViewerAction {
            EditNodeAction() {
                this.putValue("Name", Messages.getString("Action.open"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.openNode(flowViewer.getPickedState().getSelectedNode(), false, false);
            }
        }

        private class RemoveNodeAction
        extends ViewerAction {
            RemoveNodeAction() {
                this.putValue("Name", Messages.getString("Action.remove_node"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.delete();
            }
        }

        private class SelectAllAction
        extends ViewerAction {
            SelectAllAction() {
                this.putValue("Name", Messages.getString("Action.select_all"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.selectAll();
            }
        }

        private class RunAction
        extends ViewerAction {
            RunAction() {
                this.putValue("Name", Messages.getString("Action.run_flow"));
                this.putValue("SmallIcon", Icons.getIcon("16/go.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_AND_SHIFT_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                try {
                    SubflowState subflowState = flowViewer.getPickedState();
                    if (subflowState.getPickedVertices().size() == 1) {
                        FlowRunOption flowRunOption = FlowRunOption.createRunNodeOption();
                        flowViewer.getFlowModel().getExecutor().runNode(subflowState.getSelectedNode(), null, flowRunOption);
                    } else {
                        ViewerActions.this.runSelected(false);
                    }
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run flow.", operationFailedException);
                    UIUtility.showErrorDialog((Component)((Object)flowViewer), operationFailedException.getMessage());
                }
            }
        }

        private class RunClearAction
        extends ViewerAction {
            RunClearAction() {
                this.putValue("Name", Messages.getString("Action.run_clear"));
                this.putValue("SmallIcon", Icons.getOverlaidIcon(Icons.getIcon("16/go.png"), "16/asterisk_yellow.png", 8, 0, 0));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                try {
                    SubflowState subflowState = flowViewer.getPickedState();
                    if (subflowState.getPickedVertices().size() == 1) {
                        FlowRunOption flowRunOption = FlowRunOption.createClearAndRunNodeOption();
                        flowViewer.getFlowModel().getExecutor().runNode(subflowState.getSelectedNode(), null, flowRunOption);
                    } else {
                        ViewerActions.this.runSelected(true);
                    }
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run flow.", operationFailedException);
                    UIUtility.showErrorDialog((Component)((Object)flowViewer), operationFailedException.getMessage());
                }
            }
        }

        private class RunSelectedAction
        extends ViewerAction {
            RunSelectedAction() {
                this.putValue("Name", Messages.getString("Action.run_selection"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_right.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                try {
                    ViewerActions.this.runSelected(false);
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run node.", operationFailedException);
                    UIUtility.showErrorDialog((Component)((Object)flowViewer), operationFailedException.getMessage());
                }
            }
        }

        private class AddToTaskAction
        extends ViewerAction {
            AddToTaskAction() {
                this.putValue("Name", Messages.getString("Action.add_to_task"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                if (!flowViewer.getPickedState().getPickedVertices().isEmpty()) {
                    Rflow.mainView().getTaskExplorer().addTask(flowViewer.getPickedState().getPickedVertices());
                }
            }
        }

        private class ExportScriptAction
        extends ViewerAction {
            ExportScriptAction() {
                this.putValue("Name", Messages.getStringWithDots("Action.copy_export_r_script"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                FlowSegment flowSegment = FlowUtil.getFlowSegment(flowViewer.getPickedState().getPickedVertices());
                if (!FlowUtil.isExecutable(flowSegment)) {
                    return;
                }
                FlowNode flowNode = flowSegment.getEnd().getParentNode();
                boolean bl = flowNode != null && flowNode.getModel().isSubflow() && !flowNode.getModel().isOpenSubflow();
                boolean bl2 = flowSegment.getEnd().getPreviousNode() == null && flowSegment.getEnd().getModel() != TunnelNodeModel.inModel;
                NodeTaskEntry nodeTaskEntry = !bl && flowSegment.isSingleNode() && flowSegment.getEnd().isExecutable() && !bl2 ? new NodeTaskEntry(flowSegment.getEnd()) : null;
                NodeTaskEntry nodeTaskEntry2 = new NodeTaskEntry(flowSegment.getEnd(), flowSegment.getStart());
                RScriptExportView.show(Rflow.getInstance().getMainFrame(), flowViewer.getFlowModel(), nodeTaskEntry, nodeTaskEntry2);
            }
        }

        private class CleanCacheAction
        extends ViewerAction {
            CleanCacheAction() {
                this.putValue("Name", "");
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.getFlowModel().getCacheHandler().cleanCaches();
            }
        }

        private class MoveNodeAction
        extends ViewerAction {
            private static final int UP = 0;
            private static final int DOWN = 1;
            private static final int LEFT = 2;
            private static final int RIGHT = 3;
            private int type;

            MoveNodeAction(int n) {
                this.type = n;
                int n2 = 0;
                switch (n) {
                    case 0: {
                        n2 = 38;
                        break;
                    }
                    case 1: {
                        n2 = 40;
                        break;
                    }
                    case 2: {
                        n2 = 37;
                        break;
                    }
                    default: {
                        n2 = 39;
                    }
                }
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(n2, 0));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                Set<FlowNode> set = flowViewer.getPickedState().getPickedVertices();
                if (set.isEmpty()) {
                    return;
                }
                FlowLayout flowLayout = flowViewer.getGraphLayout();
                int n = flowLayout.getGridDistance();
                int n2 = 0;
                int n3 = 0;
                switch (this.type) {
                    case 0: {
                        n3 = -n;
                        break;
                    }
                    case 1: {
                        n3 = n;
                        break;
                    }
                    case 2: {
                        n2 = -n;
                        break;
                    }
                    default: {
                        n2 = n;
                    }
                }
                flowLayout.beginNodesMove();
                try {
                    HashMap<Vertex, Point2D> hashMap = new HashMap<Vertex, Point2D>(set.size());
                    for (FlowNode flowNode : set) {
                        Point2D point2D = flowLayout.getLocation((ArchetypeVertex)flowNode);
                        hashMap.put((Vertex)flowNode, (Point2D)point2D.clone());
                        if (flowViewer.isUseGrid()) {
                            flowLayout.forceMoveOnGrid((Vertex)flowNode, point2D.getX() + (double)n2, point2D.getY() + (double)n3);
                            continue;
                        }
                        flowLayout.forceMove((Vertex)flowNode, point2D.getX() + (double)n2, point2D.getY() + (double)n3);
                    }
                    UndoableEdit undoableEdit = flowViewer.undoableEditFactory.createMoveNodeEdit(hashMap);
                    flowViewer.fireUndoableEditUpdate(undoableEdit);
                }
                finally {
                    flowLayout.endNodesMove();
                }
            }
        }

        private class CreateScriptNodeAction
        extends ViewerAction {
            CreateScriptNodeAction() {
                this.putValue("Name", Messages.getString("Action.new_sentence_node"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                boolean bl = flowViewer.getPickedState().getPickedVertices().size() == 1;
                flowViewer.createOneLinerNode(bl ? null : ViewerActions.this.p, true);
            }
        }

        private class CreateSubflowNodeAction
        extends ViewerAction {
            CreateSubflowNodeAction() {
                this.putValue("Name", Messages.getString("Action.create_box"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.createNode(SubflowNodeModel.class, ViewerActions.this.p, true);
            }
        }

        private class CreateIfNodeAction
        extends ViewerAction {
            CreateIfNodeAction() {
                this.putValue("Name", Messages.getString("Action.box_if"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.createNode(IfNodeModel.class, ViewerActions.this.p, true);
            }
        }

        private class CreateForNode
        extends ViewerAction {
            CreateForNode() {
                this.putValue("Name", Messages.getString("Action.box_for"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.createNode(ForNodeModel.class, ViewerActions.this.p, true);
            }
        }

        private class CreateLoopNodeAction
        extends ViewerAction {
            private LoopType type;

            CreateLoopNodeAction(LoopType loopType, String string) {
                this.type = loopType;
                this.putValue("Name", string);
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.createLoopNode(this.type, ViewerActions.this.p);
            }
        }

        private class CreateFunctionNodeAction
        extends ViewerAction {
            CreateFunctionNodeAction() {
                this.putValue("Name", Messages.getString("Action.box_function"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.createNode(FunctionNodeModel.class, ViewerActions.this.p, true);
            }
        }

        private class InsertSourceAction
        extends ViewerAction {
            InsertSourceAction() {
                this.putValue("Name", Messages.getString("Action.file") + "...");
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.importScript(ViewerActions.this.p);
            }
        }

        private class InsertClipBoardAction
        extends ViewerAction {
            InsertClipBoardAction() {
                this.putValue("Name", Messages.getString("Action.clipboard"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.pasteScript(ViewerActions.this.p);
            }
        }

        private class PasteAction
        extends ViewerAction {
            PasteAction() {
                this.putValue("Name", Messages.getString("Action.paste"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.paste(ViewerActions.this.p);
            }
        }

        private class PropertyAction
        extends ViewerAction {
            PropertyAction() {
                this.putValue("Name", Messages.getString("Action.property"));
                this.putValue("SmallIcon", Icons.getIcon("16/cog.png"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.editProperty(flowViewer.getGraph().getParentNode());
            }
        }

        private class CreateCommentNodeAction
        extends ViewerAction {
            CreateCommentNodeAction() {
                this.putValue("Name", Messages.getString("Action.create_comment"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.createNode(CommentNodeModel.class, ViewerActions.this.p, false);
            }
        }

        private class Disable
        extends ViewerAction {
            Disable() {
                this.putValue("Name", Messages.getString("Action.disable"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_AND_SHIFT_KEY_MASK));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                boolean bl = true;
                for (FlowNode flowNode : ViewerActions.this.getSelectedNodes()) {
                    if (!flowNode.getModel().canBeDisabled() || flowNode.getModel().isDisabled()) continue;
                    bl = false;
                }
                flowViewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit((String)this.getValue("Name")));
                try {
                    for (FlowNode flowNode : ViewerActions.this.getSelectedNodes()) {
                        if (!flowNode.getModel().canBeDisabled() || flowNode.getModel().isDisabled() == !bl) continue;
                        flowNode.getModel().setDisabled(!bl);
                        FlowNode.fireNodeModelChanged(flowNode);
                        flowViewer.fireUndoableEditUpdate(flowViewer.undoableEditFactory.createNodeModelEnabledEdit(flowNode, bl));
                    }
                    flowViewer.repaint();
                }
                finally {
                    flowViewer.undoableEditSupport.endUpdate();
                }
            }
        }

        private class Enable
        extends ViewerAction {
            Enable() {
                this.putValue("Name", Messages.getString("Action.enable"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                flowViewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit((String)this.getValue("Name")));
                try {
                    for (FlowNode flowNode : ViewerActions.this.getSelectedNodes()) {
                        if (!flowNode.getModel().isDisabled()) continue;
                        flowNode.getModel().setDisabled(false);
                        FlowNode.fireNodeModelChanged(flowNode);
                        flowViewer.fireUndoableEditUpdate(flowViewer.undoableEditFactory.createNodeModelEnabledEdit(flowNode, true));
                    }
                    flowViewer.repaint();
                }
                finally {
                    flowViewer.undoableEditSupport.endUpdate();
                }
            }
        }

        private class FlowPropertiesAction
        extends ViewerAction {
            FlowPropertiesAction() {
                this.putValue("Name", Messages.getStringWithDots("View.FlowProperties.title"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                FlowActions.editFlowProperties(flowViewer.getFlowModel());
            }
        }

        private class EdgeMode
        extends ViewerAction {
            public EdgeMode() {
                this.putValue("Name", Messages.getString("Action.draw_edge"));
                this.putValue("SmallIcon", Icons.getIcon("16/pencil.png"));
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                FlowNode flowNode = flowViewer.getPickedState().getSelectedNode();
                if (flowNode == null) {
                    return;
                }
                flowViewer.edgeConnectionHandler.startEdgeConnection(flowNode);
            }
        }

        private class CreateUINodeAction
        extends ViewerAction {
            private Operation uiModel;

            public CreateUINodeAction(OpTreeNode opTreeNode) {
                this.uiModel = opTreeNode.getModel();
                this.putValue("Name", this.uiModel.getTitle());
                this.putValue("SmallIcon", opTreeNode.getSmallIcon());
            }

            @Override
            void viewerAction(FlowViewer flowViewer, ActionEvent actionEvent) {
                UINodeModel uINodeModel = new UINodeModel(this.uiModel.copy());
                FlowNode flowNode = flowViewer.addNode(new FlowNode(uINodeModel), ViewerActions.this.p, true);
                flowViewer.getPickedState().setPicked((ArchetypeVertex)flowNode);
            }
        }

        private abstract class ViewerAction
        extends LoggableAction {
            private ViewerAction() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FlowViewer flowViewer = ViewerActions.this.getViewer();
                if (flowViewer != null) {
                    this.viewerAction(flowViewer, actionEvent);
                }
            }

            abstract void viewerAction(FlowViewer var1, ActionEvent var2);
        }
    }

    private class FirstGuide
    implements VisualizationViewer.Paintable {
        private JTextArea textArea = new JTextArea(Messages.getString("Flow.starter_guide"));

        public FirstGuide() {
            this.textArea.setForeground(new Color(64, 64, 64));
            this.textArea.setBackground(FlowViewer.this.getBackground());
        }

        public void refreshFont() {
            FontSupport.setFont(this.textArea, Settings.BASIC_FONT_SIZE);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.textArea.getPreferredSize();
            Dimension dimension2 = FlowViewer.this.getSize();
            int n = dimension2.width / 2 - dimension.width / 2;
            int n2 = dimension2.height / 2 - dimension.height / 2;
            FlowViewer.this.getRenderer().getRendererPane().paintComponent(graphics, this.textArea, (Container)((Object)FlowViewer.this), n, n2, dimension.width, dimension.height, true);
        }

        public boolean useTransform() {
            return false;
        }
    }

    static class DummyEdge
    extends AbstractElement
    implements DirectedEdge {
        private Vertex from;
        private Vertex to;

        public DummyEdge(Vertex vertex, Vertex vertex2) {
            this.from = vertex;
            this.to = vertex2;
        }

        public Vertex getOpposite(Vertex vertex) {
            if (vertex == this.from) {
                return this.to;
            }
            if (vertex == this.to) {
                return this.from;
            }
            return null;
        }

        public Pair getEndpoints() {
            return new Pair((Object)this.from, (Object)this.to);
        }

        public Set<?> getIncidentVertices() {
            LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>(2);
            linkedHashSet.add(this.from);
            linkedHashSet.add(this.to);
            return Collections.unmodifiableSet(linkedHashSet);
        }

        public ArchetypeEdge getEqualEdge(ArchetypeGraph archetypeGraph) {
            return null;
        }

        public ArchetypeEdge getEquivalentEdge(ArchetypeGraph archetypeGraph) {
            return this.getEqualEdge(archetypeGraph);
        }

        public int numVertices() {
            return this.getIncidentVertices().size();
        }

        public boolean isIncident(ArchetypeVertex archetypeVertex) {
            return this.getIncidentVertices().contains(archetypeVertex);
        }

        public Set<?> getIncidentElements() {
            return this.getIncidentVertices();
        }

        public Vertex getSource() {
            return this.from;
        }

        public Vertex getDest() {
            return this.to;
        }

        public ArchetypeEdge copy(ArchetypeGraph archetypeGraph) {
            return new DummyEdge(this.from, this.to);
        }
    }

    private static class OnBreakpointActions
    extends Actions {
        private FlowViewer viewer;
        private FlowNode node;

        public OnBreakpointActions() {
            this.put(new Remove());
        }

        public void showPopup(FlowViewer flowViewer, FlowNode flowNode, int n, int n2) {
            this.viewer = flowViewer;
            this.node = flowNode;
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.get(Remove.class));
            jPopupMenu.show((Component)((Object)flowViewer), n, n2);
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.unset_breakpoint"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnBreakpointActions.this.node.setBreakpointState(0);
                Rflow.mainView().getBreakpointExplorer().update();
                OnBreakpointActions.this.viewer.repaint();
            }
        }
    }

    private static class OnCommentActions
    extends ActionMap {
        private FlowViewer viewer;
        private FlowNode node;
        private NodeComment comment;
        private static final String EDIT = "EDIT";
        private static final String REMOVE = "REMOVE";

        public OnCommentActions() {
            this.put(EDIT, new Edit());
            this.put(REMOVE, new Remove());
        }

        public void showPopup(FlowViewer flowViewer, FlowNode flowNode, NodeComment nodeComment, int n, int n2) {
            this.viewer = flowViewer;
            this.node = flowNode;
            this.comment = nodeComment;
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.get(EDIT));
            jPopupMenu.add(this.get(REMOVE));
            jPopupMenu.show((Component)((Object)flowViewer), n, n2);
        }

        private class Edit
        extends LoggableAction {
            public Edit() {
                this.putValue("Name", Messages.getString("Action.edit"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnCommentActions.this.viewer.flowModel.getState().setPoppedComment(null);
                OnCommentActions.this.viewer.repaint();
                OnCommentActions.this.viewer.editComment(OnCommentActions.this.node);
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnCommentActions.this.viewer.flowModel.getState().setPoppedComment(null);
                OnCommentActions.this.viewer.repaint();
                NodeComment nodeComment = OnCommentActions.this.node.getComment().copy();
                OnCommentActions.this.comment.removeComment();
                OnCommentActions.this.viewer.fireUndoableEditUpdate(OnCommentActions.this.viewer.undoableEditFactory.createNodeCommentChangeEdit(OnCommentActions.this.node, nodeComment));
                FlowNode.fireNodeCommentChanged(OnCommentActions.this.node, nodeComment, OnCommentActions.this.node.getComment());
                OnCommentActions.this.viewer.revalidate();
                OnCommentActions.this.viewer.repaint();
            }
        }
    }

    private static class OnNodeActions
    extends Actions {
        private static final String CREATE_EDGE = "CREATE_EDGE";
        private static final String MARK_CACHE = "MARK_CACHE";
        private static final String CACHE = "CACHE";
        private static final String CLEAR_CACHE = "CLEAR_CACHE";
        private static final String REMOVE_CACHE = "REMOVE_CACHE";
        private static final String REMOVE_EDGE = "REMOVE_EDGE";
        private static final String OPEN_IN_NEW_TAB = "OPEN_IN_NEW_TAB";
        private static final String MERGE_TO_R_SCRIPT = "MERGE_TO_R_SCRIPT";
        private static final String CREATE_BOX = "CREATE_BOX";
        private static final String UNFOLD_BOX = "UNFOLD_BOX";
        private static final String PROPERTY = "PROPERTY";
        private static final String CREATE_COMMENT = "CREATE_COMMENT";
        private static final String REMOVE_COMMENT = "REMOVE_COMMENT";
        private static final String SET_BREAKPOINT = "SET_BREAKPOINT";
        private static final String UNSET_BREAKPOINT = "UNSET_BREAKPOINT";
        private static final String CREATE_LIST = "CREATE_LIST";
        private static final String EDGE_MODE = "EDGE_MODE";
        private FlowViewer viewer;
        private FlowNode node;

        OnNodeActions() {
            this.put(CREATE_EDGE, new CreateEdge());
            this.put(EDGE_MODE, new EdgeMode());
            this.put(CACHE, new CreateCache());
            this.put(MARK_CACHE, new MarkCache());
            this.put(CLEAR_CACHE, new ClearCache());
            this.put(REMOVE_CACHE, new RemoveCache());
            this.put(REMOVE_EDGE, new RemoveEdgeAction());
            this.put(OPEN_IN_NEW_TAB, new OpenInNewTab());
            this.put(MERGE_TO_R_SCRIPT, new MergeToRScript());
            this.put(CREATE_BOX, new CreateBox());
            this.put(UNFOLD_BOX, new UnfoldBox());
            this.put(PROPERTY, new Property());
            this.put(CREATE_COMMENT, new CreateComment());
            this.put(REMOVE_COMMENT, new RemoveComment());
            this.put(SET_BREAKPOINT, new SetBreakPoint());
            this.put(UNSET_BREAKPOINT, new UnsetBreakPoint());
            this.put(CREATE_LIST, new CreateList());
        }

        private FlowNode[] getSelectedNodes() {
            if (this.viewer.getPickedState().isPicked((Vertex)this.node)) {
                Set<FlowNode> set = this.viewer.getPickedState().getPickedVertices();
                return set.toArray(new FlowNode[0]);
            }
            return new FlowNode[]{this.node};
        }

        public void setState(FlowViewer flowViewer, FlowNode flowNode) {
            this.viewer = flowViewer;
            this.node = flowNode;
        }

        private static void addIfEnabled(JPopupMenu jPopupMenu, Action action) {
            if (action.isEnabled()) {
                jPopupMenu.add(action);
            }
        }

        private static void addIfEnabled(JMenu jMenu, Action action) {
            if (action.isEnabled()) {
                jMenu.add(action);
            }
        }

        public void showPopup(Component component, FlowViewer flowViewer, FlowNode flowNode, int n, int n2) {
            Object object2;
            boolean bl;
            this.viewer = flowViewer;
            this.node = flowNode;
            NodeModelController nodeModelController = NodeModelManager.getModelController(flowNode.getModel().getClass());
            FlowNode[] flowNodeArray = this.getSelectedNodes();
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            for (FlowNode flowNode2 : flowNodeArray) {
                boolean bl6 = flowNode2.isCacheData();
                bl = bl6 && flowNode2.getCacheData().isValid();
                bl2 = bl2 && bl6;
                bl3 = bl3 && bl;
                bl4 = bl4 || bl6;
                bl5 = bl5 || bl;
            }
            boolean bl7 = flowNodeArray.length == 1;
            int n3 = flowNode.isExecutable() ? 1 : 0;
            int n4 = flowNode.getModel().isExecutable() ? 1 : 0;
            boolean bl8 = !Rflow.getInstance().isBusy();
            FlowSegment flowSegment = FlowUtil.getFlowSegment(flowViewer.getPickedState().getPickedVertices());
            bl = n4 != 0 && FlowUtil.isExecutable(flowSegment);
            boolean bl9 = flowNode.getComment().exists();
            boolean bl10 = true;
            boolean bl11 = true;
            boolean bl12 = false;
            boolean bl13 = false;
            for (Object object2 : flowViewer.getPickedState().getPickedVertices()) {
                if (object2.getModel().canSetBreakpoint()) {
                    if (object2.isFirstBreakpoint()) {
                        bl11 = false;
                    } else {
                        bl10 = false;
                    }
                }
                if (object2.getModel().isDisabled()) {
                    bl13 = true;
                    continue;
                }
                if (!object2.getModel().canBeDisabled()) continue;
                bl12 = true;
            }
            this.get(MERGE_TO_R_SCRIPT).putValue("Name", bl7 ? Messages.getStringWithDots("Action.convert_to_r_script") : Messages.getStringWithDots("Action.merge_to_r_script"));
            this.get(REMOVE_EDGE).setEnabled(bl7);
            this.get(PROPERTY).setEnabled(bl7 && flowNode.getModel().isProperty());
            this.get(MARK_CACHE).setEnabled(!bl2 && n3 != 0);
            this.get(CACHE).setEnabled(bl7 && n3 != 0 && !bl2 && bl8);
            this.get(CLEAR_CACHE).setEnabled(bl5);
            this.get(REMOVE_CACHE).setEnabled(bl4);
            this.get(UNFOLD_BOX).setEnabled(bl7 && flowNode.getModel().isOpenSubflow());
            this.get(OPEN_IN_NEW_TAB).setEnabled(bl7 && nodeModelController.canOpen());
            this.get(MERGE_TO_R_SCRIPT).setEnabled(bl && (!bl7 || !(flowNode.getModel() instanceof FreeNodeModel)));
            this.get(CREATE_COMMENT).setEnabled(n4 != 0 && !bl9);
            this.get(REMOVE_COMMENT).setEnabled(n4 != 0 && bl9);
            this.get(CREATE_BOX).setEnabled(n4 != 0);
            this.get(SET_BREAKPOINT).setEnabled(!bl10);
            this.get(UNSET_BREAKPOINT).setEnabled(!bl11);
            this.get(EDGE_MODE).setEnabled(bl7);
            Object object3 = flowViewer.getGraph().getParentNode();
            if (flowViewer.isChildView) {
                object3 = ((FlowNode)object3).getParentNode();
            }
            object2 = Rflow.mainView().getViewOpenType(flowNode, (FlowNode)object3, true);
            this.get(OPEN_IN_NEW_TAB).putValue("Name", object2 == ViewOpenType.OPEN ? Messages.getString("Action.open_this_tab") : Messages.getString("Action.open_new_tab"));
            this.get(OPEN_IN_NEW_TAB).setEnabled(!Rflow.mainView().keepRootFlow() || !((FlowNode)object3).isRootNode());
            JPopupMenu jPopupMenu = new JPopupMenu();
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("RUN_CLEAR"));
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("RUN"));
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("RUN_SELECTED"));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(EDGE_MODE));
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("ADD_TO_TASK"));
            jPopupMenu.addSeparator();
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("EDIT_NODE"));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(OPEN_IN_NEW_TAB));
            jPopupMenu.addSeparator();
            JMenu jMenu = new JMenu(Messages.getString("Menu.cache"));
            jMenu.setIcon(FileResource.getIcon("img/node/flag.png"));
            OnNodeActions.addIfEnabled(jMenu, this.get(MARK_CACHE));
            OnNodeActions.addIfEnabled(jMenu, this.get(CACHE));
            OnNodeActions.addIfEnabled(jMenu, this.get(CLEAR_CACHE));
            OnNodeActions.addIfEnabled(jMenu, this.get(REMOVE_CACHE));
            if (jMenu.getMenuComponentCount() == 0 || flowNode.isInClosedSubflow()) {
                jMenu.setEnabled(false);
            }
            if (jMenu.isEnabled()) {
                jPopupMenu.add(jMenu);
            }
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(CREATE_COMMENT));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(REMOVE_COMMENT));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(SET_BREAKPOINT));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(UNSET_BREAKPOINT));
            if (bl12) {
                JMenuItem jMenuItem = new JMenuItem(flowViewer.viewerActions.get("DISABLE"));
                jPopupMenu.add(jMenuItem);
            }
            if (bl13) {
                OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("ENABLE"));
            }
            jPopupMenu.addSeparator();
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(CREATE_BOX));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(UNFOLD_BOX));
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(MERGE_TO_R_SCRIPT));
            if (Rflow.isDevel()) {
                OnNodeActions.addIfEnabled(jPopupMenu, this.get(CREATE_LIST));
            }
            jPopupMenu.addSeparator();
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("EXPORT_SCRIPT"));
            jPopupMenu.addSeparator();
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("CUT"));
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("COPY"));
            OnNodeActions.addIfEnabled(jPopupMenu, flowViewer.viewerActions.get("REMOVE_NODE"));
            jPopupMenu.addSeparator();
            OnNodeActions.addIfEnabled(jPopupMenu, this.get(PROPERTY));
            UIUtility.clearPopupSeparator(jPopupMenu);
            jPopupMenu.show(component, n, n2);
        }

        private class CreateEdge
        extends LoggableAction {
            private CreateEdge() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.connectNode(OnNodeActions.this.node);
            }
        }

        private class EdgeMode
        extends LoggableAction {
            public EdgeMode() {
                this.putValue("Name", Messages.getString("Action.draw_edge"));
                this.putValue("SmallIcon", Icons.getIcon("16/pencil.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.edgeConnectionHandler.startEdgeConnection(OnNodeActions.this.node);
            }
        }

        private class CreateCache
        extends LoggableAction {
            CreateCache() {
                this.putValue("Name", Messages.getString("Action.cache_mark_and_run"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.cache(OnNodeActions.this.getSelectedNodes(), true);
            }
        }

        private class MarkCache
        extends LoggableAction {
            MarkCache() {
                this.putValue("Name", Messages.getString("Action.cache_mark"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.cache(OnNodeActions.this.getSelectedNodes(), false);
            }
        }

        private class ClearCache
        extends LoggableAction {
            ClearCache() {
                this.putValue("Name", Messages.getString("Action.cache_clear"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                boolean bl = Rflow.settings().getValue(Settings.USE_CACHE_BACKUP);
                OnNodeActions.this.viewer.removeCache(OnNodeActions.this.getSelectedNodes(), false, bl, (String)this.getValue("Name"));
            }
        }

        private class RemoveCache
        extends LoggableAction {
            RemoveCache() {
                this.putValue("Name", Messages.getString("Action.cache_unmark"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                boolean bl = Rflow.settings().getValue(Settings.USE_CACHE_BACKUP);
                OnNodeActions.this.viewer.removeCache(OnNodeActions.this.getSelectedNodes(), true, bl, (String)this.getValue("Name"));
            }
        }

        private class RemoveEdgeAction
        extends LoggableAction {
            RemoveEdgeAction() {
                this.putValue("Name", Messages.getString("Action.remove_edge"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FlowEdge flowEdge = OnNodeActions.this.node.getInEdge();
                if (flowEdge != null) {
                    OnNodeActions.this.viewer.getGraph().removeEdge((Edge)flowEdge);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{flowEdge}));
                }
            }
        }

        private class OpenInNewTab
        extends LoggableAction {
            OpenInNewTab() {
                this.putValue("Name", Messages.getString("Action.open_new_tab"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.openNode(OnNodeActions.this.node, false, true);
            }
        }

        private class MergeToRScript
        extends LoggableAction {
            MergeToRScript() {
                this.putValue("Name", Messages.getStringWithDots("Action.merge_to_r_script"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FlowSegment flowSegment = FlowUtil.getFlowSegment(OnNodeActions.this.viewer.getPickedState().getPickedVertices());
                FlowModel flowModel = OnNodeActions.this.viewer.getFlowModel();
                if (flowSegment == null || flowModel == null) {
                    return;
                }
                String string = (String)this.getValue("Name");
                if (string.endsWith("...")) {
                    string = string.substring(0, string.length() - "...".length());
                }
                RScriptizeView.show(Rflow.mainFrame(), string, OnNodeActions.this.viewer, flowModel, flowSegment);
            }
        }

        private class CreateBox
        extends LoggableAction {
            CreateBox() {
                this.putValue("Name", Messages.getString("Action.box_selected"));
                this.putValue("SmallIcon", FileResource.getIcon("img/node/box.png", 16));
            }

            private void showError(String string) {
                JOptionPane.showMessageDialog((Component)((Object)OnNodeActions.this.viewer), Messages.getString("Error.create_box") + " : " + string, "", 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                Object object;
                Set<FlowNode> set22;
                Object[] objectArray = OnNodeActions.this.getSelectedNodes();
                HashSet hashSet = Sets.newHashSet((Object[])(objectArray = (FlowNode[])Arrays.stream(objectArray).filter(flowNode -> flowNode.getModel().isModifiable()).toArray(FlowNode[]::new)));
                if (hashSet.isEmpty()) {
                    return;
                }
                List<Set<FlowNode>> list = FlowUtil.extractCluster(hashSet);
                HashSet<FlowNode> hashSet2 = new HashSet<FlowNode>();
                HashSet<FlowNode> hashSet3 = new HashSet<FlowNode>();
                HashSet<FlowNode> hashSet4 = new HashSet<FlowNode>();
                HashSet<FlowNode> hashSet5 = new HashSet<FlowNode>();
                for (Set<FlowNode> set22 : list) {
                    object = FlowUtil.getRootOfCluster(set22);
                    if (((FlowNode)object).getModel().isConnectable()) {
                        hashSet2.add((FlowNode)object);
                        hashSet3.add(FlowUtil.getInOfCluster(set22));
                    }
                    for (FlowNode object2 : FlowUtil.getEndsOfCluster(set22)) {
                        if (!object2.getModel().isConnectable()) continue;
                        if (object2.outDegree() == 0) {
                            hashSet4.add(object2);
                            continue;
                        }
                        hashSet5.add(object2);
                    }
                }
                if (hashSet3.size() > 1) {
                    this.showError(Messages.getString("Error.multistart"));
                    return;
                }
                if (hashSet5.size() > 1) {
                    this.showError(Messages.getString("Error.multiend"));
                    return;
                }
                FlowNode flowNode2 = (FlowNode)hashSet3.iterator().next();
                set22 = null;
                if (!hashSet5.isEmpty()) {
                    set22 = (FlowNode)hashSet5.iterator().next();
                } else if (!hashSet4.isEmpty()) {
                    set22 = (FlowNode)hashSet4.iterator().next();
                } else {
                    return;
                }
                object = ((FlowNode)((Object)set22)).getNexts();
                OnNodeActions.this.viewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit((String)this.getValue("Name")));
                OnNodeActions.this.viewer.getGraph().setAdjusting(true);
                OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createGraphAdjustingEdit(true, OnNodeActions.this.viewer.getGraph()));
                try {
                    Cloneable cloneable;
                    Object object22;
                    Object object32;
                    HashSet hashSet6 = new HashSet();
                    for (Object object32 : hashSet) {
                        hashSet6.addAll(object32.getIncidentEdges());
                        OnNodeActions.this.viewer.getGraph().removeVertex((Vertex)object32);
                    }
                    OnNodeActions.this.viewer.getPickedState().pick(hashSet, false);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createDeleteEdit(hashSet.toArray(new FlowNode[0]), hashSet6.toArray(new FlowEdge[0])));
                    FlowGraph flowGraph = new FlowGraph();
                    object32 = new FlowLayout(flowGraph);
                    FlowLayout flowLayout = OnNodeActions.this.viewer.getGraphLayout();
                    Rectangle rectangle = flowLayout.getVertexRect(hashSet);
                    Point point = new Point(100, 50);
                    int n = flowLayout.getGridDistance();
                    Point point2 = new Point(rectangle.x - rectangle.x % n, rectangle.y - rectangle.y % n);
                    for (Object object22 : hashSet) {
                        flowGraph.addVertex((Vertex)object22);
                        cloneable = flowLayout.getLocation((ArchetypeVertex)object22);
                        ((FlowLayout)((Object)object32)).addVertex((Vertex)object22, ((Point2D)cloneable).getX() - point2.getX(), ((Point2D)cloneable).getY() - point2.getY());
                    }
                    Object object4 = hashSet6.iterator();
                    while (object4.hasNext()) {
                        object22 = (FlowEdge)((Object)object4.next());
                        if (!hashSet.contains(((FlowEdge)((Object)object22)).getSource()) || !hashSet.contains(((FlowEdge)((Object)object22)).getDest())) continue;
                        flowGraph.addEdge((Edge)object22);
                    }
                    rectangle.grow(point.x, point.y);
                    object4 = new SubflowNodeModel(new ViewLayout((FlowLayout)((Object)object32), rectangle.getSize(), point), hashSet2.toArray(new FlowNode[0]), (FlowNode)((Object)set22));
                    object22 = new FlowNode((NodeModel)object4);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createBoxCreationEdit(flowGraph));
                    OnNodeActions.this.viewer.getGraphLayout().initLocation((Vertex)object22);
                    OnNodeActions.this.viewer.getGraph().addVertex((Vertex)object22);
                    cloneable = new HashSet();
                    if (flowNode2 != null) {
                        cloneable.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode2, (Vertex)object22)));
                    }
                    Object object5 = object.iterator();
                    while (object5.hasNext()) {
                        FlowNode flowNode3 = (FlowNode)object5.next();
                        if (!OnNodeActions.this.viewer.getGraph().getVertices().contains(flowNode3)) continue;
                        cloneable.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)object22, (Vertex)flowNode3)));
                    }
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createAddSublayoutEdit(new FlowNode[]{object22}, cloneable.toArray(new FlowEdge[0])));
                    object5 = OnNodeActions.this.viewer.getGraphLayout().getCentroid(hashSet);
                    OnNodeActions.this.viewer.getGraphLayout().forceMove((Vertex)object22, ((Point2D)object5).getX(), ((Point2D)object5).getY());
                    OnNodeActions.this.viewer.getPickedState().setPicked((ArchetypeVertex)object22);
                    OnNodeActions.this.viewer.requestFocusInWindow();
                }
                finally {
                    OnNodeActions.this.viewer.getGraph().setAdjusting(false);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createGraphAdjustingEdit(false, OnNodeActions.this.viewer.getGraph()));
                    OnNodeActions.this.viewer.undoableEditSupport.endUpdate();
                }
            }
        }

        private class UnfoldBox
        extends LoggableAction {
            UnfoldBox() {
                this.putValue("Name", Messages.getString("Action.unfold_box"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                if (!OnNodeActions.this.node.getModel().isOpenSubflow()) {
                    return;
                }
                SubflowNodeModel subflowNodeModel = (SubflowNodeModel)OnNodeActions.this.node.getModel();
                Set<FlowNode> set = subflowNodeModel.getIn().getNexts();
                set.remove(subflowNodeModel.getOut());
                FlowNode flowNode = null;
                if (subflowNodeModel.getOut().inDegree() > 0) {
                    flowNode = subflowNodeModel.getOut().getPreviousNode();
                }
                boolean bl = false;
                if (flowNode == subflowNodeModel.getIn()) {
                    bl = true;
                    flowNode = null;
                }
                FlowNode flowNode2 = null;
                if (OnNodeActions.this.node.inDegree() > 0) {
                    flowNode2 = OnNodeActions.this.node.getPreviousNode();
                }
                Set<FlowNode> set2 = OnNodeActions.this.node.getNexts();
                HashSet<FlowNode> hashSet = new HashSet<FlowNode>(subflowNodeModel.getLayouts()[0].getGraph().getVertices());
                hashSet.remove(subflowNodeModel.getIn());
                hashSet.remove(subflowNodeModel.getOut());
                ViewLayout viewLayout = subflowNodeModel.getLayouts()[0];
                OnNodeActions.this.viewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit(Messages.getString("Action.unfold_box")));
                OnNodeActions.this.viewer.getGraph().setAdjusting(true);
                OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createGraphAdjustingEdit(true, OnNodeActions.this.viewer.getGraph()));
                try {
                    Cloneable object;
                    HashSet hashSet2 = new HashSet(OnNodeActions.this.node.getIncidentEdges());
                    OnNodeActions.this.viewer.getGraph().removeVertex((Vertex)OnNodeActions.this.node);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createDeleteEdit(new FlowNode[]{OnNodeActions.this.node}, hashSet2.toArray(new FlowEdge[0])));
                    HashSet<FlowNode> hashSet3 = new HashSet<FlowNode>(viewLayout.getGraph().getVertices());
                    HashSet<FlowEdge> hashSet4 = new HashSet<FlowEdge>(viewLayout.getGraph().getEdges());
                    viewLayout.getGraph().removeAllVertices();
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createBoxUnfoldEdit(viewLayout.getGraph(), hashSet3, hashSet4));
                    if (viewLayout != null) {
                        object = null;
                        for (FlowNode hashSet52 : hashSet) {
                            Point2D point2D = viewLayout.getLocation((Vertex)hashSet52);
                            if (object == null) {
                                object = point2D;
                                continue;
                            }
                            if (!(((Point2D)object).getX() >= point2D.getX()) || !(((Point2D)object).getY() >= point2D.getY())) continue;
                            object = point2D;
                        }
                        Point2D point2D = OnNodeActions.this.viewer.getGraphLayout().getLocation((ArchetypeVertex)OnNodeActions.this.node);
                        for (FlowNode flowNode3 : hashSet) {
                            OnNodeActions.this.viewer.getGraphLayout().initLocation((Vertex)flowNode3);
                            OnNodeActions.this.viewer.getGraph().addVertex((Vertex)flowNode3);
                            Object object2 = viewLayout.getLocation((Vertex)flowNode3);
                            OnNodeActions.this.viewer.getGraphLayout().forceMove((Vertex)flowNode3, point2D.getX() - ((Point2D)object).getX() + ((Point2D)object2).getX(), point2D.getY() - ((Point2D)object).getY() + ((Point2D)object2).getY());
                        }
                        HashSet<Object> hashSet5 = new HashSet<Object>();
                        for (Object object2 : hashSet4) {
                            if (!hashSet.contains(object2.getSource()) || !hashSet.contains(object2.getDest())) continue;
                            OnNodeActions.this.viewer.getGraph().addEdge((Edge)object2);
                            hashSet5.add(object2);
                        }
                        OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createAddSublayoutEdit(hashSet.toArray(new FlowNode[0]), hashSet5.toArray(new FlowEdge[0])));
                    }
                    object = new HashSet<FlowEdge>();
                    if (flowNode2 != null) {
                        for (FlowNode flowNode4 : set) {
                            object.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode2, (Vertex)flowNode4)));
                        }
                    }
                    if (flowNode != null) {
                        for (FlowNode flowNode5 : set2) {
                            object.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode, (Vertex)flowNode5)));
                        }
                    }
                    if (bl && flowNode2 != null) {
                        for (FlowNode flowNode6 : set2) {
                            object.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode2, (Vertex)flowNode6)));
                        }
                    }
                    if (!object.isEmpty()) {
                        OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createAddEdgeEdit(object.toArray(new FlowEdge[0])));
                    }
                }
                finally {
                    OnNodeActions.this.viewer.getGraph().setAdjusting(false);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createGraphAdjustingEdit(false, OnNodeActions.this.viewer.getGraph()));
                    OnNodeActions.this.viewer.undoableEditSupport.endUpdate();
                }
                OnNodeActions.this.viewer.getPickedState().pick(hashSet, true);
            }
        }

        private class Property
        extends LoggableAction {
            Property() {
                this.putValue("Name", Messages.getStringWithDots("Action.property"));
                this.putValue("SmallIcon", Icons.getIcon("16/cog.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.editProperty(OnNodeActions.this.node);
            }
        }

        private class CreateComment
        extends LoggableAction {
            CreateComment() {
                this.putValue("Name", Messages.getString("Action.create_comment"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (!OnNodeActions.this.node.getComment().exists()) {
                    OnNodeActions.this.viewer.editComment(OnNodeActions.this.node);
                }
            }
        }

        private class RemoveComment
        extends LoggableAction {
            RemoveComment() {
                this.putValue("Name", Messages.getString("Action.remove_comment"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (OnNodeActions.this.node.getComment().exists()) {
                    OnNodeActions.this.viewer.flowModel.getState().setPoppedComment(null);
                    NodeComment nodeComment = OnNodeActions.this.node.getComment().copy();
                    OnNodeActions.this.node.getComment().removeComment();
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createNodeCommentChangeEdit(OnNodeActions.this.node, nodeComment));
                    FlowNode.fireNodeCommentChanged(OnNodeActions.this.node, nodeComment, OnNodeActions.this.node.getComment());
                    OnNodeActions.this.viewer.revalidate();
                    OnNodeActions.this.viewer.repaint();
                }
            }
        }

        private class SetBreakPoint
        extends LoggableAction {
            SetBreakPoint() {
                this.putValue("Name", Messages.getString("Action.set_breakpoint"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit(Messages.getString("Action.set_breakpoint")));
                try {
                    for (FlowNode flowNode : OnNodeActions.this.getSelectedNodes()) {
                        if (!flowNode.getModel().canSetBreakpoint()) continue;
                        flowNode.setBreakpointState(2);
                    }
                }
                finally {
                    OnNodeActions.this.viewer.undoableEditSupport.endUpdate();
                }
                Rflow.mainView().getBreakpointExplorer().update();
                OnNodeActions.this.viewer.repaint();
            }
        }

        private class UnsetBreakPoint
        extends LoggableAction {
            UnsetBreakPoint() {
                this.putValue("Name", Messages.getString("Action.unset_breakpoint"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                OnNodeActions.this.viewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit(Messages.getString("Action.unset_breakpoint")));
                for (FlowNode flowNode : OnNodeActions.this.getSelectedNodes()) {
                    flowNode.setBreakpointState(0);
                }
                OnNodeActions.this.viewer.undoableEditSupport.endUpdate();
                Rflow.mainView().getBreakpointExplorer().update();
                OnNodeActions.this.viewer.repaint();
            }
        }

        private class CreateList
        extends LoggableAction {
            CreateList() {
                this.putValue("Name", Messages.getString("Action.create_list_node"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                FlowNode flowNode;
                FlowSegment flowSegment = FlowUtil.getFlowSegment(OnNodeActions.this.viewer.getPickedState().getPickedVertices());
                if (flowSegment == null) {
                    return;
                }
                ArrayDeque<FlowNode> arrayDeque = new ArrayDeque<FlowNode>();
                arrayDeque.add(flowNode);
                for (flowNode = flowSegment.getEnd(); flowNode != null && flowNode != flowSegment.getStart(); flowNode = flowNode.getPreviousNode()) {
                    arrayDeque.addFirst(flowNode);
                }
                FlowNode flowNode2 = ((FlowNode)arrayDeque.getFirst()).getPreviousNode();
                Set<FlowNode> set = ((FlowNode)arrayDeque.getLast()).getNexts();
                OnNodeActions.this.viewer.undoableEditSupport.beginUpdate(new NamedCompoundEdit((String)this.getValue("Name")));
                OnNodeActions.this.viewer.getGraph().setAdjusting(true);
                OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createGraphAdjustingEdit(true, OnNodeActions.this.viewer.getGraph()));
                try {
                    HashSet hashSet = new HashSet();
                    for (FlowNode object22 : arrayDeque) {
                        hashSet.addAll(object22.getIncidentEdges());
                        OnNodeActions.this.viewer.getGraph().removeVertex((Vertex)object22);
                    }
                    OnNodeActions.this.viewer.getPickedState().pick(arrayDeque, false);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createDeleteEdit(arrayDeque.toArray(new FlowNode[0]), hashSet.toArray(new FlowEdge[0])));
                    ListNodeModel listNodeModel = new ListNodeModel();
                    for (FlowNode flowNode3 : arrayDeque) {
                        listNodeModel.addNode(flowNode3, null);
                    }
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createBoxCreationEdit(listNodeModel.getViewLayout().getGraph()));
                    FlowNode flowNode4 = new FlowNode(listNodeModel);
                    OnNodeActions.this.viewer.getGraphLayout().initLocation((Vertex)flowNode4);
                    OnNodeActions.this.viewer.getGraph().addVertex((Vertex)flowNode4);
                    HashSet<FlowEdge> hashSet2 = new HashSet<FlowEdge>();
                    if (flowNode2 != null) {
                        hashSet2.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode2, (Vertex)flowNode4)));
                    }
                    for (FlowNode flowNode5 : set) {
                        hashSet2.add((FlowEdge)OnNodeActions.this.viewer.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode4, (Vertex)flowNode5)));
                    }
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createAddSublayoutEdit(new FlowNode[]{flowNode4}, hashSet2.toArray(new FlowEdge[0])));
                    Point2D point2D = OnNodeActions.this.viewer.getGraphLayout().getCentroid(arrayDeque);
                    OnNodeActions.this.viewer.getGraphLayout().forceMoveOnGrid((Vertex)flowNode4, point2D.getX(), point2D.getY());
                }
                finally {
                    OnNodeActions.this.viewer.getGraph().setAdjusting(false);
                    OnNodeActions.this.viewer.fireUndoableEditUpdate(OnNodeActions.this.viewer.undoableEditFactory.createGraphAdjustingEdit(false, OnNodeActions.this.viewer.getGraph()));
                    OnNodeActions.this.viewer.undoableEditSupport.endUpdate();
                }
            }
        }
    }
}

