/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.ui.flow.FlowViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlowViewerScrollPane
extends JPanel
implements MouseWheelListener,
ComponentListener,
ChangeListener {
    private FlowViewer viewer;
    private FlowViewerScrollBar horizontalScrollBar;
    private FlowViewerScrollBar verticalScrollBar;
    private JComponent corner;
    private boolean allowAdjustment = true;
    private JPanel south;

    public FlowViewerScrollPane(FlowViewer flowViewer) {
        super(new BorderLayout());
        this.viewer = flowViewer;
        this.setOpaque(false);
        this.addComponentListener(this);
        this.verticalScrollBar = new FlowViewerScrollBar(false);
        this.horizontalScrollBar = new FlowViewerScrollBar(true);
        flowViewer.addChangeListener(this);
        flowViewer.addMouseWheelListener(this);
        this.add((Component)((Object)flowViewer));
        this.add((Component)this.verticalScrollBar, "East");
        this.south = new JPanel(new BorderLayout());
        this.south.add(this.horizontalScrollBar);
        this.setCorner(new JPanel());
        this.add((Component)this.south, "South");
    }

    private void setScrollBars(FlowViewer flowViewer) {
        Rectangle rectangle = flowViewer.getPaintedArea();
        Point point = rectangle.getLocation();
        Point2D point2D = flowViewer.transform(new Point2D.Float(point.x, point.y));
        point.translate(rectangle.width, rectangle.height);
        Point2D point2D2 = flowViewer.transform(new Point2D.Float(point.x, point.y));
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setFrameFromDiagonal(point2D, point2D2);
        if (rectangle.width > 0) {
            rectangle2.grow(20, 20);
        }
        Rectangle rectangle3 = flowViewer.getBounds();
        rectangle3.width -= this.verticalScrollBar.getWidth();
        rectangle3.height -= this.horizontalScrollBar.getHeight();
        Rectangle2D rectangle2D = rectangle2.createUnion(rectangle3);
        this.allowAdjustment = false;
        this.horizontalScrollBar.setValues((int)rectangle3.getMinX(), (int)rectangle3.getWidth(), (int)rectangle2D.getMinX(), (int)rectangle2D.getMaxX());
        this.verticalScrollBar.setValues((int)rectangle3.getMinY(), (int)rectangle3.getHeight(), (int)rectangle2D.getMinY(), (int)rectangle2D.getMaxY());
        this.allowAdjustment = true;
    }

    public JComponent getCorner() {
        return this.corner;
    }

    public void setCorner(JComponent jComponent) {
        this.corner = jComponent;
        jComponent.setPreferredSize(new Dimension(this.verticalScrollBar.getPreferredSize().width, this.horizontalScrollBar.getPreferredSize().height));
        this.south.add((Component)this.corner, "East");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.viewer.getPreferredSize();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        FlowViewerScrollBar flowViewerScrollBar = mouseWheelEvent.isShiftDown() ? this.horizontalScrollBar : this.verticalScrollBar;
        int n = flowViewerScrollBar.getUnitIncrement() * mouseWheelEvent.getWheelRotation();
        flowViewerScrollBar.setValueWithoutExpansion(flowViewerScrollBar.getValue() + n);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.verticalScrollBar.setBlockIncrement((int)((double)this.viewer.getSize().height * 0.9));
        this.horizontalScrollBar.setBlockIncrement((int)((double)this.viewer.getSize().width * 0.9));
        this.setScrollBars(this.viewer);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setScrollBars((FlowViewer)changeEvent.getSource());
    }

    private class FlowViewerScrollBar
    extends JScrollBar
    implements AdjustmentListener {
        private boolean horizontal;
        private int previous;

        public FlowViewerScrollBar(boolean bl) {
            super(bl ? 0 : 1, 0, 100, 0, 100);
            this.previous = 0;
            this.horizontal = bl;
            this.setUnitIncrement(40);
            this.setBlockIncrement(80);
            this.addAdjustmentListener(this);
        }

        @Override
        public void setValue(int n) {
            if (n < this.getMinimum()) {
                this.setMinimum(n);
            } else if (n + this.getModel().getExtent() > this.getMaximum()) {
                this.setMaximum(n + this.getModel().getExtent());
            }
            super.setValue(n);
        }

        public void setValueWithoutExpansion(int n) {
            super.setValue(n);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = adjustmentEvent.getValue();
            float f = this.previous - n;
            this.previous = n;
            if (f != 0.0f && FlowViewerScrollPane.this.allowAdjustment) {
                AffineTransform affineTransform = this.horizontal ? AffineTransform.getTranslateInstance(f, 0.0) : AffineTransform.getTranslateInstance(0.0, f);
                FlowViewerScrollPane.this.viewer.getLayoutTransformer().preConcatenate(affineTransform);
            }
        }
    }
}

