/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.console.BusyListener;
import com.ef_prime.rflow.core.app.r.console.CommandPlan;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.FlowStateEvent;
import com.ef_prime.rflow.core.flow.FlowStateEventHandler;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.flow.task.NodeTaskProperty;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.ButtonPanel;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowScrollPane;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.component.TreeDnDMoveHandler;
import com.ef_prime.rflow.ui.common.component.TreeIterator;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.tree.BasicTreeCellRenderer;
import com.ef_prime.rflow.ui.common.tree.MutableTreeNodeFlavor;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.flow.FlowExecutor;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.HighlightChangedEvent;
import com.ef_prime.rflow.ui.flow.RScriptExportView;
import com.ef_prime.rflow.ui.flow.rendering.NodeRendering;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.TreeUtils;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class NodeTaskExplorer
extends View
implements GraphEventListener,
BusyListener,
FlowStateEventHandler,
FlowNodeSelectionEventHandler,
ActiveViewEventHandler {
    private static final Logger LOGGER = Logger.getLogger(NodeTaskExplorer.class.getName());
    private JTree tree;
    private DefaultTreeModel model;
    private final TreeModelListener dirtyListener;
    private DropTargetHandler dropHandler;
    private TaskNodeRenderer taskNodeRenderer;
    private NodeTask[] copiedTasks = null;
    private static final String ACTION_SINGLE_SELECTION = "single";
    private TaskActions actions;
    private UndoManager undoManager = new UndoManager();
    private UndoableEditSupport undoableEditSupport = new UndoableEditSupport(this.tree);
    private HighlightChangedHandler highlightChangedHandler = new HighlightChangedHandler();
    private FlowModel flowModel;
    private NodeRendering nodeRendering;

    public NodeTaskExplorer() {
        FlowViewer.addGraphEventListener(this);
        EventManager.getInstance().registerEventHandler(FlowNodeSelectionEvent.class, this);
        EventManager.getInstance().registerEventHandler(HighlightChangedEvent.class, this.highlightChangedHandler);
        EventManager.getInstance().registerEventHandler(FlowStateEvent.class, this);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.taskNodeRenderer = new TaskNodeRenderer();
        this.dirtyListener = new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.setDirty();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.setDirty();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.setDirty();
            }

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.setDirty();
            }

            private void setDirty() {
                if (NodeTaskExplorer.this.flowModel != null) {
                    NodeTaskExplorer.this.flowModel.setDirty(true);
                }
            }
        };
        this.model = new DefaultTreeModel(this.createRootTaskGroup());
        this.tree = new RflowTree(this.model){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return null;
                }
                NodeTask nodeTask = (NodeTask)treePath.getLastPathComponent();
                Object object = nodeTask.getProperty().getComment();
                if (!(object != null && ((String)object).length() >= 1 || nodeTask.getProperty().isMain())) {
                    return null;
                }
                if (object == null) {
                    object = "";
                }
                object = UIUtility.escapeHtml((String)object);
                if (nodeTask.getProperty().isMain()) {
                    object = "<b></b><br>" + (String)object;
                }
                return "<html>" + (String)object + "</html>";
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                NodeTaskExplorer.this.dropHandler.drawTargetLine(graphics);
            }
        };
        this.tree.setEditable(true);
        this.tree.setFocusable(true);
        this.tree.setRequestFocusEnabled(true);
        this.tree.setToggleClickCount(3);
        this.tree.setCellRenderer(this.taskNodeRenderer);
        UIUtility.insertMouseListener(this.tree, new MouseHandler());
        this.tree.getSelectionModel().addTreeSelectionListener(new SelectionHandler());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.add(new RflowScrollPane(this.tree));
        DragSource dragSource = new DragSource();
        DragSourceHandler dragSourceHandler = new DragSourceHandler();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 3, dragSourceHandler);
        this.dropHandler = new DropTargetHandler(this.tree);
        new DropTarget(this.tree, this.dropHandler);
        this.actions = new TaskActions();
        this.actions.installActions(this.tree, true, 1);
        this.undoableEditSupport.addUndoableEditListener(this.undoManager);
    }

    @Override
    public String getTitle() {
        return Messages.getString("Explorer.task");
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("16/text_list_bullets.png");
    }

    @Override
    public boolean isIconOnly() {
        return true;
    }

    private NodeTask createRootTaskGroup() {
        NodeTaskGroup nodeTaskGroup = new NodeTaskGroup();
        nodeTaskGroup.getProperty().setTitle(Messages.getString("Explorer.task.root"));
        return nodeTaskGroup;
    }

    public NodeTask getRootTask() {
        return (NodeTask)this.model.getRoot();
    }

    public void init(NodeTask nodeTask) {
        Object object;
        this.copiedTasks = null;
        if (nodeTask == null) {
            nodeTask = this.createRootTaskGroup();
        }
        this.model.removeTreeModelListener(this.dirtyListener);
        NodeTask nodeTask2 = (NodeTask)this.model.getRoot();
        TreeIterator treeIterator = new TreeIterator(nodeTask2);
        while (treeIterator.hasNext()) {
            object = (NodeTask)treeIterator.next();
            this.removeTaskPropertyListener(((NodeTask)object).getProperty());
        }
        this.model.setRoot(nodeTask);
        this.model.addTreeModelListener(this.dirtyListener);
        object = new TreeIterator(nodeTask);
        while (((TreeIterator)object).hasNext()) {
            NodeTask nodeTask3 = (NodeTask)((TreeIterator)object).next();
            nodeTask3.getProperty().addPropertyChangeListener(new TaskPropertyListener(nodeTask3));
        }
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public void addTask(Set<FlowNode> set) {
        this.tree.clearSelection();
        NodeTask nodeTask = (NodeTask)this.model.getRoot();
        HashMap<FlowNode, ArrayList<NodeTaskEntry>> hashMap = new HashMap<FlowNode, ArrayList<NodeTaskEntry>>();
        this.undoableEditSupport.beginUpdate();
        for (FlowNode flowNode : new ArrayList<FlowNode>(set)) {
            if (flowNode.getModel() instanceof TunnelNodeModel) continue;
            NodeTaskEntry nodeTaskEntry = new NodeTaskEntry(flowNode);
            int n = nodeTask.getChildCount();
            this.insertTask(nodeTaskEntry, nodeTask, n);
            this.tree.addSelectionPath(new TreePath(new Object[]{nodeTask, nodeTaskEntry}));
            ArrayList<NodeTaskEntry> arrayList = (ArrayList<NodeTaskEntry>)hashMap.get(flowNode);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeTaskEntry>();
                hashMap.put(flowNode, arrayList);
            }
            arrayList.add(nodeTaskEntry);
        }
        this.undoableEditSupport.endUpdate();
    }

    private void insertTask(NodeTask nodeTask, NodeTask nodeTask2, int n) {
        this.model.insertNodeInto(nodeTask, nodeTask2, n);
        nodeTask.getProperty().addPropertyChangeListener(new TaskPropertyListener(nodeTask));
        this.undoableEditSupport.postEdit(new InsertEdit(nodeTask, nodeTask2));
    }

    public boolean isNode(Set<FlowNode> set) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>(set);
        for (FlowNode object : set) {
            hashSet.addAll(FlowUtil.getAllDescendants(object));
        }
        TreeIterator treeIterator = new TreeIterator((NodeTask)this.model.getRoot());
        while (treeIterator.hasNext()) {
            NodeTaskEntry nodeTaskEntry;
            NodeTask nodeTask = (NodeTask)treeIterator.next();
            if (!(nodeTask instanceof NodeTaskEntry) || !hashSet.contains((nodeTaskEntry = (NodeTaskEntry)nodeTask).getNode())) continue;
            return true;
        }
        return false;
    }

    public void removeNode(Set<FlowNode> set) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>(set);
        for (FlowNode object : set) {
            hashSet.addAll(FlowUtil.getAllDescendants(object));
        }
        this.undoableEditSupport.beginUpdate();
        TreeIterator treeIterator = new TreeIterator((NodeTask)this.model.getRoot());
        while (treeIterator.hasNext()) {
            NodeTaskEntry nodeTaskEntry;
            NodeTask nodeTask = (NodeTask)treeIterator.next();
            if (!(nodeTask instanceof NodeTaskEntry) || !hashSet.contains((nodeTaskEntry = (NodeTaskEntry)nodeTask).getNode())) continue;
            this.removeTask(nodeTaskEntry);
        }
        this.undoableEditSupport.endUpdate();
    }

    private void removeTask(NodeTask nodeTask) {
        NodeTask nodeTask2 = (NodeTask)nodeTask.getParent();
        if (nodeTask2 == null) {
            return;
        }
        int n = nodeTask2.getIndex(nodeTask);
        this.model.removeNodeFromParent(nodeTask);
        this.undoableEditSupport.postEdit(new RemoveEdit(nodeTask, nodeTask2, n));
        this.removeTaskPropertyListener(nodeTask.getProperty());
    }

    private void removeTaskPropertyListener(NodeTaskProperty nodeTaskProperty) {
        PropertyChangeListener[] propertyChangeListenerArray = nodeTaskProperty.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            if (!(propertyChangeListenerArray[i] instanceof TaskPropertyListener)) continue;
            nodeTaskProperty.removePropertyChangeListener(propertyChangeListenerArray[i]);
        }
    }

    private void moveNode(TreePath[] treePathArray, boolean bl) {
        if (treePathArray == null || treePathArray.length == 0 || treePathArray[0].getPathCount() == 1) {
            return;
        }
        NodeTask nodeTask = (NodeTask)treePathArray[0].getParentPath().getLastPathComponent();
        if (bl) {
            if (nodeTask.getIndex((NodeTask)treePathArray[0].getLastPathComponent()) == 0) {
                return;
            }
            this.undoableEditSupport.beginUpdate();
            for (int i = 0; i < treePathArray.length; ++i) {
                NodeTask nodeTask2 = (NodeTask)treePathArray[i].getLastPathComponent();
                int n = nodeTask.getIndex(nodeTask2);
                this.removeTask(nodeTask2);
                this.insertTask(nodeTask2, nodeTask, n - 1);
            }
            this.undoableEditSupport.endUpdate();
        } else {
            if (nodeTask.getIndex((NodeTask)treePathArray[treePathArray.length - 1].getLastPathComponent()) == nodeTask.getChildCount() - 1) {
                return;
            }
            this.undoableEditSupport.beginUpdate();
            for (int i = treePathArray.length - 1; i >= 0; --i) {
                NodeTask nodeTask3 = (NodeTask)treePathArray[i].getLastPathComponent();
                int n = nodeTask.getIndex(nodeTask3);
                this.removeTask(nodeTask3);
                this.insertTask(nodeTask3, nodeTask, n + 1);
            }
            this.undoableEditSupport.endUpdate();
        }
        this.tree.setSelectionPaths(treePathArray);
    }

    private void showPopup(JTree jTree, int n, int n2) {
        Object object;
        if (jTree.getSelectionPath() == null) {
            return;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (!TreeUtils.isSiblings(treePathArray)) {
            return;
        }
        boolean bl = treePathArray.length == 1;
        boolean bl2 = bl && treePathArray[0].getLastPathComponent() instanceof NodeTaskGroup;
        boolean bl3 = bl && ((NodeTask)treePathArray[0].getLastPathComponent()).getChildCount() > 0;
        this.actions.get("PASTE").setEnabled(this.copiedTasks != null);
        boolean bl4 = !Rflow.getInstance().isBusy() && (!bl2 || bl3) && this.flowModel != null;
        this.actions.get("RUN").setEnabled(bl4);
        this.actions.get("RUN_CLEAR").setEnabled(bl4);
        this.actions.get("RUN_CLEAR_EVERY_TASK").setEnabled(bl4);
        Object object2 = Messages.getString("Action.run");
        Object object3 = Messages.getString("Action.run_clear");
        Object object4 = Messages.getString("Action.run_clear_every_task");
        if (bl4) {
            FlowRunOption flowRunOption;
            CommandPlan commandPlan;
            FlowRunOption flowRunOption2;
            CommandPlan commandPlan2;
            FlowRunOption flowRunOption3;
            NodeTask nodeTask;
            object = Messages.getString("Action.cache_notice");
            String string = Messages.getString("Action.breakpoint_notice");
            FlowExecutor flowExecutor = this.flowModel.getExecutor();
            CommandPlan commandPlan3 = flowExecutor.getCommandPlan(nodeTask = (NodeTask)jTree.getSelectionPath().getLastPathComponent(), null, flowRunOption3 = new FlowRunOption().setExecRest(true).setUseCache(true).setDebug(true));
            if (commandPlan3.isLoadCache()) {
                object2 = (String)object2 + (String)object;
            }
            if (commandPlan3.isBrowse()) {
                object2 = (String)object2 + string;
            }
            if ((commandPlan2 = flowExecutor.getCommandPlan(nodeTask, null, flowRunOption2 = new FlowRunOption().setClearObjects(true).setUseCache(true).setClearOnce(true).setDebug(true))).isLoadCache()) {
                object3 = (String)object3 + (String)object;
            }
            if (commandPlan2.isBrowse()) {
                object3 = (String)object3 + string;
            }
            if ((commandPlan = flowExecutor.getCommandPlan(nodeTask, null, flowRunOption = new FlowRunOption().setClearObjects(true).setUseCache(true).setDebug(true))).isLoadCache()) {
                object4 = (String)object4 + (String)object;
            }
            if (commandPlan.isBrowse()) {
                object4 = (String)object4 + string;
            }
        }
        this.actions.get("RUN").putValue("Name", object2);
        this.actions.get("RUN_CLEAR").putValue("Name", object3);
        this.actions.get("RUN_CLEAR_EVERY_TASK").putValue("Name", object4);
        object = new JPopupMenu();
        if (bl) {
            ((JPopupMenu)object).add(this.actions.get("RUN_CLEAR"));
            if (bl2) {
                ((JPopupMenu)object).add(this.actions.get("RUN_CLEAR_EVERY_TASK"));
            }
            ((JPopupMenu)object).add(this.actions.get("RUN"));
            ((JPopupMenu)object).addSeparator();
            ((JPopupMenu)object).add(this.actions.get("CREATE_TASK_GROUP"));
        }
        ((JPopupMenu)object).add(this.actions.get("NEW_TASK_GROUP_FROM_SELECTION"));
        ((JPopupMenu)object).addSeparator();
        if (bl) {
            ((JPopupMenu)object).add(this.actions.get("OPEN_CONTAINING_BOX"));
            ((JPopupMenu)object).addSeparator();
        }
        ((JPopupMenu)object).add(this.actions.get("CUT"));
        ((JPopupMenu)object).add(this.actions.get("COPY"));
        if (bl) {
            ((JPopupMenu)object).add(this.actions.get("PASTE"));
        }
        ((JPopupMenu)object).add(this.actions.get("REMOVE"));
        ((JPopupMenu)object).addSeparator();
        if (bl) {
            ((JPopupMenu)object).add(this.actions.get("EXPORT_SCRIPT"));
            ((JPopupMenu)object).addSeparator();
            ((JPopupMenu)object).add(this.actions.get("PROPERTY"));
        }
        UIUtility.clearPopupSeparator((JPopupMenu)object);
        ((JPopupMenu)object).show(jTree, n, n2);
    }

    private void showPopupOnGround(JTree jTree, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new LoggableAction(Messages.getString("Action.create_task_group")){

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.model.getRoot();
                NodeTaskExplorer.this.model.insertNodeInto(NodeTaskGroup.createNewTaskGroup(), nodeTask, nodeTask.getChildCount());
            }
        });
        jPopupMenu.show(jTree, n, n2);
    }

    private boolean isTaskAlive(NodeTask nodeTask) {
        if (nodeTask.getNode() == null || this.flowModel == null) {
            return true;
        }
        Set<FlowNode> set = FlowUtil.getAllNodes(this.flowModel.getLayout().getGraph());
        return set.contains(nodeTask.getNode());
    }

    public TreePath[] getSelectedPaths(TreePath treePath) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return new TreePath[]{treePath};
        }
        boolean bl = this.tree.getSelectionModel().isPathSelected(treePath);
        if (bl && TreeUtils.isSiblings(treePathArray)) {
            return treePathArray;
        }
        if (bl) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
        return new TreePath[]{treePath};
    }

    private NodeTask[] getLastComponents(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return new NodeTask[0];
        }
        NodeTask[] nodeTaskArray = new NodeTask[treePathArray.length];
        for (int i = 0; i < nodeTaskArray.length; ++i) {
            nodeTaskArray[i] = (NodeTask)treePathArray[i].getLastPathComponent();
        }
        return nodeTaskArray;
    }

    public void edgeAdded(GraphEvent graphEvent) {
    }

    public void edgeRemoved(GraphEvent graphEvent) {
    }

    public void vertexAdded(GraphEvent graphEvent) {
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (flowGraph.isAdjusting()) {
            return;
        }
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        hashSet.add(flowNode);
        this.removeNode(hashSet);
    }

    @Override
    public void flowStateChanged(FlowStateEvent flowStateEvent) {
        FlowState flowState;
        if ("PROPERTY_NEXT_STEP_TASK".equals(flowStateEvent.getPropertyName()) && this.taskNodeRenderer.nextStepTask != (flowState = flowStateEvent.getState()).getNextStepTask()) {
            this.taskNodeRenderer.nextStepTask = flowState.getNextStepTask();
            this.tree.repaint();
        }
    }

    @Override
    public void busyStateChanged(int n) {
        boolean bl = n == 1;
        this.actions.get("RUN").setEnabled(!bl);
        this.actions.get("RUN_CLEAR").setEnabled(!bl);
    }

    @Override
    public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
        this.clearSelection();
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        FlowModel flowModel = activeViewEvent.getActiveFileEdit(FlowModel.class);
        if (this.flowModel != flowModel) {
            this.flowModel = flowModel;
            this.nodeRendering = this.flowModel == null ? null : new NodeRendering(this.flowModel.getState());
            this.init(this.flowModel == null ? null : this.flowModel.getRootTask());
        }
    }

    private class HighlightChangedHandler
    implements SimpleEventHandler {
        private HighlightChangedHandler() {
        }

        @Override
        public void onEvent(SimpleEvent simpleEvent) {
            HighlightChangedEvent highlightChangedEvent;
            if (simpleEvent.getClass().equals(HighlightChangedEvent.class) && !(highlightChangedEvent = (HighlightChangedEvent)simpleEvent).getState().isTaskHighlight()) {
                NodeTaskExplorer.this.clearSelection();
            }
        }
    }

    private class TaskNodeRenderer
    extends BasicTreeCellRenderer {
        NodeTask nextStepTask = null;
        private boolean dropTarget = false;

        private TaskNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            NodeTask nodeTask = (NodeTask)object;
            this.dropTarget = NodeTaskExplorer.this.dropHandler.isDropTargetNode(nodeTask);
            if (nodeTask == this.nextStepTask) {
                this.setIcon(FileResource.getIcon("img/desktop_16.png"));
            } else if (nodeTask.isLeaf() && nodeTask instanceof NodeTaskEntry) {
                NodeTaskEntry nodeTaskEntry = (NodeTaskEntry)nodeTask;
                if (NodeTaskExplorer.this.nodeRendering != null) {
                    this.setIcon(NodeTaskExplorer.this.nodeRendering.getSmallIcon((Vertex)nodeTaskEntry.getNode()));
                }
            }
            if (nodeTask.getParent() == null) {
                this.setText(Messages.getString("Explorer.task.root"));
            } else {
                this.setText(nodeTask.getParent().getIndex(nodeTask) + 1 + ". " + this.getText());
            }
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            Color color = this.backgroundNonSelectionColor;
            if (this.dropTarget) {
                this.backgroundNonSelectionColor = this.backgroundSelectionColor;
            }
            super.paint(graphics);
            this.backgroundNonSelectionColor = color;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            JTree jTree = (JTree)mouseEvent.getSource();
            TreePath treePath = jTree.getPathForLocation((int)(point = mouseEvent.getPoint()).getX(), (int)point.getY());
            if (treePath == null) {
                return;
            }
            if (jTree.isPathSelected(treePath)) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            JTree jTree = (JTree)mouseEvent.getSource();
            TreePath treePath = jTree.getPathForLocation((int)(point = mouseEvent.getPoint()).getX(), (int)point.getY());
            if (treePath == null) {
                jTree.clearSelection();
                if (UIUtility.isRightMouseButton(mouseEvent)) {
                    NodeTaskExplorer.this.showPopupOnGround(jTree, point.x, point.y);
                }
                return;
            }
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 2) {
                    NodeTaskExplorer.this.actions.doAction("PROPERTY");
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                if (!jTree.getSelectionModel().isPathSelected(treePath)) {
                    jTree.setSelectionPath(treePath);
                }
                NodeTaskExplorer.this.showPopup(jTree, point.x, point.y);
            }
        }
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            boolean bl = NodeTaskExplorer.this.tree.isSelectionEmpty() || TreeUtils.isSiblings(NodeTaskExplorer.this.tree.getSelectionPaths());
            Object object = NodeTaskExplorer.this.actions.allKeys();
            int n = ((Object[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                Boolean bl2 = (Boolean)NodeTaskExplorer.this.actions.get(object2).getValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION);
                boolean bl3 = bl && (bl2 == false || NodeTaskExplorer.this.tree.getSelectionCount() == 1);
                NodeTaskExplorer.this.actions.get(object2).setEnabled(bl3);
            }
            if (bl && !NodeTaskExplorer.this.tree.isSelectionEmpty() && !((object = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent()) instanceof NodeTaskEntry)) {
                NodeTaskExplorer.this.actions.get("OPEN_CONTAINING_BOX").setEnabled(false);
            }
            object = NodeTaskExplorer.this.getLastComponents(NodeTaskExplorer.this.tree.getSelectionPaths());
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            for (Object object3 : object) {
                arrayDeque.add(object3);
            }
            HashSet hashSet = new HashSet();
            while (!arrayDeque.isEmpty()) {
                NodeTask nodeTask = (NodeTask)arrayDeque.poll();
                if (nodeTask.getChildCount() > 0) {
                    Enumeration enumeration = (Enumeration)Utility.cast(nodeTask.children());
                    while (enumeration.hasMoreElements()) {
                        arrayDeque.add((NodeTask)enumeration.nextElement());
                    }
                    continue;
                }
                if (!(nodeTask instanceof NodeTaskEntry)) continue;
                hashSet.add(((NodeTaskEntry)nodeTask).getNode());
            }
            if (NodeTaskExplorer.this.flowModel != null) {
                EventManager.getInstance().removeEventHandler(HighlightChangedEvent.class, NodeTaskExplorer.this.highlightChangedHandler);
                NodeTaskExplorer.this.flowModel.getState().clearTaskHighlightNode();
                EventManager.getInstance().registerEventHandler(HighlightChangedEvent.class, NodeTaskExplorer.this.highlightChangedHandler);
                if (!hashSet.isEmpty()) {
                    NodeTaskExplorer.this.flowModel.getState().addTaskHighlightNode(hashSet);
                }
                Rflow.mainView().repaintFlow();
            }
            NodeTaskExplorer.this.tree.repaint();
        }
    }

    private class DragSourceHandler
    extends DragSourceAdapter
    implements DragGestureListener {
        private Set<MutableTreeNode> dragNodeSet = new HashSet<MutableTreeNode>();
        private Cursor MOVE_CURSOR;
        private Cursor COPY_CURSOR;
        private Cursor INVALID_CURSOR;

        DragSourceHandler() {
            try {
                this.MOVE_CURSOR = Cursor.getSystemCustomCursor("MoveDrop.32x32");
                this.COPY_CURSOR = Cursor.getSystemCustomCursor("CopyDrop.32x32");
                this.INVALID_CURSOR = Cursor.getSystemCustomCursor("InvalidDrop.32x32");
            }
            catch (Exception exception) {
                this.COPY_CURSOR = this.INVALID_CURSOR = Cursor.getDefaultCursor();
                this.MOVE_CURSOR = this.INVALID_CURSOR;
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(this.INVALID_CURSOR);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.dragNodeSet.clear();
            NodeTaskExplorer.this.tree.repaint();
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            this.setCursor(dragSourceDragEvent);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.setCursor(dragSourceDragEvent);
        }

        private void setCursor(DragSourceDragEvent dragSourceDragEvent) {
            if (dragSourceDragEvent.getTargetActions() != 0) {
                switch (dragSourceDragEvent.getUserAction()) {
                    case 1: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(this.COPY_CURSOR);
                        break;
                    }
                    case 2: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(this.MOVE_CURSOR);
                        break;
                    }
                    case 0: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(this.INVALID_CURSOR);
                    }
                }
            } else {
                dragSourceDragEvent.getDragSourceContext().setCursor(this.INVALID_CURSOR);
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if ((dragGestureEvent.getTriggerEvent().getModifiers() & 0x10) == 0) {
                return;
            }
            Point point = dragGestureEvent.getDragOrigin();
            TreePath treePath = NodeTaskExplorer.this.tree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            TreePath[] treePathArray = NodeTaskExplorer.this.getSelectedPaths(treePath);
            NodeTask[] nodeTaskArray = NodeTaskExplorer.this.getLastComponents(treePathArray);
            TaskTransferable taskTransferable = new TaskTransferable(nodeTaskArray);
            try {
                dragGestureEvent.getDragSource().startDrag(dragGestureEvent, Cursor.getDefaultCursor(), taskTransferable, this);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to start drag.", exception);
            }
            this.dragNodeSet.clear();
            for (NodeTask nodeTask : nodeTaskArray) {
                this.dragNodeSet.add(nodeTask);
            }
        }
    }

    private class DropTargetHandler
    extends TreeDnDMoveHandler {
        public DropTargetHandler(JTree jTree) {
            super(jTree, true);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            NodeTaskExplorer.this.tree.cancelEditing();
            super.dragOver(dropTargetDragEvent);
        }

        @Override
        protected void copyDragNode(DropTargetDropEvent dropTargetDropEvent, MutableTreeNode[] mutableTreeNodeArray, MutableTreeNode mutableTreeNode, int n) {
            int n2 = this.getCurrentTargetIndex();
            NodeTaskExplorer.this.undoableEditSupport.beginUpdate();
            for (int i = mutableTreeNodeArray.length - 1; i >= 0; --i) {
                NodeTaskExplorer.this.insertTask(((NodeTask)mutableTreeNodeArray[i]).copy(), (NodeTask)mutableTreeNode, n2);
            }
            NodeTaskExplorer.this.undoableEditSupport.endUpdate();
        }

        @Override
        protected void moveDragNode(DropTargetDropEvent dropTargetDropEvent, MutableTreeNode[] mutableTreeNodeArray, MutableTreeNode mutableTreeNode, int n) {
            NodeTaskExplorer.this.undoableEditSupport.beginUpdate();
            MutableTreeNode[] mutableTreeNodeArray2 = mutableTreeNodeArray;
            int n2 = mutableTreeNodeArray2.length;
            for (int i = 0; i < n2; ++i) {
                MutableTreeNode mutableTreeNode2 = mutableTreeNodeArray2[i];
                NodeTaskExplorer.this.removeTask((NodeTask)mutableTreeNode2);
            }
            int n3 = this.getCurrentTargetIndex();
            for (n2 = mutableTreeNodeArray.length - 1; n2 >= 0; --n2) {
                NodeTaskExplorer.this.insertTask((NodeTask)mutableTreeNodeArray[n2], (NodeTask)mutableTreeNode, n3);
            }
            NodeTaskExplorer.this.undoableEditSupport.endUpdate();
        }

        @Override
        protected void onDropComplete(MutableTreeNode[] mutableTreeNodeArray) {
            NodeTaskExplorer.this.tree.clearSelection();
        }

        @Override
        protected DataFlavor getNodeFlavor() {
            return NodeTaskFlavor.getInstance();
        }
    }

    private class TaskActions
    extends Actions {
        public TaskActions() {
            this.put("RUN", new Run());
            this.put("RUN_CLEAR", new RunClear());
            this.put("RUN_CLEAR_EVERY_TASK", new RunClearOnEveryTask());
            this.put("PROPERTY", new Property());
            this.put("REMOVE", new Remove());
            this.put("COPY", new Copy());
            this.put("CUT", new Cut());
            this.put("PASTE", new Paste());
            this.put("MOVE_UP", new MoveUp());
            this.put("MOVE_DOWN", new MoveDown());
            this.put("CREATE_TASK_GROUP", new CreateTaskGroup());
            this.put("NEW_TASK_GROUP_FROM_SELECTION", new NewTaskGroupFromSelection());
            this.put("OPEN_CONTAINING_BOX", new OpenContainingBox());
            this.put("EXPORT_SCRIPT", new ExportScript());
            this.put("UNDO", new Undo());
            this.put("REDO", new Redo());
        }

        private void remove() {
            NodeTaskExplorer.this.undoableEditSupport.beginUpdate();
            for (NodeTask nodeTask : NodeTaskExplorer.this.getLastComponents(NodeTaskExplorer.this.tree.getSelectionPaths())) {
                NodeTaskExplorer.this.removeTask(nodeTask);
            }
            NodeTaskExplorer.this.undoableEditSupport.endUpdate();
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (NodeTaskExplorer.this.flowModel == null) {
                    return;
                }
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                FlowExecutor flowExecutor = NodeTaskExplorer.this.flowModel.getExecutor();
                FlowRunOption flowRunOption = new FlowRunOption().setExecRest(true).setUseCache(true).setDebug(true);
                flowExecutor.run(nodeTask, flowRunOption);
            }
        }

        private class RunClear
        extends LoggableAction {
            public RunClear() {
                this.putValue("Name", Messages.getString("Action.run_clear"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (NodeTaskExplorer.this.flowModel == null) {
                    return;
                }
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                FlowExecutor flowExecutor = NodeTaskExplorer.this.flowModel.getExecutor();
                FlowRunOption flowRunOption = new FlowRunOption().setClearObjects(true).setUseCache(true).setClearOnce(true).setDebug(true);
                flowExecutor.run(nodeTask, flowRunOption);
            }
        }

        private class RunClearOnEveryTask
        extends LoggableAction {
            public RunClearOnEveryTask() {
                this.putValue("Name", Messages.getString("Action.run_clear_every_task"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (NodeTaskExplorer.this.flowModel == null) {
                    return;
                }
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                FlowExecutor flowExecutor = NodeTaskExplorer.this.flowModel.getExecutor();
                FlowRunOption flowRunOption = new FlowRunOption().setClearObjects(true).setUseCache(true).setDebug(true);
                flowExecutor.run(nodeTask, flowRunOption);
            }
        }

        private class Property
        extends LoggableAction {
            public Property() {
                this.putValue("Name", Messages.getStringWithDots("Action.property"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                TaskPropertyDialog taskPropertyDialog = new TaskPropertyDialog(Rflow.getInstance().getMainFrame(), nodeTask);
                taskPropertyDialog.setVisible(true);
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                TaskActions.this.remove();
            }
        }

        private class Copy
        extends LoggableAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTaskExplorer.this.copiedTasks = NodeTaskExplorer.this.getLastComponents(NodeTaskExplorer.this.tree.getSelectionPaths());
            }
        }

        private class Cut
        extends LoggableAction {
            public Cut() {
                this.putValue("Name", Messages.getString("Action.cut"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ((LoggableAction)NodeTaskExplorer.this.actions.get("COPY")).action(actionEvent);
                TaskActions.this.remove();
            }
        }

        private class Paste
        extends LoggableAction {
            public Paste() {
                this.putValue("Name", Messages.getString("Action.paste"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (NodeTaskExplorer.this.copiedTasks == null) {
                    return;
                }
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                NodeTaskExplorer.this.undoableEditSupport.beginUpdate();
                if (nodeTask instanceof NodeTaskEntry) {
                    NodeTaskGroup nodeTaskGroup = (NodeTaskGroup)nodeTask.getParent();
                    for (NodeTask nodeTask2 : NodeTaskExplorer.this.copiedTasks) {
                        NodeTaskExplorer.this.insertTask(nodeTask2.copy(), nodeTaskGroup, nodeTaskGroup.getIndex(nodeTask));
                    }
                } else if (nodeTask instanceof NodeTaskGroup) {
                    NodeTaskGroup nodeTaskGroup = (NodeTaskGroup)nodeTask;
                    for (NodeTask nodeTask3 : NodeTaskExplorer.this.copiedTasks) {
                        NodeTaskExplorer.this.insertTask(nodeTask3.copy(), nodeTaskGroup, nodeTaskGroup.getChildCount());
                    }
                }
                NodeTaskExplorer.this.undoableEditSupport.endUpdate();
            }
        }

        private class MoveUp
        extends LoggableAction {
            public MoveUp() {
                this.putValue("Name", Messages.getString("Action.move_up"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 8));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTaskExplorer.this.moveNode(NodeTaskExplorer.this.tree.getSelectionPaths(), true);
            }
        }

        private class MoveDown
        extends LoggableAction {
            public MoveDown() {
                this.putValue("Name", Messages.getString("Action.move_down"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 8));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTaskExplorer.this.moveNode(NodeTaskExplorer.this.tree.getSelectionPaths(), false);
            }
        }

        private class CreateTaskGroup
        extends LoggableAction {
            public CreateTaskGroup() {
                this.putValue("Name", Messages.getString("Action.create_task_group"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Object object;
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                NodeTaskGroup nodeTaskGroup = NodeTaskGroup.createNewTaskGroup();
                if (nodeTask instanceof NodeTaskEntry) {
                    object = (NodeTask)nodeTask.getParent();
                    if (object == null) {
                        return;
                    }
                    NodeTaskExplorer.this.insertTask(nodeTaskGroup, (NodeTask)object, object.getIndex(nodeTask));
                } else {
                    NodeTaskExplorer.this.insertTask(nodeTaskGroup, nodeTask, nodeTask.getChildCount());
                }
                object = new TreePath(NodeTaskExplorer.this.model.getPathToRoot(nodeTaskGroup));
                NodeTaskExplorer.this.tree.setSelectionPath((TreePath)object);
                NodeTaskExplorer.this.tree.startEditingAtPath((TreePath)object);
            }
        }

        private class NewTaskGroupFromSelection
        extends LoggableAction {
            public NewTaskGroupFromSelection() {
                this.putValue("Name", Messages.getString("Action.group_selected_tasks"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                TreePath[] treePathArray = NodeTaskExplorer.this.tree.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                NodeTaskGroup nodeTaskGroup = NodeTaskGroup.createNewTaskGroup();
                NodeTask nodeTask2 = (NodeTask)nodeTask.getParent();
                if (nodeTask2 == null) {
                    return;
                }
                NodeTaskExplorer.this.undoableEditSupport.beginUpdate();
                NodeTaskExplorer.this.insertTask(nodeTaskGroup, nodeTask2, nodeTask2.getIndex(nodeTask));
                TreePath treePath = new TreePath(NodeTaskExplorer.this.model.getPathToRoot(nodeTaskGroup));
                for (int i = 0; i < treePathArray.length; ++i) {
                    NodeTask nodeTask3 = (NodeTask)treePathArray[i].getLastPathComponent();
                    if (nodeTask3.getParent() == null) continue;
                    NodeTaskExplorer.this.removeTask(nodeTask3);
                    NodeTaskExplorer.this.insertTask(nodeTask3, nodeTaskGroup, nodeTaskGroup.getChildCount());
                }
                NodeTaskExplorer.this.undoableEditSupport.endUpdate();
                NodeTaskExplorer.this.tree.setSelectionPath(treePath);
                NodeTaskExplorer.this.tree.startEditingAtPath(treePath);
            }
        }

        private class OpenContainingBox
        extends LoggableAction {
            public OpenContainingBox() {
                this.putValue("Name", Messages.getString("Action.open_containing_box"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                if (nodeTask instanceof NodeTaskEntry) {
                    FlowNode flowNode = ((NodeTaskEntry)nodeTask).getNode();
                    FlowNode flowNode2 = flowNode.getParentNode();
                    if (flowNode2 == null) {
                        return;
                    }
                    Rflow.mainView().openViewer(flowNode2, ViewOpenType.OPEN_NEW);
                }
            }
        }

        private class ExportScript
        extends LoggableAction {
            public ExportScript() {
                this.putValue("Name", Messages.getStringWithDots("Action.copy_export_r_script"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, true);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                NodeTask nodeTask = (NodeTask)NodeTaskExplorer.this.tree.getSelectionPath().getLastPathComponent();
                if (NodeTaskExplorer.this.flowModel != null) {
                    RScriptExportView.show(Rflow.getInstance().getMainFrame(), NodeTaskExplorer.this.flowModel, nodeTask, null);
                }
            }
        }

        private class Undo
        extends LoggableAction {
            public Undo() {
                this.putValue("Name", Messages.getString("Action.undo"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (NodeTaskExplorer.this.undoManager.canUndo()) {
                    NodeTaskExplorer.this.tree.clearSelection();
                    NodeTaskExplorer.this.undoManager.undo();
                }
            }
        }

        private class Redo
        extends LoggableAction {
            public Redo() {
                this.putValue("Name", Messages.getString("Action.redo"));
                this.putValue(NodeTaskExplorer.ACTION_SINGLE_SELECTION, false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (NodeTaskExplorer.this.undoManager.canRedo()) {
                    NodeTaskExplorer.this.tree.clearSelection();
                    NodeTaskExplorer.this.undoManager.redo();
                }
            }
        }
    }

    private class TaskPropertyListener
    implements PropertyChangeListener {
        private NodeTask task;

        public TaskPropertyListener(NodeTask nodeTask) {
            this.task = nodeTask;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            NodeTaskExplorer.this.undoableEditSupport.postEdit(new PropertyEdit(this.task, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    }

    private class InsertEdit
    extends AbstractUndoableEdit {
        private NodeTask newTask;
        private NodeTask parentTask;
        private int index = -1;

        public InsertEdit(NodeTask nodeTask, NodeTask nodeTask2) {
            this.newTask = nodeTask;
            this.parentTask = nodeTask2;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (NodeTaskExplorer.this.isTaskAlive(this.newTask)) {
                if (this.index < 0 || this.index > this.parentTask.getChildCount()) {
                    this.index = this.parentTask.getChildCount() - 1;
                }
                NodeTaskExplorer.this.model.insertNodeInto(this.newTask, this.parentTask, this.index);
                NodeTaskExplorer.this.tree.addSelectionPath(new TreePath(NodeTaskExplorer.this.model.getPathToRoot(this.newTask)));
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.index = this.parentTask.getIndex(this.newTask);
            if (this.index >= 0) {
                NodeTaskExplorer.this.model.removeNodeFromParent(this.newTask);
            }
        }

        @Override
        public boolean isSignificant() {
            return NodeTaskExplorer.this.isTaskAlive(this.newTask);
        }
    }

    private class RemoveEdit
    extends AbstractUndoableEdit {
        private NodeTask removedTask;
        private NodeTask parentTask;
        private int index;

        public RemoveEdit(NodeTask nodeTask, NodeTask nodeTask2, int n) {
            this.removedTask = nodeTask;
            this.parentTask = nodeTask2;
            this.index = n;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.index = this.parentTask.getIndex(this.removedTask);
            if (this.index >= 0) {
                NodeTaskExplorer.this.model.removeNodeFromParent(this.removedTask);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.index < 0 || this.index > this.parentTask.getChildCount()) {
                this.index = this.parentTask.getChildCount() - 1;
            }
            if (NodeTaskExplorer.this.isTaskAlive(this.removedTask)) {
                NodeTaskExplorer.this.model.insertNodeInto(this.removedTask, this.parentTask, this.index);
                NodeTaskExplorer.this.tree.addSelectionPath(new TreePath(NodeTaskExplorer.this.model.getPathToRoot(this.removedTask)));
            }
        }

        @Override
        public boolean isSignificant() {
            return NodeTaskExplorer.this.isTaskAlive(this.removedTask);
        }
    }

    private static class ActionKeys {
        static final String RUN = "RUN";
        static final String RUN_CLEAR = "RUN_CLEAR";
        static final String RUN_CLEAR_EVERY_TASK = "RUN_CLEAR_EVERY_TASK";
        static final String PROPERTY = "PROPERTY";
        static final String REMOVE = "REMOVE";
        static final String COPY = "COPY";
        static final String CUT = "CUT";
        static final String PASTE = "PASTE";
        static final String MOVE_UP = "MOVE_UP";
        static final String MOVE_DOWN = "MOVE_DOWN";
        static final String CREATE_TASK_GROUP = "CREATE_TASK_GROUP";
        static final String NEW_TASK_GROUP_FROM_SELECTION = "NEW_TASK_GROUP_FROM_SELECTION";
        static final String OPEN_CONTAINING_BOX = "OPEN_CONTAINING_BOX";
        static final String EXPORT_SCRIPT = "EXPORT_SCRIPT";
        static final String UNDO = "UNDO";
        static final String REDO = "REDO";

        private ActionKeys() {
        }
    }

    private static class NodeTaskFlavor
    extends DataFlavor {
        private static final NodeTaskFlavor instance = new NodeTaskFlavor();

        private NodeTaskFlavor() {
            super(Array.class, "TaskFlavor");
        }

        public static NodeTaskFlavor getInstance() {
            return instance;
        }
    }

    private static class TaskTransferable
    implements Transferable {
        private NodeTask[] tasks;
        DataFlavor[] flavors = new DataFlavor[]{MutableTreeNodeFlavor.getInstance(), NodeTaskFlavor.getInstance()};

        public TaskTransferable(NodeTask[] nodeTaskArray) {
            this.tasks = (NodeTask[])nodeTaskArray.clone();
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.flavors[0]) || dataFlavor.equals(this.flavors[1])) {
                return this.tasks.clone();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!dataFlavor.equals(this.flavors[i])) continue;
                return true;
            }
            return false;
        }
    }

    private class TaskPropertyDialog
    extends JDialog {
        private JTextField title;
        private JTextArea comment;
        private NodeTask task;

        public TaskPropertyDialog(Window window, NodeTask nodeTask) {
            super(window);
            this.task = nodeTask;
            boolean bl = nodeTask.getParent() == null;
            this.setDefaultCloseOperation(2);
            this.setTitle(Messages.getString("Action.property"));
            this.getContentPane().setLayout(new BorderLayout());
            AC aC = new AC();
            if (!bl) {
                aC = aC.gap().gap();
            }
            aC = aC.gap().grow().gap().shrink();
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("10").fill(), new AC(), aC));
            jPanel.setPreferredSize(new Dimension(600, 400));
            this.add(jPanel);
            this.title = new JTextField(nodeTask.getProperty().getTitle());
            this.comment = new JTextArea(nodeTask.getProperty().getComment());
            if (!bl) {
                jPanel.add((Component)new JLabel(Messages.getString("Message.title")), new CC().wrap());
                jPanel.add((Component)this.title, new CC().growX().wrap());
            }
            jPanel.add((Component)new JLabel(Messages.getString("Message.comment")), new CC().wrap());
            jPanel.add((Component)new JScrollPane(this.comment), new CC().grow().wrap());
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TaskPropertyDialog.this.task.getProperty().setTitle(TaskPropertyDialog.this.title.getText());
                    TaskPropertyDialog.this.task.getProperty().setComment(TaskPropertyDialog.this.comment.getText());
                    NodeTaskExplorer.this.model.nodeChanged(TaskPropertyDialog.this.task);
                    TaskPropertyDialog.this.dispose();
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TaskPropertyDialog.this.dispose();
                }
            };
            final ButtonPanel buttonPanel = new ButtonPanel(actionListener, actionListener2);
            jPanel.add((Component)buttonPanel, new CC().alignX("center"));
            this.title.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        buttonPanel.getFirstButton().requestFocusInWindow();
                    }
                }
            });
            this.pack();
            this.setLocationRelativeTo(null);
        }
    }

    private class PropertyEdit
    extends AbstractUndoableEdit {
        private NodeTask t;
        private String key;
        private Object oldValue;
        private Object newValue;

        public PropertyEdit(NodeTask nodeTask, String string, Object object, Object object2) {
            this.t = nodeTask;
            this.key = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (NodeTaskExplorer.this.isTaskAlive(this.t)) {
                this.t.getProperty().put(this.key, this.newValue.toString());
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (NodeTaskExplorer.this.isTaskAlive(this.t)) {
                this.t.getProperty().put(this.key, this.oldValue.toString());
            }
        }

        @Override
        public boolean isSignificant() {
            return NodeTaskExplorer.this.isTaskAlive(this.t);
        }
    }
}

