/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowSettings;
import com.ef_prime.rflow.core.flow.RScriptExporter;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.FileEvent;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rtextarea.RTextArea;

public class RScriptExportView
extends PagesView
implements ValueChangeEventHandler,
Supplier<String> {
    private FlowModel flowModel;
    private NodeTask task;
    private NodeTask selection;
    protected ExportModel exportModel;
    private RScriptPreview scriptPreview;

    public RScriptExportView(Window window, FlowModel flowModel, NodeTask nodeTask, NodeTask nodeTask2) {
        this.flowModel = flowModel;
        this.task = nodeTask;
        this.selection = nodeTask2;
        this.exportModel = new ExportModel();
        this.initExportModel();
        this.scriptPreview = new RScriptPreview(this, Messages.getString("View.preview"));
        this.scriptPreview.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.scriptPreview.setPreferredSize(new Dimension(600, 300));
        Component component = WidgetFactory.getInstance().create(this.exportModel, this.getWidgetNode());
        View view2 = new View();
        view2.add(component);
        view2.add((Component)this.scriptPreview, "South");
        this.setPage(new Page(view2));
        this.scriptPreview.refreshPreview();
        this.exportModel.addEventHandler(this);
    }

    protected void initExportModel() {
        String string;
        if (this.task == null) {
            this.exportModel.putValue(ExportModel.TARGET, "selection");
        }
        NodeTask nodeTask = this.task == null ? this.selection : this.task;
        String string2 = nodeTask.getProperty().getTitle() + ".R";
        this.exportModel.putValue(ExportModel.FILE, FileUtility.toLegalFileName(string2));
        FlowSettings flowSettings = this.flowModel.getFlowSetting();
        try {
            string = flowSettings.getValue(FlowSettings.EXPORT_ENCODING);
            if (string.equals("SystemDefault")) {
                this.exportModel.putValue(ExportModel.ENCODING, "SystemDefault");
            } else {
                Charset charset = string.isEmpty() ? Rflow.project().getCharset(null) : Charset.forName(string);
                this.exportModel.putValue(ExportModel.ENCODING, charset == null ? "SystemDefault" : charset.name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = flowSettings.getValue(FlowSettings.EXPORT_NEWLINE);
            if (string.isEmpty()) {
                string = Rflow.project().getNewline();
            }
            this.exportModel.putValue(ExportModel.NEWLINE, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exportModel.putValue(ExportModel.TITLE, flowSettings.getValue(FlowSettings.EXPORT_NODE_NAMES));
        this.exportModel.putValue(ExportModel.COMMENT, flowSettings.getValue(FlowSettings.EXPORT_COMMENT));
        this.exportModel.putValue(ExportModel.CHECK_REQUIRED_PACKAGES, flowSettings.getValue(FlowSettings.EXPORT_CHECK_REQUIRED_PACKAGES));
    }

    public static void show(Window window, FlowModel flowModel, NodeTask nodeTask, NodeTask nodeTask2) {
        RScriptExportView rScriptExportView = new RScriptExportView(window, flowModel, nodeTask, nodeTask2);
        rScriptExportView.showDialog(window, Messages.getString("Action.copy_export_r_script"), false, null);
    }

    @Override
    protected boolean viewWillClose(int n) {
        if (n == 1) {
            return this.export();
        }
        return super.viewWillClose(n);
    }

    @Override
    protected Component createButtons() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 10 0 0 0, fill", "[grow][][][]"));
        String string = "w 120";
        JButton jButton = new JButton(Messages.getString("Action.copy"), Icons.getIcon("16/page_white_copy.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RScriptExportView.this.copy();
            }
        });
        this.nextButton = this.createNextButton();
        this.cancelButton = this.createCancelButton();
        jPanel.add(new JLabel());
        jPanel.add((Component)jButton, string);
        jPanel.add((Component)this.nextButton, string);
        jPanel.add((Component)this.cancelButton, string);
        return jPanel;
    }

    @Override
    protected String getFinishButtonTitle() {
        return Messages.getString("Button.save");
    }

    @Override
    protected Icon getFinishButtonIcon() {
        return Icons.getIcon("16/diskette.png");
    }

    @Override
    public String get() {
        return this.getScript();
    }

    protected String getScript() {
        NodeTask nodeTask = this.exportModel.isSelectionTarget() ? this.selection : this.task;
        String string = this.exportModel.getValue(ExportModel.NEWLINE);
        String string2 = "\n";
        switch (string) {
            case "SystemDefault": {
                string2 = System.getProperty("line.separator");
                if (string2 != null) break;
                string2 = "\n";
                break;
            }
            case "CRLF": {
                string2 = "\r\n";
                break;
            }
            case "LF": {
                string2 = "\n";
                break;
            }
            case "CR": {
                string2 = "\r";
            }
        }
        boolean bl = this.isIncludeAttach();
        return RScriptExporter.script(this.flowModel.getExecutor(), nodeTask, string2, bl, this.exportModel.getValue(ExportModel.TITLE), this.exportModel.getValue(ExportModel.COMMENT), this.exportModel.getValue(ExportModel.CHECK_REQUIRED_PACKAGES));
    }

    protected boolean isIncludeAttach() {
        return true;
    }

    private void copy() {
        UIUtility.copyToClipboard(this.getScript());
    }

    private boolean export() {
        Object object;
        Charset charset;
        File file = WorkingDirectory.toAbsolutePath(new File(this.exportModel.getValue(ExportModel.FILE)));
        String string = this.exportModel.getValue(ExportModel.ENCODING);
        if (string.equals("SystemDefault")) {
            charset = Charset.defaultCharset();
        } else {
            charset = Charset.forName(string);
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
        }
        try {
            object = this.getScript();
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), charset, new OpenOption[0]);){
                bufferedWriter.write((String)object);
            }
            EventManager.getInstance().dispatchEvent(new FileEvent(file));
        }
        catch (IOException iOException) {
            UIUtility.showErrorDialog((Component)this, iOException);
            return false;
        }
        object = this.flowModel.getFlowSetting();
        ((ValueMap)object).putValue(FlowSettings.EXPORT_ENCODING, string);
        ((ValueMap)object).putValue(FlowSettings.EXPORT_NEWLINE, this.exportModel.getValue(ExportModel.NEWLINE));
        ((ValueMap)object).putValue(FlowSettings.EXPORT_NODE_NAMES, this.exportModel.getValue(ExportModel.TITLE));
        ((ValueMap)object).putValue(FlowSettings.EXPORT_COMMENT, this.exportModel.getValue(ExportModel.COMMENT));
        ((ValueMap)object).putValue(FlowSettings.EXPORT_CHECK_REQUIRED_PACKAGES, this.exportModel.getValue(ExportModel.CHECK_REQUIRED_PACKAGES));
        return true;
    }

    protected WidgetNode getWidgetNode() {
        PanelWidgetNode panelWidgetNode = new PanelWidgetNode();
        if (this.task != null && this.selection != null) {
            panelWidgetNode.addKeys(ExportModel.TARGET);
        }
        panelWidgetNode.addKeys(ExportModel.FILE, ExportModel.ENCODING, ExportModel.NEWLINE, ExportModel.TITLE, ExportModel.COMMENT, ExportModel.CHECK_REQUIRED_PACKAGES);
        return panelWidgetNode;
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        this.scriptPreview.refreshPreview();
    }

    protected static class ExportModel
    extends ValueMap {
        static final String TARGET_SELECTION = "selection";
        static final RadioButtonKey TARGET = ((RadioButtonKey.Builder)RadioButtonKey.builder("target", Messages.getString("View.RScriptExport.target")).setValuesAndLabels("flow", Messages.getString("View.RScriptExport.flow"), "selection", Messages.getString("View.RScriptExport.selection"))).build();
        static final FileKey FILE = FileKey.builder("file", Messages.getString("View.RScriptExport.file")).build();
        static final ChoiceKey ENCODING = ((ChoiceKey.Builder)ChoiceKey.builder("encoding", Messages.getString("View.RScriptExport.encoding")).setChoices(ExportModel.encodings())).build();
        static final ChoiceKey NEWLINE = ((ChoiceKey.Builder)ChoiceKey.builder("newline", Messages.getString("View.RScriptExport.newline")).setValuesAndLabels("SystemDefault", Messages.getString("Message.system_default") + " (" + ExportModel.newline() + ")", "CRLF", "CRLF", "LF", "LF", "CR", "CR")).build();
        static final BoolKey TITLE = ((BoolKey.Builder)BoolKey.builder("title", Messages.getString("View.RScriptExport.include_node_name")).noLabel()).build();
        static final BoolKey COMMENT = ((BoolKey.Builder)BoolKey.builder("comment", Messages.getString("View.RScriptExport.include_comment")).noLabel()).build();
        static final BoolKey CHECK_REQUIRED_PACKAGES = ((BoolKey.Builder)BoolKey.builder("packages", Messages.getString("View.RScriptExport.check_required_packeges")).noLabel()).build();

        private static String newline() {
            String string = System.getProperty("line.separator");
            if (string == null) {
                string = "\n";
            }
            switch (string) {
                case "\r\n": {
                    string = "CRLF";
                    break;
                }
                case "\n": {
                    string = "LF";
                    break;
                }
                case "\r": {
                    string = "CR";
                    break;
                }
                default: {
                    string = "LF";
                }
            }
            return string;
        }

        private static List<Choice> encodings() {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            arrayList.add(new Choice("SystemDefault", Messages.getString("Message.system_default") + " (" + Charset.defaultCharset().displayName() + ")"));
            HashSet<Charset> hashSet = new HashSet<Charset>();
            for (Charset charset : new Charset[]{StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII}) {
                hashSet.add(charset);
                arrayList.add(new Choice(charset.name()));
            }
            for (Charset charset : Charset.availableCharsets().values()) {
                if (!charset.isRegistered() || hashSet.contains(charset)) continue;
                arrayList.add(new Choice(charset.name()));
            }
            return arrayList;
        }

        public ExportModel() {
            this.registerKeys(TARGET, FILE, ENCODING, NEWLINE, TITLE, COMMENT, CHECK_REQUIRED_PACKAGES);
        }

        public boolean isSelectionTarget() {
            return this.getValue(TARGET).equals(TARGET_SELECTION);
        }
    }

    private static class RScriptPreview
    extends JPanel {
        private Supplier<String> scriptSupplier;
        private RCodingTextArea textArea;
        private SimpleCodingScrollPane scrollPane;

        public RScriptPreview(Supplier<String> supplier, String string) {
            this.scriptSupplier = supplier;
            this.textArea = new RCodingTextArea();
            this.textArea.setEditable(false);
            this.textArea.setUneditableBackgroundColor();
            this.scrollPane = new SimpleCodingScrollPane((RTextArea)this.textArea);
            CodingSearchBar codingSearchBar = new CodingSearchBar(this.textArea);
            this.setLayout(new BorderLayout());
            if (string != null) {
                this.add((Component)new JLabel(string), "North");
            }
            this.add((Component)((Object)this.scrollPane), "Center");
            this.add((Component)codingSearchBar, "South");
        }

        public void refreshPreview() {
            int n = this.scrollPane.getVerticalScrollBar().getValue();
            this.textArea.setStopCaretScroll(true);
            this.textArea.setText(this.scriptSupplier.get());
            this.textArea.discardAllEdits();
            this.scrollPane.getVerticalScrollBar().setValue(n);
            SwingUtilities.invokeLater(() -> this.textArea.setStopCaretScroll(false));
        }
    }
}

