/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowSegment;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.NamedCompoundEdit;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.RScriptExportView;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class RScriptizeView
extends RScriptExportView {
    private String title;
    private FlowViewer viewer;
    private FlowSegment segment;

    public RScriptizeView(Window window, String string, FlowViewer flowViewer, FlowModel flowModel, FlowSegment flowSegment) {
        super(window, flowModel, null, new NodeTaskEntry(flowSegment.getEnd(), flowSegment.getStart()));
        this.title = string;
        this.viewer = flowViewer;
        this.segment = flowSegment;
    }

    @Override
    protected void initExportModel() {
        this.exportModel.putValue(RScriptExportView.ExportModel.TARGET, "selection");
        this.exportModel.putValue(RScriptExportView.ExportModel.NEWLINE, "LF");
    }

    @Override
    protected WidgetNode getWidgetNode() {
        return new PanelWidgetNode().addKeys(RScriptExportView.ExportModel.TITLE, RScriptExportView.ExportModel.COMMENT);
    }

    public static void show(Window window, String string, FlowViewer flowViewer, FlowModel flowModel, FlowSegment flowSegment) {
        RScriptizeView rScriptizeView = new RScriptizeView(window, string, flowViewer, flowModel, flowSegment);
        rScriptizeView.showDialog(window, string, true, null);
    }

    @Override
    protected boolean viewWillClose(int n) {
        if (n == 1) {
            return this.merge();
        }
        return super.viewWillClose(n);
    }

    @Override
    protected String getFinishButtonTitle() {
        return Messages.getString("Button.ok") + " ";
    }

    @Override
    protected Icon getFinishButtonIcon() {
        return Icons.getIcon("16/tick.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean merge() {
        List<FlowNode> list = FlowUtil.getStreamSimple(this.segment.getEnd());
        list = list.subList(list.indexOf(this.segment.getStart()), list.size());
        String string = this.getScript();
        NamedCompoundEdit namedCompoundEdit = new NamedCompoundEdit(this.title);
        this.viewer.getUndoableEditSupport().beginUpdate(namedCompoundEdit);
        try {
            FlowNode flowNode3;
            FlowNode flowNode2 = list.get(0).getPreviousNode();
            Set<FlowNode> set = this.segment.getEnd().getNexts();
            HashSet hashSet = new HashSet();
            for (FlowNode flowNode3 : list) {
                hashSet.addAll(flowNode3.getIncidentEdges());
                this.viewer.getGraph().removeVertex((Vertex)flowNode3);
            }
            this.viewer.fireUndoableEditUpdate(this.viewer.undoableEditFactory.createDeleteEdit(list.toArray(new FlowNode[0]), hashSet.toArray(new FlowEdge[0])));
            FreeNodeModel freeNodeModel = new FreeNodeModel(string);
            flowNode3 = new FlowNode(freeNodeModel);
            this.viewer.getGraphLayout().initLocation((Vertex)flowNode3);
            this.viewer.getGraph().addVertex((Vertex)flowNode3);
            Point2D point2D = this.viewer.getGraphLayout().getCentroid(list);
            this.viewer.getGraphLayout().forceMove((Vertex)flowNode3, point2D.getX(), point2D.getY());
            this.viewer.fireUndoableEditUpdate(this.viewer.undoableEditFactory.createAddNodeEdit(flowNode3));
            HashSet<Object> hashSet2 = new HashSet<Object>();
            if (flowNode2 != null) {
                FlowEdge flowEdge = new FlowEdge((Vertex)flowNode2, (Vertex)flowNode3);
                hashSet2.add((Object)flowEdge);
                this.viewer.getGraph().addEdge((Edge)flowEdge);
            }
            if (!set.isEmpty()) {
                for (FlowNode flowNode4 : set) {
                    FlowEdge flowEdge = new FlowEdge((Vertex)flowNode3, (Vertex)flowNode4);
                    hashSet2.add((Object)flowEdge);
                    this.viewer.getGraph().addEdge((Edge)flowEdge);
                }
            }
            if (!hashSet2.isEmpty()) {
                this.viewer.fireUndoableEditUpdate(this.viewer.undoableEditFactory.createAddEdgeEdit(hashSet2.toArray(new FlowEdge[0])));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.viewer.getUndoableEditSupport().endUpdate();
        }
    }

    @Override
    protected boolean isIncludeAttach() {
        return false;
    }
}

