/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow;

import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.SubflowState;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.flow.CacheHandler;
import com.ef_prime.rflow.ui.flow.DefaultUndoableEdits;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoableEditFactory {
    private ViewLayout viewLayout;
    private SubflowState state;

    public UndoableEditFactory(ViewLayout viewLayout, SubflowState subflowState) {
        this.viewLayout = viewLayout;
        this.state = subflowState;
        if (this.state == null) {
            this.state = new SubflowState();
        }
    }

    public UndoableEdit createAddNodeEdit(FlowNode flowNode) {
        return new DefaultUndoableEdits.AddNodeEdit(this.viewLayout, this.state, flowNode);
    }

    public UndoableEdit createDeleteEdit(final FlowNode[] flowNodeArray, final FlowEdge[] flowEdgeArray) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                if (flowNodeArray != null) {
                    for (FlowNode flowNode : flowNodeArray) {
                        UndoableEditFactory.this.viewLayout.getGraph().addVertex((Vertex)flowNode);
                    }
                }
                if (flowEdgeArray != null) {
                    for (FlowEdge flowEdge : flowEdgeArray) {
                        UndoableEditFactory.this.viewLayout.getGraph().addEdge((Edge)flowEdge);
                    }
                }
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                if (flowNodeArray != null) {
                    for (FlowNode flowNode : flowNodeArray) {
                        UndoableEditFactory.this.viewLayout.getGraph().removeVertex((Vertex)flowNode);
                    }
                }
                if ((flowNodeArray == null || flowNodeArray.length == 0) && flowEdgeArray != null) {
                    for (FlowEdge flowEdge : flowEdgeArray) {
                        UndoableEditFactory.this.viewLayout.getGraph().removeEdge((Edge)flowEdge);
                    }
                }
            }

            @Override
            public String getPresentationName() {
                if (flowNodeArray != null && flowNodeArray.length > 0) {
                    return Messages.getString("Action.remove_node");
                }
                return Messages.getString("Action.remove_edge");
            }
        };
    }

    public UndoableEdit createAddEdgeEdit(final FlowEdge[] flowEdgeArray) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                for (FlowEdge flowEdge : flowEdgeArray) {
                    UndoableEditFactory.this.viewLayout.getGraph().removeEdge((Edge)flowEdge);
                }
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (FlowEdge flowEdge : flowEdgeArray) {
                    UndoableEditFactory.this.viewLayout.getGraph().addEdge((Edge)flowEdge);
                }
            }

            @Override
            public String getPresentationName() {
                return Messages.getString("Action.new_edge");
            }
        };
    }

    public UndoableEdit createAddSublayoutEdit(final FlowNode[] flowNodeArray, final FlowEdge[] flowEdgeArray) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                for (FlowNode flowNode : flowNodeArray) {
                    UndoableEditFactory.this.viewLayout.getGraph().removeVertex((Vertex)flowNode);
                }
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (FlowNode flowNode : flowNodeArray) {
                    UndoableEditFactory.this.viewLayout.getGraph().addVertex((Vertex)flowNode);
                }
                for (FlowEdge flowEdge : flowEdgeArray) {
                    UndoableEditFactory.this.viewLayout.getGraph().addEdge((Edge)flowEdge);
                }
            }

            @Override
            public String getPresentationName() {
                return Messages.getString("Action.add_subflow");
            }
        };
    }

    public UndoableEdit createMoveNodeEdit(final Map<Vertex, Point2D> map) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                this.setLocation();
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                this.setLocation();
            }

            private void setLocation() {
                for (Map.Entry entry : map.entrySet()) {
                    Vertex vertex = (Vertex)entry.getKey();
                    Point2D point2D = (Point2D)entry.getValue();
                    map.put(vertex, (Point2D)UndoableEditFactory.this.viewLayout.getLayout().getLocation((ArchetypeVertex)vertex).clone());
                    UndoableEditFactory.this.viewLayout.getLayout().forceMove(vertex, point2D.getX(), point2D.getY());
                }
            }

            @Override
            public String getPresentationName() {
                return Messages.getString("Action.move_node");
            }
        };
    }

    UndoableEdit createNodeModelEnabledEdit(final FlowNode flowNode, final boolean bl) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                this.setEnabled(!bl);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                this.setEnabled(bl);
            }

            private void setEnabled(boolean bl2) {
                if (flowNode.getModel().canBeDisabled() && flowNode.getModel().isDisabled() != !bl2) {
                    flowNode.getModel().setDisabled(!bl2);
                    FlowNode.fireNodeModelChanged(flowNode);
                }
            }

            @Override
            public String getPresentationName() {
                return bl ? Messages.getString("Action.enable") : Messages.getString("Action.disable");
            }
        };
    }

    UndoableEdit createNodeCommentChangeEdit(final FlowNode flowNode, final NodeComment nodeComment) {
        return new AbstractUndoableEdit(){
            private NodeComment comment;
            {
                this.comment = nodeComment;
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                this.switchComment();
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                this.switchComment();
            }

            private void switchComment() {
                NodeComment nodeComment2 = flowNode.getComment();
                flowNode.setComment(this.comment);
                this.comment = nodeComment2;
                UndoableEditFactory.this.state.setPicked((ArchetypeVertex)flowNode);
            }

            @Override
            public String getPresentationName() {
                return Messages.getString("Action.edit_node_comment");
            }
        };
    }

    public UndoableEdit createGraphAdjustingEdit(final boolean bl, final FlowGraph flowGraph) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                flowGraph.setAdjusting(!bl);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                flowGraph.setAdjusting(bl);
            }
        };
    }

    public UndoableEdit createAndSetClearCache(FlowNode flowNode, CacheHandler cacheHandler, boolean bl, boolean bl2) {
        DefaultUndoableEdits.ClearCacheEdit clearCacheEdit = new DefaultUndoableEdits.ClearCacheEdit(cacheHandler, flowNode, bl, bl2);
        flowNode.setClearCacheEdit(clearCacheEdit);
        return clearCacheEdit;
    }

    public UndoableEdit createBoxCreationEdit(final FlowGraph flowGraph) {
        return new AbstractUndoableEdit(){
            HashSet<FlowNode> nodes;
            HashSet<FlowEdge> edges;
            {
                this.nodes = new HashSet(flowGraph.getVertices());
                this.edges = new HashSet(flowGraph.getEdges());
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                flowGraph.removeVertices(this.nodes);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (FlowNode object : this.nodes) {
                    flowGraph.addVertex((Vertex)object);
                }
                for (FlowEdge flowEdge : this.edges) {
                    flowGraph.addEdge((Edge)flowEdge);
                }
            }
        };
    }

    public UndoableEdit createBoxUnfoldEdit(final FlowGraph flowGraph, final HashSet<FlowNode> hashSet, final HashSet<FlowEdge> hashSet2) {
        return new AbstractUndoableEdit(){

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                for (Object object : hashSet) {
                    flowGraph.addVertex((Vertex)object);
                }
                for (Object object : hashSet2) {
                    flowGraph.addEdge((Edge)object);
                }
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                flowGraph.removeVertices(hashSet);
            }
        };
    }
}

