/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow.rendering;

import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.SubflowState;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.visualization.ArrowFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class EdgeRendering
implements EdgePaintFunction,
EdgeShapeFunction,
EdgeStrokeFunction {
    static final Paint DRAW_PAINT = new Color(0.3f, 0.3f, 0.3f);
    private static final Paint DRAW_PAINT_LIGHT = new Color(0.8f, 0.8f, 0.8f);
    private static final Paint PICKED_DRAW_PAINT = new Color(0xFF9900);
    private static final Paint INSERT_TARGET_PAINT = new Color(0xFF9900);
    static final Stroke EDGE_STROKE = new BasicStroke(1.4f);
    private static final EdgeShapeFunction lineEdgeShapeFunction = new EdgeShape.Line();
    static Line2D EDGE_LINE = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
    static Shape ARROW = ArrowFactory.getNotchedArrow((float)8.0f, (float)10.0f, (float)4.0f);
    private FlowState state;
    private SubflowState subflowState;

    public EdgeRendering(FlowState flowState, SubflowState subflowState) {
        this.state = flowState;
        this.subflowState = subflowState;
    }

    public Paint getDrawPaint(Edge edge) {
        if (edge.equals((Object)this.subflowState.getInsertTargetEdge()) || edge.equals((Object)this.state.getCreatingEdge())) {
            return INSERT_TARGET_PAINT;
        }
        if (this.subflowState.isPicked(edge)) {
            return PICKED_DRAW_PAINT;
        }
        if (this.subflowState.isFlowSelected()) {
            if (this.subflowState.getSelectionEdgeFlow().contains(edge)) {
                return Color.ORANGE;
            }
            return DRAW_PAINT_LIGHT;
        }
        if (this.state.isTaskHighlight()) {
            if (this.state.getTaskHighlightEdgeFlow().contains(edge)) {
                return Color.ORANGE;
            }
            return DRAW_PAINT_LIGHT;
        }
        return DRAW_PAINT;
    }

    public Paint getFillPaint(Edge edge) {
        return null;
    }

    public Shape getShape(Edge edge) {
        return lineEdgeShapeFunction.getShape(edge);
    }

    public Stroke getStroke(Edge edge) {
        return EDGE_STROKE;
    }
}

