/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow.rendering;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.ErrorLevel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.SubflowState;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.ui.flow.rendering.EdgeRendering;
import com.ef_prime.rflow.ui.flow.rendering.NodeRendering;
import com.ef_prime.rflow.ui.flow.rendering.TextPaneGraphLabelRenderer;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class FlowRenderer
extends PluggableRenderer {
    private static Icon disabledErrorIcon;
    private FlowState state;
    private NodeRendering nodeRendering;
    private EdgeRendering edgeRendering;
    private Map<Edge, Shape> edgeShapes = new HashMap<Edge, Shape>();
    private Set<Edge> arrowOnlyEdges = new HashSet<Edge>();
    private Color labelSpaceColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    private static final Stroke LOCK_ON_STROKE;
    private Map<FlowNode, LockOn> stepMarks = new HashMap<FlowNode, LockOn>();

    public FlowRenderer(FlowState flowState, SubflowState subflowState) {
        this.state = flowState;
        this.nodeRendering = new NodeRendering(flowState, subflowState);
        this.setVertexShapeFunction(this.nodeRendering);
        this.setVertexStrokeFunction(this.nodeRendering);
        this.setVertexPaintFunction(this.nodeRendering);
        this.setVertexStringer(this.nodeRendering);
        this.setVertexFontFunction(this.nodeRendering);
        this.setVertexIconFunction(this.nodeRendering);
        this.edgeRendering = new EdgeRendering(flowState, subflowState);
        this.setEdgePaintFunction(this.edgeRendering);
        this.setEdgeShapeFunction(this.edgeRendering);
        this.setEdgeStrokeFunction(this.edgeRendering);
        this.setGraphLabelRenderer(new TextPaneGraphLabelRenderer());
    }

    public void clearArrowOnlyEdges() {
        this.arrowOnlyEdges.clear();
    }

    public Set<Edge> getArrowOnlyEdges() {
        return this.arrowOnlyEdges;
    }

    public Map<Edge, Shape> getEdgeShapes() {
        return this.edgeShapes;
    }

    public NodeRendering getNodeRendering() {
        return this.nodeRendering;
    }

    public EdgeRendering getEdgeRendering() {
        return this.edgeRendering;
    }

    public FlowState getState() {
        return this.state;
    }

    public void paintVertex(Graphics graphics, Vertex vertex, int n, int n2) {
        Object object;
        if (!this.vertexIncludePredicate.evaluate((Object)vertex)) {
            return;
        }
        boolean bl = true;
        Rectangle rectangle = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.screenDevice != null) {
            object = this.screenDevice.getSize();
            if (((Dimension)object).width <= 0 || ((Dimension)object).height <= 0) {
                object = this.screenDevice.getPreferredSize();
            }
            rectangle = new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        }
        object = this.vertexShapeFunction.getShape(vertex);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        object = affineTransform.createTransformedShape((Shape)object);
        Rectangle rectangle2 = this.getLabelRect(vertex, n, n2);
        rectangle2 = rectangle2 == null ? object.getBounds() : object.getBounds().union(rectangle2);
        bl = this.viewTransformer.transform((Shape)rectangle2).intersects(rectangle);
        if (bl) {
            String string;
            Stroke stroke = graphics2D.getStroke();
            Stroke stroke2 = this.vertexStrokeFunction.getStroke(vertex);
            if (stroke2 != null) {
                graphics2D.setStroke(stroke2);
            }
            this.paintForVertex(graphics2D, vertex, (Shape)object, n, n2);
            if (stroke2 != null) {
                graphics2D.setStroke(stroke);
            }
            if ((string = this.vertexStringer.getLabel((ArchetypeVertex)vertex)) != null) {
                this.labelVertex(graphics, vertex, string, n, n2);
            }
        }
    }

    private void paintForVertex(Graphics2D graphics2D, Vertex vertex, Shape shape, int n, int n2) {
        Component component = this.nodeRendering.getComponent((FlowNode)vertex);
        if (component != null) {
            if (component.getParent() != this.screenDevice) {
                Dimension dimension = component.getPreferredSize();
                this.rendererPane.paintComponent(graphics2D, component, this.screenDevice, n, n2, dimension.width, dimension.height, true);
            }
        } else {
            Icon icon = this.nodeRendering.getIcon((ArchetypeVertex)vertex);
            if (icon != null) {
                int n3 = n - icon.getIconWidth() / 2;
                int n4 = n2 - icon.getIconHeight() / 2;
                icon.paintIcon(this.screenDevice, graphics2D, n3, n4);
            } else {
                this.paintShapeForVertex(graphics2D, vertex, shape);
            }
        }
    }

    protected void drawSimpleEdge(Graphics2D graphics2D, Edge edge, int n, int n2, int n3, int n4) {
        Object object;
        Cloneable cloneable;
        Pair pair = edge.getEndpoints();
        Vertex vertex = (Vertex)pair.getFirst();
        Vertex vertex2 = (Vertex)pair.getSecond();
        boolean bl = vertex.equals((Object)vertex2);
        Shape shape = this.vertexShapeFunction.getShape(vertex2);
        Shape shape2 = this.edgeShapeFunction.getShape(edge);
        boolean bl2 = true;
        boolean bl3 = true;
        Rectangle rectangle = null;
        if (this.screenDevice != null) {
            cloneable = this.screenDevice.getSize();
            if (((Dimension)cloneable).width <= 0 || ((Dimension)cloneable).height <= 0) {
                cloneable = this.screenDevice.getPreferredSize();
            }
            rectangle = new Rectangle(0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
        }
        cloneable = AffineTransform.getTranslateInstance(n, n2);
        if (bl) {
            object = shape.getBounds2D();
            ((AffineTransform)cloneable).scale(((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight());
            ((AffineTransform)cloneable).translate(0.0, -shape2.getBounds2D().getWidth() / 2.0);
        } else {
            float f = n3 - n;
            float f2 = n4 - n2;
            float f3 = (float)Math.atan2(f2, f);
            ((AffineTransform)cloneable).rotate(f3);
            float f4 = (float)Math.sqrt(f * f + f2 * f2);
            ((AffineTransform)cloneable).scale(f4, 1.0);
        }
        shape2 = ((AffineTransform)cloneable).createTransformedShape(shape2);
        bl2 = this.viewTransformer.transform(shape2).intersects(rectangle);
        if (bl2) {
            Object object2;
            Paint paint;
            object = graphics2D.getPaint();
            Shape shape3 = this.nodeRendering.getGlassShape(vertex);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
            shape3 = affineTransform.createTransformedShape(shape3);
            AffineTransform affineTransform2 = shape2 instanceof GeneralPath ? this.getReverseArrowTransform((GeneralPath)shape2, shape3, !bl) : this.getReverseArrowTransform(new GeneralPath(shape2), shape3, !bl);
            if (affineTransform2 == null) {
                return;
            }
            if (affineTransform2.isIdentity()) {
                this.arrowOnlyEdges.add(edge);
                this.edgeShapes.put(edge, null);
                return;
            }
            int n5 = (int)affineTransform2.getTranslateX();
            int n6 = (int)affineTransform2.getTranslateY();
            Shape shape4 = this.nodeRendering.getGlassShape(vertex2);
            AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(n3, n4);
            shape4 = affineTransform3.createTransformedShape(shape4);
            AffineTransform affineTransform4 = shape2 instanceof GeneralPath ? this.getArrowTransform((GeneralPath)shape2, shape4) : this.getArrowTransform(new GeneralPath(shape2), shape4);
            if (affineTransform4 == null) {
                return;
            }
            int n7 = (int)affineTransform4.getTranslateX();
            int n8 = (int)affineTransform4.getTranslateY();
            int n9 = n3 - n;
            int n10 = n4 - n2;
            int n11 = n7 - n5;
            int n12 = n8 - n6;
            if (n9 > 0 ^ n11 > 0 && n9 != 0 && n11 != 0 || n10 > 0 ^ n12 > 0 && n10 != 0 && n12 != 0) {
                this.arrowOnlyEdges.add(edge);
                this.edgeShapes.put(edge, null);
                return;
            }
            AffineTransform affineTransform5 = AffineTransform.getTranslateInstance(n5, n6);
            float f = (float)Math.atan2(n12, n11);
            affineTransform5.rotate(f);
            float f5 = (float)Math.sqrt(n11 * n11 + n12 * n12) - 3.0f;
            affineTransform5.scale(f5, 1.0);
            shape2 = affineTransform5.createTransformedShape(this.edgeShapeFunction.getShape(edge));
            this.edgeShapes.put(edge, shape2);
            Paint paint2 = this.edgePaintFunction.getFillPaint(edge);
            if (paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.fill(shape2);
            }
            if ((paint = this.edgePaintFunction.getDrawPaint(edge)) != null) {
                graphics2D.setPaint(paint);
                graphics2D.draw(shape2);
            }
            float f6 = (float)graphics2D.getTransform().getScaleX();
            float f7 = (float)graphics2D.getTransform().getScaleY();
            if ((double)f6 < 0.3 || (double)f7 < 0.3) {
                return;
            }
            if (this.edgeArrowPredicate.evaluate((Object)edge) && bl3) {
                object2 = AffineTransform.getTranslateInstance(n7, n8);
                ((AffineTransform)object2).rotate(f);
                Shape shape5 = this.edgeArrowFunction.getArrow(edge);
                shape5 = ((AffineTransform)object2).createTransformedShape(shape5);
                graphics2D.fill(shape5);
            }
            if (paint == null) {
                graphics2D.setPaint((Paint)object);
            }
            if ((object2 = this.edgeStringer.getLabel((ArchetypeEdge)edge)) != null) {
                this.labelEdge(graphics2D, edge, (String)object2, n, n3, n2, n4);
            }
            graphics2D.setPaint((Paint)object);
        }
    }

    public void drawEdge(Graphics2D graphics2D, FlowNode flowNode, int n, int n2, int n3, int n4) {
        Cloneable cloneable;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(EdgeRendering.EDGE_STROKE);
        Shape shape = EdgeRendering.EDGE_LINE;
        boolean bl = true;
        boolean bl2 = true;
        Rectangle rectangle = null;
        if (this.screenDevice != null) {
            cloneable = this.screenDevice.getSize();
            if (((Dimension)cloneable).width <= 0 || ((Dimension)cloneable).height <= 0) {
                cloneable = this.screenDevice.getPreferredSize();
            }
            rectangle = new Rectangle(0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
        }
        cloneable = AffineTransform.getTranslateInstance(n, n2);
        float f = n3 - n;
        float f2 = n4 - n2;
        float f3 = (float)Math.atan2(f2, f);
        ((AffineTransform)cloneable).rotate(f3);
        float f4 = (float)Math.sqrt(f * f + f2 * f2);
        ((AffineTransform)cloneable).scale(f4, 1.0);
        shape = ((AffineTransform)cloneable).createTransformedShape(shape);
        bl = this.viewTransformer.transform(shape).intersects(rectangle);
        if (bl) {
            Color color;
            Paint paint = graphics2D.getPaint();
            Shape shape2 = this.nodeRendering.getGlassShape((Vertex)flowNode);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
            shape2 = affineTransform.createTransformedShape(shape2);
            AffineTransform affineTransform2 = shape instanceof GeneralPath ? this.getReverseArrowTransform((GeneralPath)shape, shape2, true) : this.getReverseArrowTransform(new GeneralPath(shape), shape2, true);
            if (affineTransform2 == null) {
                return;
            }
            int n5 = (int)affineTransform2.getTranslateX();
            int n6 = (int)affineTransform2.getTranslateY();
            AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(n5, n6);
            float f5 = n3 - n5;
            float f6 = n4 - n6;
            float f7 = (float)Math.atan2(f6, f5);
            affineTransform3.rotate(f7);
            float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6);
            affineTransform3.scale(f8, 1.0);
            shape = affineTransform3.createTransformedShape(EdgeRendering.EDGE_LINE);
            Color color2 = Color.BLACK;
            if (color2 != null) {
                graphics2D.setPaint(color2);
                graphics2D.fill(shape);
            }
            if ((color = Color.BLACK) != null) {
                graphics2D.setPaint(color);
                graphics2D.draw(shape);
            }
            float f9 = (float)graphics2D.getTransform().getScaleX();
            float f10 = (float)graphics2D.getTransform().getScaleY();
            if (!((double)f9 < 0.3) && !((double)f10 < 0.3) && bl2) {
                Shape shape3 = EdgeRendering.ARROW;
                AffineTransform affineTransform4 = AffineTransform.getTranslateInstance(n3, n4);
                affineTransform4.rotate(f3);
                shape3 = affineTransform4.createTransformedShape(shape3);
                graphics2D.fill(shape3);
            }
            graphics2D.setPaint(paint);
        }
        graphics2D.setStroke(stroke);
    }

    public void paintVertexSpaces(Graphics2D graphics2D, Vertex vertex, int n, int n2) {
        Rectangle rectangle = this.getLabelRect(vertex, n, n2);
        if (rectangle != null) {
            graphics2D.setColor(this.labelSpaceColor);
            graphics2D.fill(rectangle);
        }
    }

    public Component getLabelComponent(Vertex vertex, String string) {
        return this.prepareRenderer(this.graphLabelRenderer, string, this.getPickedKey().isPicked((ArchetypeVertex)vertex), vertex);
    }

    public Rectangle getLabelRect(Vertex vertex, int n, int n2) {
        String string = this.vertexStringer.getLabel((ArchetypeVertex)vertex);
        if (string != null) {
            Component component = this.getLabelComponent(vertex, string);
            return this.getLabelRect(vertex, n, n2, component);
        }
        return null;
    }

    public Rectangle getLabelRect(Vertex vertex, int n, int n2, Component component) {
        Dimension dimension = component.getPreferredSize();
        Rectangle2D rectangle2D = this.vertexShapeFunction.getShape(vertex).getBounds2D();
        Rectangle rectangle = ((FlowNode)vertex).getModel().getTitleRectangle(component, rectangle2D, n, n2);
        if (rectangle == null) {
            int n3;
            int n4;
            int n5 = Math.min(100, dimension.width);
            if (this.centerVertexLabel) {
                n4 = -n5 / 2;
                n3 = -dimension.height / 2;
            } else {
                n4 = -n5 / 2;
                n3 = 16;
            }
            rectangle = new Rectangle(n + n4, n2 + n3, n5, dimension.height);
        }
        return rectangle;
    }

    private static Icon getDisabledErrorIcon() {
        if (disabledErrorIcon == null) {
            disabledErrorIcon = UIManager.getLookAndFeel().getDisabledSelectedIcon(null, FileResource.getIcon("img/error_16.png"));
        }
        return disabledErrorIcon;
    }

    protected void labelVertex(Graphics graphics, Vertex vertex, String string, int n, int n2) {
        Object object;
        Component component = this.getLabelComponent(vertex, string);
        Rectangle rectangle = this.getLabelRect(vertex, n, n2, component);
        this.rendererPane.paintComponent(graphics, component, this.screenDevice, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        FlowNode flowNode = (FlowNode)vertex;
        if (flowNode.isCacheData()) {
            object = flowNode.getCacheData().isValid() ? NodeRendering.FLAG_IMAGE_VALID : NodeRendering.FLAG_IMAGE_INVALID;
            ((ImageIcon)object).paintIcon(this.screenDevice, graphics, n + 9, n2 - 30);
        }
        if (flowNode.isFirstBreakpoint()) {
            object = (Graphics2D)graphics;
            Paint paint = ((Graphics2D)object).getPaint();
            Stroke stroke = ((Graphics2D)object).getStroke();
            ((Graphics2D)object).setPaint(flowNode.isFirstBreakpointEnabled() ? Color.ORANGE : Color.LIGHT_GRAY);
            Rectangle rectangle2 = flowNode.getModel().getBreakpointRectangle(n, n2);
            ((Graphics)object).fillOval(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            ((Graphics2D)object).setPaint(paint);
            ((Graphics2D)object).setStroke(stroke);
        }
        if (this.state.isError(flowNode)) {
            this.paintError(graphics, vertex, n, n2, flowNode.getModel().isDisabled() ? FlowRenderer.getDisabledErrorIcon() : FileResource.getIcon("img/error_16.png"));
        } else if (flowNode.getModel().getNodeMode() == NodeModel.NodeMode.UPDATE) {
            this.paintError(graphics, vertex, n, n2, FileResource.getIcon("img/warning_16.png"));
        } else if (flowNode.getModel().getErrorLevel() == ErrorLevel.WARNING) {
            this.paintError(graphics, vertex, n, n2, FileResource.getIcon("img/warning_16.png"));
        }
        if (vertex.equals((Object)this.state.getFlagNode())) {
            this.paintLockOn(graphics, vertex, n, n2, Color.BLACK);
        } else if (this.state.getFlagBoxSet().contains(vertex)) {
            this.paintLockOn(graphics, vertex, n, n2, Color.LIGHT_GRAY);
        }
        if (this.state.isExecutingNode(flowNode)) {
            this.paintLockOn(graphics, vertex, n, n2, Color.ORANGE);
        }
    }

    private void paintError(Graphics graphics, Vertex vertex, int n, int n2, Icon icon) {
        Rectangle rectangle = this.vertexShapeFunction.getShape(vertex).getBounds();
        icon.paintIcon(this.screenDevice, graphics, n + rectangle.width / 2 - icon.getIconWidth() / 2, n2 + rectangle.height / 2 - icon.getIconHeight() - 5);
    }

    private void paintLockOn(Graphics graphics, Vertex vertex, int n, int n2, Paint paint) {
        Rectangle rectangle = this.nodeRendering.getGlassShape(vertex).getBounds();
        boolean bl = rectangle.width > rectangle.height;
        int n3 = Math.abs(rectangle.width - rectangle.height) / 2;
        rectangle.grow(bl ? 0 : n3, bl ? n3 : 0);
        rectangle.grow(5, 5);
        rectangle.translate(n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(paint);
        graphics2D.setStroke(LOCK_ON_STROKE);
        this.paintLockOnPart(graphics2D, (int)rectangle.getMinX(), (int)rectangle.getMinY(), true, true);
        this.paintLockOnPart(graphics2D, (int)rectangle.getMinX(), (int)rectangle.getMaxY(), true, false);
        this.paintLockOnPart(graphics2D, (int)rectangle.getMaxX(), (int)rectangle.getMaxY(), false, false);
        this.paintLockOnPart(graphics2D, (int)rectangle.getMaxX(), (int)rectangle.getMinY(), false, true);
        graphics2D.setPaint(paint2);
        graphics2D.setStroke(stroke);
    }

    private void paintLockOnPart(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2) {
        int n3 = 5;
        int n4 = 5;
        if (!bl) {
            n3 *= -1;
        }
        if (!bl2) {
            n4 *= -1;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n + n3, n2);
        generalPath.lineTo(n, n2);
        generalPath.lineTo(n, n2 + n4);
        graphics2D.draw(generalPath);
    }

    public void paintArrowOnlyEdge(Graphics2D graphics2D, Edge edge, int n, int n2, int n3, int n4) {
        float f = n3 - n;
        float f2 = n4 - n2;
        float f3 = (float)Math.atan2(f2, f);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((float)n + f / 2.0f, (float)n2 + f2 / 2.0f);
        affineTransform.rotate(f3);
        Shape shape = this.edgeArrowFunction.getArrow(edge);
        shape = affineTransform.createTransformedShape(shape);
        Paint paint = graphics2D.getPaint();
        Paint paint2 = this.edgePaintFunction.getDrawPaint(edge);
        graphics2D.setPaint(paint2);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public Rectangle getTaskRect(int n, int n2, Component component) {
        Dimension dimension = component.getPreferredSize();
        return new Rectangle(n + 10, n2 - dimension.height - 5, dimension.width, dimension.height);
    }

    public void paintPostRenderings(Graphics2D graphics2D, FlowNode flowNode, int n, int n2) {
        if (flowNode.getComment().exists()) {
            NodeComment nodeComment = flowNode.getComment();
            nodeComment.setRollOvered(this.state.isRollOverCommentNode(flowNode));
            if (!nodeComment.isCommentOpened()) {
                Color color = graphics2D.getColor();
                Rectangle rectangle = nodeComment.getCommentIconRect(n, n2);
                graphics2D.setColor(NodeComment.FILL_COLOR);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Color color2 = Color.ORANGE;
                graphics2D.setColor(this.state.isPoppedComment(flowNode) ? color2 : NodeComment.DRAW_COLOR);
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setColor(color);
            }
        }
    }

    public void paintPostRenderings2(Graphics2D graphics2D, FlowNode flowNode, int n, int n2) {
        Object object;
        if (this.state.isNextStepNode(flowNode)) {
            object = this.stepMarks.get(flowNode);
            if (object == null) {
                object = new LockOn((Vertex)flowNode);
                this.screenDevice.add((Component)object);
                this.stepMarks.put(flowNode, (LockOn)object);
            }
            ((Component)object).setBounds(n - ((LockOn)object).size / 2, n2 - ((LockOn)object).size / 2, ((LockOn)object).size, ((LockOn)object).size);
        } else {
            object = this.stepMarks.remove(flowNode);
            if (object != null) {
                this.screenDevice.remove((Component)object);
                ((LockOn)object).dispose();
            }
        }
        if (flowNode.getComment().exists()) {
            object = flowNode.getComment();
            ((NodeComment)object).setRollOvered(this.state.isRollOverCommentNode(flowNode));
            if (((NodeComment)object).isCommentOpened() || this.state.isPoppedComment(flowNode)) {
                JTextComponent jTextComponent = ((NodeComment)object).getCommentComponent();
                Rectangle rectangle = ((NodeComment)object).getCommentRect(n, n2);
                int n3 = n < rectangle.x + rectangle.width / 2 ? rectangle.x : rectangle.x + rectangle.width;
                int n4 = n2 < rectangle.y + rectangle.height / 2 ? rectangle.y : rectangle.y + rectangle.height;
                n3 = rectangle.x + rectangle.width / 2;
                n4 = rectangle.y + rectangle.height / 2;
                AffineTransform affineTransform = this.getArrowTransform(new Line2D.Double(n, n2, n3, n4), rectangle);
                n3 = (int)affineTransform.getTranslateX();
                n4 = (int)affineTransform.getTranslateY();
                Shape shape = this.nodeRendering.getGlassShape((Vertex)flowNode);
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n, n2);
                shape = affineTransform2.createTransformedShape(shape);
                AffineTransform affineTransform3 = this.getReverseArrowTransform(new Line2D.Double(n, n2, n3, n4), shape);
                int n5 = (int)affineTransform3.getTranslateX();
                int n6 = (int)affineTransform3.getTranslateY();
                Color color = graphics2D.getColor();
                graphics2D.setColor(NodeComment.DRAW_COLOR);
                graphics2D.drawLine(n5, n6, n3, n4);
                graphics2D.setColor(color);
                if (((NodeComment)object).isCommentOpened()) {
                    if (jTextComponent.getParent() != this.screenDevice) {
                        this.rendererPane.paintComponent(graphics2D, jTextComponent, this.screenDevice, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    } else {
                        ((NodeComment)object).setRollOvered(false);
                        if (jTextComponent.getLocation().x != rectangle.x || jTextComponent.getLocation().y != rectangle.y) {
                            jTextComponent.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                    }
                }
            }
        }
        if (this.state.isRollOverNode(flowNode)) {
            flowNode.getModel().paintOnRollOver(this, graphics2D, n, n2);
        }
    }

    protected Line2D getFirstOutsideSegment(Line2D line2D, Shape shape) {
        if (!shape.contains(line2D.getP1())) {
            String string = "line start point: " + String.valueOf(line2D.getP1()) + " is not contained in shape: " + String.valueOf(shape.getBounds2D());
            throw new IllegalArgumentException(string);
        }
        Line2D.Float float_ = new Line2D.Float();
        Line2D.Float float_2 = new Line2D.Float();
        int n = 0;
        do {
            this.subdivide(line2D, float_, float_2);
        } while (!shape.contains((line2D = float_).getP2()) && n++ < 10);
        return float_2;
    }

    static {
        LOCK_ON_STROKE = new BasicStroke(3.0f);
    }

    private class LockOn
    extends JComponent {
        Vertex v;
        Timer timer;
        private int size;

        public LockOn(Vertex vertex) {
            this.v = vertex;
            this.timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LockOn.this.setVisible(!LockOn.this.isVisible());
                }
            });
            this.timer.start();
            Rectangle rectangle = FlowRenderer.this.nodeRendering.getGlassShape(vertex).getBounds();
            this.size = Math.max(rectangle.width, rectangle.height) + 50;
            this.setSize(this.size, this.size);
        }

        @Override
        public void paint(Graphics graphics) {
            FlowRenderer.this.paintLockOn(graphics, this.v, this.size / 2, this.size / 2, Color.ORANGE);
        }

        public void dispose() {
            this.timer.stop();
        }
    }
}

