/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow.rendering;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.SubflowState;
import com.ef_prime.rflow.node.group.AppearanceGroup;
import com.ef_prime.rflow.ui.base.Prefs;
import com.ef_prime.rflow.ui.common.component.ColorMaskedIcon;
import com.ef_prime.rflow.ui.util.UIUtility;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexFontFunction;
import edu.uci.ics.jung.graph.decorators.VertexIconFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.decorators.VertexStrokeFunction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NodeRendering
implements VertexShapeFunction,
VertexPaintFunction,
VertexStrokeFunction,
VertexStringer,
VertexFontFunction,
VertexIconFunction {
    public static final ImageIcon FLAG_IMAGE_INVALID = FileResource.getIcon("img/node/flag.png");
    public static final ImageIcon FLAG_IMAGE_VALID = new ColorMaskedIcon(FLAG_IMAGE_INVALID, Color.RED, 0.5f);
    public static final Color FILLPAINT = new Color(0, 120, 120);
    public static final Color PICKED_FILLPAINT = new Color(100, 200, 100);
    public static final Color PICKED_FILLPAINT_LIGHT = new Color(0, 180, 160);
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke BOLDSTROKE = new BasicStroke(2.5f);
    public static final Font BOLD_FONT = new Font(Prefs.CODE_FONT.getName(), 1, Prefs.CODE_FONT.getSize());
    private FlowState state;
    private SubflowState subflowState;

    public NodeRendering(FlowState flowState) {
        this(flowState, new SubflowState());
    }

    public NodeRendering(FlowState flowState, SubflowState subflowState) {
        this.state = flowState;
        this.subflowState = subflowState;
    }

    public Component getComponent(FlowNode flowNode) {
        return flowNode.getModel().getComponent(this.subflowState.isPicked((Vertex)flowNode), this.state.isRollOverNode(flowNode));
    }

    public Shape getShape(Vertex vertex) {
        FlowNode flowNode = (FlowNode)vertex;
        AppearanceGroup appearanceGroup = flowNode.getProperty().getAppearanceGroup();
        if (appearanceGroup == null) {
            return flowNode.getModel().getShape();
        }
        return appearanceGroup.getShape();
    }

    public Shape getGlassShape(Vertex vertex) {
        FlowNode flowNode = (FlowNode)vertex;
        AppearanceGroup appearanceGroup = flowNode.getProperty().getAppearanceGroup();
        if (appearanceGroup == null) {
            return flowNode.getModel().getGlassShape();
        }
        return appearanceGroup.getGlassShape();
    }

    public Icon getIcon(ArchetypeVertex archetypeVertex) {
        return this.colorIcon(((FlowNode)archetypeVertex).getIcon(), archetypeVertex);
    }

    public Icon getSmallIcon(Vertex vertex) {
        return this.colorIcon(((FlowNode)vertex).getSmallIcon(), (ArchetypeVertex)vertex);
    }

    private Icon colorIcon(Icon icon, ArchetypeVertex archetypeVertex) {
        if (icon == null) {
            return null;
        }
        FlowNode flowNode = (FlowNode)archetypeVertex;
        if (flowNode.getModel().isDisabled() && icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            icon = new ImageIcon(UIUtility.createDisabledImage(image, 70));
        }
        if (this.state.isHighlightNode(flowNode) || this.subflowState.isActiveNode(flowNode)) {
            return new ColorMaskedIcon(icon, Color.BLUE, 0.15f);
        }
        if (this.isNodeSelectionColor(flowNode)) {
            return new ColorMaskedIcon(icon, Color.YELLOW, flowNode.getModel().isDisabled() ? 0.2f : 0.3f);
        }
        return icon;
    }

    public Paint getDrawPaint(Vertex vertex) {
        return ((FlowNode)vertex).getModel().getDrawPaint(this.subflowState.isPicked(vertex));
    }

    public Stroke getStroke(Vertex vertex) {
        return ((FlowNode)vertex).getModel().getStroke();
    }

    public Paint getFillPaint(Vertex vertex) {
        FlowNode flowNode = (FlowNode)vertex;
        return flowNode.getModel().getFillPaint(this.isNodeSelectionColor(flowNode), this.state.isHighlightNode(flowNode) || this.subflowState.isActiveNode(flowNode));
    }

    public String getLabel(ArchetypeVertex archetypeVertex) {
        return ((FlowNode)archetypeVertex).getTitle();
    }

    public Font getFont(Vertex vertex) {
        return Prefs.CODE_FONT;
    }

    private boolean isNodeSelectionColor(FlowNode flowNode) {
        return this.subflowState.isPicked((Vertex)flowNode) || this.state.isTaskHighlightNode(flowNode) || this.subflowState.isRectangleSelectionNode(flowNode) || this.subflowState.getConnectTargetNode() == flowNode;
    }
}

