/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow.rendering;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.flow.rendering.NodeRendering;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public enum NodeShape {
    CIRCLE(Messages.getString("NodeShape.circle")),
    TRIANGLE(Messages.getString("NodeShape.triangle")),
    RECTANGLE(Messages.getString("NodeShape.rectangle")),
    STAR(Messages.getString("NodeShape.star"));

    private String name;
    private Shape shape;
    private Icon smallIcon;
    public static final int DEFAULT_SIZE = 22;
    public static final int DEFAULT_GLASS_SIZE = 30;
    public static final int DEFAULT_SPACE = 5;
    private static final Shape GLASS_SHAPE;

    private NodeShape(String string2) {
        this.name = string2;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Icon getSmallIcon() {
        if (this.smallIcon == null) {
            Shape shape = this.getShape();
            int n = 26;
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            shape = AffineTransform.getTranslateInstance(n / 2, n / 2).createTransformedShape(shape);
            graphics2D.setPaint(NodeRendering.FILLPAINT);
            graphics2D.fill(shape);
            this.smallIcon = new ImageIcon(bufferedImage.getScaledInstance(16, 16, 16));
            bufferedImage.flush();
        }
        return this.smallIcon;
    }

    public String getName() {
        return this.name;
    }

    public static Shape getGlassShape() {
        return GLASS_SHAPE;
    }

    private static Shape getTriangle(int n) {
        int n2 = 3;
        int n3 = n;
        double d = Math.PI * 2 / (double)n2;
        double d2 = 0.0;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        for (int i = 0; i < n2; ++i) {
            float f = (float)((double)n3 * Math.cos(d2 -= d));
            float f2 = (float)((double)n3 * Math.sin(d2));
            Point2D point2D = generalPath.getCurrentPoint();
            generalPath.lineTo((float)point2D.getX() + f, (float)point2D.getY() + f2);
        }
        generalPath.closePath();
        double d3 = generalPath.getBounds().getHeight() / 2.0;
        Shape shape = AffineTransform.getTranslateInstance((double)n3 / 2.0, d3).createTransformedShape(generalPath);
        return shape;
    }

    private static Shape getRegularStar(int n, int n2) {
        if (n < 5) {
            throw new IllegalArgumentException("Number of sides must be >= 5");
        }
        GeneralPath generalPath = new GeneralPath();
        float f = n2;
        float f2 = n2;
        double d = Math.PI * 2 / (double)n;
        double d2 = -d / 2.0;
        generalPath.reset();
        generalPath.moveTo(0.0f, 0.0f);
        float f3 = f * (float)Math.cos(d2);
        float f4 = f * (float)Math.sin(d2);
        Point2D point2D = generalPath.getCurrentPoint();
        generalPath.lineTo((float)point2D.getX() + f3, (float)point2D.getY() + f4);
        for (int i = 1; i < n; ++i) {
            f3 = f * (float)Math.cos(d2 += d);
            f4 = f * (float)Math.sin(d2);
            point2D = generalPath.getCurrentPoint();
            generalPath.lineTo((float)point2D.getX() + f3, (float)point2D.getY() + f4);
            f3 = f * (float)Math.cos(d2 -= d * 2.0);
            f4 = f * (float)Math.sin(d2);
            point2D = generalPath.getCurrentPoint();
            generalPath.lineTo((float)point2D.getX() + f3, (float)point2D.getY() + f4);
        }
        generalPath.closePath();
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        double d3 = (double)f / rectangle2D.getWidth();
        double d4 = (double)f2 / rectangle2D.getHeight();
        float f5 = (float)(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0);
        float f6 = (float)(rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d4);
        affineTransform.translate(-f5, -f6);
        Shape shape = affineTransform.createTransformedShape(generalPath);
        return shape;
    }

    static {
        NodeShape.CIRCLE.shape = new Ellipse2D.Double(-11.0, -11.0, 22.0, 22.0);
        NodeShape.TRIANGLE.shape = NodeShape.getTriangle(22);
        NodeShape.RECTANGLE.shape = new Rectangle(-11, -11, 22, 22);
        NodeShape.STAR.shape = NodeShape.getRegularStar(5, 22);
        GLASS_SHAPE = new Rectangle(-20, -20, 40, 50);
    }
}

