/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.flow.rendering;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class TextPaneGraphLabelRenderer
extends JTextPane
implements GraphLabelRenderer {
    private static final Color DISABLED_SELECTED = new Color(134, 134, 211);
    private int lineCount = 2;
    private int width = 100;

    public TextPaneGraphLabelRenderer() {
        this.setOpaque(false);
        this.setBorder(null);
        this.setFocusable(false);
        this.setEditable(false);
        this.setSize(64, 1000);
        this.setEditorKit(new WrapEditorKit());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setSize(this.width, fontMetrics.getHeight() * this.lineCount);
        dimension.width = Math.min(dimension.width, this.width);
        dimension.height = Math.min(dimension.height, fontMetrics.getHeight() * this.lineCount);
        return dimension;
    }

    public Component getGraphLabelRendererComponent(JComponent jComponent, Object object, Font font, boolean bl, Vertex vertex) {
        FlowViewer flowViewer = (FlowViewer)((Object)jComponent);
        FlowNode flowNode = (FlowNode)vertex;
        if (bl || flowViewer.getPickedState().isRectangleSelectionNode(flowNode)) {
            this.setForeground(flowNode.getModel().isDisabled() ? DISABLED_SELECTED : Color.BLUE);
        } else {
            this.setForeground(flowNode.getModel().isDisabled() ? Color.GRAY : Color.BLACK);
        }
        this.setFont(font != null ? font : jComponent.getFont());
        String string = object == null ? "" : object.toString();
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        try {
            abstractDocument.replace(0, abstractDocument.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.Alignment, 1);
        simpleAttributeSet.addAttribute(StyleConstants.Foreground, this.getForeground());
        simpleAttributeSet.addAttribute(StyleConstants.LineSpacing, Float.valueOf(0.0f));
        this.setParagraphAttributes(simpleAttributeSet, true);
        this.lineCount = flowNode.getModel().getTitleLineCount();
        this.width = flowNode.getModel().getTitleWidth();
        Dimension dimension = this.getPreferredSize();
        int n = this.viewToModel(new Point(this.width, dimension.height - 2));
        if (n < abstractDocument.getLength()) {
            int n2 = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), "...") + 2;
            int n3 = this.viewToModel(new Point(this.width - n2, dimension.height - 2));
            String string2 = string.substring(0, n3) + "...";
            try {
                abstractDocument.replace(0, abstractDocument.getLength(), string2, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            n = this.viewToModel(new Point(this.width, dimension.height - 2));
            if (n < abstractDocument.getLength()) {
                string2 = string.substring(0, n3 - 1) + "...";
                try {
                    abstractDocument.replace(0, abstractDocument.getLength(), string2, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public Component getGraphLabelRendererComponent(JComponent jComponent, Object object, Font font, boolean bl, Edge edge) {
        return null;
    }

    public boolean isRotateEdgeLabels() {
        return false;
    }

    public void setRotateEdgeLabels(boolean bl) {
    }

    private static class WrapEditorKit
    extends StyledEditorKit {
        private ViewFactory defaultFactory = new WrapFactory();

        private WrapEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    private static class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public float getMinimumSpan(int n) {
            switch (n) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(n);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
    }

    private static class WrapFactory
    implements ViewFactory {
        private WrapFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new WrapLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }
}

