/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.node;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.node.UnknownNodeModel;
import com.ef_prime.rflow.core.util.XMLException;
import com.ef_prime.rflow.core.util.XMLWriter;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeOptionView;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.RCodingScrollPane;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaEx;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingStatusBar;
import com.ef_prime.rflow.ui.common.component.LabelArea;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.node.DefaultNodeModelController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.w3c.dom.Element;

public class UnknownNodeModelController
extends DefaultNodeModelController {
    private static final Logger LOGGER = Logger.getLogger(UnknownNodeModelController.class.getName());

    @Override
    public String getModelName() {
        return "";
    }

    @Override
    public Class<? extends NodeModel> getModelClass() {
        return UnknownNodeModel.class;
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        return null;
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlowNodeView createView(FlowNode flowNode, boolean bl) {
        return new RScriptView(flowNode, bl);
    }

    private class RScriptView
    extends NodeOptionView {
        public RScriptView(FlowNode flowNode, boolean bl) {
            super(flowNode, bl);
        }

        @Override
        protected void modelChanged() {
        }

        @Override
        protected Component createCenterView() {
            UnknownNodeModel unknownNodeModel = (UnknownNodeModel)this.getNode().getModel();
            if (unknownNodeModel.hasRScript()) {
                RCodingTextAreaEx rCodingTextAreaEx = new RCodingTextAreaEx(unknownNodeModel.getCommand());
                rCodingTextAreaEx.setEditable(false);
                rCodingTextAreaEx.setCodeFoldingEnabled(true);
                rCodingTextAreaEx.setUneditableBackgroundColor();
                RCodingScrollPane rCodingScrollPane = new RCodingScrollPane(rCodingTextAreaEx, this.getNode());
                rCodingScrollPane.setPreferredSize(new Dimension(500, 300));
                ErrorStrip errorStrip = RScriptUtility.createErrorStrip(rCodingTextAreaEx);
                CodingStatusBar codingStatusBar = new CodingStatusBar(rCodingTextAreaEx);
                CodingSearchBar codingSearchBar = new CodingSearchBar(rCodingTextAreaEx);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)((Object)rCodingScrollPane), "Center");
                jPanel.add((Component)codingSearchBar, "South");
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.add((Component)jPanel, "Center");
                jPanel2.add((Component)errorStrip, "East");
                jPanel2.add((Component)codingStatusBar, "South");
                if (unknownNodeModel.isNewerVersionNode()) {
                    LabelArea labelArea = new LabelArea(Messages.getString("View.Unknown.newer_version"));
                    jPanel2.add((Component)labelArea, "North");
                }
                return jPanel2;
            }
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter(stringWriter);
            try {
                xMLWriter.writeElement(unknownNodeModel.getElement());
            }
            catch (XMLException xMLException) {
                LOGGER.log(Level.WARNING, "Failed to read xml.", xMLException);
            }
            RSyntaxTextArea rSyntaxTextArea = new RSyntaxTextArea();
            rSyntaxTextArea.setSyntaxEditingStyle("text/xml");
            rSyntaxTextArea.setText(stringWriter.toString());
            rSyntaxTextArea.setCaretPosition(0);
            rSyntaxTextArea.setEditable(false);
            rSyntaxTextArea.setBackground(UIColor.UNEDITABLE_BACKGROUND);
            RTextScrollPane rTextScrollPane = new RTextScrollPane((RTextArea)rSyntaxTextArea);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)rTextScrollPane);
            return jPanel;
        }
    }
}

