/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.task;

import com.ef_prime.rflow.core.feature.history.FlowNodeFlavor;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.ui.common.item.AbstractItem;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.task.TaskFlavor;
import com.google.common.collect.Iterables;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TaskTransferable
extends AbstractItem {
    private final List<Task> tasks;
    private final DataFlavor[] flavors;

    public TaskTransferable(Collection<Task> collection) {
        this.tasks = Collections.unmodifiableList(new ArrayList<Task>(collection));
        this.flavors = new DataFlavor[]{TaskFlavor.getInstance(), FlowNodeFlavor.getInstance()};
        this.setName(collection.stream().map(task -> task.getTitle()).collect(Collectors.joining(", ")));
        if (collection.size() > 0) {
            this.setIcon(((Task)Iterables.get(collection, (int)0)).getIcon());
        }
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.flavors[0].equals(dataFlavor)) {
            return this.tasks;
        }
        if (this.flavors[1].equals(dataFlavor)) {
            ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
            for (Task task : this.tasks) {
                arrayList.add(task.createFlowNode());
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!dataFlavor.equals(this.flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public View createPreviewView() {
        if (this.tasks.size() != 1) {
            return null;
        }
        Task task = this.tasks.get(0);
        if (!(task instanceof NodeModelTask)) {
            return null;
        }
        NodeModelTask nodeModelTask = (NodeModelTask)task;
        NodeModelController nodeModelController = NodeModelManager.getModelController(nodeModelTask.getModel().getClass());
        return nodeModelController.createView(nodeModelTask.createFlowNode(), true);
    }
}

