/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.util;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import java.awt.Component;
import java.awt.Font;

public class FontSupport {
    public static void setCodeFont(Component component) {
        component.setFont(FontSupport.getCodeFont());
    }

    public static void setFont(Component component, Key<Double> key) {
        component.setFont(FontSupport.getFont(component.getFont(), key));
    }

    public static Font getFont(Font font, Key<Double> key) {
        try {
            float f = Rflow.settings().getValue(key).floatValue();
            return font.deriveFont(f);
        }
        catch (Exception exception) {
            return font;
        }
    }

    public static Font getFont(String string, Key<Double> key) {
        try {
            float f = Rflow.settings().getValue(key).floatValue();
            Font font = new Font(string, 0, (int)f);
            return font.deriveFont(f);
        }
        catch (Exception exception) {
            return new Font(string, 0, 12);
        }
    }

    public static Font getCodeFont() {
        String string = Rflow.settings().getValue(Settings.CODE_FONT_FAMILY);
        return FontSupport.getFont(string, (Key<Double>)Settings.CODE_FONT_SIZE);
    }

    public static Font getDataFont() {
        return FontSupport.getFont("Monospaced", (Key<Double>)Settings.DATA_FONT_SIZE);
    }
}

