/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GraphicsUtility {
    public static ImageIcon createCircleIcon(int n, int n2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.fillOval(n2, n2, n - n2 * 2, n - n2 * 2);
        graphics2D.dispose();
        bufferedImage.flush();
        return new ImageIcon(bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJpeg(BufferedImage bufferedImage, File file, float f) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (!iterator.hasNext()) {
            throw new IOException("Do not support jpeg export.");
        }
        ImageWriter imageWriter = iterator.next();
        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
        try {
            imageWriter.setOutput(fileImageOutputStream);
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            if (imageWriteParam.canWriteCompressed()) {
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(f);
            }
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            imageWriter.write(null, iIOImage, imageWriteParam);
        }
        finally {
            imageWriter.dispose();
            if (fileImageOutputStream != null) {
                fileImageOutputStream.close();
            }
        }
    }

    public static byte[] writeEmfToBytes(Dimension dimension, Color color, Paintable paintable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        EMFGraphics2D eMFGraphics2D = new EMFGraphics2D((OutputStream)byteArrayOutputStream, dimension);
        eMFGraphics2D.setDeviceIndependent(true);
        eMFGraphics2D.startExport();
        paintable.paintToGraphics((Graphics2D)eMFGraphics2D, dimension, color);
        eMFGraphics2D.endExport();
        int n = 96;
        Dimension dimension2 = new Dimension(1024, 768);
        double d = (double)dimension2.width / (double)n * 25.4;
        double d2 = (double)dimension2.height / (double)n * 25.4;
        int n2 = (int)((double)(dimension.width * 100) * d / (double)dimension2.width);
        int n3 = (int)((double)(dimension.height * 100) * d2 / (double)dimension2.height);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GraphicsUtility.setInt(byArray, 32, n2);
        GraphicsUtility.setInt(byArray, 36, n3);
        GraphicsUtility.setInt(byArray, 80, (int)d);
        GraphicsUtility.setInt(byArray, 84, (int)d2);
        GraphicsUtility.setInt(byArray, 100, (int)(d * 1000.0));
        GraphicsUtility.setInt(byArray, 104, (int)(d2 * 1000.0));
        return byArray;
    }

    public static void writeEmf(File file, Dimension dimension, Color color, Paintable paintable) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            bufferedOutputStream.write(GraphicsUtility.writeEmfToBytes(dimension, color, paintable));
        }
    }

    public static void writePs(File file, Dimension dimension, Color color, Paintable paintable) throws IOException {
        PSGraphics2D pSGraphics2D = new PSGraphics2D(file, dimension);
        pSGraphics2D.startExport();
        paintable.paintToGraphics((Graphics2D)pSGraphics2D, dimension, color);
        pSGraphics2D.endExport();
    }

    public static void writeSvg(File file, Dimension dimension, Color color, Paintable paintable) throws IOException {
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        Element element = document.getDocumentElement();
        element.setAttribute("color-rendering", "optimizeQuality");
        element.setAttribute("shape-rendering", "geometricPrecision");
        element.setAttribute("text-rendering", "geometricPrecision");
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        sVGGraphics2D.setSVGCanvasSize(dimension);
        paintable.paintToGraphics((Graphics2D)sVGGraphics2D, dimension, color);
        sVGGraphics2D.dispose();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                transformer.transform(new DOMSource(sVGGraphics2D.getRoot()), new StreamResult(bufferedWriter));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private static void setInt(byte[] byArray, int n, int n2) {
        int n3 = Integer.reverseBytes(n2);
        byte[] byArray2 = new byte[]{(byte)(n3 >>> 24), (byte)(n3 >> 16 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF)};
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static interface Paintable {
        public void paintToGraphics(Graphics2D var1, Dimension var2, Color var3);
    }
}

