/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.util;

import com.ef_prime.rflow.ui.common.component.MultiSplitPaneEx;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;

public class SwingXUtility {
    public static MultiSplitLayout createHorizontalSplitLayout(String string, String string2, double d) {
        return SwingXUtility.createSimpleSplitLayout(true, string, string2, d);
    }

    public static MultiSplitLayout createVerticalSplitLayout(String string, String string2, double d) {
        return SwingXUtility.createSimpleSplitLayout(false, string, string2, d);
    }

    private static MultiSplitLayout createSimpleSplitLayout(boolean bl, String string, String string2, double d) {
        MultiSplitLayout multiSplitLayout = new MultiSplitLayout();
        MultiSplitLayout.Leaf leaf = new MultiSplitLayout.Leaf(string);
        leaf.setWeight(d);
        MultiSplitLayout.Leaf leaf2 = new MultiSplitLayout.Leaf(string2);
        leaf2.setWeight(1.0 - d);
        Object object = bl ? new MultiSplitLayout.RowSplit(new MultiSplitLayout.Node[]{leaf, new MultiSplitLayout.Divider(), leaf2}) : new MultiSplitLayout.ColSplit(new MultiSplitLayout.Node[]{leaf, new MultiSplitLayout.Divider(), leaf2});
        multiSplitLayout.setFloatingDividers(false);
        multiSplitLayout.setModel((MultiSplitLayout.Node)object);
        multiSplitLayout.setLayoutMode(2);
        return multiSplitLayout;
    }

    public static JXMultiSplitPane createHorizontalSplitPane(Component component, Component component2, double d) {
        return SwingXUtility.createSplitPane(true, component, component2, d);
    }

    public static JXMultiSplitPane createVerticalSplitPane(Component component, Component component2, double d) {
        return SwingXUtility.createSplitPane(false, component, component2, d);
    }

    private static JXMultiSplitPane createSplitPane(boolean bl, Component component, Component component2, double d) {
        String string = "left";
        String string2 = "right";
        MultiSplitLayout multiSplitLayout = bl ? SwingXUtility.createHorizontalSplitLayout(string, string2, d) : SwingXUtility.createVerticalSplitLayout(string, string2, d);
        MultiSplitPaneEx multiSplitPaneEx = new MultiSplitPaneEx(multiSplitLayout);
        multiSplitPaneEx.setFocusable(false);
        multiSplitPaneEx.add(component, string);
        multiSplitPaneEx.add(component2, string2);
        multiSplitPaneEx.setDividerSize(6);
        multiSplitPaneEx.setInitialSplit(d);
        return multiSplitPaneEx;
    }

    public static MultiSplitLayout.Node getFirstChild(MultiSplitLayout.Node node) {
        MultiSplitLayout.Split split;
        List list;
        if (node instanceof MultiSplitLayout.Split && !(list = (split = (MultiSplitLayout.Split)node).getChildren()).isEmpty()) {
            return (MultiSplitLayout.Node)list.get(0);
        }
        return null;
    }

    public static Double getHorizontalRatio(JXMultiSplitPane jXMultiSplitPane) {
        MultiSplitLayout.Node node = jXMultiSplitPane.getMultiSplitLayout().getModel();
        if (!(node instanceof MultiSplitLayout.Split)) {
            return null;
        }
        List list = ((MultiSplitLayout.Split)node).getChildren();
        if (list.size() < 3) {
            return null;
        }
        MultiSplitLayout.Node node2 = (MultiSplitLayout.Node)list.get(0);
        return (double)node2.getBounds().width / (double)node.getBounds().width;
    }

    public static float getHorizontalRatio(MultiSplitLayout.Node node) {
        return (float)node.getBounds().width / (float)node.getParent().getBounds().width;
    }

    public static float getVerticalRatio(MultiSplitLayout.Node node) {
        return (float)node.getBounds().height / (float)node.getParent().getBounds().height;
    }

    public static void installWeightChanger(final JXMultiSplitPane jXMultiSplitPane, final double d, final double d2) {
        jXMultiSplitPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                try {
                    MultiSplitLayout.Split split = (MultiSplitLayout.Split)jXMultiSplitPane.getMultiSplitLayout().getModel();
                    ((MultiSplitLayout.Node)split.getChildren().get(0)).setWeight(d);
                    ((MultiSplitLayout.Node)split.getChildren().get(2)).setWeight(d2);
                }
                finally {
                    jXMultiSplitPane.removeComponentListener((ComponentListener)this);
                }
            }
        });
    }

    public static void setHorizontalSplit(JXMultiSplitPane jXMultiSplitPane, double d) {
        MultiSplitLayout.Node node = jXMultiSplitPane.getMultiSplitLayout().getModel();
        MultiSplitLayout.Split split = (MultiSplitLayout.Split)node;
        SwingXUtility.setSplit(split, d, true);
        jXMultiSplitPane.revalidate();
        jXMultiSplitPane.repaint();
    }

    public static void setSplit(MultiSplitLayout.Split split, double d, boolean bl) {
        List list = split.getChildren();
        MultiSplitLayout.Node node = (MultiSplitLayout.Node)list.get(1);
        Rectangle rectangle = split.getBounds();
        Rectangle rectangle2 = node.getBounds();
        if (bl) {
            rectangle2.x = rectangle.x + (int)((double)rectangle.width * d + 0.5);
        } else {
            rectangle2.y = rectangle.y + (int)((double)rectangle.height * d + 0.5);
        }
        node.setBounds(rectangle2);
    }
}

