/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.util;

import java.util.ArrayDeque;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;

public class TreeUtils {
    public static boolean isSiblings(TreeNode[] treeNodeArray) {
        if (treeNodeArray.length < 2) {
            return true;
        }
        int n = 0;
        TreeNode treeNode = treeNodeArray[n++].getParent();
        while (n < treeNodeArray.length) {
            if (!treeNode.equals(treeNodeArray[n].getParent())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isSiblings(TreePath[] treePathArray) {
        if (treePathArray.length < 2) {
            return true;
        }
        int n = 0;
        if (treePathArray[0].getPathCount() == 1) {
            return false;
        }
        Object object = treePathArray[n++].getParentPath().getLastPathComponent();
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 1) {
                return false;
            }
            if (!object.equals(treePathArray[n].getParentPath().getLastPathComponent())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static TreePath getSelectedPath(JTree jTree) {
        Object[] objectArray = jTree.getSelectionPaths();
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return null;
        }
        if (objectArray.length > 1) {
            return null;
        }
        return objectArray[0];
    }

    public static Object getSelectedNode(JTree jTree) {
        TreePath treePath = TreeUtils.getSelectedPath(jTree);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public static TreePath getPath(TreeNode treeNode) {
        return TreeUtils.getPath(treeNode, null);
    }

    public static TreePath getPath(TreeNode treeNode, TreeNode treeNode2) {
        ArrayDeque<TreeNode> arrayDeque = new ArrayDeque<TreeNode>();
        while (treeNode != null) {
            arrayDeque.addFirst(treeNode);
            if (treeNode2 != null && treeNode2.equals(treeNode)) break;
            treeNode = treeNode.getParent();
        }
        return new TreePath(arrayDeque.toArray(new TreeNode[arrayDeque.size()]));
    }
}

