/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.util;

import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.RflowUI;
import com.ef_prime.rflow.ui.common.component.ErrorPanel;
import com.ef_prime.rflow.ui.common.component.MyFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jdesktop.swingx.JXMultiSplitPane;

public class UIUtility {
    private static final Logger LOGGER = Logger.getLogger(UIUtility.class.getName());
    public static final int MENU_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final int MENU_AND_SHIFT_KEY_MASK = MENU_KEY_MASK | 1;
    private static Cursor MOVE_CURSOR;
    private static Cursor COPY_CURSOR;
    private static Cursor LINK_CURSOR;
    private static Cursor INVALID_CURSOR;
    private static MouseListener flatbuttonMouselListener;
    public static final int FILE_NOT_FOUND = -1;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;

    public static void checkEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            LOGGER.log(Level.FINE, "Not in EDT", new RuntimeException("Not in EDT"));
        }
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        if (com.ef_prime.rflow.core.util.Platform.isMac() && mouseEvent.isControlDown()) {
            return false;
        }
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent) || com.ef_prime.rflow.core.util.Platform.isMac() && mouseEvent.isControlDown();
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isMiddleMouseButton(mouseEvent);
    }

    public static boolean isMenuKeyDown(InputEvent inputEvent) {
        return (inputEvent.getModifiers() & MENU_KEY_MASK) == MENU_KEY_MASK;
    }

    public static MouseEvent setPopupTrigger(MouseEvent mouseEvent) {
        if (com.ef_prime.rflow.core.util.Platform.isMac() && mouseEvent.isControlDown()) {
            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), true, mouseEvent.getButton());
        }
        return mouseEvent;
    }

    private static Cursor getSystemCursor(String string) {
        try {
            return Cursor.getSystemCustomCursor(string);
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getMoveCursor() {
        if (MOVE_CURSOR == null) {
            MOVE_CURSOR = UIUtility.getSystemCursor("MoveDrop.32x32");
        }
        return MOVE_CURSOR;
    }

    public static Cursor getCopyCursor() {
        if (COPY_CURSOR == null) {
            COPY_CURSOR = UIUtility.getSystemCursor("CopyDrop.32x32");
        }
        return COPY_CURSOR;
    }

    public static Cursor getLinkCursor() {
        if (LINK_CURSOR == null) {
            LINK_CURSOR = UIUtility.getSystemCursor("LinkDrop.32x32");
        }
        return LINK_CURSOR;
    }

    public static Cursor getInvalidCursor() {
        if (INVALID_CURSOR == null) {
            INVALID_CURSOR = UIUtility.getSystemCursor("InvalidDrop.32x32");
        }
        return INVALID_CURSOR;
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static JRadioButton[] createRadioButtons(String[] stringArray, int n) {
        JRadioButton[] jRadioButtonArray = new JRadioButton[stringArray.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            jRadioButtonArray[i] = new JRadioButton(stringArray[i], i == n);
            buttonGroup.add(jRadioButtonArray[i]);
        }
        return jRadioButtonArray;
    }

    public static void makeButtonFlat(AbstractButton ... abstractButtonArray) {
        if (flatbuttonMouselListener == null) {
            flatbuttonMouselListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    if (abstractButton.isEnabled()) {
                        abstractButton.setContentAreaFilled(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    abstractButton.setContentAreaFilled(false);
                }
            };
        }
        for (AbstractButton abstractButton : abstractButtonArray) {
            abstractButton.setFocusPainted(false);
            abstractButton.setContentAreaFilled(false);
            abstractButton.addMouseListener(flatbuttonMouselListener);
        }
    }

    public static void setTabs(JTextPane jTextPane, Font font, int n) {
        TabSet tabSet = UIUtility.createTabSet(jTextPane, font, n);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        jTextPane.setParagraphAttributes(simpleAttributeSet, false);
    }

    public static TabSet createTabSet(JTextPane jTextPane, Font font, int n) {
        FontMetrics fontMetrics = jTextPane.getFontMetrics(font);
        int n2 = fontMetrics.charWidth('w');
        int n3 = n2 * n;
        TabStop[] tabStopArray = new TabStop[10];
        for (int i = 0; i < tabStopArray.length; ++i) {
            int n4 = i + 1;
            tabStopArray[i] = new TabStop(n4 * n3);
        }
        return new TabSet(tabStopArray);
    }

    public static Box createVerticalBox(Object ... objectArray) {
        Box box = Box.createVerticalBox();
        for (Object object : objectArray) {
            if (object instanceof Component) {
                box.add((Component)object);
                continue;
            }
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                if (n < 0) {
                    box.add(Box.createVerticalGlue());
                    continue;
                }
                box.add(Box.createVerticalStrut(n));
                continue;
            }
            if (!(object instanceof Dimension)) continue;
            box.add(Box.createRigidArea((Dimension)object));
        }
        return box;
    }

    public static Box createHorizontalBox(Object ... objectArray) {
        Box box = Box.createHorizontalBox();
        for (Object object : objectArray) {
            if (object instanceof Component) {
                box.add((Component)object);
                continue;
            }
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                if (n < 0) {
                    box.add(Box.createHorizontalGlue());
                    continue;
                }
                box.add(Box.createHorizontalStrut(n));
                continue;
            }
            if (!(object instanceof Dimension)) continue;
            box.add(Box.createRigidArea((Dimension)object));
        }
        return box;
    }

    public static void setMinWidth(int n, Component ... componentArray) {
        for (Component component : componentArray) {
            component.setMinimumSize(new Dimension(n, component.getMinimumSize().height));
            component.setPreferredSize(new Dimension(n, component.getPreferredSize().height));
        }
    }

    public static void setMinHeight(int n, Component ... componentArray) {
        for (Component component : componentArray) {
            component.setMinimumSize(new Dimension(component.getMinimumSize().width, n));
            component.setPreferredSize(new Dimension(component.getPreferredSize().width, n));
        }
    }

    public static void setWidth(int n, Component ... componentArray) {
        for (Component component : componentArray) {
            component.setPreferredSize(new Dimension(n, component.getPreferredSize().height));
            component.setMaximumSize(new Dimension(n, component.getMaximumSize().height));
        }
    }

    public static void setHeight(int n, Component ... componentArray) {
        for (Component component : componentArray) {
            component.setPreferredSize(new Dimension(component.getPreferredSize().width, n));
            component.setMaximumSize(new Dimension(component.getMaximumSize().width, n));
        }
    }

    public static void setPreferredWidth(int n, Component ... componentArray) {
        for (Component component : componentArray) {
            Dimension dimension = component.getPreferredSize();
            dimension.width = n;
            component.setPreferredSize(dimension);
        }
    }

    public static int[] getSelectedIndices(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int n3 = 0;
        int[] nArray = new int[1 + (n2 - n)];
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public static void setAutoResizeSupport(final JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                    if (n < 0) {
                        return;
                    }
                    int n2 = UIUtility.getTableFirstVisibleRow(jTable);
                    UIUtility.resizeColumn(jTableHeader, n, n2, 1000, 0);
                }
            }
        };
        jTableHeader.addMouseListener(mouseAdapter);
    }

    private static int getTableFirstVisibleRow(JTable jTable) {
        int n = jTable.rowAtPoint(jTable.getVisibleRect().getLocation());
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static void resizeColumns(JTable jTable, int n, int n2) {
        UIUtility.resizeColumns(jTable, n, n2, 500);
    }

    public static void resizeColumns(JTable jTable, int n, int n2, int n3) {
        UIUtility.resizeColumns(jTable, n, n2, n3, 0, -1);
    }

    public static void resizeColumns(JTable jTable, int n, int n2, int n3, int n4, int n5) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        int n6 = UIUtility.getTableFirstVisibleRow(jTable);
        int n7 = n5 < 0 ? jTableHeader.getColumnModel().getColumnCount() : Math.min(n4 + n5, jTableHeader.getColumnModel().getColumnCount());
        for (int i = n4; i < n7; ++i) {
            UIUtility.resizeColumn(jTableHeader, i, n6, n, n2, n3);
        }
    }

    public static void resizeColumn(JTableHeader jTableHeader, int n, int n2, int n3, int n4) {
        UIUtility.resizeColumn(jTableHeader, n, n2, n3, n4, 500);
    }

    public static void resizeColumn(JTableHeader jTableHeader, int n, int n2, int n3, int n4, int n5) {
        JTable jTable = jTableHeader.getTable();
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        n4 = Math.max(15, n4);
        int n6 = jTable.getRowCount() - n2;
        if (n3 == 0) {
            n3 = jTable.getVisibleRect().height / jTable.getRowHeight() + 1;
            n3 = Math.min(n6, Math.max(n3, 50));
        } else {
            n3 = n3 < 0 ? n6 : Math.min(n6, n3);
        }
        int n7 = Math.max(n4, component.getPreferredSize().width);
        for (int i = n2; i < n2 + n3; ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i, n);
            Component component2 = tableCellRenderer2.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            if ((n7 = Math.max(n7, component2.getPreferredSize().width)) <= n5) continue;
            n7 = n5;
            break;
        }
        jTable.getColumnModel().getColumn(n).setPreferredWidth(n7 + 5);
    }

    public static int getColumn(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        return jTable.convertColumnIndexToModel(jTable.columnAtPoint(mouseEvent.getPoint()));
    }

    public static int getRow(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        return jTable.convertRowIndexToModel(jTable.rowAtPoint(mouseEvent.getPoint()));
    }

    public static boolean isInsideTable(MouseEvent mouseEvent) {
        return UIUtility.getColumn(mouseEvent) >= 0 && UIUtility.getRow(mouseEvent) >= 0;
    }

    public static File chooseFile(Component component, File file, int n, int n2, FileFilter[] fileFilterArray) {
        JFileChooser jFileChooser = UIUtility.createFileChooser(component, file, n, n2, fileFilterArray);
        if (jFileChooser.showDialog(component, null) != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile();
    }

    public static File[] chooseFiles(Component component, File file, int n, FileFilter[] fileFilterArray) {
        JFileChooser jFileChooser = UIUtility.createFileChooser(component, file, 0, n, fileFilterArray);
        jFileChooser.setMultiSelectionEnabled(true);
        if (jFileChooser.showDialog(component, null) != 0) {
            return null;
        }
        return jFileChooser.getSelectedFiles();
    }

    private static JFileChooser createFileChooser(Component component, File file, int n, int n2, FileFilter[] fileFilterArray) {
        JFileChooser jFileChooser = new JFileChooser();
        if (file != null) {
            if (file.isDirectory()) {
                jFileChooser.setCurrentDirectory(file);
            } else {
                FileFilter[] fileFilterArray2 = file.getParentFile();
                if (fileFilterArray2 != null) {
                    jFileChooser.setCurrentDirectory((File)fileFilterArray2);
                    jFileChooser.setSelectedFile(file);
                }
            }
        }
        jFileChooser.setPreferredSize(new Dimension(600, 600));
        jFileChooser.setFileSelectionMode(n);
        jFileChooser.setDialogType(n2);
        jFileChooser.setApproveButtonText(Messages.getString("Button.ok"));
        jFileChooser.setApproveButtonToolTipText(null);
        if (fileFilterArray != null && fileFilterArray.length > 0) {
            for (FileFilter fileFilter : fileFilterArray) {
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
            jFileChooser.setFileFilter(fileFilterArray[0]);
        }
        return jFileChooser;
    }

    public static File chooseFileAwt(Frame frame, String string, int n, File file) {
        FileDialog fileDialog = new FileDialog(frame, string, n);
        if (file != null) {
            if (file.isDirectory()) {
                fileDialog.setDirectory(file.getAbsolutePath());
            } else {
                fileDialog.setDirectory(file.getParent());
                fileDialog.setFile(file.getName());
            }
        }
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null || string2 == null) {
            return null;
        }
        return new File(string2, string3);
    }

    public static void showErrorDialog(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, Messages.getString("Error.title.error"), 0);
    }

    public static void showErrorDialog(Component component, Throwable throwable) {
        ErrorPanel.showErrorDialog(component, null, null, throwable, true);
    }

    public static void showErrorDialog(Component component, String string, Throwable throwable) {
        if (throwable == null) {
            UIUtility.showErrorDialog(component, string);
        } else {
            ErrorPanel.showErrorDialog(component, null, string, throwable, true);
        }
    }

    public static void showErrorDialog(Component component, String string, Throwable throwable, boolean bl) {
        if (throwable == null) {
            UIUtility.showErrorDialog(component, string);
        } else {
            ErrorPanel.showErrorDialog(component, null, string, throwable, bl);
        }
    }

    public static void showErrorDialog(Component component, String string, boolean bl) {
        if (bl) {
            UIUtility.showWarningDialog(component, string);
        } else {
            UIUtility.showErrorDialog(component, string);
        }
    }

    public static void showWarningDialog(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, Messages.getString("Error.title.warning"), 2);
    }

    public static String showInputDialog(Component component, String string, Object object, String string2) {
        JOptionPane jOptionPane = new JOptionPane(object, -1, 2);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(string2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object2 = jOptionPane.getValue();
        if (object2 == null) {
            return null;
        }
        if (!(object2 instanceof Integer)) {
            return null;
        }
        if ((Integer)object2 != 0) {
            return null;
        }
        return jOptionPane.getInputValue().toString();
    }

    public static void cleanUpPopupMenu(JPopupMenu jPopupMenu) {
        UIUtility.clearUnabledMenuItem(jPopupMenu);
        UIUtility.clearPopupSeparator(jPopupMenu);
    }

    public static void clearUnabledMenuItem(Container container) {
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            Component component = container.getComponent(i);
            if (!component.isEnabled()) {
                container.remove(i);
                continue;
            }
            if (!(component instanceof JMenu)) continue;
            UIUtility.clearUnabledMenuItem(((JMenu)component).getPopupMenu());
        }
    }

    public static void clearPopupSeparator(JPopupMenu jPopupMenu) {
        if (jPopupMenu.getComponentCount() == 0) {
            return;
        }
        boolean bl = false;
        HashSet<Component> hashSet = new HashSet<Component>();
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            boolean bl2 = jPopupMenu.getComponent(i) instanceof JSeparator;
            if (bl2 && !bl) {
                hashSet.add(jPopupMenu.getComponent(i));
            }
            bl = !bl2;
        }
        for (Component component : hashSet) {
            jPopupMenu.remove(component);
        }
        while (jPopupMenu.getComponentCount() > 0 && jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1) instanceof JSeparator) {
            jPopupMenu.remove(jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1));
        }
    }

    public static void setEnabled(boolean bl, Component component) {
        if (component == null) {
            return;
        }
        component.setEnabled(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                UIUtility.setEnabled(bl, component2);
            }
        }
    }

    public static Rectangle getScreenBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }

    public static Rectangle getScreenBoundsForPoint(int n, int n2, boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (!rectangle.contains(n, n2)) continue;
            if (!bl) {
                return rectangle;
            }
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    public static void copyToClipboard(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static File chooseSaveFile(String string, File file, FileFilter[] fileFilterArray, Component component) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(string);
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            jFileChooser.addChoosableFileFilter(fileFilter);
            if (i != 0) continue;
            jFileChooser.setFileFilter(fileFilter);
        }
        return UIUtility.chooseSaveFile(jFileChooser, component);
    }

    public static File chooseSaveFile(JFileChooser jFileChooser, Component component) {
        int n = jFileChooser.showSaveDialog(component);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (fileFilter != jFileChooser.getAcceptAllFileFilter()) {
            if (fileFilter instanceof MyFileFilter) {
                MyFileFilter myFileFilter = (MyFileFilter)fileFilter;
                SortedSet<String> sortedSet = myFileFilter.getExtension();
                file = new File(UIUtility.addExtension(file.getAbsolutePath(), sortedSet.toArray(new String[sortedSet.size()]), myFileFilter.getDelegateExtension()));
            } else if (fileFilter instanceof FileNameExtensionFilter) {
                FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)fileFilter;
                file = new File(UIUtility.addExtension(file.getAbsolutePath(), fileNameExtensionFilter.getExtensions(), fileNameExtensionFilter.getExtensions()[0]));
            }
        }
        if (!UIUtility.confirmOverwrite(file, component)) {
            return UIUtility.chooseSaveFile(jFileChooser, component);
        }
        return file;
    }

    public static JFileChooser chooser(boolean bl, String[] stringArray, String[] stringArray2) {
        JFileChooser jFileChooser = new JFileChooser();
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(stringArray2[i], stringArray[i].split(",")));
        }
        jFileChooser.setAcceptAllFileFilterUsed(bl);
        return jFileChooser;
    }

    public static String addExtension(String object, String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            Object object3 = object2 = stringArray[i].startsWith(".") ? stringArray[i] : "." + stringArray[i];
            if (!((String)object).toLowerCase().endsWith(((String)object2).toLowerCase())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = (String)object + (String)(string.startsWith(".") ? string : "." + string);
        }
        return object;
    }

    public static File chooseOpenFile(String string, File file, FileFilter[] fileFilterArray, Component component) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(string);
        for (FileFilter fileFilter : fileFilterArray) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        return UIUtility.chooseOpenFile(jFileChooser, component);
    }

    private static File chooseOpenFile(JFileChooser jFileChooser, Component component) {
        int n = jFileChooser.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        return file;
    }

    public static File chooseDir(Component component, File file) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(Messages.getString("Message.select_dir"));
        if (file != null && file.exists() && file.isDirectory()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if ((n = jFileChooser.showDialog(component, Messages.getString("Button.ok"))) != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile();
    }

    public static boolean confirmOverwrite(File file, Component component) {
        int n;
        return !WorkingDirectory.toAbsolutePath(file).exists() || (n = JOptionPane.showConfirmDialog(component, Messages.format("Message.ask_overwrite", file.getAbsolutePath()), Messages.getString("Message.confirm_overwrite"), 0)) != 1;
    }

    public static int confirmYesNoCancel(File file, Component component, boolean bl) {
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(component, Messages.format("Message.ask_overwrite", file.getAbsolutePath()), Messages.getString("Message.confirm_overwrite"), bl ? 1 : 0);
            switch (n) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
        }
        return -1;
    }

    public static FileFilter[] toFileFilter(List<FileKey.FileExtensionFilter> list) {
        if (list == null) {
            return null;
        }
        FileFilter[] fileFilterArray = new FileFilter[list.size()];
        for (int i = 0; i < fileFilterArray.length; ++i) {
            fileFilterArray[i] = new ExtensionFilter(list.get(i));
        }
        return fileFilterArray;
    }

    public static InputMap createInputMap(ActionMap actionMap) {
        InputMap inputMap = new InputMap();
        for (Object object : actionMap.allKeys()) {
            Action action = actionMap.get(object);
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            inputMap.put(keyStroke, object);
        }
        return inputMap;
    }

    public static void insertMouseListener(Component component, MouseListener mouseListener) {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener2 : mouseListenerArray = component.getMouseListeners()) {
            component.removeMouseListener(mouseListener2);
        }
        component.addMouseListener(mouseListener);
        for (MouseListener mouseListener2 : mouseListenerArray) {
            component.addMouseListener(mouseListener2);
        }
    }

    public static void insertMouseMotionListener(Component component, MouseMotionListener mouseMotionListener) {
        MouseMotionListener[] mouseMotionListenerArray;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = component.getMouseMotionListeners()) {
            component.removeMouseMotionListener(mouseMotionListener2);
        }
        component.addMouseMotionListener(mouseMotionListener);
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray) {
            component.addMouseMotionListener(mouseMotionListener2);
        }
    }

    public static void insertMouseWheelListener(Component component, MouseWheelListener mouseWheelListener) {
        MouseWheelListener[] mouseWheelListenerArray;
        for (MouseWheelListener mouseWheelListener2 : mouseWheelListenerArray = component.getMouseWheelListeners()) {
            component.removeMouseWheelListener(mouseWheelListener2);
        }
        component.addMouseWheelListener(mouseWheelListener);
        for (MouseWheelListener mouseWheelListener2 : mouseWheelListenerArray) {
            component.addMouseWheelListener(mouseWheelListener2);
        }
    }

    public static void insertKeyListener(Component component, KeyListener keyListener) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener2 : keyListenerArray = component.getKeyListeners()) {
            component.removeKeyListener(keyListener2);
        }
        component.addKeyListener(keyListener);
        for (KeyListener keyListener2 : keyListenerArray) {
            component.addKeyListener(keyListener2);
        }
    }

    public static Object inputDialog(Component component, String string, Object object, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, -1, 2);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(object2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.setVisible(true);
        jDialog.dispose();
        if (jOptionPane.getValue() instanceof Integer && jOptionPane.getValue().equals(0)) {
            return jOptionPane.getInputValue();
        }
        return null;
    }

    public static void makeSplitPaneFlat(JSplitPane jSplitPane) {
        jSplitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border border) {
                    }
                };
            }
        });
        jSplitPane.setBorder(null);
    }

    public static int[] saveScrollBarPosition(JScrollPane jScrollPane) {
        int n = 0;
        int n2 = 0;
        if (jScrollPane.getVerticalScrollBar() != null) {
            n = jScrollPane.getVerticalScrollBar().getValue();
        }
        if (jScrollPane.getHorizontalScrollBar() != null) {
            n2 = jScrollPane.getHorizontalScrollBar().getValue();
        }
        return new int[]{n, n2};
    }

    public static void loadScrollBarPosition(JScrollPane jScrollPane, int[] nArray) {
        if (nArray == null || nArray.length != 2) {
            throw new IllegalArgumentException();
        }
        if (jScrollPane.getVerticalScrollBar() != null) {
            jScrollPane.getVerticalScrollBar().setValue(nArray[0]);
        }
        if (jScrollPane.getHorizontalScrollBar() != null) {
            jScrollPane.getHorizontalScrollBar().setValue(nArray[1]);
        }
    }

    public static boolean isFlagOn(HierarchyEvent hierarchyEvent, int n) {
        return (hierarchyEvent.getChangeFlags() & (long)n) == (long)n;
    }

    public static boolean isDisplayablityChanged(HierarchyEvent hierarchyEvent) {
        return UIUtility.isFlagOn(hierarchyEvent, 2);
    }

    public static boolean isShowingChanged(HierarchyEvent hierarchyEvent) {
        return UIUtility.isFlagOn(hierarchyEvent, 4);
    }

    public static int getSelectedButtonIndex(ButtonGroup buttonGroup) {
        int n = 0;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().getModel() == buttonGroup.getSelection()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void setSelectedButtonIndex(ButtonGroup buttonGroup, int n) {
        int n2 = 0;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (n2 == n) {
                buttonGroup.setSelected(abstractButton.getModel(), true);
                break;
            }
            ++n2;
        }
    }

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static String getTableToolTip(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        JTable jTable = (JTable)mouseEvent.getSource();
        Object object = null;
        Point point = mouseEvent.getPoint();
        int n = jTable.columnAtPoint(point);
        int n2 = jTable.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (component = jTable.prepareRenderer(tableCellRenderer = jTable.getCellRenderer(n2, n), n2, n)) instanceof JComponent) {
            Rectangle rectangle = jTable.getCellRect(n2, n, false);
            if (rectangle.width >= component.getPreferredSize().width) {
                return null;
            }
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
            object = ((JComponent)component).getToolTipText(mouseEvent2);
            if (object != null && ((String)object).contains("\n") && !((String)object).startsWith("<html>")) {
                object = "<html>" + ((String)object).replaceAll("\n", "<br>") + "<html>";
            }
        }
        if (object == null) {
            object = jTable.getToolTipText();
        }
        return object;
    }

    public static String getTableHeaderToolTip(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = jTableHeader.columnAtPoint(point);
        if (n != -1) {
            TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, 0, n);
            if (component instanceof JComponent) {
                Rectangle rectangle = jTableHeader.getHeaderRect(n);
                if (rectangle.width >= component.getPreferredSize().width) {
                    return null;
                }
                string = tableColumn.getHeaderValue().toString();
            }
        }
        if (string == null) {
            string = jTableHeader.getToolTipText();
        }
        return string;
    }

    public static TreePath getPathForY(JTree jTree, int n) {
        TreePath treePath = jTree.getClosestPathForLocation(0, n);
        if (treePath == null) {
            return null;
        }
        Rectangle rectangle = jTree.getPathBounds(treePath);
        if (rectangle != null && n >= rectangle.y && n < rectangle.y + rectangle.height) {
            return treePath;
        }
        return null;
    }

    public static void scrollPathToVisibleIncludingExpandControl(JTree jTree, TreePath treePath) {
        jTree.makeVisible(treePath);
        Rectangle rectangle = jTree.getPathBounds(treePath);
        if (rectangle == null) {
            return;
        }
        if (treePath.getPathCount() < 4) {
            rectangle.x = 0;
        }
        rectangle.width = 0;
        jTree.scrollRectToVisible(rectangle);
    }

    public static File chooseFileFx(final File file, final boolean bl) {
        RflowUI.initFx();
        FutureTask<File> futureTask = new FutureTask<File>(new Callable<File>(){

            @Override
            public File call() throws Exception {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setInitialDirectory(file);
                return bl ? fileChooser.showSaveDialog(null) : fileChooser.showOpenDialog(null);
            }
        });
        Platform.runLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    public static File chooseDirFx(Window window, File ... fileArray) {
        File file = null;
        block2: for (File file2 : fileArray) {
            for (int i = 0; i < 3; ++i) {
                if (file2.isDirectory()) {
                    file = file2;
                    if (file.isAbsolute() && !file.getPath().isEmpty()) break block2;
                    file = WorkingDirectory.toAbsolutePath(file);
                    break block2;
                }
                if ((file2 = file2.getParentFile()) == null) continue block2;
            }
        }
        File[] fileArray2 = file;
        RflowUI.initFx();
        JDialog jDialog = new JDialog(window, Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setUndecorated(true);
        final FutureTask<File> futureTask = new FutureTask<File>(new Callable<File>(){
            final /* synthetic */ File val$initialDirectory;
            final /* synthetic */ JDialog val$dummyDialog;
            {
                this.val$initialDirectory = file;
                this.val$dummyDialog = jDialog;
            }

            @Override
            public File call() throws Exception {
                DirectoryChooser directoryChooser = new DirectoryChooser();
                if (this.val$initialDirectory != null) {
                    directoryChooser.setInitialDirectory(this.val$initialDirectory);
                }
                File file = directoryChooser.showDialog(null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        val$dummyDialog.dispose();
                    }
                });
                return file;
            }
        });
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                Platform.runLater((Runnable)futureTask);
            }
        });
        jDialog.setVisible(true);
        try {
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    public static void removeFromParent(Component component) {
        if (component == null) {
            return;
        }
        Container container = component.getParent();
        if (container != null) {
            container.remove(component);
        }
    }

    public static int getBaseLineCenterY(int n, FontMetrics fontMetrics) {
        return (int)((double)n / 2.0 + (double)fontMetrics.getHeight() / 2.0 - (double)fontMetrics.getDescent() + 0.5);
    }

    public static void drawStringCenterY(Graphics graphics, Component component, String string, int n) {
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, -1, n, UIUtility.getBaseLineCenterY(component.getHeight(), graphics.getFontMetrics()));
    }

    public static void drawString(Graphics graphics, String string, int n, int n2) {
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, -1, n, n2);
    }

    public static boolean isJXMultiSplitPaneDragging(Component component) {
        while (component != null) {
            if (component instanceof JXMultiSplitPane) {
                return ((JXMultiSplitPane)component).activeDivider() != null;
            }
            component = component.getParent();
        }
        return false;
    }

    public static JButton createToolbarButton(Action action, boolean bl) {
        JButton jButton = new JButton(action);
        if (bl) {
            jButton.setHideActionText(true);
            jButton.setToolTipText((String)action.getValue("Name"));
        }
        jButton.setFocusPainted(false);
        return jButton;
    }

    public static Image createDisabledImage(Image image, int n) {
        GrayFilter grayFilter = new GrayFilter(true, n);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), grayFilter);
        Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        return image2;
    }

    public static void openUrl(String string) {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URL(string).toURI());
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    public static boolean confirmDelete(Component component, int n, String string) {
        return UIUtility.confirmDelete(component, n, string, Messages.getString("Message.confirm_delete.single"), Messages.getString("Message.confirm_delete.multiple"));
    }

    public static boolean confirmDelete(Component component, int n, String string, String string2, String string3) {
        String string4;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n == 1) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            string4 = MessageFormat.format(string2, string);
        } else {
            string4 = MessageFormat.format(string3, Integer.toString(n));
        }
        int n2 = JOptionPane.showConfirmDialog(component, string4, Messages.getString("Message.confirm"), 0, 2);
        return n2 == 0;
    }

    public static String convertToHTML(String string) {
        return "<html>" + UIUtility.escapeHtml(string) + "</html>";
    }

    public static String escapeHtml(String string) {
        string = StringEscapeUtils.escapeHtml4((String)string);
        string = string.replaceAll(" ", "&#160;");
        string = string.replaceAll("\\n", "<br>");
        return string;
    }

    public static void setDefaultTextComponentOption(JTextComponent jTextComponent) {
        UIUtility.setTextComponentUndoable(jTextComponent);
        UIUtility.setTextComponentPopupMenu(jTextComponent);
    }

    public static UndoManager setTextComponentUndoable(JTextComponent jTextComponent) {
        final UndoManager undoManager = new UndoManager();
        jTextComponent.getDocument().addUndoableEditListener(undoManager);
        jTextComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getModifiers() == MENU_KEY_MASK) {
                    switch (keyEvent.getKeyCode()) {
                        case 90: {
                            if (undoManager.canUndo()) {
                                undoManager.undo();
                            }
                            keyEvent.consume();
                            break;
                        }
                        case 89: {
                            if (undoManager.canRedo()) {
                                undoManager.redo();
                            }
                            keyEvent.consume();
                        }
                    }
                    return;
                }
            }
        });
        return undoManager;
    }

    public static void setTextComponentPopupMenu(final JTextComponent jTextComponent) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.cut();
            }
        };
        abstractAction.putValue("Name", Messages.getString("Action.cut"));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, MENU_KEY_MASK));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.copy();
            }
        };
        abstractAction2.putValue("Name", Messages.getString("Action.copy"));
        abstractAction2.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MENU_KEY_MASK));
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.paste();
            }
        };
        abstractAction3.putValue("Name", Messages.getString("Action.paste"));
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, MENU_KEY_MASK));
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.selectAll();
            }
        };
        abstractAction4.putValue("Name", Messages.getString("Action.select_all"));
        abstractAction4.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, MENU_KEY_MASK));
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(abstractAction);
        jPopupMenu.add(abstractAction2);
        jPopupMenu.add(abstractAction3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(abstractAction4);
        jTextComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (UIUtility.isRightMouseButton(mouseEvent)) {
                    jPopupMenu.show(jTextComponent, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    mouseEvent.consume();
                }
            }
        });
    }

    public static void setShortDescription(Action action) {
        Object object = (String)action.getValue("Name");
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            object = (String)object + " (" + UIUtility.keyStrokeToString(keyStroke) + ")";
        }
        action.putValue("ShortDescription", object);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        StringBuilder stringBuilder = new StringBuilder(50);
        int n = keyStroke.getModifiers();
        String string = "+";
        if ((n & 0x41) != 0) {
            stringBuilder.append("Shift");
        }
        if ((n & 0x82) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("Ctrl");
        }
        if ((n & 0x104) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("Meta");
        }
        if ((n & 0x208) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("Alt");
        }
        if ((n & 0x410) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("Button1");
        }
        if ((n & 0x808) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("Button2");
        }
        if ((n & 0x1004) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append("Button3");
        }
        switch (keyStroke.getKeyEventType()) {
            case 400: {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(keyStroke.getKeyChar());
                break;
            }
            case 401: 
            case 402: {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(UIUtility.getKeyText(keyStroke.getKeyCode()));
                break;
            }
        }
        return stringBuilder.toString();
    }

    public static String getKeyText(int n) {
        if (n >= 48 && n <= 57 || n >= 65 && n <= 90) {
            return String.valueOf((char)n);
        }
        switch (n) {
            case 44: {
                return "COMMA";
            }
            case 46: {
                return "PERIOD";
            }
            case 47: {
                return "SLASH";
            }
            case 59: {
                return "SEMICOLON";
            }
            case 61: {
                return "EQUALS";
            }
            case 91: {
                return "OPEN_BRACKET";
            }
            case 92: {
                return "BACK_SLASH";
            }
            case 93: {
                return "CLOSE_BRACKET";
            }
            case 10: {
                return "ENTER";
            }
            case 8: {
                return "BACK_SPACE";
            }
            case 9: {
                return "TAB";
            }
            case 3: {
                return "CANCEL";
            }
            case 12: {
                return "CLEAR";
            }
            case 16: {
                return "SHIFT";
            }
            case 17: {
                return "CONTROL";
            }
            case 18: {
                return "ALT";
            }
            case 19: {
                return "PAUSE";
            }
            case 20: {
                return "CAPS_LOCK";
            }
            case 27: {
                return "ESCAPE";
            }
            case 32: {
                return "SPACE";
            }
            case 33: {
                return "PAGE_UP";
            }
            case 34: {
                return "PAGE_DOWN";
            }
            case 35: {
                return "END";
            }
            case 36: {
                return "HOME";
            }
            case 37: {
                return "LEFT";
            }
            case 38: {
                return "UP";
            }
            case 39: {
                return "RIGHT";
            }
            case 40: {
                return "DOWN";
            }
            case 106: {
                return "MULTIPLY";
            }
            case 107: {
                return "ADD";
            }
            case 108: {
                return "SEPARATOR";
            }
            case 109: {
                return "SUBTRACT";
            }
            case 110: {
                return "DECIMAL";
            }
            case 111: {
                return "DIVIDE";
            }
            case 127: {
                return "DELETE";
            }
            case 144: {
                return "NUM_LOCK";
            }
            case 145: {
                return "SCROLL_LOCK";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
            case 154: {
                return "PRINTSCREEN";
            }
            case 155: {
                return "INSERT";
            }
            case 156: {
                return "HELP";
            }
            case 157: {
                return "META";
            }
            case 192: {
                return "BACK_QUOTE";
            }
            case 222: {
                return "QUOTE";
            }
            case 224: {
                return "KP_UP";
            }
            case 225: {
                return "KP_DOWN";
            }
            case 226: {
                return "KP_LEFT";
            }
            case 227: {
                return "KP_RIGHT";
            }
            case 128: {
                return "DEAD_GRAVE";
            }
            case 129: {
                return "DEAD_ACUTE";
            }
            case 130: {
                return "DEAD_CIRCUMFLEX";
            }
            case 131: {
                return "DEAD_TILDE";
            }
            case 132: {
                return "DEAD_MACRON";
            }
            case 133: {
                return "DEAD_BREVE";
            }
            case 134: {
                return "DEAD_ABOVEDOT";
            }
            case 135: {
                return "DEAD_DIAERESIS";
            }
            case 136: {
                return "DEAD_ABOVERING";
            }
            case 137: {
                return "DEAD_DOUBLEACUTE";
            }
            case 138: {
                return "DEAD_CARON";
            }
            case 139: {
                return "DEAD_CEDILLA";
            }
            case 140: {
                return "DEAD_OGONEK";
            }
            case 141: {
                return "DEAD_IOTA";
            }
            case 142: {
                return "DEAD_VOICED_SOUND";
            }
            case 143: {
                return "DEAD_SEMIVOICED_SOUND";
            }
            case 150: {
                return "AMPERSAND";
            }
            case 151: {
                return "ASTERISK";
            }
            case 152: {
                return "QUOTEDBL";
            }
            case 153: {
                return "LESS";
            }
            case 160: {
                return "GREATER";
            }
            case 161: {
                return "BRACELEFT";
            }
            case 162: {
                return "BRACERIGHT";
            }
            case 512: {
                return "AT";
            }
            case 513: {
                return "COLON";
            }
            case 514: {
                return "CIRCUMFLEX";
            }
            case 515: {
                return "DOLLAR";
            }
            case 516: {
                return "EURO_SIGN";
            }
            case 517: {
                return "EXCLAMATION_MARK";
            }
            case 518: {
                return "INVERTED_EXCLAMATION_MARK";
            }
            case 519: {
                return "LEFT_PARENTHESIS";
            }
            case 520: {
                return "NUMBER_SIGN";
            }
            case 45: {
                return "MINUS";
            }
            case 521: {
                return "PLUS";
            }
            case 522: {
                return "RIGHT_PARENTHESIS";
            }
            case 523: {
                return "UNDERSCORE";
            }
            case 24: {
                return "FINAL";
            }
            case 28: {
                return "CONVERT";
            }
            case 29: {
                return "NONCONVERT";
            }
            case 30: {
                return "ACCEPT";
            }
            case 31: {
                return "MODECHANGE";
            }
            case 21: {
                return "KANA";
            }
            case 25: {
                return "KANJI";
            }
            case 240: {
                return "ALPHANUMERIC";
            }
            case 241: {
                return "KATAKANA";
            }
            case 242: {
                return "HIRAGANA";
            }
            case 243: {
                return "FULL_WIDTH";
            }
            case 244: {
                return "HALF_WIDTH";
            }
            case 245: {
                return "ROMAN_CHARACTERS";
            }
            case 256: {
                return "ALL_CANDIDATES";
            }
            case 257: {
                return "PREVIOUS_CANDIDATE";
            }
            case 258: {
                return "CODE_INPUT";
            }
            case 259: {
                return "JAPANESE_KATAKANA";
            }
            case 260: {
                return "JAPANESE_HIRAGANA";
            }
            case 261: {
                return "JAPANESE_ROMAN";
            }
            case 262: {
                return "KANA_LOCK";
            }
            case 263: {
                return "INPUT_METHOD_ON_OFF";
            }
            case 65481: {
                return "AGAIN";
            }
            case 65483: {
                return "UNDO";
            }
            case 65485: {
                return "COPY";
            }
            case 65487: {
                return "PASTE";
            }
            case 65489: {
                return "CUT";
            }
            case 65488: {
                return "FIND";
            }
            case 65482: {
                return "PROPS";
            }
            case 65480: {
                return "STOP";
            }
            case 65312: {
                return "COMPOSE";
            }
            case 65406: {
                return "ALT_GRAPH";
            }
        }
        if (n >= 96 && n <= 105) {
            char c = (char)(n - 96 + 48);
            return "NUMPAD" + c;
        }
        return "unknown(0x" + Integer.toString(n, 16) + ")";
    }

    private static final class ExtensionFilter
    extends FileFilter {
        private FileKey.FileExtensionFilter filter;

        public ExtensionFilter(FileKey.FileExtensionFilter fileExtensionFilter) {
            this.filter = fileExtensionFilter;
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String[] stringArray = this.filter.getExtensions();
            String string = file.getName().toLowerCase();
            for (String string2 : stringArray) {
                String object = "." + string2.toLowerCase();
                if (!string.endsWith(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.filter.getDescription();
        }
    }
}

