/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowSegment;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.ui.app.r.RMultiNodesScriptView;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;

public class AbstractFlowNodePreviewView
extends View
implements PropertyChangeListener {
    private static final String FOCUS_OWNER = "focusOwner";
    private SwitchPanel switchPanel;
    private FlowViewer activerViewer;
    private boolean active;
    private Set<FlowNode> nodes;
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);

    public AbstractFlowNodePreviewView() {
        this.switchPanel = new SwitchPanel();
        this.add((Component)this.switchPanel, "Center");
    }

    public void startEditing() {
        View view2 = this.getView();
        if (view2 instanceof FlowNodeView) {
            ((FlowNodeView)view2).startEditing();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void setView(View view2) {
        this.unloadCurrentView();
        this.switchPanel.set(view2);
        if (view2 != null) {
            view2.loadView();
        }
    }

    private void unloadCurrentView() {
        Component component = this.switchPanel.get();
        if (component instanceof View) {
            View view2 = (View)component;
            view2.unloadView();
        }
    }

    public View getView() {
        Component component = this.switchPanel.get();
        if (component instanceof View) {
            return (View)component;
        }
        return null;
    }

    public Set<FlowNode> getNodes() {
        return this.nodes;
    }

    public FlowViewer getActiveViewer() {
        return this.activerViewer;
    }

    private void setActiveViewer(FlowViewer flowViewer) {
        if (this.activerViewer == flowViewer) {
            return;
        }
        this.activerViewer = flowViewer;
        Rflow.mainView().fireActiveViewerChanged();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUS_OWNER, this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FOCUS_OWNER, this);
        this.unloadCurrentView();
    }

    public void setSelectedNode(Set<FlowNode> set) {
        this.nodes = null;
        this.setActiveViewer(null);
        if (set == null || set.isEmpty()) {
            this.setView(null);
            return;
        }
        if (set.size() == 1) {
            FlowNode flowNode = set.iterator().next();
            NodeModelController nodeModelController = NodeModelManager.getModelController(flowNode.getModel().getClass());
            FlowNodeView flowNodeView = nodeModelController.createView(flowNode, true);
            if (flowNodeView instanceof SubflowNodeView) {
                FlowViewer[] flowViewerArray;
                for (FlowViewer flowViewer : flowViewerArray = ((SubflowNodeView)flowNodeView).getViewers()) {
                    flowViewer.setChildView(true);
                }
            }
            this.nodes = set;
            this.setView(flowNodeView);
        } else {
            FlowSegment flowSegment = FlowUtil.getFlowSegment(set);
            if (flowSegment != null) {
                this.nodes = set;
                this.setView(new RMultiNodesScriptView(set, flowSegment, true));
            } else {
                this.setView(null);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (FOCUS_OWNER.equals(propertyChangeEvent.getPropertyName())) {
            Boolean bl = null;
            FlowViewer flowViewer = null;
            if (propertyChangeEvent.getNewValue() instanceof Component) {
                for (Component component = (Component)propertyChangeEvent.getNewValue(); component != null; component = component.getParent()) {
                    if (component instanceof FlowViewer) {
                        flowViewer = (FlowViewer)((Object)component);
                    }
                    if (component == this) {
                        bl = true;
                        break;
                    }
                    if (component != this.getParent()) continue;
                    bl = false;
                    break;
                }
            }
            if (bl != null) {
                this.active = bl;
                this.changeEventSupport.dispatchEvent();
                this.setActive(bl);
                this.setActiveViewer(bl != false ? flowViewer : null);
            }
        }
    }

    protected void setActive(boolean bl) {
    }

    public void addEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    public void removeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }
}

