/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.ExcelConnection;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.app.file.ZipInfo;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileEditViewFactory;
import com.ef_prime.rflow.ui.view.ExcelSheetFileNode;
import com.ef_prime.rflow.ui.view.FileForSort;
import com.ef_prime.rflow.ui.view.FileNode;
import com.ef_prime.rflow.ui.view.GroupFileNode;
import com.ef_prime.rflow.ui.view.ZipFileNode;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicFileNode
implements FileNode {
    private static Icon nattoIcon;
    protected File file;
    protected String filePath;
    protected FileInfo info;
    private boolean fileValid;
    private boolean isDirectory;
    private boolean isHidden;
    private String name;
    protected List<FileNode> children = new ArrayList<FileNode>();
    private FileNode parent;
    private boolean hiddenFiles;
    private boolean childrenReady;
    public static final Comparator<FileForSort> NAME_COMPARATOR;
    public static final Comparator<FileForSort> TYPE_COMPARATOR;
    protected static Comparator<FileForSort> comparator;

    public BasicFileNode(File file) {
        this(file, true);
    }

    public BasicFileNode(File file, boolean bl) {
        this.init(file);
        this.hiddenFiles = bl;
    }

    BasicFileNode(boolean bl) {
        this.hiddenFiles = bl;
    }

    private void init(File file) {
        this.file = file;
        this.info = FileInfos.getInstance().getFileInfo(file);
        if (file != null) {
            this.filePath = FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
        }
        this.updateAttributes();
    }

    protected void updateAttributes() {
        if (this.file == null) {
            this.fileValid = true;
            this.isDirectory = true;
            this.isHidden = false;
        } else {
            this.fileValid = this.info.exists();
            this.isDirectory = this.info.isDirectory();
            this.isHidden = BasicFileNode.isHidden(this.file);
        }
    }

    protected static boolean isHidden(File file) {
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        return fileInfo.isHidden() || file.getName().startsWith(".");
    }

    protected static boolean isHidden(FileInfo fileInfo) {
        return fileInfo.isHidden() || fileInfo.getFile().getName().startsWith(".");
    }

    public static Comparator<FileForSort> getComparator() {
        return comparator;
    }

    public static void setComparator(Comparator<FileForSort> comparator) {
        BasicFileNode.comparator = comparator;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public List<FileNode> retrieveChildren() {
        this.info = FileInfos.getInstance().refreshFileInfo(this.file);
        this.updateAttributes();
        if (this.isDirectory) {
            return this.refreshDirectoryChildren();
        }
        if (this.info.is(FileInfo.ZIP)) {
            return this.refreshZipChildren();
        }
        if (this.info.is(FileInfo.EXCEL)) {
            return this.refreshExcelChildren();
        }
        return new ArrayList<FileNode>(0);
    }

    @Override
    public void setChildren(List<FileNode> list) {
        if (list == null) {
            return;
        }
        this.childrenReady = true;
        this.children = list;
        if (this.watchChildren() && !FileManager.getInstance().isRecursiveFileWatch()) {
            ThreadUtility.execute(() -> {
                for (FileNode fileNode : list) {
                    if (!fileNode.isFile()) continue;
                    FileManager.getInstance().watchDirectory(fileNode.getFile().toPath());
                }
            });
        }
    }

    public List<FileNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean areChildrenReady() {
        return this.childrenReady;
    }

    public void resetChildrenReady() {
        this.childrenReady = false;
    }

    protected boolean watchChildren() {
        return true;
    }

    @Override
    public void refreshState() {
        this.hiddenFiles = Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
    }

    private List<FileNode> refreshDirectoryChildren() {
        List<FileForSort> list = this.getFileChildren(this.isHiddenFiles());
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>(list.size());
        for (FileForSort fileForSort : list) {
            BasicFileNode basicFileNode = new BasicFileNode(fileForSort.getFile(), this.isHiddenFiles());
            arrayList.add(basicFileNode);
            basicFileNode.setParent(this);
        }
        return arrayList;
    }

    protected List<FileForSort> getFileChildren(final boolean bl) {
        final ArrayList<FileForSort> arrayList = new ArrayList<FileForSort>();
        try {
            Files.walkFileTree(this.file.toPath(), Sets.newHashSet(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    FileInfo fileInfo = FileInfos.getInstance().getFileInfo(path.toFile(), basicFileAttributes);
                    if (bl || !BasicFileNode.isHidden(fileInfo)) {
                        arrayList.add(new FileForSort(path, basicFileAttributes.isDirectory()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private List<FileNode> refreshZipChildren() {
        Object object;
        block12: {
            if (!this.info.isZip()) {
                return new ArrayList<FileNode>(0);
            }
            ZipFile zipFile = ZipInfo.get(this.file).createZipFile();
            try {
                Object object2;
                Object object3;
                Enumeration enumeration = zipFile.getEntries();
                ArrayList<FileForSort> arrayList = new ArrayList<FileForSort>();
                HashSet<Object> hashSet = new HashSet<Object>();
                while (enumeration.hasMoreElements()) {
                    object3 = (ZipArchiveEntry)enumeration.nextElement();
                    object = ZipFileUtility.path(object3.getName());
                    int n = ((String)object).indexOf(47);
                    if (n >= 0 && n < ((String)object).length() - 1) {
                        object2 = ((String)object).substring(0, n + 1);
                        if (hashSet.contains(object2)) continue;
                        object3 = new ZipArchiveEntry((String)object2);
                        object = object2;
                    }
                    hashSet.add(object);
                    arrayList.add(new FileForSort((String)object));
                }
                Collections.sort(arrayList, comparator);
                object3 = new ArrayList(arrayList.size());
                for (FileForSort fileForSort : arrayList) {
                    object2 = new File(this.file.getAbsolutePath(), fileForSort.getName());
                    ZipFileNode zipFileNode = new ZipFileNode((File)object2, this.file, fileForSort.getName());
                    zipFileNode.setParent(this);
                    object3.add(zipFileNode);
                }
                object = object3;
                if (zipFile == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return new ArrayList<FileNode>(0);
                }
            }
            zipFile.close();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileNode> refreshExcelChildren() {
        if (this.file.length() > 0xA00000L) {
            return new ArrayList<FileNode>(0);
        }
        try (ExcelConnection excelConnection = null;){
            excelConnection = new ExcelConnection(this.file);
            List<String> list = excelConnection.getSheetNames();
            ArrayList<ExcelSheetFileNode> arrayList = new ArrayList<ExcelSheetFileNode>(list.size());
            for (String string : list) {
                File file = new File(this.file, string);
                ExcelSheetFileNode excelSheetFileNode = new ExcelSheetFileNode(file);
                arrayList.add(excelSheetFileNode);
                excelSheetFileNode.setParent(this);
            }
            ArrayList<ExcelSheetFileNode> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isFileValid() {
        return this.fileValid;
    }

    @Override
    public boolean isLinkEntry() {
        return this.getParent() instanceof GroupFileNode;
    }

    @Override
    public boolean isFixedNode() {
        return false;
    }

    @Override
    public String getName() {
        String string;
        String string2 = string = this.name == null ? FilenameUtils.getName((String)this.filePath) : this.name;
        if (this.file.equals(WorkingDirectory.getWorkingDirectory())) {
            return "<html>" + string + " <font color=\"#4f71a8\">(" + Messages.getString("View.FileTree.working_dir") + ")</font></html>";
        }
        return string;
    }

    @Override
    public void setName(String string) {
        if (string != null && (string.isEmpty() || string.equals(FilenameUtils.getName((String)this.filePath)))) {
            string = null;
        }
        this.name = string;
    }

    @Override
    public Icon getIcon() {
        if (this.info.isRflow()) {
            return FileResource.getIcon("img/doc_16.png");
        }
        if (Rflow.isDevel() && this.info.isExtension("natto")) {
            if (nattoIcon == null) {
                try {
                    Class<?> clazz = Class.forName("natto.resource.NattoImages");
                    Field field = clazz.getField("APP_16");
                    nattoIcon = (Icon)field.get(null);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                    nattoIcon = FileEditViewFactory.getInstance().getIcon(this.info.getExtension());
                }
            }
            return nattoIcon;
        }
        return FileEditViewFactory.getInstance().getIcon(this.info.getExtension());
    }

    public void setHiddenFiles(boolean bl) {
        this.hiddenFiles = bl;
    }

    public boolean isHiddenFiles() {
        return this.hiddenFiles;
    }

    @Override
    public Enumeration<? extends TreeNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDirectory || this.info.is(FileInfo.ZIP) || this.info.is(FileInfo.EXCEL);
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        if (this.info.is(FileInfo.ZIP)) {
            return false;
        }
        return !this.isDirectory;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
    }

    @Override
    public void remove(int n) {
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
    }

    @Override
    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (FileNode)mutableTreeNode;
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public String getTypeKey() {
        return "entry";
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        String string = Rflow.project().toProjectAbstractPath(this.file);
        element.setAttribute("path", string);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        String string = element.getAttribute("path");
        string = Rflow.project().toProjectAbsolutePath(string);
        this.init(new File(string));
        this.setName(element.getAttribute("name"));
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("type", this.getTypeKey());
        linkedHashMap.put("path", Rflow.project().toProjectAbstractPath(this.file));
        if (this.name != null) {
            linkedHashMap.put("name", this.name);
        }
        return linkedHashMap;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        String string = Rflow.project().toProjectAbsolutePath((String)map.get("path"));
        this.init(new File(string));
        this.setName((String)map.get("name"));
    }

    public int hashCode() {
        return this.filePath == null ? 0 : this.filePath.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicFileNode)) {
            return false;
        }
        BasicFileNode basicFileNode = (BasicFileNode)object;
        return Objects.equals(this.filePath, basicFileNode.filePath);
    }

    static {
        NAME_COMPARATOR = new Comparator<FileForSort>(){

            @Override
            public int compare(FileForSort fileForSort, FileForSort fileForSort2) {
                if (fileForSort.isDirectory() ^ fileForSort2.isDirectory()) {
                    return fileForSort.isDirectory() ? -1 : 1;
                }
                return fileForSort.getName().compareToIgnoreCase(fileForSort2.getName());
            }
        };
        TYPE_COMPARATOR = new Comparator<FileForSort>(){

            @Override
            public int compare(FileForSort fileForSort, FileForSort fileForSort2) {
                int n;
                if (fileForSort.isDirectory() ^ fileForSort2.isDirectory()) {
                    return fileForSort.isDirectory() ? -1 : 1;
                }
                if (!fileForSort.isDirectory() && (n = fileForSort.getExtension().compareToIgnoreCase(fileForSort2.getExtension())) != 0) {
                    return n;
                }
                return fileForSort.getName().compareToIgnoreCase(fileForSort2.getName());
            }
        };
        comparator = TYPE_COMPARATOR;
    }
}

