/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.feature.search.LineSearchResult;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowScrollPane;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.GraphicsUtility;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.ArrayUtils;

public class BreakpointExplorer
extends View
implements NodeBreakpointChangeListener,
GraphEventListener,
ActiveViewEventHandler {
    private static final ImageIcon BREAKPOINT_ICON = GraphicsUtility.createCircleIcon(10, 0, Color.ORANGE);
    private static final ImageIcon DISABLED_BREAKPOINT_ICON = GraphicsUtility.createCircleIcon(10, 0, Color.LIGHT_GRAY);
    private JList<BreakpointEntry> list;
    private FlowModel model;
    private List<BreakpointEntry> entries;
    private boolean lockState;

    public BreakpointExplorer() {
        this.setTitle(Messages.getString("Explorer.breakpoint"));
        this.setIconOnly(true);
        FlowViewer.addGraphEventListener(this);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
        FlowNode.addNodeBreakpointChangeListener(this);
        this.setLayout(new BorderLayout());
        this.entries = new ArrayList<BreakpointEntry>();
        this.list = new JList<BreakpointEntry>(new DefaultListModel()){

            @Override
            public int locationToIndex(Point point) {
                if (point.y > this.getFixedCellHeight() * BreakpointExplorer.this.list.getModel().getSize()) {
                    return -1;
                }
                return super.locationToIndex(point);
            }
        };
        this.list.setCellRenderer(new BreakpointCellRenderer());
        this.list.setSelectionMode(2);
        this.list.getSelectionModel().addListSelectionListener(new SelectionHandler());
        MouseHandler mouseHandler = new MouseHandler();
        UIUtility.insertMouseListener(this.list, mouseHandler);
        this.list.addMouseMotionListener(mouseHandler);
        this.list.setFixedCellHeight(20);
        RflowScrollPane rflowScrollPane = new RflowScrollPane(this.list);
        this.add(rflowScrollPane);
        this.setActionMap(new BreakpointActions());
        this.setInputMap(1, UIUtility.createInputMap(this.getActionMap()));
        this.refreshIcon();
    }

    private void refreshIcon() {
        boolean bl = false;
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            if (!((BreakpointEntry)defaultListModel.getElementAt(i)).isBreakpointEnabled()) continue;
            bl = true;
            break;
        }
        this.setIcon(bl ? BREAKPOINT_ICON : DISABLED_BREAKPOINT_ICON);
        this.updateTab();
    }

    public void update() {
        this.entries.clear();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        defaultListModel.removeAllElements();
        if (this.model == null) {
            this.refreshIcon();
            return;
        }
        ArrayDeque<ViewLayout> arrayDeque = new ArrayDeque<ViewLayout>();
        arrayDeque.add(this.model.getLayout());
        while (!arrayDeque.isEmpty()) {
            ViewLayout viewLayout = (ViewLayout)arrayDeque.removeLast();
            for (Object e : viewLayout.getGraph().getVertices()) {
                FlowNode flowNode = (FlowNode)e;
                List<Integer> list = flowNode.getModel().getBreakpoints();
                if (!list.isEmpty()) {
                    for (Integer n : list) {
                        this.entries.add(new BreakpointEntry(flowNode, n));
                    }
                }
                if (!flowNode.getModel().isSubflow()) continue;
                SubflowNodeModel subflowNodeModel = (SubflowNodeModel)flowNode.getModel();
                ViewLayout[] viewLayoutArray = subflowNodeModel.getLayouts();
                for (int i = viewLayoutArray.length - 1; i >= 0; --i) {
                    arrayDeque.add(viewLayoutArray[i]);
                }
            }
        }
        Collections.sort(this.entries);
        for (BreakpointEntry breakpointEntry : this.entries) {
            defaultListModel.addElement(breakpointEntry);
        }
        this.refreshIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        this.setLockState(true);
        try {
            FlowNode.fireNodeBreakpointChanged(flowNode, n, n2, false);
        }
        finally {
            this.setLockState(false);
        }
    }

    @Override
    public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        if (this.lockState) {
            return;
        }
        this.update();
    }

    public void setLockState(boolean bl) {
        this.lockState = bl;
    }

    public void edgeAdded(GraphEvent graphEvent) {
    }

    public void edgeRemoved(GraphEvent graphEvent) {
    }

    public void vertexAdded(GraphEvent graphEvent) {
        this.processNodeGraphEvent(graphEvent);
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        this.processNodeGraphEvent(graphEvent);
    }

    private void processNodeGraphEvent(GraphEvent graphEvent) {
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (flowGraph.isAdjusting()) {
            return;
        }
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        if (!flowNode.getModel().getBreakpoints().isEmpty()) {
            this.update();
        }
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        FlowModel flowModel = activeViewEvent.getActiveFileEdit(FlowModel.class);
        if (this.model != flowModel) {
            this.model = flowModel;
            this.update();
        }
    }

    private static class BreakpointCellRenderer
    extends JPanel
    implements ListCellRenderer<BreakpointEntry> {
        private JLabel breakpointLabel;
        private JLabel label;

        public BreakpointCellRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.breakpointLabel = new JLabel();
            this.breakpointLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
            this.label = new JLabel();
            this.add(this.breakpointLabel);
            this.add(this.label);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends BreakpointEntry> jList, BreakpointEntry breakpointEntry, int n, boolean bl, boolean bl2) {
            this.label.setFont(jList.getFont());
            if (bl) {
                this.label.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.label.setForeground(jList.getForeground());
                this.setBackground(Color.WHITE);
            }
            BreakpointEntry breakpointEntry2 = breakpointEntry;
            Object object = breakpointEntry2.node.getTitle();
            if (breakpointEntry2.canSetInnerBreakpoint() && breakpointEntry2.isInnerBreakpoint()) {
                object = (String)object + "(line:" + breakpointEntry2.getLineNumber() + ")";
            }
            this.label.setText((String)object);
            Icon icon = breakpointEntry2.node.getSmallIcon();
            if (icon != null) {
                this.label.setIcon(icon);
            }
            this.breakpointLabel.setIcon(breakpointEntry2.isBreakpointEnabled() ? BREAKPOINT_ICON : DISABLED_BREAKPOINT_ICON);
            return this;
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BreakpointExplorer.this.model == null) {
                return;
            }
            int[] nArray = BreakpointExplorer.this.list.getSelectedIndices();
            FlowState flowState = BreakpointExplorer.this.model.getState();
            flowState.clearTaskHighlightNode();
            HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
            for (int n : nArray) {
                BreakpointEntry breakpointEntry = BreakpointExplorer.this.list.getModel().getElementAt(n);
                hashSet.add(breakpointEntry.node);
            }
            flowState.addTaskHighlightNode(hashSet);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private int iconArea = 20;
        private Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
        private Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);

        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = BreakpointExplorer.this.list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && mouseEvent.getPoint().x < this.iconArea) {
                BreakpointExplorer.this.list.setCursor(this.HAND_CURSOR);
            } else {
                BreakpointExplorer.this.list.setCursor(this.DEFAULT_CURSOR);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getPoint().x < this.iconArea) {
                mouseEvent.consume();
                int n = BreakpointExplorer.this.list.locationToIndex(mouseEvent.getPoint());
                new ToggleBreakpoint(n).doAction();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = BreakpointExplorer.this.list.locationToIndex(mouseEvent.getPoint());
            if (mouseEvent.getPoint().x < this.iconArea) {
                return;
            }
            if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                if (n < 0) {
                    return;
                }
                BreakpointEntry breakpointEntry = BreakpointExplorer.this.list.getModel().getElementAt(n);
                FlowNode flowNode = breakpointEntry.node;
                boolean bl = flowNode.getModel().canSetInnerBreakpoint();
                flowNode = !breakpointEntry.isInnerBreakpoint() || breakpointEntry.getLineNumber() == 1 && !bl ? flowNode.getParentNode() : breakpointEntry.node;
                Rflow.mainView().openViewer(flowNode, ViewOpenType.OPEN_NEW);
                if (bl) {
                    final FlowNode flowNode2 = flowNode;
                    final int n2 = breakpointEntry.getLineNumber();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            View view2 = Rflow.mainView().getView(flowNode2);
                            if (view2 != null) {
                                view2.select(new LineSearchResult(n2));
                            }
                        }
                    });
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                this.ensureSelected(n);
                this.createPopup().show(BreakpointExplorer.this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        }

        private void ensureSelected(int n) {
            if (n < 0) {
                BreakpointExplorer.this.list.clearSelection();
            } else {
                int[] nArray = BreakpointExplorer.this.list.getSelectedIndices();
                int n2 = Arrays.binarySearch(nArray, n);
                if (n2 < 0) {
                    BreakpointExplorer.this.list.clearSelection();
                    BreakpointExplorer.this.list.setSelectedIndex(n);
                }
            }
        }

        private JPopupMenu createPopup() {
            ActionMap actionMap = BreakpointExplorer.this.getActionMap();
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(actionMap.get(BreakpointActions.EnableAll.class));
            jPopupMenu.add(actionMap.get(BreakpointActions.DisableAll.class));
            if (!BreakpointExplorer.this.list.isSelectionEmpty()) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(actionMap.get(BreakpointActions.Remove.class));
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(actionMap.get(BreakpointActions.Update.class));
            return jPopupMenu;
        }
    }

    private class BreakpointActions
    extends Actions {
        public BreakpointActions() {
            this.put(new EnableAll());
            this.put(new DisableAll());
            this.put(new Remove());
            this.put(new Update());
        }

        private class EnableAll
        extends LoggableAction {
            public EnableAll() {
                this.putValue("Name", Messages.getString("Action.enable_all"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ListModel<BreakpointEntry> listModel = BreakpointExplorer.this.list.getModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    listModel.getElementAt(i).setEnabled(true);
                }
                BreakpointExplorer.this.refreshIcon();
                BreakpointExplorer.this.list.repaint();
            }
        }

        private class DisableAll
        extends LoggableAction {
            public DisableAll() {
                this.putValue("Name", Messages.getString("Action.disable_all"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ListModel<BreakpointEntry> listModel = BreakpointExplorer.this.list.getModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    listModel.getElementAt(i).setEnabled(false);
                }
                BreakpointExplorer.this.refreshIcon();
                BreakpointExplorer.this.list.repaint();
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (BreakpointExplorer.this.model == null) {
                    return;
                }
                int[] nArray = BreakpointExplorer.this.list.getSelectedIndices();
                if (nArray.length > 0) {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        BreakpointEntry breakpointEntry = BreakpointExplorer.this.list.getModel().getElementAt(nArray[i]);
                        if (breakpointEntry.isInnerBreakpoint()) {
                            List<Integer> list = breakpointEntry.node.getModel().getBreakpoints();
                            if (!list.isEmpty()) {
                                int n = breakpointEntry.line > 0 ? 1 : 2;
                                int n2 = 0;
                                list.remove(breakpointEntry.line);
                                BreakpointExplorer.this.fireNodeBreakpointChanged(breakpointEntry.node, n, n2);
                            }
                        } else {
                            breakpointEntry.node.setBreakpointState(0);
                        }
                        ((DefaultListModel)BreakpointExplorer.this.list.getModel()).remove(nArray[i]);
                    }
                    BreakpointExplorer.this.model.setDirty(true);
                    BreakpointExplorer.this.refreshIcon();
                }
            }
        }

        private class Update
        extends LoggableAction {
            public Update() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                BreakpointExplorer.this.update();
            }
        }
    }

    private class BreakpointEntry
    implements Comparable<BreakpointEntry> {
        private FlowNode node;
        private Integer line;

        public BreakpointEntry(FlowNode flowNode, Integer n) {
            this.node = flowNode;
            this.line = n;
        }

        public boolean canSetInnerBreakpoint() {
            return this.node.getModel().canSetInnerBreakpoint();
        }

        public boolean isInnerBreakpoint() {
            return this.line != null;
        }

        public boolean isBreakpointEnabled() {
            return this.isInnerBreakpoint() ? this.line > 0 : this.node.isFirstBreakpointEnabled();
        }

        public int getLineNumber() {
            return Math.abs(this.line);
        }

        @Override
        public int compareTo(BreakpointEntry breakpointEntry) {
            return this.node.getTitle().compareTo(breakpointEntry.node.getTitle());
        }

        public void setEnabled(boolean bl) {
            if (this.isInnerBreakpoint()) {
                List<Integer> list = this.node.getModel().getBreakpoints();
                int n = list.indexOf(this.line);
                if (n < 0) {
                    return;
                }
                if (bl ^ this.line > 0) {
                    this.line = -this.line.intValue();
                    list.set(n, this.line);
                    int n2 = this.line > 0 ? 1 : 2;
                    int n3 = this.line > 0 ? 2 : 1;
                    BreakpointExplorer.this.fireNodeBreakpointChanged(this.node, n2, n3);
                }
            } else if (bl ^ this.node.isFirstBreakpointEnabled()) {
                int n = bl ? 2 : 1;
                this.node.setBreakpointState(n);
            }
        }
    }

    private class ToggleBreakpoint
    extends LoggableAction {
        private int index;

        public ToggleBreakpoint(int n) {
            this.index = n;
        }

        @Override
        public void prepareLog(ActionEvent actionEvent) {
            BreakpointEntry breakpointEntry = BreakpointExplorer.this.list.getModel().getElementAt(this.index);
            boolean bl = !breakpointEntry.isBreakpointEnabled();
            this.putValue("logparameter", bl ? "on" : "off");
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (BreakpointExplorer.this.model == null || this.index < 0) {
                return;
            }
            int[] nArray = BreakpointExplorer.this.list.getSelectedIndices();
            boolean bl = ArrayUtils.contains((int[])nArray, (int)this.index);
            int[] nArray2 = bl ? nArray : new int[]{};
            nArray2 = ArrayUtils.add((int[])nArray2, (int)0, (int)this.index);
            Boolean bl2 = null;
            for (int n : nArray2) {
                BreakpointEntry breakpointEntry = BreakpointExplorer.this.list.getModel().getElementAt(n);
                if (bl2 == null) {
                    bl2 = !breakpointEntry.isBreakpointEnabled();
                }
                breakpointEntry.setEnabled(bl2);
            }
            if (bl) {
                for (int n : nArray2) {
                    BreakpointExplorer.this.list.addSelectionInterval(n, n);
                }
            }
            BreakpointExplorer.this.model.setDirty(true);
            BreakpointExplorer.this.refreshIcon();
            BreakpointExplorer.this.list.repaint();
        }
    }
}

