/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.LineHighlight;
import com.ef_prime.rflow.ui.common.component.WordHighlight;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.SwingXUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import name.fraser.neil.plaintext.diff_match_patch;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.swingx.JXMultiSplitPane;

public class DiffView
extends View {
    private static final Logger LOGGER = Logger.getLogger(DiffView.class.getName());
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private CodingTextArea textArea1 = this.createCodingTextArea();
    private CodingTextArea textArea2 = this.createCodingTextArea();

    public DiffView() {
        JPanel jPanel = this.buildPanel(this.label1, this.textArea1);
        JPanel jPanel2 = this.buildPanel(this.label2, this.textArea2);
        JXMultiSplitPane jXMultiSplitPane = SwingXUtility.createHorizontalSplitPane(jPanel, jPanel2, 0.5);
        this.add((Component)jXMultiSplitPane, "Center");
    }

    private JPanel buildPanel(JLabel jLabel, CodingTextArea codingTextArea) {
        this.configureTextArea(codingTextArea);
        SimpleCodingScrollPane simpleCodingScrollPane = new SimpleCodingScrollPane((RTextArea)codingTextArea, true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)((Object)simpleCodingScrollPane), "Center");
        return jPanel;
    }

    private void configureTextArea(CodingTextArea codingTextArea) {
        codingTextArea.setEditable(false);
        codingTextArea.setHighlightCurrentLine(false);
    }

    protected CodingTextArea createCodingTextArea() {
        return new RCodingTextArea();
    }

    public void load(final String string, String string2, final String string3, String string4) {
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiffView.this.label1.setText(string);
                DiffView.this.label2.setText(string3);
                DiffView.this.textArea1.clearHighlights();
                DiffView.this.textArea2.clearHighlights();
                DiffView.this.textArea1.setText("");
                DiffView.this.textArea2.setText("");
            }
        });
        this.doBusyWork(new DiffLoadWorker(string2, string4));
    }

    private void load(String string, String string2, List<DiffEdit> list) {
        this.textArea1.clearHighlights();
        this.textArea2.clearHighlights();
        this.textArea1.setText(string);
        this.textArea2.setText(string2);
        this.textArea1.setCaretPosition(0);
        this.textArea2.setCaretPosition(0);
        Color color = new Color(255, 230, 230);
        Color color2 = new Color(230, 255, 230);
        Color color3 = new Color(240, 200, 200);
        Color color4 = new Color(200, 240, 200);
        Color color5 = new Color(240, 240, 240);
        block13: for (DiffEdit diffEdit : list) {
            Edit edit = diffEdit.getEdit();
            switch (edit.getType()) {
                case DELETE: {
                    this.textArea1.addHighlight(new LineHighlight(edit.getBeginA(), edit.getEndA(), color));
                    break;
                }
                case EMPTY: {
                    break;
                }
                case INSERT: {
                    this.textArea2.addHighlight(new LineHighlight(edit.getBeginB(), edit.getEndB(), color2));
                    break;
                }
                case REPLACE: {
                    this.textArea1.addHighlight(new LineHighlight(edit.getBeginA(), edit.getEndA(), color5));
                    this.textArea2.addHighlight(new LineHighlight(edit.getBeginB(), edit.getEndB(), color5));
                    List<diff_match_patch.Diff> list2 = diffEdit.getDiff();
                    try {
                        int n = this.textArea1.getLineStartOffset(edit.getBeginA());
                        int n2 = this.textArea2.getLineStartOffset(edit.getBeginB());
                        for (diff_match_patch.Diff diff : list2) {
                            int n3 = diff.text.length();
                            switch (diff.operation) {
                                case EQUAL: {
                                    n += n3;
                                    n2 += n3;
                                    break;
                                }
                                case DELETE: {
                                    this.textArea1.addHighlight(new WordHighlight(n, n + n3 - 1, color3));
                                    n += n3;
                                    break;
                                }
                                case INSERT: {
                                    this.textArea2.addHighlight(new WordHighlight(n2, n2 + n3 - 1, color4));
                                    n2 += n3;
                                    break;
                                }
                            }
                        }
                        continue block13;
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Failed to highlight replacement details.", exception);
                        break;
                    }
                }
            }
        }
    }

    private class DiffLoadWorker
    extends SwingWorker<List<DiffEdit>, Void> {
        private String oldText;
        private String newText;

        public DiffLoadWorker(String string, String string2) {
            this.oldText = string;
            this.newText = string2;
        }

        @Override
        protected List<DiffEdit> doInBackground() throws Exception {
            String[] stringArray = this.oldText.split("\n", -1);
            String[] stringArray2 = this.newText.split("\n", -1);
            DiffAlgorithm diffAlgorithm = DiffAlgorithm.getAlgorithm((DiffAlgorithm.SupportedAlgorithm)DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
            EditList editList = diffAlgorithm.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)new RawText(this.oldText.getBytes(StandardCharsets.UTF_8)), (Sequence)new RawText(this.newText.getBytes(StandardCharsets.UTF_8)));
            ArrayList<DiffEdit> arrayList = new ArrayList<DiffEdit>(editList.size());
            diff_match_patch diff_match_patch2 = new diff_match_patch();
            for (Edit edit : editList) {
                LinkedList linkedList = null;
                if (edit.getType() == Edit.Type.REPLACE) {
                    String string = this.getLines(stringArray, edit.getBeginA(), edit.getEndA());
                    String string2 = this.getLines(stringArray2, edit.getBeginB(), edit.getEndB());
                    linkedList = diff_match_patch2.diff_main(string, string2);
                    diff_match_patch2.diff_cleanupSemantic(linkedList);
                }
                arrayList.add(new DiffEdit(edit, linkedList));
            }
            return arrayList;
        }

        private String getLines(String[] stringArray, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n; i < n2; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }

        @Override
        protected void done() {
            try {
                DiffView.this.load(this.oldText, this.newText, (List)this.get());
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.log(Level.SEVERE, "Failed to perform diff on texts.", exception);
            }
        }
    }

    private static class DiffEdit {
        private Edit edit;
        private List<diff_match_patch.Diff> diff;

        public DiffEdit(Edit edit, List<diff_match_patch.Diff> list) {
            this.edit = edit;
            this.diff = list;
        }

        public Edit getEdit() {
            return this.edit;
        }

        public List<diff_match_patch.Diff> getDiff() {
            return this.diff;
        }
    }
}

