/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.base.RflowUI;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CloseButton;
import com.ef_prime.rflow.ui.common.component.DocumentAdapter;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ShapeIconFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

public class FXBrowserView
extends View
implements ValueChangeEventHandler,
ItemListener,
MenuActionProvider {
    private static final Logger LOGGER = Logger.getLogger(FXBrowserView.class.getName());
    private WebView view;
    private WebEngine engine;
    private JFXPanel jfxPanel;
    private JToolBar toolBar;
    private JToolBar searchBar;
    private JTextFieldEx findField;
    private JCheckBox matchCase;
    private JCheckBox wholeWord;
    private BrowserViewActions actions = new BrowserViewActions();
    private List<HistoryEntry> history = new ArrayList<HistoryEntry>();

    public FXBrowserView() {
        this.setTitle(Messages.getString("View.Browser.title"));
        this.setIcon(Icons.getIcon("16/globe_model.png"));
        this.setClosable(true);
        this.jfxPanel = new JFXPanel();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        for (Object object : new Object[]{BrowserViewActions.History.class, BrowserViewActions.Back.class, BrowserViewActions.Forward.class}) {
            Action action = this.actions.get(object);
            JButton jButton = this.toolBar.add(action);
            jButton.setHideActionText(true);
            jButton.setToolTipText((String)action.getValue("Name"));
            jButton.setFocusable(false);
        }
        this.configureToolBar(this.toolBar);
        this.searchBar = new JToolBar();
        this.searchBar.setFloatable(false);
        this.searchBar.setVisible(false);
        this.findField = new JTextFieldEx();
        this.findField.setPreferredSize(new Dimension(200, this.findField.getPreferredSize().height));
        this.findField.setMaximumSize(this.findField.getPreferredSize());
        this.findField.getDocument().addDocumentListener(new SearchDocumentListener());
        this.findField.setEmptyMessage(Messages.getString("View.FindReplace.find_prompt"));
        this.findField.setClearButtonEnabled(true);
        new FindFieldActions().installActions(this.findField, false, 0);
        CloseButton closeButton = new CloseButton(14, Color.LIGHT_GRAY, Color.GRAY);
        closeButton.setFocusable(false);
        closeButton.addActionListener(this.actions.get(BrowserViewActions.CloseFind.class));
        closeButton.setToolTipText(Messages.getString("Action.close"));
        this.matchCase = new JCheckBox(Messages.getString("View.FindReplace.match_case"));
        this.matchCase.addItemListener(this);
        this.wholeWord = new JCheckBox(Messages.getString("View.FindReplace.whole_word"));
        this.wholeWord.addItemListener(this);
        this.searchBar.add(closeButton);
        this.searchBar.add(Box.createHorizontalStrut(10));
        this.searchBar.add(this.findField);
        this.searchBar.add(this.actions.get(BrowserViewActions.Previous.class));
        this.searchBar.add(this.actions.get(BrowserViewActions.Next.class));
        this.searchBar.add(this.wholeWord);
        this.searchBar.add(this.matchCase);
        this.add((Component)this.jfxPanel, "Center");
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.searchBar, "South");
        this.createScene();
        this.actions.installActions(this, false, 1);
    }

    protected void configureToolBar(JToolBar jToolBar) {
    }

    private void createScene() {
        RflowUI.initFx();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.view = new WebView();
                FXBrowserView.this.view.setContextMenuEnabled(false);
                FXBrowserView.this.engine = FXBrowserView.this.view.getEngine();
                FXBrowserView.this.engine.setJavaScriptEnabled(true);
                FXBrowserView.this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new FXWorkerStateChangeListener());
                FXBrowserView.this.engine.titleProperty().addListener((ChangeListener)new TitleChangeListener());
                FXBrowserView.this.engine.getHistory().currentIndexProperty().addListener((ChangeListener)new HistoryChangeListener());
                FXBrowserView.this.engine.getHistory().getEntries().addListener((ListChangeListener)new HistoryListChangeListener());
                BorderPane borderPane = new BorderPane();
                Scene scene = new Scene((Parent)borderPane);
                borderPane.setCenter((Node)FXBrowserView.this.view);
                FXBrowserView.this.jfxPanel.setScene(scene);
            }
        });
    }

    protected String getSelectedText() {
        Object object = this.engine.executeScript("window.getSelection().toString();");
        String string = null;
        if (object instanceof String && (string = (String)object).isEmpty()) {
            string = null;
        }
        return string;
    }

    protected boolean handleLinkClick(MouseEvent mouseEvent) {
        if (!(mouseEvent.getCurrentTarget() instanceof HTMLAnchorElement)) {
            return false;
        }
        MouseEvent mouseEvent2 = mouseEvent;
        HTMLAnchorElement hTMLAnchorElement = (HTMLAnchorElement)((Object)mouseEvent.getCurrentTarget());
        String string = hTMLAnchorElement.getHref();
        boolean bl = com.ef_prime.rflow.core.util.Platform.isMac();
        if (!bl && mouseEvent2.getCtrlKey() || bl && mouseEvent2.getMetaKey() || mouseEvent2.getButton() == 1) {
            this.openLinkInNewTab(string);
            mouseEvent.preventDefault();
            return true;
        }
        return false;
    }

    protected void handleContextMenu(MouseEvent mouseEvent) {
        EventTarget eventTarget = mouseEvent.getTarget();
        ContextMenu contextMenu = null;
        if (eventTarget instanceof HTMLAnchorElement) {
            contextMenu = this.createLinkContextMenu((HTMLAnchorElement)((Object)eventTarget));
        } else if (eventTarget instanceof Element) {
            contextMenu = this.createContextMenu(this.getSelectedText());
        }
        if (contextMenu != null) {
            contextMenu.show((Node)this.view, (double)mouseEvent.getScreenX(), (double)mouseEvent.getScreenY());
        }
    }

    protected ContextMenu createContextMenu(String string) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem = new MenuItem(Messages.getString("Action.find"));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menuItem.setOnAction(actionEvent -> SwingUtilities.invokeLater(() -> this.actions.doAction(BrowserViewActions.Find.class)));
        contextMenu.getItems().add((Object)menuItem);
        if (string != null) {
            MenuItem menuItem2 = new MenuItem(Messages.getString("Action.copy"));
            menuItem2.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            menuItem2.setOnAction(actionEvent -> this.copy(string));
            contextMenu.getItems().add((Object)menuItem2);
        }
        return contextMenu;
    }

    protected ContextMenu createLinkContextMenu(HTMLAnchorElement hTMLAnchorElement) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem = new MenuItem(Messages.getString("Action.open_link_new_tab"));
        menuItem.setOnAction(actionEvent -> this.openLinkInNewTab(hTMLAnchorElement.getHref()));
        contextMenu.getItems().add((Object)menuItem);
        MenuItem menuItem2 = new MenuItem(Messages.getString("Action.copy_link"));
        menuItem2.setOnAction(actionEvent -> SwingUtilities.invokeLater(() -> UIUtility.copyToClipboard(hTMLAnchorElement.getHref())));
        contextMenu.getItems().add((Object)menuItem2);
        return contextMenu;
    }

    protected FXBrowserView newInstance() {
        try {
            return (FXBrowserView)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to copy : default constructor is required.");
        }
    }

    protected void openLinkInNewTab(String string) {
        SwingUtilities.invokeLater(() -> {
            FXBrowserView fXBrowserView = this.newInstance();
            fXBrowserView.load(string);
            Rflow.mainView().getDefaultFlowPane().openView(fXBrowserView, ViewOpenType.OPEN_NEW, true);
        });
    }

    @Override
    public Object getKey() {
        return this;
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        this.refreshFontScale();
        Rflow.settings().addEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        Rflow.settings().removeEventHandler(this);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.engine.getLoadWorker().cancel();
            }
        });
    }

    public void setToolBarVisible(boolean bl) {
        this.toolBar.setVisible(bl);
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public String getCurrentUrl() {
        return this.engine.getLocation();
    }

    public void load(final String string) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.engine.load(string);
            }
        });
    }

    public void reload() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.engine.reload();
            }
        });
    }

    public void loadContent(final String string) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.engine.loadContent(string);
            }
        });
    }

    private void updateTitle(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.setTitle(FXBrowserView.this.createTitle(string, string2, false));
                FXBrowserView.this.updateTab();
            }
        });
    }

    protected String createTitle(String string, String string2, boolean bl) {
        return string;
    }

    private void go(final boolean bl) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebHistory webHistory = FXBrowserView.this.engine.getHistory();
                if (bl) {
                    webHistory.go(1);
                } else {
                    webHistory.go(-1);
                }
            }
        });
    }

    private void refreshFontScale() {
        final float f = Rflow.settings().getValue(Settings.HELP_FONT_SCALE).floatValue();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.view.setFontScale((double)f);
            }
        });
    }

    private void find(final boolean bl) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder();
                if (bl) {
                    stringBuilder.append("findIndex += 1;");
                } else {
                    stringBuilder.append("findIndex -= 1;");
                }
                stringBuilder.append("findIndex = Math.min(Math.max(0, findIndex), $('.highlight').size()-1);");
                stringBuilder.append("$('.highlight').removeClass('hselected');");
                stringBuilder.append("var target = $('.highlight').eq(findIndex);");
                stringBuilder.append("if (target.offset() !== undefined) {");
                stringBuilder.append("target.addClass('hselected');");
                stringBuilder.append("$('html, body').animate({ scrollTop: target.offset().top-100 }, 0);");
                stringBuilder.append("}");
                FXBrowserView.this.engine.executeScript(stringBuilder.toString());
            }
        });
    }

    private void copy(final String string) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(string);
                clipboard.setContent((Map)clipboardContent);
            }
        });
    }

    private void highlight() {
        String string = null;
        try {
            string = this.findField.getDocument().getText(0, this.findField.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (string == null) {
            string = "";
        }
        final String string2 = string;
        final String string3 = " { caseSensitive: " + this.matchCase.isSelected() + ", wordsOnly: " + this.wholeWord.isSelected() + " }";
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXBrowserView.this.engine.executeScript("var findIndex = -1;");
                if (string2.isEmpty()) {
                    FXBrowserView.this.engine.executeScript("$('body').unhighlight();");
                } else {
                    FXBrowserView.this.engine.executeScript("$('body').unhighlight().highlight('" + string2 + "', " + string3 + ");");
                }
            }
        });
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (Settings.HELP_FONT_SCALE.equals(valueChangeEvent.getKey())) {
            this.refreshFontScale();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.highlight();
    }

    @Override
    public Action getAction(String string) {
        if ("MENU_ACTION_FIND".equals(string)) {
            return this.actions.get(BrowserViewActions.Find.class);
        }
        return null;
    }

    private class BrowserViewActions
    extends Actions {
        public BrowserViewActions() {
            this.put(new Back());
            this.put(new Forward());
            this.put(new Copy());
            this.put(new History());
            this.put(new Find());
            this.put(new CloseFind());
            this.put(new Next());
            this.put(new Previous());
        }

        private void updateState(final boolean bl, final boolean bl2, final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserViewActions.this.get(Back.class).setEnabled(bl);
                    BrowserViewActions.this.get(Forward.class).setEnabled(bl2);
                    BrowserViewActions.this.get(History.class).setEnabled(n > 0);
                }
            });
        }

        private class Back
        extends LoggableAction {
            public Back() {
                this.putValue("Name", Messages.getString("Action.back"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 512));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_previous.png"));
                this.setEnabled(false);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.go(false);
            }
        }

        private class Forward
        extends LoggableAction {
            public Forward() {
                this.putValue("Name", Messages.getString("Action.forward"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 512));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
                this.setEnabled(false);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.go(true);
            }
        }

        private class Copy
        extends DefaultEditorKit.CopyAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }
        }

        private class History
        extends LoggableAction {
            public History() {
                this.putValue("Name", Messages.getString("Action.history"));
                this.putValue("SmallIcon", Icons.getIcon("16/clock_history_frame.png"));
                this.setEnabled(false);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (HistoryEntry historyEntry : FXBrowserView.this.history) {
                    jPopupMenu.insert(new OpenHistory(historyEntry.getTitle(), historyEntry.getUrl()), 0);
                }
                Component component = (Component)actionEvent.getSource();
                jPopupMenu.show(component, 0, component.getHeight());
            }
        }

        private class Find
        extends LoggableAction {
            public Find() {
                this.putValue("Name", Messages.getString("Action.find"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.searchBar.setVisible(true);
                FXBrowserView.this.findField.requestFocusInWindow();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Object object = FXBrowserView.this.engine.executeScript("window.getSelection().toString();");
                        if (object instanceof String) {
                            final String string = (String)object;
                            if (string.isEmpty()) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FXBrowserView.this.findField.setText(string);
                                }
                            });
                        }
                    }
                });
            }
        }

        private class CloseFind
        extends LoggableAction {
            public CloseFind() {
                this.putValue("Name", Messages.getString("Action.close"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.searchBar.setVisible(false);
                FXBrowserView.this.jfxPanel.requestFocusInWindow();
            }
        }

        private class Next
        extends LoggableAction {
            public Next() {
                this.putValue("Name", Messages.getString("Action.next_match"));
                this.putValue("SmallIcon", ShapeIconFactory.create(0, 10, Color.DARK_GRAY));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
                UIUtility.setShortDescription(this);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.find(true);
            }
        }

        private class Previous
        extends LoggableAction {
            public Previous() {
                this.putValue("Name", Messages.getString("Action.previous_match"));
                this.putValue("SmallIcon", ShapeIconFactory.create(1, 10, Color.DARK_GRAY));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 64));
                UIUtility.setShortDescription(this);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.find(false);
            }
        }

        private class OpenHistory
        extends LoggableAction {
            private String url;

            public OpenHistory(String string, String string2) {
                this.url = string2;
                this.putValue("Name", FXBrowserView.this.createTitle(string, string2, true));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.load(this.url);
            }
        }
    }

    private class SearchDocumentListener
    extends DocumentAdapter {
        private SearchDocumentListener() {
        }

        @Override
        public void documentUpdate(DocumentEvent documentEvent) {
            FXBrowserView.this.highlight();
        }
    }

    private class FindFieldActions
    extends Actions {
        public FindFieldActions() {
            this.put(new Enter());
            this.put(new CloseFind());
        }

        private class Enter
        extends LoggableAction {
            public Enter() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.actions.doAction(BrowserViewActions.Next.class);
            }
        }

        private class CloseFind
        extends LoggableAction {
            public CloseFind() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FXBrowserView.this.actions.doAction(BrowserViewActions.CloseFind.class);
            }
        }
    }

    private static class HistoryEntry {
        private String url;
        private ReadOnlyObjectProperty<String> title;

        public HistoryEntry(String string, ReadOnlyObjectProperty<String> readOnlyObjectProperty) {
            this.url = string;
            this.title = readOnlyObjectProperty;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTitle() {
            return (String)this.title.getValue();
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HistoryEntry)) {
                return false;
            }
            HistoryEntry historyEntry = (HistoryEntry)object;
            return this.url.equals(historyEntry.url);
        }
    }

    private class HistoryListChangeListener
    implements ListChangeListener<WebHistory.Entry> {
        private HistoryListChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends WebHistory.Entry> change) {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                for (WebHistory.Entry entry : change.getAddedSubList()) {
                    HistoryEntry historyEntry = new HistoryEntry(entry.getUrl(), (ReadOnlyObjectProperty<String>)entry.titleProperty());
                    FXBrowserView.this.history.remove(historyEntry);
                    FXBrowserView.this.history.add(historyEntry);
                }
                while (FXBrowserView.this.history.size() > 10) {
                    FXBrowserView.this.history.remove(0);
                }
            }
        }
    }

    private class FXWorkerStateChangeListener
    implements ChangeListener<Worker.State>,
    EventListener {
        private FXWorkerStateChangeListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state2, Worker.State state3) {
            switch (state3) {
                case SUCCEEDED: {
                    Element element;
                    NodeList nodeList = FXBrowserView.this.engine.getDocument().getElementsByTagName("a");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element2 = (Element)nodeList.item(i);
                        if (!(element2 instanceof EventTarget)) continue;
                        ((EventTarget)((Object)element2)).addEventListener("click", this, false);
                    }
                    nodeList = FXBrowserView.this.engine.getDocument().getElementsByTagName("body");
                    if (nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) instanceof EventTarget) {
                        ((EventTarget)((Object)element)).addEventListener("mouseup", this, false);
                    }
                    try {
                        this.addScriptElement(FXBrowserView.this.engine.getDocument(), Utility.getPathStr("ext/jquery-2.1.3.min.js"));
                        this.addScriptElement(FXBrowserView.this.engine.getDocument(), Utility.getPathStr("ext/jquery.highlight.js"));
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Failed to load .js file.", iOException);
                    }
                    this.addStyleElement(FXBrowserView.this.engine.getDocument(), ".highlight { background-color: yellow; } .hselected { background-color: cyan; }");
                    FXBrowserView.this.highlight();
                    break;
                }
            }
        }

        @Override
        public void handleEvent(Event event) {
            boolean bl;
            if (!(event instanceof MouseEvent)) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getType().equals("click")) {
                FXBrowserView.this.handleLinkClick(mouseEvent);
            } else if (mouseEvent.getType().equals("mouseup") && (!(bl = com.ef_prime.rflow.core.util.Platform.isMac()) && mouseEvent.getButton() == 2 || bl && mouseEvent.getCtrlKey())) {
                FXBrowserView.this.handleContextMenu(mouseEvent);
            }
        }

        private void addScriptElement(Document document, String string) throws IOException {
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element element = document.createElement("script");
                element.setAttribute("type", "text/javascript");
                element.setTextContent(FileUtils.readFileToString((File)new File(string)));
                nodeList.item(0).appendChild(element);
            }
        }

        private void addStyleElement(Document document, String string) {
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element element = document.createElement("style");
                element.setAttribute("type", "text/css");
                element.setTextContent(string);
                nodeList.item(0).appendChild(element);
            }
        }
    }

    private class HistoryChangeListener
    implements ChangeListener<Number> {
        private HistoryChangeListener() {
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            WebHistory webHistory = FXBrowserView.this.engine.getHistory();
            int n = webHistory.getCurrentIndex();
            boolean bl = n > 0;
            boolean bl2 = n < webHistory.getEntries().size() - 1;
            int n2 = webHistory.getEntries().size();
            FXBrowserView.this.actions.updateState(bl, bl2, n2);
        }
    }

    private class TitleChangeListener
    implements ChangeListener<String> {
        private TitleChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
            FXBrowserView.this.updateTitle(FXBrowserView.this.engine.getTitle(), FXBrowserView.this.engine.getLocation());
        }
    }
}

