/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.SessionEntrySupplier;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowOptionPane;
import com.ef_prime.rflow.ui.common.component.ShapeIconFactory;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import org.apache.commons.io.FilenameUtils;

public abstract class FileEditView
extends LazyLoadView
implements FileEditEventHandler,
MenuActionProvider,
ItemEventHandler,
SessionEntrySupplier {
    public static final String SAVE = "FileEditView.SAVE";
    public static final String SAVE_AS = "FileEditView.SAVE_AS";
    public static final String SAVE_AS_DROP_DOWN = "FileEditView.SAVE_AS_DROP_DOWN";
    public static final String REOPEN = "FileEditView.REOPEN";
    private static final Logger LOGGER = Logger.getLogger(FileEditView.class.getName());
    private File file;
    private FileEdit fileEdit;
    private FileEditViewActions actions = new FileEditViewActions();
    private boolean reloadLock;

    public FileEditView(FileEdit fileEdit) {
        this.init();
        if (fileEdit != null) {
            this.setFileEdit(fileEdit);
        }
    }

    public FileEditView(File file) {
        this.file = file;
        this.init();
        this.doBusyWork(new FileLoader(file));
    }

    private void init() {
        this.setClosable(true);
        this.actions.installActions(this, false, 1);
    }

    public static FileEdit toFileEdit(Class<? extends FileEditView> clazz, Path path) {
        try {
            Method method = clazz.getMethod("toFileEdit", Path.class);
            return (FileEdit)method.invoke(null, path);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed invoke toFileEdit()", exception);
            return null;
        }
    }

    public FileEdit getFileEdit() {
        return this.fileEdit;
    }

    public void setFileEdit(FileEdit fileEdit) {
        if (Objects.equals(this.fileEdit, fileEdit)) {
            return;
        }
        this.setCloseLocked(true);
        try {
            if (this.fileEdit != null) {
                this.unloadResource();
            }
            this.fileEdit = fileEdit;
            this.file = fileEdit == null ? null : fileEdit.getFile();
            this.loadResource();
            this.updateTab();
        }
        finally {
            this.setCloseLocked(false);
        }
    }

    protected Object getProtectKey() {
        return this;
    }

    protected void loadResource() {
        if (this.fileEdit != null) {
            if (this.getProtectKey() != null) {
                FileEditManager.getInstance().load(this.fileEdit, this.getProtectKey());
            }
            this.fileEdit.addFileEditEventHandler(this);
        }
        this.actions.update();
    }

    protected void unloadResource() {
        if (this.fileEdit != null) {
            if (this.shouldUnloadResource() && this.getProtectKey() != null) {
                FileEditManager.getInstance().unload(this.fileEdit, this.getProtectKey());
            }
            this.fileEdit.removeFileEditEventHandler(this);
        }
    }

    @Override
    public String getTitle() {
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit == null) {
            if (this.file != null) {
                return FilenameUtils.removeExtension((String)this.file.getName());
            }
            return super.getTitle();
        }
        String string = fileEdit.getFileEditName();
        return fileEdit.isDirty() ? "*" + string : string;
    }

    @Override
    public String getIconToolTip() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return super.getIconToolTip();
    }

    @Override
    public Object getKey() {
        if (this.fileEdit != null) {
            return this.fileEdit;
        }
        return this.file;
    }

    @Override
    public SessionEntry getSessionEntry(boolean bl) {
        return null;
    }

    public void loadSessionEntry(SessionEntry sessionEntry) {
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        FileManager.getInstance().addItemEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        FileManager.getInstance().removeItemEventHandler(this);
        if (this.getFileEdit() != null) {
            this.unloadResource();
        }
        this.saveSessionEntryToHistory();
    }

    @Override
    public boolean viewWillClose() {
        return this.askSave(false);
    }

    public boolean askSave(boolean bl) {
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit != null && fileEdit.isDirty() && !Rflow.project().isNewProjectSaveMode()) {
            return this.showSaveConfirmDialog(bl);
        }
        return true;
    }

    protected boolean showSaveConfirmDialog(boolean bl) {
        String string = Messages.format("Message.confirm_save_file", this.fileEdit.getFileEditName());
        int n = RflowOptionPane.showConfirmDialog((Component)Rflow.mainFrame(), string, Messages.getString("Message.confirm"), 3);
        switch (n) {
            case 0: {
                return this.save(false);
            }
            case 1: {
                if (bl) {
                    this.fileEdit.setDirty(false);
                    return true;
                }
                return this.confirmRetainingChanges();
            }
        }
        return false;
    }

    protected boolean confirmRetainingChanges() {
        if (this.fileEdit.getProtectKeys().size() <= 1) {
            return true;
        }
        this.fileEdit.setDirty(false);
        this.reload();
        return true;
    }

    protected Boolean checkExternalEdit() {
        if (!this.getFileEdit().hasLastModifiedChanged()) {
            return true;
        }
        String string = Messages.format("Message.confirm_changed", this.getFileEdit().getFile().getName());
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        String string2 = Messages.getStringWithDots("Action.save_as");
        String string3 = Messages.getString("ConfirmOverwrite.overwrite");
        String string4 = Messages.getString("Button.cancel");
        jOptionPane.setOptions(new String[]{string2, string3, string4});
        JDialog jDialog = jOptionPane.createDialog(Rflow.mainFrame(), Messages.getString("Error.title.warning"));
        jDialog.setVisible(true);
        jDialog.dispose();
        String string5 = (String)jOptionPane.getValue();
        if (string5 == null) {
            return null;
        }
        if (string5.equals(string2)) {
            return false;
        }
        if (string5.equals(string3)) {
            return true;
        }
        return null;
    }

    public boolean save(boolean bl) {
        long l = this.file == null ? 0L : this.file.lastModified();
        try {
            boolean bl2 = this.doSave(bl);
            if (bl2) {
                this.getFileEdit().updateLastModified();
            }
            return bl2;
        }
        catch (Exception exception) {
            long l2;
            long l3 = l2 = this.file == null ? 0L : this.file.lastModified();
            if (l != l2) {
                this.getFileEdit().updateLastModified();
            }
            String string = this.file == null ? "" : this.file.getPath();
            UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.save") + ": " + string, exception);
            return false;
        }
    }

    protected abstract boolean doSave(boolean var1) throws IOException;

    public void reload() {
        int n;
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit == null) {
            return;
        }
        if (fileEdit.isDirty() && (n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.reopen"), Messages.getString("Message.confirm"), 2, 2)) != 0) {
            return;
        }
        fileEdit.clearEdit();
        fileEdit.dispatchFileEditEvent(4);
    }

    protected void reloaded() {
        this.refresh();
    }

    protected boolean shouldUnloadResource() {
        return true;
    }

    public void setReloadLock(boolean bl) {
        this.reloadLock = bl;
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        this.updateTab();
        switch (fileEditEvent.getState()) {
            case 2: {
                this.actions.update();
                break;
            }
            case 4: {
                if (this.reloadLock) break;
                this.reloaded();
                break;
            }
        }
    }

    protected FileEdit loadResource(File file) throws Exception {
        return null;
    }

    protected void resourceLoaded() {
    }

    @Override
    public Action getAction(String string) {
        switch (string) {
            case "MENU_ACTION_SAVE": {
                return this.getActionMap().get(SAVE);
            }
            case "MENU_ACTION_SAVE_AS": {
                return this.getActionMap().get(SAVE_AS);
            }
        }
        return null;
    }

    @Override
    public void itemChanged(ItemEvent itemEvent) {
        switch (itemEvent.getType()) {
            case 6: {
                if (this.fileEdit == null || this.file == null || !FileManager.stringToFile(itemEvent.getName()).equals(this.file) || this.fileEdit.isDirty()) break;
                this.reload();
                break;
            }
            case 0: {
                if (this.fileEdit == null || this.file == null || !FileManager.stringToFile(itemEvent.getName()).equals(this.file)) break;
                if (this.fileEdit.isDirty()) {
                    this.actions.get(REOPEN).setEnabled(true);
                    break;
                }
                long l = -1L;
                try {
                    l = Files.size(this.file.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l >= 0L && l < 0x500000L) {
                    this.reload();
                    break;
                }
                this.actions.get(REOPEN).setEnabled(true);
            }
        }
    }

    private class FileEditViewActions
    extends Actions {
        public FileEditViewActions() {
            this.put(FileEditView.SAVE, new Save());
            this.put(FileEditView.SAVE_AS, new SaveAs());
            this.put(FileEditView.SAVE_AS_DROP_DOWN, new SaveAsDropDown());
            this.put(FileEditView.REOPEN, new Reload());
        }

        public void update() {
            this.get(FileEditView.SAVE).setEnabled(FileEditView.this.getFileEdit() != null && FileEditView.this.getFileEdit().isDirty());
            this.get(FileEditView.SAVE_AS).setEnabled(FileEditView.this.getFileEdit() != null);
            this.get(FileEditView.REOPEN).setEnabled(FileEditView.this.getFileEdit() != null && FileEditView.this.getFileEdit().isDirty());
        }

        private class Save
        extends LoggableAction {
            public Save() {
                this.putValue("Name", Messages.getString("Action.save"));
                this.putValue("SmallIcon", Icons.getIcon("16/diskette.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileEditView.this.save(false);
            }
        }

        private class SaveAs
        extends LoggableAction {
            public SaveAs() {
                this.putValue("Name", Messages.getStringWithDots("Action.save_as"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileEditView.this.save(true);
            }
        }

        private class SaveAsDropDown
        extends LoggableAction {
            public SaveAsDropDown() {
                Icon icon = ShapeIconFactory.create(3, 8, Color.DARK_GRAY);
                this.putValue("SmallIcon", icon);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(FileEditViewActions.this.get(FileEditView.SAVE_AS));
                jPopupMenu.show(component, 0, component.getHeight());
            }
        }

        private class Reload
        extends LoggableAction {
            public Reload() {
                this.putValue("Name", Messages.getString("Action.reopen"));
                this.putValue("SmallIcon", Icons.getIcon("16/update.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileEditView.this.reload();
            }
        }
    }

    private class FileLoader
    extends SwingWorker<FileEdit, Void> {
        private File file;

        public FileLoader(File file) {
            this.file = file;
        }

        @Override
        protected FileEdit doInBackground() throws Exception {
            FileEdit fileEdit = FileEditView.this.loadResource(this.file);
            FileEditView.this.setFileEdit(fileEdit);
            return fileEdit;
        }

        @Override
        protected void done() {
            try {
                this.get();
                FileEditView.this.resourceLoaded();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to load file.", exception);
            }
        }
    }
}

