/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.node.ui.OpPopupMenu;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.HasApp;
import com.ef_prime.rflow.ui.app.file.FileTransferable;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.app.file.FileViewer;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.base.WindowSizeSetEvent;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.FileControl;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowScrollPane;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.component.TreeDnDMoveHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.event.FileEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemSelectable;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEvent;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEventHandler;
import com.ef_prime.rflow.ui.common.tree.BasicTreeCellRenderer;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.SwingXUtility;
import com.ef_prime.rflow.ui.util.TreeUtils;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.FileForSort;
import com.ef_prime.rflow.ui.view.FileNode;
import com.ef_prime.rflow.ui.view.FileNodeTransferable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.jdesktop.swingx.JXMultiSplitPane;

public class FileExplorer
extends View
implements ClipboardOwner,
TreeWillExpandListener,
SimpleEventHandler,
ItemSelectable,
TreeSelectionListener,
ChangeEventHandler,
ItemEventHandler,
HasApp,
RflowEventHandler {
    private static final Logger LOGGER = Logger.getLogger(FileExplorer.class.getName());
    private FileManager fileManager;
    private JXMultiSplitPane splitPane;
    private FileViewer preview;
    private FileTree tree;
    private DragSourceHandler dragSourceHandler;
    private DropTargetHandler dropHandler;
    private final FileTreeActions fileActions = new FileTreeActions();
    private FileControl fileControl;
    private TreePath weakSelection;
    private long lastUpdateTimeSpan = 0L;
    private EventSupport<ItemSelectionEvent, ItemSelectionEventHandler> eventSupport = new EventSupport();
    private RItemEventHandler rItemEventHandler = new RItemEventHandler();
    private Executor executor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ThreadUtility.threadFactory("FileExplorer-Refresh-%d", true));
    private ScheduledExecutorService externalRefreshExecutor = Executors.newScheduledThreadPool(0, (ThreadFactory)ThreadUtility.threadFactory("FileExplorer-ExternalRefresh-%d", true));
    private Map<File, Future<?>> externalRefreshFutures = new HashMap();
    private boolean refreshing;
    private boolean refreshingFolder;

    public FileExplorer(FileManager fileManager) {
        this.fileManager = fileManager;
        this.setTitle(Messages.getString("Explorer.file"));
        this.setIcon(Icons.getIcon("16/folders.png"));
        this.setIconOnly(true);
        EventManager.getInstance().registerEventHandler(FileEvent.class, this);
        EventManager.getInstance().registerEventHandler(WindowSizeSetEvent.class, this);
        fileManager.addLoadEventHandler(this);
        fileManager.addItemEventHandler(this);
        Rflow.getInstance().addRflowEventHandler(this);
        this.fileControl = new FileControl(Rflow.settings().getValue(Settings.MAX_PATH), Rflow.getInstance().getMainFrame());
        this.tree = new FileTree(fileManager.getTreeModel());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        UIUtility.insertMouseListener(this.tree, new MouseHandler());
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.fileActions.installActions(this.tree, false, 1);
        this.fileActions.installActions(this.tree, false, 0);
        DragSource dragSource = new DragSource();
        this.dragSourceHandler = new DragSourceHandler();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 0x40000003, this.dragSourceHandler);
        this.dropHandler = new DropTargetHandler(this.tree);
        new DropTarget(this.tree, 0x40000003, this.dropHandler);
        this.tree.setCellRenderer(new FileTreeRenderer());
        this.setLayout(new BorderLayout());
        this.preview = new FileViewer();
        this.preview.setExplorer(this);
        double d = Rflow.settings().getRatio(Settings.SPLIT_FILE);
        this.splitPane = SwingXUtility.createHorizontalSplitPane(new RflowScrollPane(this.tree), this.preview, d);
        SwingXUtility.installWeightChanger(this.splitPane, 0.0, 1.0);
        this.add((Component)this.splitPane);
        this.fileActions.updateTarget();
        Rflow.settings().addEventHandler(new SettingsListener());
        String string = Rflow.settings().getValue(Settings.FILE_TREE_SORT);
        Comparator<FileForSort> comparator = BasicFileNode.TYPE_COMPARATOR;
        if (string.equals("name")) {
            comparator = BasicFileNode.NAME_COMPARATOR;
        }
        BasicFileNode.setComparator(comparator);
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        R.client().addItemEventHandler(this.rItemEventHandler);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        R.client().removeItemEventHandler(this.rItemEventHandler);
    }

    public Action removeFromList() {
        return this.fileActions.get("REMOVE_FROM_LIST");
    }

    public void refreshed(FileNode fileNode, List<FileNode> list) {
        fileNode.setChildren(list);
        this.getModel().nodeStructureChanged(fileNode);
    }

    public void select(FileNode fileNode) {
        TreePath treePath = new TreePath(this.getModel().getPathToRoot(fileNode));
        this.tree.setSelectionPath(treePath);
        UIUtility.scrollPathToVisibleIncludingExpandControl(this.tree, treePath);
    }

    private DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    private void refresh(File file) {
        this.refresh(this.fileManager.getNodes(file));
    }

    private void refreshRoot() {
        ((FileNode)this.getModel().getRoot()).refreshState();
        this.refresh((FileNode)this.getModel().getRoot());
    }

    private void refreshWorkingDirectory() {
        List<FileNode> list = this.fileManager.getNodes(WorkingDirectory.getWorkingDirectory());
        if (list != null) {
            this.refresh(list);
        }
    }

    private void refresh(Collection<FileNode> collection) {
        this.refresh(collection.toArray(new FileNode[collection.size()]));
    }

    private void refresh(FileNode ... fileNodeArray) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        for (FileNode fileNode : fileNodeArray) {
            List<TreePath> list = this.getExpandedPaths(fileNode);
            if (list != null && !list.isEmpty()) {
                for (TreePath treePath : list) {
                    this.executor.execute(new RefreshWorker(treePath, true));
                }
                continue;
            }
            this.executor.execute(new RefreshWorker(TreeUtils.getPath(fileNode), false));
        }
        this.executor.execute(new RefreshFinishWorker(treePathArray));
    }

    private List<TreePath> getExpandedPaths(FileNode fileNode) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        ArrayDeque<FileNode> arrayDeque = new ArrayDeque<FileNode>();
        arrayDeque.add((FileNode)this.tree.getModel().getRoot());
        TreePath treePath = TreeUtils.getPath(fileNode);
        while (arrayDeque.size() > 0) {
            Enumeration<? extends TreeNode> enumeration = ((FileNode)arrayDeque.poll()).children();
            while (enumeration.hasMoreElements()) {
                TreePath treePath2;
                FileNode fileNode2 = (FileNode)enumeration.nextElement();
                if (fileNode2.isLeaf() || !this.tree.isExpanded(treePath2 = TreeUtils.getPath(fileNode2)) || !treePath2.equals(treePath) && !treePath2.isDescendant(treePath) && !treePath.isDescendant(treePath2)) continue;
                arrayDeque.addLast(fileNode2);
                if (!treePath2.equals(treePath) && !treePath.isDescendant(treePath2)) continue;
                arrayList.add(treePath2);
            }
        }
        return arrayList;
    }

    private TreePath getTreePath(TreePath treePath) {
        FileNode fileNode = (FileNode)this.tree.getModel().getRoot();
        if (!fileNode.equals(treePath.getPathComponent(0))) {
            return null;
        }
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            FileNode fileNode2 = (FileNode)treePath.getPathComponent(i);
            int n = 0;
            Enumeration<? extends TreeNode> enumeration = fileNode.children();
            while (enumeration.hasMoreElements() && !fileNode2.equals(enumeration.nextElement())) {
                ++n;
            }
            if (n >= fileNode.getChildCount()) {
                return null;
            }
            fileNode = (FileNode)fileNode.getChildAt(n);
        }
        return TreeUtils.getPath(fileNode);
    }

    private TreePath[] getSelectedPaths(TreePath treePath) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return new TreePath[]{treePath};
        }
        boolean bl = this.tree.getSelectionModel().isPathSelected(treePath);
        if (bl && TreeUtils.isSiblings(treePathArray)) {
            return treePathArray;
        }
        if (bl) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
        return new TreePath[]{treePath};
    }

    void open(File file, boolean bl) {
        Object object;
        if (!this.fileControl.checkFileExists(file) || !file.isFile()) {
            return;
        }
        Path path = WorkingDirectory.toAbsolutePath(file).toPath();
        String string = null;
        if (!bl && (string = Rflow.settings().getFileOpenType(path)) == null && (FlowModel.isRflow(((FileInfo)(object = FileInfos.getInstance().getFileInfo(file))).getFile().getName()) || FileViewMap.getInstance().hasSupportedView((FileInfo)object))) {
            string = "tab";
        }
        if (string == null) {
            Object object2;
            object = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").fill()));
            ButtonGroup buttonGroup = new ButtonGroup();
            String[] stringArray = new String[]{Messages.getString("View.FileTree.new_tab"), Messages.getString("View.FileTree.sys_def_app"), Messages.getString("View.FileTree.choose_app")};
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = new JRadioButton(stringArray[i], i == 0);
                buttonGroup.add((AbstractButton)object2);
                ((Container)object).add((Component)object2, new CC().wrap());
            }
            Object object3 = FilenameUtils.getExtension((String)file.getName());
            object3 = ((String)object3).isEmpty() ? Messages.getString("Message.none") : "." + (String)object3;
            object2 = Messages.format("View.FileTree.always_open_option", object3);
            JCheckBox jCheckBox = new JCheckBox((String)object2, !bl);
            ((Container)object).add((Component)jCheckBox, new CC());
            int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), object, Messages.getString("Action.open_with"), 2, -1);
            if (n != 0) {
                return;
            }
            int n2 = UIUtility.getSelectedButtonIndex(buttonGroup);
            switch (n2) {
                case 0: {
                    string = "tab";
                    break;
                }
                case 1: {
                    string = "system";
                    break;
                }
                case 2: {
                    string = "choose";
                    break;
                }
                default: {
                    throw new RuntimeException("unknown 'openType'");
                }
            }
            if (jCheckBox.isSelected()) {
                Rflow.settings().setFileOpenType(path, string);
            }
        }
        switch (string) {
            case "tab": {
                this.openFileInTab(file);
                break;
            }
            case "system": {
                this.openFileWithSystemEditor(file);
                break;
            }
            case "choose": {
                this.chooseProgramAndOpenFile(file);
                break;
            }
        }
    }

    private void openFileInTab(File file) {
        String string = file.getName();
        if (FlowModel.isRflow(string)) {
            Rflow.actions().openFlow(file, false);
        } else if (!FilenameUtils.isExtension((String)string, (String)"afp")) {
            if (Rflow.isDevel() && FilenameUtils.isExtension((String)string, (String)"natto")) {
                try {
                    Class<?> clazz = Class.forName("natto.NattoUtility");
                    Method method = clazz.getMethod("launchNatto", String.class);
                    method.invoke(null, file.getAbsolutePath());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Failed to invoke class:natto.NattoUtility method:launchNatto", exception);
                }
            } else {
                this.weakSelectPath(this.tree.getSelectionPath());
                FileViewer fileViewer = new FileViewer();
                fileViewer.setFile(file);
                FileManager.getInstance().removeNewItem(file);
                Rflow.mainView().openViewAtDefaultObjectPane(fileViewer, ViewOpenType.OPEN_NEW, true);
            }
        }
    }

    private void openFileWithSystemEditor(File file) {
        this.weakSelectPath(this.tree.getSelectionPath());
        FileUIUtility.openFileWithSystemEditor(Rflow.mainFrame(), file);
    }

    private void weakSelectPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.tree.clearSelection();
        this.weakSelection = treePath;
        this.repaint();
        this.dispatchItemSelectionEvent();
    }

    private void chooseProgramAndOpenFile(File file) {
        File file2 = UIUtility.chooseFileAwt(Rflow.mainFrame(), Messages.getString("View.FileTree.choose_app"), 0, null);
        if (file2 == null) {
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(file2.getAbsolutePath(), file.getAbsolutePath());
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {
            UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.file.run_app"), iOException);
        }
    }

    private void delete(TreePath[] treePathArray) {
        if (!TreeUtils.isSiblings(treePathArray)) {
            throw new RuntimeException("Invalid delete operation. Paths must be siblings.");
        }
        if (treePathArray[0].getPathCount() == 2) {
            String string = ((FileNode)treePathArray[0].getLastPathComponent()).getName();
            if (!UIUtility.confirmDelete(Rflow.mainFrame(), treePathArray.length, string, Messages.getString("View.FileTree.confirm_delete_link.single"), Messages.getString("View.FileTree.confirm_delete_link.multiple"))) {
                return;
            }
            ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
            for (int i = 0; i < treePathArray.length; ++i) {
                arrayList.add((FileNode)treePathArray[i].getLastPathComponent());
            }
            this.fileManager.remove(arrayList);
            this.tree.clearSelection();
        } else {
            List list = Arrays.stream(treePathArray).map(treePath -> ((FileNode)treePath.getLastPathComponent()).getFile()).filter(Objects::nonNull).collect(Collectors.toList());
            if (list.isEmpty()) {
                return;
            }
            HashMultimap hashMultimap = HashMultimap.create();
            FileEditManager.getInstance().getFileEdits().stream().forEach(arg_0 -> FileExplorer.lambda$delete$1((Multimap)hashMultimap, arg_0));
            for (TreePath[] treePathArray2 : list) {
                Collection collection = hashMultimap.get((Object)treePathArray2);
                if (!collection.stream().anyMatch(FileEdit::isDirty)) continue;
                JOptionPane.showMessageDialog(Rflow.mainFrame(), Messages.format("Error.editing", treePathArray2.getName()), Messages.getString("Error.title.error"), 0);
                return;
            }
            if (!UIUtility.confirmDelete(Rflow.mainFrame(), treePathArray.length, ((File)list.get(0)).getName())) {
                return;
            }
            HashSet hashSet = new HashSet();
            for (TreePath treePath2 : treePathArray) {
                FileNode fileNode = (FileNode)treePath2.getLastPathComponent();
                File file = fileNode.getFile();
                if (file == null) continue;
                this.tree.removeSelectionPath(treePath2);
                try {
                    FileNode fileNode2 = (FileNode)fileNode.getParent();
                    hashSet.add(fileNode2);
                    hashMultimap.get((Object)file).stream().forEach(fileEdit -> {
                        List list = fileEdit.getProtectKeys().stream().filter(object -> !(object instanceof FlowNode)).collect(Collectors.toList());
                        list.stream().forEach(object -> FileEditManager.getInstance().unload((FileEdit)fileEdit, object));
                        Rflow.mainView().getViews((FileEdit)fileEdit).stream().forEach(fileEditView -> fileEditView.closeTab(true));
                    });
                    this.removeFile(file);
                }
                catch (Exception exception) {
                    UIUtility.showErrorDialog((Component)this, exception);
                    break;
                }
            }
            this.refresh(hashSet.toArray(new FileNode[0]));
        }
    }

    private void removeFile(File file) throws IOException {
        if (FlowModel.isRflow(file.getName())) {
            try {
                FlowModel flowModel = FlowModel.readFlowModel(file, file, null);
                flowModel.remove();
            }
            catch (ReadException readException) {
                throw new IOException(readException);
            }
        } else {
            FileUtility.removeFile(file);
        }
    }

    void copyToClipboard(TreePath[] treePathArray) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        clipboard.setContents(new FileNodeTransferable(this.getLastComponents(treePathArray).toArray(new FileNode[0])), this);
    }

    private List<FileNode> getLastComponents(TreePath[] treePathArray) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() <= 1) continue;
            arrayList.add((FileNode)treePathArray[i].getLastPathComponent());
        }
        return arrayList;
    }

    private List<File> getFiles(TreePath[] treePathArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        List<FileNode> list = this.getLastComponents(treePathArray);
        if (list.isEmpty()) {
            return arrayList;
        }
        for (FileNode fileNode : list) {
            if (!fileNode.isFile()) continue;
            arrayList.add(fileNode.getFile());
        }
        return arrayList;
    }

    private boolean showHiddenFiles() {
        return Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
    }

    private boolean copyFile(File file, File file2, boolean bl) {
        if (FlowModel.isRflow(file.getName())) {
            try {
                FlowModel flowModel = FlowModel.readFlowModel(file, file, null);
                flowModel = flowModel.copyToDir(file2);
                return true;
            }
            catch (ReadException | IOException exception) {
                LOGGER.log(Level.SEVERE, "Failed to read file: " + file.getPath(), exception);
                return false;
            }
        }
        return this.fileControl.copyFile(file, file2, 2, bl);
    }

    private boolean moveFile(File file, File file2, boolean bl) {
        if (file.equals(file2)) {
            return false;
        }
        if (FlowModel.isRflow(file.getName())) {
            if (file2.exists() && !UIUtility.confirmOverwrite(file2, Rflow.mainFrame())) {
                return false;
            }
            try {
                FileEditManager fileEditManager = FileEditManager.getInstance();
                for (FlowModel flowModel : fileEditManager.getFlowModels()) {
                    if (!file.equals(flowModel.getWorkingFile())) continue;
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.format("Error.editing", file.getPath()));
                    return false;
                }
                FlowModel flowModel = FlowModel.readFlowModel(file, file, null);
                flowModel.move(file2);
                return true;
            }
            catch (ReadException | IOException exception) {
                LOGGER.log(Level.SEVERE, "Failed to move file: " + file.getPath(), exception);
                return false;
            }
        }
        return this.fileControl.moveFile(file, file2, 2, bl);
    }

    private void setSortOrder(Comparator<FileForSort> comparator) {
        BasicFileNode.setComparator(comparator);
        String string = "type";
        if (comparator.equals(BasicFileNode.NAME_COMPARATOR)) {
            string = "name";
        }
        Rflow.settings().putValue(Settings.FILE_TREE_SORT, string);
        this.refreshRoot();
    }

    private void addFileLinks(List<File> list) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(list.size());
        for (File file : list) {
            BasicFileNode basicFileNode = new BasicFileNode(file, this.showHiddenFiles());
            FileNode fileNode = this.fileManager.getSameLink(basicFileNode);
            if (fileNode == null) {
                this.fileManager.add(basicFileNode);
                arrayList.add(TreeUtils.getPath(basicFileNode));
                continue;
            }
            arrayList.add(TreeUtils.getPath(fileNode));
        }
        this.tree.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
        this.tree.scrollPathToVisible((TreePath)arrayList.get(0));
    }

    @Override
    public void addItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.addEventHandler(itemSelectionEventHandler);
    }

    @Override
    public void removeItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.removeEventHandler(itemSelectionEventHandler);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        final FileNode fileNode = (FileNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (fileNode.areChildrenReady()) {
            return;
        }
        final SwingWorker<List<FileNode>, Void> swingWorker = new SwingWorker<List<FileNode>, Void>(){

            @Override
            protected List<FileNode> doInBackground() throws Exception {
                return fileNode.retrieveChildren();
            }

            @Override
            protected void done() {
                FileExplorer.this.refreshingFolder = true;
                try {
                    List list = (List)this.get();
                    fileNode.setChildren(list);
                    FileExplorer.this.getModel().nodeStructureChanged(fileNode);
                    FileExplorer.this.tree.setCursor(Cursor.getDefaultCursor());
                }
                catch (InterruptedException | ExecutionException exception) {
                    LOGGER.log(Level.SEVERE, "Failed to refresh file tree", exception);
                }
                finally {
                    FileExplorer.this.refreshingFolder = false;
                }
            }
        };
        Timer timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!swingWorker.isDone()) {
                    FileExplorer.this.tree.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
        this.executor.execute(swingWorker);
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(FileEvent.class)) {
            if (this.lastUpdateTimeSpan > 1000L) {
                return;
            }
            this.refreshWorkingDirectory();
        } else if (simpleEvent.getClass().equals(WindowSizeSetEvent.class)) {
            double d = Rflow.settings().getRatio(Settings.SPLIT_FILE);
            SwingXUtility.setHorizontalSplit(this.splitPane, d);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private TreePath[] getSelectedPaths() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            if (this.weakSelection == null) {
                return null;
            }
            treePathArray = new TreePath[]{this.weakSelection};
        }
        if (!TreeUtils.isSiblings(treePathArray)) {
            return null;
        }
        return treePathArray;
    }

    @Override
    public Item getSelectedItem() {
        TreePath[] treePathArray = this.getSelectedPaths();
        if (treePathArray == null) {
            return null;
        }
        List<File> list = this.getFiles(treePathArray);
        if (list.isEmpty()) {
            return null;
        }
        return new FileTransferable(list);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.weakSelection = null;
        this.fileActions.updateTarget();
        this.dispatchItemSelectionEvent();
    }

    private void dispatchItemSelectionEvent() {
        ItemSelectionEvent itemSelectionEvent = new ItemSelectionEvent(this.getSelectedItem(), this.refreshing, this.weakSelection != null);
        this.eventSupport.dispatchEvent(itemSelectionEvent);
        EventManager.getInstance().dispatchEvent(itemSelectionEvent);
        if (!itemSelectionEvent.isAdjusting() && !itemSelectionEvent.isWeakSelection() && this.preview != null) {
            this.updateTabBusy(false);
            TreePath[] treePathArray = this.getSelectedPaths();
            if (treePathArray == null || treePathArray.length != 1) {
                this.preview.clear();
            } else {
                FileNode fileNode = (FileNode)treePathArray[0].getLastPathComponent();
                if (fileNode instanceof BasicFileNode) {
                    this.preview.setFileNode((BasicFileNode)fileNode);
                } else {
                    this.preview.clear();
                }
            }
        }
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        List<FileNode> list;
        if (this.fileManager.getProjectHomeFileNode() != null) {
            this.tree.expandPath(TreeUtils.getPath(this.fileManager.getProjectHomeFileNode(), null));
        }
        if (!(list = this.fileManager.getNodes(WorkingDirectory.getWorkingDirectory())).isEmpty()) {
            this.tree.expandPath(TreeUtils.getPath(list.get(0), null));
        }
    }

    @Override
    public void itemChanged(final ItemEvent itemEvent) {
        File file;
        if (itemEvent.getType() == 0) {
            this.repaint();
            return;
        }
        File file2 = FileManager.stringToFile(itemEvent.getName());
        if (file2 == null) {
            return;
        }
        File file3 = file = itemEvent.isFocusEventType() ? file2 : file2.getParentFile();
        if (itemEvent.isFocusEventType()) {
            if (Rflow.settings().getValue(Settings.AUTO_SELECT_ITEM).booleanValue()) {
                SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        return null;
                    }

                    @Override
                    protected void done() {
                        List<FileNode> list = FileExplorer.this.fileManager.getNodes(file);
                        if (list.isEmpty()) {
                            return;
                        }
                        FileNode fileNode = list.iterator().next();
                        TreePath treePath = new TreePath(FileExplorer.this.getModel().getPathToRoot(fileNode));
                        if (itemEvent.getType() == 3) {
                            FileExplorer.this.tree.setSelectionPath(treePath);
                        } else {
                            FileExplorer.this.weakSelectPath(treePath);
                        }
                        FileExplorer.this.toFront();
                    }
                };
                this.executor.execute(swingWorker);
            }
        } else {
            Future<?> future;
            Future<?> future2 = this.externalRefreshFutures.entrySet().iterator();
            while (future2.hasNext()) {
                future = future2.next().getValue();
                if (!future.isDone()) continue;
                future2.remove();
            }
            future2 = this.externalRefreshFutures.get(file);
            if (future2 != null && !future2.isDone()) {
                future2.cancel(false);
            }
            if (this.externalRefreshExecutor.isShutdown()) {
                return;
            }
            future = this.externalRefreshExecutor.schedule(() -> {
                this.refresh(file);
                if (itemEvent.getType() == 2) {
                    this.setUnread(true);
                }
            }, 200L, TimeUnit.MILLISECONDS);
            this.externalRefreshFutures.put(file, future);
        }
    }

    @Override
    public App getApp() {
        return Apps.FILE;
    }

    @Override
    public void rflowWillShutdown() {
        Double d = SwingXUtility.getHorizontalRatio(this.splitPane);
        if (d != null) {
            Rflow.settings().putValue(Settings.SPLIT_FILE, d);
        }
        this.externalRefreshExecutor.shutdown();
    }

    @Override
    public void rflowProjectDidStart() {
        this.toFront();
    }

    @Override
    public void rflowProjectWillEnd() {
    }

    private static /* synthetic */ void lambda$delete$1(Multimap multimap, FileEdit fileEdit) {
        multimap.put((Object)fileEdit.getFile(), (Object)fileEdit);
    }

    private class FileTreeActions
    extends Actions
    implements PopupMenuListener {
        static final String ADD = "ADD";
        static final String REMOVE_FROM_LIST = "REMOVE_FROM_LIST";
        static final String UP = "UP";
        static final String DOWN = "DOWN";
        static final String OPEN = "OPEN";
        static final String OPEN_WITH = "OPEN_WITH";
        static final String DELETE = "DELETE";
        static final String RENAME = "RENAME";
        static final String NEW_FOLDER = "NEW_FOLDER";
        static final String NEW_FILE = "NEW_FILE";
        static final String COPY = "COPY";
        static final String PASTE = "PASTE";
        static final String SORT_NAME = "SORT_NAME";
        static final String SORT_TYPE = "SORT_TYPE";
        static final String SET_WORKDIR = "SET_WORKDIR";
        static final String OPEN_PATH = "OPEN_PATH";
        static final String COPY_PATH = "COPY_PATH";
        static final String REFRESH = "REFRESH";
        boolean actionEnabled = true;
        boolean isSingleSelection;
        private TreePath[] paths;
        private TreePath path;
        private FileNode node;

        FileTreeActions() {
            this.put(ADD, new Add());
            this.put(REMOVE_FROM_LIST, new RemoveFromList());
            this.put(UP, new Up());
            this.put(DOWN, new Down());
            this.put(OPEN, new Open());
            this.put(OPEN_WITH, new OpenWith());
            this.put(DELETE, new Delete());
            this.put(COPY, new Copy());
            this.put(PASTE, new Paste());
            this.put(RENAME, new Rename());
            this.put(NEW_FOLDER, new NewFolder());
            this.put(NEW_FILE, new NewFile());
            this.put(SORT_NAME, new SortName());
            this.put(SORT_TYPE, new SortType());
            this.put(SET_WORKDIR, new SetWorkDir());
            this.put(COPY_PATH, new CopyPath());
            this.put(OPEN_PATH, new OpenPath());
            this.put(REFRESH, new Refresh());
        }

        void setActionEnabled(boolean bl) {
            if (this.actionEnabled != bl) {
                for (Object object : this.keys()) {
                    this.get(object).setEnabled(bl);
                }
                this.get(ADD).setEnabled(true);
                this.get(REFRESH).setEnabled(true);
            }
            this.actionEnabled = bl;
        }

        void updateTarget() {
            this.paths = FileExplorer.this.tree.getSelectionPaths();
            if (this.paths == null || this.paths.length == 0 || !TreeUtils.isSiblings(this.paths)) {
                this.node = null;
                this.setActionEnabled(false);
                return;
            }
            this.setActionEnabled(true);
            this.isSingleSelection = this.paths.length == 1;
            this.path = this.paths[0];
            this.node = (FileNode)this.path.getLastPathComponent();
            boolean bl = this.path.getPathCount() == 2;
            boolean bl2 = this.path.getPathCount() > 2;
            this.get(OPEN).setEnabled(this.isSingleSelection && this.node.isFile() && this.node.getFile().isFile());
            this.get(RENAME).setEnabled(this.isSingleSelection && !this.node.isFixedNode());
            this.get(NEW_FOLDER).setEnabled(this.isSingleSelection);
            this.get(PASTE).setEnabled(this.isSingleSelection);
            this.get(REMOVE_FROM_LIST).setEnabled(bl);
            this.get(UP).setEnabled(bl);
            this.get(DOWN).setEnabled(bl);
            this.get(DELETE).setEnabled(bl || bl2);
            this.get(SORT_NAME).setEnabled(bl2);
            this.get(SORT_TYPE).setEnabled(bl2);
            this.get(SET_WORKDIR).setEnabled(this.isSingleSelection && this.node.isFile() && this.node.getFile().isDirectory());
            this.get(OPEN_PATH).setEnabled(this.isSingleSelection);
            this.get(OPEN_WITH).setEnabled(this.get(OPEN).isEnabled());
        }

        public void showPopup(Component component, int n, int n2) {
            JMenuItem jMenuItem;
            if (!this.actionEnabled) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(this.get(ADD));
                jPopupMenu.add(FileExplorer.this.tree.getActionMap().get("ACTION_COLLAPSE_ALL"));
                jPopupMenu.add(this.get(REFRESH));
                jPopupMenu.show(component, n, n2);
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.get(OPEN));
            jPopupMenu.add(this.get(OPEN_WITH));
            jPopupMenu.addSeparator();
            Item item = FileExplorer.this.getSelectedItem();
            if (item != null) {
                jMenuItem = OpPopupMenu.createMenu(item, true);
                jPopupMenu.add(jMenuItem).setEnabled(((JMenu)jMenuItem).getItemCount() > 0);
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(OPEN_PATH));
            jPopupMenu.add(this.get(COPY_PATH));
            jPopupMenu.add(this.get(RENAME));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(NEW_FOLDER));
            jPopupMenu.add(this.get(NEW_FILE));
            jPopupMenu.add(this.get(ADD));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(COPY));
            jPopupMenu.add(this.get(PASTE));
            jPopupMenu.add(this.get(REMOVE_FROM_LIST));
            jPopupMenu.add(this.get(DELETE));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(SET_WORKDIR));
            jPopupMenu.addSeparator();
            jMenuItem = new JRadioButtonMenuItem(this.get(SORT_NAME));
            jMenuItem.setSelected(BasicFileNode.getComparator().equals(BasicFileNode.NAME_COMPARATOR));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.get(SORT_TYPE));
            jRadioButtonMenuItem.setSelected(BasicFileNode.getComparator().equals(BasicFileNode.TYPE_COMPARATOR));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            JMenu jMenu = new JMenu(Messages.getString("Menu.sort"));
            jMenu.add(jMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jMenu.add(this.get(UP));
            jMenu.add(this.get(DOWN));
            jPopupMenu.add(jMenu);
            jPopupMenu.add(FileExplorer.this.tree.getActionMap().get("ACTION_COLLAPSE_ALL"));
            jPopupMenu.add(this.get(REFRESH));
            UIUtility.cleanUpPopupMenu(jPopupMenu);
            jPopupMenu.addPopupMenuListener(this);
            jPopupMenu.show(component, n, n2);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            UIUtility.clearUnabledMenuItem((Container)popupMenuEvent.getSource());
            this.get(SET_WORKDIR).setEnabled(!Rflow.getInstance().isBusy());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                this.get(PASTE).setEnabled(clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor));
            }
            catch (Exception exception) {
                this.get(PASTE).setEnabled(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        private class Add
        extends LoggableAction {
            public Add() {
                this.putValue("Name", Messages.getStringWithDots("Action.add_entry"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Rflow.getInstance().getDefaultDirForSelection());
                jFileChooser.setFileSelectionMode(2);
                int n = jFileChooser.showDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Button.ok"));
                if (n != 0) {
                    return;
                }
                File file = jFileChooser.getSelectedFile();
                FileExplorer.this.addFileLinks(Lists.newArrayList((Object[])new File[]{file}));
            }
        }

        private class RemoveFromList
        extends LoggableAction {
            public RemoveFromList() {
                this.putValue("Name", Messages.getString("Action.remove_from_list"));
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (FileTreeActions.this.paths[0].getPathCount() != 2) {
                    return;
                }
                ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
                for (int i = 0; i < FileTreeActions.this.paths.length; ++i) {
                    arrayList.add((FileNode)FileTreeActions.this.paths[i].getLastPathComponent());
                }
                FileExplorer.this.fileManager.remove(arrayList);
            }
        }

        private class Up
        extends LoggableAction {
            public Up() {
                this.putValue("Name", Messages.getString("Action.up"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (FileTreeActions.this.paths[0].getPathCount() != 2) {
                    return;
                }
                FileExplorer.this.fileManager.moveUp(FileExplorer.this.getLastComponents(FileTreeActions.this.paths));
            }
        }

        private class Down
        extends LoggableAction {
            public Down() {
                this.putValue("Name", Messages.getString("Action.down"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (FileTreeActions.this.paths[0].getPathCount() != 2) {
                    return;
                }
                FileExplorer.this.fileManager.moveDown(FileExplorer.this.getLastComponents(FileTreeActions.this.paths));
            }
        }

        private class Open
        extends LoggableAction {
            public Open() {
                this.putValue("Name", Messages.getString("Action.open"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.open(FileTreeActions.this.node.getFile(), false);
            }
        }

        private class OpenWith
        extends LoggableAction {
            public OpenWith() {
                this.putValue("Name", Messages.getStringWithDots("Action.open_with"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.open(FileTreeActions.this.node.getFile(), true);
            }
        }

        private class Delete
        extends LoggableAction {
            public Delete() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.delete(FileTreeActions.this.paths);
            }
        }

        private class Copy
        extends LoggableAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.copyToClipboard(FileTreeActions.this.paths);
            }
        }

        private class Paste
        extends LoggableAction {
            public Paste() {
                this.putValue("Name", Messages.getString("Action.paste"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (!FileTreeActions.this.node.isFile() || !clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor)) {
                    return;
                }
                File file = FileTreeActions.this.node.getFile();
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                if (file == null) {
                    return;
                }
                try {
                    File file2;
                    List list = (List)Utility.cast(clipboard.getData(DataFlavor.javaFileListFlavor));
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && FileExplorer.this.copyFile(file2 = (File)iterator.next(), file, list.size() > 1)) {
                    }
                }
                catch (IOException iOException) {
                    UIUtility.showErrorDialog((Component)FileExplorer.this, iOException);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
                if (FileTreeActions.this.node.isFile() && FileTreeActions.this.node.getFile().isFile()) {
                    FileExplorer.this.refresh((FileNode)FileTreeActions.this.node.getParent());
                } else {
                    FileExplorer.this.refresh(FileTreeActions.this.node);
                }
            }
        }

        private class Rename
        extends LoggableAction {
            public Rename() {
                this.putValue("Name", Messages.getString("Action.rename"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (FileTreeActions.this.node.isFixedNode()) {
                    return;
                }
                if (FileTreeActions.this.node.isLinkEntry()) {
                    String string = UIUtility.showInputDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Action.rename"), "", FileTreeActions.this.node.getName());
                    if (string == null) {
                        return;
                    }
                    FileExplorer.this.fileManager.rename(FileTreeActions.this.node, string);
                } else {
                    File file = FileTreeActions.this.node.getFile();
                    File file2 = FileExplorer.this.fileControl.renameName(file);
                    if (file2 == null || file2.equals(file)) {
                        return;
                    }
                    if (file2.exists()) {
                        UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.format("Error.already_exists", file.getPath()));
                        return;
                    }
                    if (FlowModel.isRflow(file.getName()) && FlowModel.isRflow(file2.getName())) {
                        try {
                            FlowModel flowModel = null;
                            FileEditManager fileEditManager = FileEditManager.getInstance();
                            for (FlowModel flowModel2 : fileEditManager.getFlowModels()) {
                                if (!file.equals(flowModel2.getWorkingFile())) continue;
                                flowModel = flowModel2;
                                if (!flowModel.isDirty()) break;
                                UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.format("Error.editing", file.getPath()));
                                return;
                            }
                            if (flowModel == null) {
                                flowModel = FlowModel.readFlowModel(file, file, null);
                            }
                            flowModel.move(file2);
                        }
                        catch (ReadException | IOException exception) {
                            UIUtility.showErrorDialog((Component)Rflow.mainFrame(), exception);
                        }
                    } else {
                        FileExplorer.this.fileControl.rename(file, file2);
                    }
                    FileExplorer.this.refresh((FileNode)FileTreeActions.this.node.getParent());
                }
            }
        }

        private class NewFolder
        extends LoggableAction {
            public NewFolder() {
                this.putValue("Name", Messages.getStringWithDots("Action.new_folder"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.fileControl.createFolderAskName(FileTreeActions.this.node.getFile());
                FileExplorer.this.refresh(FileTreeActions.this.node);
            }
        }

        private class NewFile
        extends LoggableAction {
            public NewFile() {
                this.putValue("Name", Messages.getStringWithDots("Action.new_file"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Path path = WorkingDirectory.toAbsolutePath(FileTreeActions.this.node.getFile()).toPath();
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    path = path.getParent();
                }
                if (path == null) {
                    return;
                }
                try {
                    String string = UIUtility.showInputDialog(Rflow.mainFrame(), Messages.getString("Action.new_file"), Messages.getString("Message.name"), "");
                    if (string == null) {
                        return;
                    }
                    if (string.isEmpty()) {
                        throw new IOException("File name is empty");
                    }
                    final Path path2 = path.resolve(string);
                    if (Files.exists(path2, new LinkOption[0])) {
                        throw new IOException(Messages.format("Error.already_exists", string));
                    }
                    Files.createFile(path2, new FileAttribute[0]);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            return null;
                        }

                        @Override
                        protected void done() {
                            List<FileNode> list = FileExplorer.this.fileManager.getNodes(path2.toFile());
                            if (list.isEmpty()) {
                                return;
                            }
                            FileNode fileNode = list.iterator().next();
                            TreePath treePath = new TreePath(FileExplorer.this.getModel().getPathToRoot(fileNode));
                            FileExplorer.this.tree.setSelectionPath(treePath);
                            FileExplorer.this.tree.scrollPathToVisible(treePath);
                        }
                    };
                    FileExplorer.this.executor.execute(swingWorker);
                }
                catch (Exception exception) {
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), exception);
                }
            }
        }

        private class SortName
        extends LoggableAction {
            public SortName() {
                this.putValue("Name", Messages.getString("Action.sort_name"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.setSortOrder(BasicFileNode.NAME_COMPARATOR);
            }
        }

        private class SortType
        extends LoggableAction {
            public SortType() {
                this.putValue("Name", Messages.getString("Action.sort_type"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileExplorer.this.setSortOrder(BasicFileNode.TYPE_COMPARATOR);
            }
        }

        private class SetWorkDir
        extends LoggableAction {
            public SetWorkDir() {
                this.putValue("Name", Messages.getString("Action.set_dir0"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                File file = FileTreeActions.this.node.getFile();
                if (!file.isDirectory() || !file.exists()) {
                    return;
                }
                if (!WorkingDirectory.setWorkingDirectory(file)) {
                    Rflow.actions().showSettingRWorkingDirFailedMessage(false);
                }
            }
        }

        private class CopyPath
        extends LoggableAction {
            public CopyPath() {
                this.putValue("Name", Messages.getString("Action.copy_path"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                List<File> list = FileExplorer.this.getFiles(FileTreeActions.this.paths);
                StringBuilder stringBuilder = new StringBuilder();
                if (list.size() == 1) {
                    stringBuilder.append(list.get(0).getAbsolutePath());
                } else {
                    for (File file : list) {
                        stringBuilder.append(file.getAbsolutePath()).append('\n');
                    }
                }
                UIUtility.copyToClipboard(stringBuilder.toString());
            }
        }

        private class OpenPath
        extends LoggableAction {
            public OpenPath() {
                this.putValue("Name", Messages.getString("Action.open_path"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                File file = FileTreeActions.this.node.getFile();
                FileUIUtility.openPath(file);
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (FileTreeActions.this.node != null) {
                    FileExplorer.this.refresh(FileTreeActions.this.node);
                } else {
                    FileExplorer.this.refreshRoot();
                }
            }
        }
    }

    private class RItemEventHandler
    implements ItemEventHandler {
        private RItemEventHandler() {
        }

        @Override
        public void itemChanged(ItemEvent itemEvent) {
            if (itemEvent.getType() != 1) {
                return;
            }
            if (FileExplorer.this.lastUpdateTimeSpan < 300L) {
                FileExplorer.this.refreshWorkingDirectory();
            }
        }
    }

    private class FileTree
    extends RflowTree {
        public FileTree(TreeModel treeModel) {
            super(treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return null;
            }
            FileNode fileNode = (FileNode)treePath.getLastPathComponent();
            if (fileNode.getFile() == null || fileNode.getParent() == null) {
                return null;
            }
            if (((FileNode)fileNode.getParent()).getFile() != null) {
                return null;
            }
            return fileNode.getFile().getAbsolutePath();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            JTree jTree = (JTree)mouseEvent.getSource();
            TreePath treePath = jTree.getPathForLocation((int)(point = mouseEvent.getPoint()).getX(), (int)point.getY());
            if (treePath == null) {
                return;
            }
            if (jTree.isPathSelected(treePath)) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            TreePath treePath = jTree.getPathForLocation((int)point.getX(), (int)point.getY());
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                if (treePath == null) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2) {
                    FileNode fileNode = (FileNode)treePath.getLastPathComponent();
                    FileExplorer.this.open(fileNode.getFile(), false);
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                if (!jTree.getSelectionModel().isPathSelected(treePath)) {
                    jTree.setSelectionPath(treePath);
                }
                FileExplorer.this.fileActions.showPopup(jTree, point.x, point.y);
            }
        }
    }

    private class DragSourceHandler
    extends DragSourceAdapter
    implements DragGestureListener {
        private Set<FileNode> dragNodeSet = new HashSet<FileNode>();

        private DragSourceHandler() {
        }

        public Set<FileNode> getDragNodeSet() {
            return this.dragNodeSet;
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(UIUtility.getInvalidCursor());
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            HashSet<FileNode> hashSet = new HashSet<FileNode>();
            for (FileNode fileNode : this.dragNodeSet) {
                if (fileNode.isFile() && !fileNode.getFile().isDirectory()) {
                    hashSet.add((FileNode)fileNode.getParent());
                    continue;
                }
                hashSet.add(fileNode);
            }
            FileExplorer.this.refresh(hashSet);
            this.dragNodeSet.clear();
            FileExplorer.this.tree.repaint();
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            this.setCursor(dragSourceDragEvent);
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.setCursor(dragSourceDragEvent);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.setCursor(dragSourceDragEvent);
        }

        private void setCursor(DragSourceDragEvent dragSourceDragEvent) {
            if (dragSourceDragEvent.getTargetActions() != 0) {
                switch (dragSourceDragEvent.getDropAction()) {
                    case 1: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(UIUtility.getCopyCursor());
                        break;
                    }
                    case 2: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(UIUtility.getMoveCursor());
                        break;
                    }
                    case 0x40000000: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(UIUtility.getLinkCursor());
                        break;
                    }
                    case 0: {
                        dragSourceDragEvent.getDragSourceContext().setCursor(UIUtility.getInvalidCursor());
                    }
                }
            } else {
                dragSourceDragEvent.getDragSourceContext().setCursor(UIUtility.getInvalidCursor());
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if ((dragGestureEvent.getTriggerEvent().getModifiers() & 0x10) == 0) {
                return;
            }
            Point point = dragGestureEvent.getDragOrigin();
            TreePath treePath = FileExplorer.this.tree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            TreePath[] treePathArray = FileExplorer.this.getSelectedPaths(treePath);
            List<FileNode> list = FileExplorer.this.getLastComponents(treePathArray);
            if (list.isEmpty()) {
                return;
            }
            FileNodeTransferable fileNodeTransferable = new FileNodeTransferable(list.toArray(new FileNode[0]));
            try {
                dragGestureEvent.getDragSource().startDrag(dragGestureEvent, Cursor.getDefaultCursor(), fileNodeTransferable, this);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to start drag.", exception);
            }
            this.dragNodeSet.clear();
            for (FileNode fileNode : list) {
                this.dragNodeSet.add(fileNode);
            }
        }
    }

    private class DropTargetHandler
    extends TreeDnDMoveHandler {
        public DropTargetHandler(JTree jTree) {
            super(jTree, false);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Point point = dropTargetDragEvent.getLocation();
                TreePath treePath = FileExplorer.this.tree.getPathForLocation(point.x, point.y);
                FileExplorer.this.tree.setSelectionPath(treePath);
                if (!dropTargetDragEvent.isDataFlavorSupported(this.getNodeFlavor())) {
                    if (treePath == null) {
                        dropTargetDragEvent.acceptDrag(0x40000000);
                    } else {
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    }
                    return;
                }
            }
            super.dragOver(dropTargetDragEvent);
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isLocalTransfer()) {
                super.drop(dropTargetDropEvent);
            } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                File file;
                List list;
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                Transferable transferable = dropTargetDropEvent.getTransferable();
                try {
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Failed to get file transfer data.", exception);
                    return;
                }
                Point point = dropTargetDropEvent.getLocation();
                TreePath treePath = FileExplorer.this.tree.getPathForLocation(point.x, point.y);
                FileExplorer.this.tree.setSelectionPath(treePath);
                if (treePath == null) {
                    FileExplorer.this.addFileLinks(list);
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
                FileNode fileNode = (FileNode)treePath.getLastPathComponent();
                File file2 = file = fileNode.getFile().isDirectory() ? fileNode.getFile() : fileNode.getFile().getParentFile();
                if (file == null) {
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                switch (dropTargetDropEvent.getDropAction()) {
                    case 1: {
                        File file3;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && FileExplorer.this.copyFile(file3 = (File)iterator.next(), file, list.size() > 1)) {
                        }
                        FileExplorer.this.refresh(fileNode);
                        dropTargetDropEvent.dropComplete(true);
                        break;
                    }
                    case 2: {
                        File file4;
                        if (file.equals(((File)list.get(0)).getParentFile())) {
                            return;
                        }
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && FileExplorer.this.moveFile(file4 = (File)iterator.next(), new File(file, file4.getName()), list.size() > 1)) {
                        }
                        FileExplorer.this.refresh(fileNode.getFile().isDirectory() ? fileNode : (FileNode)fileNode.getParent());
                        dropTargetDropEvent.dropComplete(true);
                        break;
                    }
                    default: {
                        dropTargetDropEvent.dropComplete(false);
                    }
                }
            }
        }

        @Override
        protected void moveDragNode(DropTargetDropEvent dropTargetDropEvent, MutableTreeNode[] mutableTreeNodeArray, MutableTreeNode mutableTreeNode, int n) {
            File file = ((FileNode)mutableTreeNode).getFile();
            if (file.equals(((FileNode)mutableTreeNodeArray[0].getParent()).getFile())) {
                return;
            }
            if (file.exists()) {
                MutableTreeNode mutableTreeNode2;
                File file2;
                MutableTreeNode[] mutableTreeNodeArray2 = mutableTreeNodeArray;
                int n2 = mutableTreeNodeArray2.length;
                for (int i = 0; i < n2 && FileExplorer.this.moveFile(file2 = ((FileNode)(mutableTreeNode2 = mutableTreeNodeArray2[i])).getFile(), new File(file, file2.getName()), mutableTreeNodeArray.length > 1); ++i) {
                }
                FileExplorer.this.refresh((FileNode)mutableTreeNode);
            }
        }

        @Override
        protected void copyDragNode(DropTargetDropEvent dropTargetDropEvent, MutableTreeNode[] mutableTreeNodeArray, MutableTreeNode mutableTreeNode, int n) {
            File file = ((FileNode)mutableTreeNode).getFile();
            if (file != null && file.exists()) {
                MutableTreeNode mutableTreeNode2;
                File file2;
                MutableTreeNode[] mutableTreeNodeArray2 = mutableTreeNodeArray;
                int n2 = mutableTreeNodeArray2.length;
                for (int i = 0; i < n2 && ((file2 = ((FileNode)(mutableTreeNode2 = mutableTreeNodeArray2[i])).getFile()) == null || FileExplorer.this.copyFile(file2, file, mutableTreeNodeArray.length > 1)); ++i) {
                }
            }
            FileExplorer.this.refresh((FileNode)mutableTreeNode);
        }

        @Override
        protected boolean checkDragAccept(DropTargetDragEvent dropTargetDragEvent, MutableTreeNode[] mutableTreeNodeArray) {
            return dropTargetDragEvent.getDropAction() != 2 || !this.getCurrentTargetParent().equals(mutableTreeNodeArray[0].getParent());
        }
    }

    private class FileTreeRenderer
    extends BasicTreeCellRenderer {
        private boolean weak;

        private FileTreeRenderer() {
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            if (this.weak) {
                return UIColor.WEAK_SELECTION;
            }
            return super.getBackgroundNonSelectionColor();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Icon icon;
            TreePath treePath = jTree.getPathForRow(n);
            if (treePath != null && treePath.getLastPathComponent() != object) {
                String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
                this.setText(string);
                return this;
            }
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            FileNode fileNode = (FileNode)object;
            File file = fileNode.getFile();
            boolean bl5 = this.selected = this.selected || FileExplorer.this.dragSourceHandler.getDragNodeSet().contains(fileNode);
            if (!this.selected && fileNode.isLinkEntry()) {
                this.setForeground(Color.BLUE);
            }
            if (file != null && !this.selected && FileExplorer.this.fileManager.isNewItem(file)) {
                this.setForeground(Color.BLUE);
            }
            boolean bl6 = this.weak = treePath != null && treePath.equals(FileExplorer.this.weakSelection);
            if (!FileExplorer.this.refreshingFolder && (icon = FileUIUtility.getIcon(fileNode, this.getIcon())) != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.SHOW_HIDDEN_FILES.equals(valueChangeEvent.getKey())) {
                FileExplorer.this.refreshRoot();
            }
        }
    }

    private class RefreshWorker
    implements Runnable {
        private TreePath path;
        private boolean expand;

        public RefreshWorker(TreePath treePath, boolean bl) {
            this.path = treePath;
            this.expand = bl;
        }

        @Override
        public void run() {
            FileExplorer.this.refreshing = true;
            this.path = FileExplorer.this.getTreePath(this.path);
            if (this.path == null) {
                return;
            }
            FileNode fileNode = (FileNode)this.path.getLastPathComponent();
            List<FileNode> list = fileNode.retrieveChildren();
            try {
                SwingUtilities.invokeAndWait(() -> {
                    fileNode.setChildren(list);
                    FileExplorer.this.getModel().nodeStructureChanged(fileNode);
                    if (this.expand) {
                        FileExplorer.this.tree.removeTreeWillExpandListener(FileExplorer.this);
                        try {
                            FileExplorer.this.tree.expandPath(this.path);
                        }
                        finally {
                            FileExplorer.this.tree.addTreeWillExpandListener(FileExplorer.this);
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to refresh file tree", exception);
            }
        }
    }

    private class RefreshFinishWorker
    extends SwingWorker<Void, Void> {
        private TreePath[] paths;

        public RefreshFinishWorker(TreePath[] treePathArray) {
            this.paths = treePathArray;
        }

        @Override
        protected Void doInBackground() throws Exception {
            return null;
        }

        @Override
        protected void done() {
            if (this.paths != null && this.paths.length > 0) {
                int[] nArray = Arrays.stream(this.paths).mapToInt(treePath -> FileExplorer.this.tree.getRowForPath((TreePath)treePath)).filter(n -> n >= 0).toArray();
                if (nArray.length > 0) {
                    FileExplorer.this.tree.setSelectionRows(nArray);
                } else {
                    FileExplorer.this.tree.clearSelection();
                }
            } else {
                FileExplorer.this.tree.clearSelection();
            }
            FileExplorer.this.refreshing = false;
            FileExplorer.this.dispatchItemSelectionEvent();
        }
    }
}

