/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.google.common.io.Files;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;

class FileForSort {
    private File file;
    private String name;
    private boolean isDirectory;
    private String extension;

    public FileForSort(Path path, boolean bl) {
        this.file = path.toFile();
        this.name = path.getFileName().toString();
        this.isDirectory = bl;
        this.extension = bl ? "" : Files.getFileExtension((String)this.name);
    }

    public FileForSort(String string) {
        this.init(string, string.endsWith("/"));
    }

    private void init(String string, boolean bl) {
        this.name = string;
        this.isDirectory = bl;
        this.extension = bl ? "" : this.getExtensionFromName(string);
    }

    private String getExtensionFromName(String string) {
        String string2 = FilenameUtils.getExtension((String)string);
        return string2 == null ? "" : string2;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getExtension() {
        return this.extension;
    }
}

