/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.ElementReader;
import com.ef_prime.rflow.core.flow.ElementWriter;
import com.ef_prime.rflow.core.flow.FlowDataReader;
import com.ef_prime.rflow.core.flow.FlowDataWriter;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.core.util.XMLException;
import com.ef_prime.rflow.node.group.AppearanceGroup;
import com.ef_prime.rflow.node.group.AppearanceGroupManager;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.ButtonPanel;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowScrollPane;
import com.ef_prime.rflow.ui.common.component.RflowTextField;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.component.TreeDnDMoveHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.TreeUtils;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FunctionNode;
import com.ef_prime.rflow.ui.view.FunctionNodeTransferable;
import com.ef_prime.rflow.ui.view.FunctionTreeElementWriter;
import com.ef_prime.rflow.ui.view.FunctionTreeReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@Deprecated
public class FunctionExplorer
extends View {
    private static final Logger LOGGER = Logger.getLogger(FunctionExplorer.class.getName());
    private JTree tree;
    private MoveDropHandler moveDropHandler;

    public FunctionExplorer() {
        this.setLayout(new BorderLayout());
        this.tree = new RflowTree(new DefaultTreeModel(new FunctionNode("(Empty)"))){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                FunctionExplorer.this.moveDropHandler.drawTargetLine(graphics);
            }
        };
        this.tree.setEditable(false);
        this.tree.addMouseListener(new MouseHandler());
        this.getTreeModel().addTreeModelListener(new FunctionTreeModelListener());
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 2, new DragGesture());
        this.moveDropHandler = new MoveDropHandler(this.tree);
        new DropTarget(this.tree, this.moveDropHandler);
        this.tree.setCellRenderer(new TreeRenderer());
        this.add((Component)new RflowScrollPane(this.tree), "Center");
    }

    @Override
    public String getTitle() {
        return Messages.getString("Explorer.function");
    }

    public void importFunctionTree(File file) throws ReadException, IOException {
        FlowDataReader flowDataReader = new FlowDataReader();
        FunctionTreeReader functionTreeReader = new FunctionTreeReader(AppearanceGroupManager.getInstance());
        flowDataReader.read(file, new ElementReader[]{functionTreeReader});
        this.init(functionTreeReader.getRootNode());
    }

    public void init(FunctionNode functionNode) {
        this.getTreeModel().setRoot(functionNode);
    }

    public FunctionNode getRoot() {
        return (FunctionNode)this.tree.getModel().getRoot();
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    public void save(File file) throws IOException, XMLException {
        new FlowDataWriter().write(file, new ElementWriter[]{new FunctionTreeElementWriter(AppearanceGroupManager.getInstance(), this.getRoot())});
    }

    public FunctionNode[] getSelectedNodes(FunctionNode functionNode) {
        TreeNode[] treeNodeArray = new FunctionNode[this.tree.getSelectionCount()];
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            treePathArray = new TreePath[]{};
        }
        boolean bl = false;
        for (int i = 0; i < treePathArray.length; ++i) {
            treeNodeArray[i] = (FunctionNode)treePathArray[i].getLastPathComponent();
            if (bl || !treeNodeArray[i].equals(functionNode)) continue;
            bl = true;
        }
        if (bl && TreeUtils.isSiblings(treeNodeArray)) {
            return treeNodeArray;
        }
        if (bl) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(new TreePath(functionNode.getPath()));
        }
        return new FunctionNode[]{functionNode};
    }

    void newNode(FunctionNode functionNode, boolean bl, Point point) {
        FunctionNode functionNode2 = bl ? new FunctionNode("", "", "") : new FunctionNode("");
        FunctionNode functionNode3 = this.editNode_internal(functionNode2, point);
        if (functionNode3 == null) {
            return;
        }
        FunctionNode functionNode4 = functionNode;
        if (!functionNode4.hasFunction() || functionNode4.isRoot()) {
            this.getTreeModel().insertNodeInto(functionNode3, functionNode4, functionNode4.getChildCount());
        } else {
            functionNode4 = (FunctionNode)functionNode4.getParent();
            this.getTreeModel().insertNodeInto(functionNode3, functionNode4, functionNode4.getIndex(functionNode) + 1);
        }
        AppearanceGroupManager.getInstance().addFunction(functionNode3.getFunction(), functionNode3.getGroupBelongTo(), true);
        this.updateGroup();
    }

    void removeNode(FunctionNode functionNode) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)functionNode.getParent();
        if (mutableTreeNode == null) {
            return;
        }
        this.removeFunctionFromGroup(functionNode);
        this.getTreeModel().removeNodeFromParent(functionNode);
    }

    void editNode(FunctionNode functionNode, Point point) {
        FunctionNode functionNode2 = this.editNode_internal(functionNode, point);
        if (functionNode2 == null) {
            return;
        }
        this.removeFunctionFromGroup(functionNode);
        functionNode.setData(functionNode2);
        this.addFunctionToGroup(functionNode);
        this.getTreeModel().nodeChanged(functionNode);
    }

    private FunctionNode editNode_internal(FunctionNode functionNode, Point point) {
        Point point2 = this.getLocationOnScreen();
        EditDialog editDialog = new EditDialog(Rflow.getInstance().getMainFrame(), functionNode);
        editDialog.setLocation(point2.x + point.x + 50, point2.y + point.y - editDialog.getHeight() / 2);
        editDialog.setVisible(true);
        editDialog.dispose();
        return editDialog.getFunctionNode();
    }

    void moveNode(MutableTreeNode mutableTreeNode, boolean bl) {
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
        if (mutableTreeNode2 == null) {
            return;
        }
        int n = mutableTreeNode2.getIndex(mutableTreeNode);
        int n2 = n = bl ? n - 1 : n + 1;
        if (n < 0 || n > mutableTreeNode2.getChildCount() - 1) {
            return;
        }
        this.getTreeModel().removeNodeFromParent(mutableTreeNode);
        this.getTreeModel().insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
    }

    private void removeFunctionFromGroup(FunctionNode functionNode) {
        if (functionNode.hasFunction()) {
            AppearanceGroupManager.getInstance().removeFunction(functionNode.getFunction());
        }
        for (int i = 0; i < functionNode.getChildCount(); ++i) {
            this.removeFunctionFromGroup((FunctionNode)functionNode.getChildAt(i));
        }
    }

    private void addFunctionToGroup(FunctionNode functionNode) {
        AppearanceGroup appearanceGroup;
        if (functionNode.hasFunction() && (appearanceGroup = functionNode.getGroupBelongTo()) != null) {
            AppearanceGroupManager.getInstance().addFunction(functionNode.getFunction(), appearanceGroup, true);
        }
        for (int i = 0; i < functionNode.getChildCount(); ++i) {
            this.addFunctionToGroup((FunctionNode)functionNode.getChildAt(i));
        }
    }

    public void updateGroup() {
        Rflow.mainView().repaint();
    }

    private class MouseHandler
    extends MouseAdapter {
        private FunctionActions popup;

        private MouseHandler() {
            this.popup = new FunctionActions();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            JTree jTree = (JTree)mouseEvent.getSource();
            TreePath treePath = jTree.getPathForLocation((int)(point = mouseEvent.getPoint()).getX(), (int)point.getY());
            if (treePath == null) {
                return;
            }
            FunctionNode functionNode = (FunctionNode)treePath.getLastPathComponent();
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                this.popup.show(jTree, functionNode, point.x, point.y);
            }
        }
    }

    private class FunctionTreeModelListener
    implements TreeModelListener {
        private FunctionTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            FunctionExplorer.this.updateGroup();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            FunctionExplorer.this.updateGroup();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            FunctionExplorer.this.updateGroup();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.update();
            FunctionExplorer.this.updateGroup();
        }

        private void update() {
            AppearanceGroupManager.getInstance().clearFunctions();
            this.registerFunction(FunctionExplorer.this.getRoot());
        }

        private void registerFunction(FunctionNode functionNode) {
            AppearanceGroup appearanceGroup;
            if (functionNode.hasFunction() && (appearanceGroup = functionNode.getGroupBelongTo()) != null) {
                AppearanceGroupManager.getInstance().addFunction(functionNode.getFunction(), appearanceGroup, false);
            }
            for (int i = 0; i < functionNode.getChildCount(); ++i) {
                this.registerFunction((FunctionNode)functionNode.getChildAt(i));
            }
        }
    }

    private class DragGesture
    extends DragSourceAdapter
    implements DragGestureListener {
        private Cursor MOVE_CURSOR;
        private Cursor INVALID_CURSOR;

        DragGesture() {
            try {
                this.MOVE_CURSOR = Cursor.getSystemCustomCursor("MoveDrop.32x32");
                this.INVALID_CURSOR = Cursor.getSystemCustomCursor("InvalidDrop.32x32");
            }
            catch (Exception exception) {
                this.MOVE_CURSOR = this.INVALID_CURSOR = Cursor.getDefaultCursor();
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(this.MOVE_CURSOR);
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(this.INVALID_CURSOR);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            TreePath treePath = FunctionExplorer.this.tree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            FunctionNode functionNode = (FunctionNode)treePath.getLastPathComponent();
            FunctionNode[] functionNodeArray = FunctionExplorer.this.getSelectedNodes(functionNode);
            FunctionNodeTransferable functionNodeTransferable = new FunctionNodeTransferable(functionNodeArray);
            try {
                dragGestureEvent.getDragSource().startDrag(dragGestureEvent, Cursor.getSystemCustomCursor("MoveDrop.32x32"), functionNodeTransferable, this);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    private class MoveDropHandler
    extends TreeDnDMoveHandler {
        public MoveDropHandler(JTree jTree) {
            super(jTree, true);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            FunctionExplorer.this.tree.cancelEditing();
            super.dragOver(dropTargetDragEvent);
            if (this.getTargetNode() != null && this.getCurrentTargetParent() == this.getTargetNode()) {
                FunctionExplorer.this.tree.setSelectionPath(new TreePath(this.getTreeModel().getPathToRoot(this.getTargetNode())));
            } else {
                FunctionExplorer.this.tree.clearSelection();
            }
        }

        @Override
        protected boolean checkDragAccept(DropTargetDragEvent dropTargetDragEvent, MutableTreeNode[] mutableTreeNodeArray) {
            for (MutableTreeNode mutableTreeNode : mutableTreeNodeArray) {
                if (mutableTreeNode != this.getTargetNode()) continue;
                return false;
            }
            if (this.getCurrentTargetParent().getIndex(mutableTreeNodeArray[0]) > -1) {
                int n = this.getCurrentTargetIndex() - 1;
                TreeNode treeNode = mutableTreeNodeArray[0].getParent();
                for (MutableTreeNode mutableTreeNode : mutableTreeNodeArray) {
                    int n2 = treeNode.getIndex(mutableTreeNode);
                    if (n != n2 && n + 1 != n2) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        protected void copyDragNode(DropTargetDropEvent dropTargetDropEvent, MutableTreeNode[] mutableTreeNodeArray, MutableTreeNode mutableTreeNode, int n) {
        }

        @Override
        protected void onDropComplete(MutableTreeNode[] mutableTreeNodeArray) {
            for (MutableTreeNode mutableTreeNode : mutableTreeNodeArray) {
                FunctionExplorer.this.addFunctionToGroup((FunctionNode)mutableTreeNode);
            }
            FunctionExplorer.this.updateGroup();
            FunctionExplorer.this.tree.clearSelection();
        }
    }

    private class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            FunctionNode functionNode = (FunctionNode)object;
            if (functionNode.hasGroup()) {
                this.setIcon(functionNode.getGroup().getSmallIcon());
            } else if (!functionNode.hasFunction()) {
                this.setIcon(bl2 ? this.getOpenIcon() : this.getClosedIcon());
            }
            return this;
        }
    }

    private class EditDialog
    extends JDialog {
        private boolean hasFunction;
        private FunctionNode node;

        public EditDialog(Frame frame, FunctionNode functionNode) throws HeadlessException {
            super(frame, true);
            this.init(functionNode);
        }

        private void init(FunctionNode functionNode) {
            final FunctionNode functionNode2 = functionNode.copy();
            AppearanceGroup appearanceGroup = functionNode.getGroupBelongTo();
            this.hasFunction = functionNode2.hasFunction();
            this.setTitle(Messages.getString("Message.edit"));
            Dimension dimension = new Dimension(60, 20);
            Dimension dimension2 = new Dimension(200, 20);
            JLabel jLabel = new JLabel(Messages.getString("Message.name"));
            jLabel.setMaximumSize(dimension);
            jLabel.setPreferredSize(dimension);
            final RflowTextField rflowTextField = new RflowTextField();
            rflowTextField.setMaximumSize(dimension2);
            rflowTextField.setPreferredSize(dimension2);
            rflowTextField.setText(functionNode2.getTitle());
            Box box = Box.createHorizontalBox();
            box.add(jLabel);
            box.add(rflowTextField);
            JLabel jLabel2 = new JLabel("");
            jLabel2.setMaximumSize(dimension);
            jLabel2.setPreferredSize(dimension);
            String[] stringArray = R.client().getInstalledPackages();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
            vector.add(0, "");
            final JComboBox<String> jComboBox = new JComboBox<String>(vector);
            jComboBox.setMaximumSize(dimension2);
            jComboBox.setPreferredSize(dimension2);
            if (functionNode2.hasPackage()) {
                jComboBox.setSelectedItem(functionNode2.getPackage());
            }
            Box box2 = Box.createHorizontalBox();
            box2.add(jLabel2);
            box2.add(jComboBox);
            JLabel jLabel3 = new JLabel(Messages.getString("FunctionExplorer.function"));
            jLabel3.setMaximumSize(dimension);
            jLabel3.setPreferredSize(dimension);
            final RflowTextField rflowTextField2 = new RflowTextField();
            rflowTextField2.setMaximumSize(dimension2);
            rflowTextField2.setPreferredSize(dimension2);
            if (this.hasFunction) {
                rflowTextField2.setText(functionNode2.getFunction());
            }
            Box box3 = Box.createHorizontalBox();
            box3.add(jLabel3);
            box3.add(rflowTextField2);
            JLabel jLabel4 = new JLabel(Messages.getString("FunctionExplorer.group"));
            jLabel4.setMaximumSize(dimension);
            jLabel4.setPreferredSize(dimension);
            Vector<AppearanceGroup> vector2 = new Vector<AppearanceGroup>();
            vector2.add(null);
            vector2.addAll(AppearanceGroupManager.getInstance().getGroups());
            final JComboBox<Object> jComboBox2 = new JComboBox<Object>(vector2);
            jComboBox2.setMaximumSize(dimension2);
            jComboBox2.setPreferredSize(dimension2);
            jComboBox2.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    AppearanceGroup appearanceGroup = (AppearanceGroup)object;
                    if (appearanceGroup == null) {
                        this.setText(Messages.getString("FunctionExplorer.inherit_from_parent"));
                    } else {
                        this.setIcon(appearanceGroup.getSmallIcon());
                    }
                    return this;
                }
            });
            jComboBox2.setSelectedItem(functionNode2.getGroup());
            if (functionNode2.getGroup() == null && appearanceGroup != null) {
                jComboBox2.removeItem(appearanceGroup);
            }
            Box box4 = Box.createHorizontalBox();
            box4.add(jLabel4);
            box4.add(jComboBox2);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    if (EditDialog.this.hasFunction) {
                        string = rflowTextField2.getText();
                        if (string.length() < 1) {
                            JOptionPane.showMessageDialog(EditDialog.this, Messages.getString("Error.function_is_empty"), Messages.getString("Error.title.error"), 0);
                            return;
                        }
                        if (!functionNode2.getFunction().equals(string) && AppearanceGroupManager.getInstance().hasFunction(string)) {
                            JOptionPane.showMessageDialog(EditDialog.this, Messages.getString("Error.duplicate_function"), Messages.getString("Error.title.error"), 0);
                            rflowTextField2.requestFocusInWindow();
                            rflowTextField2.selectAll();
                            return;
                        }
                    }
                    if ((string = (String)jComboBox.getSelectedItem()).equals("")) {
                        string = null;
                    }
                    EditDialog.this.node = new FunctionNode(rflowTextField.getText(), EditDialog.this.hasFunction ? rflowTextField2.getText() : null, EditDialog.this.hasFunction ? string : null, null, (AppearanceGroup)jComboBox2.getSelectedItem());
                    EditDialog.this.dispose();
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditDialog.this.node = null;
                    EditDialog.this.dispose();
                }
            };
            ButtonPanel buttonPanel = new ButtonPanel(actionListener, actionListener2, new Dimension(80, 22));
            Box box5 = Box.createVerticalBox();
            box5.setBorder(new EmptyBorder(10, 10, 10, 10));
            box5.add(box);
            if (this.hasFunction) {
                box5.add(Box.createVerticalStrut(5));
                box5.add(box3);
            }
            box5.add(Box.createVerticalStrut(5));
            box5.add(box4);
            box5.add(Box.createVerticalStrut(15));
            box5.add(buttonPanel);
            this.getContentPane().add((Component)box5, "Center");
            this.pack();
        }

        public FunctionNode getFunctionNode() {
            return this.node;
        }
    }

    private class FunctionActions
    extends Actions {
        static final String NEW_FUNCTION = "NEW_FUNCTION";
        static final String NEW_FOLDER = "NEW_FOLDER";
        static final String REMOVE = "REMOVE";
        static final String EDIT = "EDIT";
        static final String MOVE_UP = "MOVE_UP";
        static final String MOVE_DOWN = "MOVE_DOWN";
        static final String HELP = "HELP";
        static final String SOURCE = "SOURCE";
        static final String DEFAULT = "DEFAULT";
        private FunctionNode node;
        private Point p;

        FunctionActions() {
            this.put(NEW_FUNCTION, new NewFunction());
            this.put(NEW_FOLDER, new NewFolder());
            this.put(REMOVE, new Remove());
            this.put(EDIT, new Edit());
            this.put(MOVE_UP, new MoveUp());
            this.put(MOVE_DOWN, new MoveDown());
            this.put(HELP, new Help());
            this.put(SOURCE, new DisplaySource());
            this.put(DEFAULT, new RestoreDefault());
        }

        public void show(Component component, FunctionNode functionNode, int n, int n2) {
            this.node = functionNode;
            this.p = new Point(n, n2);
            boolean bl = !Rflow.getInstance().isBusy();
            this.get(EDIT).setEnabled(bl);
            this.get(NEW_FUNCTION).setEnabled(bl);
            this.get(HELP).setEnabled(bl);
            this.get(SOURCE).setEnabled(bl);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.get(EDIT));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(NEW_FUNCTION));
            jPopupMenu.add(this.get(NEW_FOLDER));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(REMOVE));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(MOVE_UP));
            jPopupMenu.add(this.get(MOVE_DOWN));
            if (functionNode.hasFunction()) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(this.get(HELP));
                jPopupMenu.add(this.get(SOURCE));
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(DEFAULT));
            jPopupMenu.show(component, n, n2);
        }

        private class NewFunction
        extends LoggableAction {
            public NewFunction() {
                super(Messages.getString("Action.new_function"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FunctionExplorer.this.newNode(FunctionActions.this.node, true, FunctionActions.this.p);
            }
        }

        private class NewFolder
        extends LoggableAction {
            public NewFolder() {
                super(Messages.getString("Action.new_folder"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FunctionExplorer.this.newNode(FunctionActions.this.node, false, FunctionActions.this.p);
            }
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                super(Messages.getString("Action.remove"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Message.confirm_delete"), Messages.getString("Message.confirm"), 0, 1);
                if (n == 0) {
                    FunctionExplorer.this.removeNode(FunctionActions.this.node);
                }
            }
        }

        private class Edit
        extends LoggableAction {
            public Edit() {
                super(Messages.getString("Action.edit"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FunctionExplorer.this.editNode(FunctionActions.this.node, FunctionActions.this.p);
            }
        }

        private class MoveUp
        extends LoggableAction {
            public MoveUp() {
                super(Messages.getString("Action.move_up"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FunctionExplorer.this.moveNode(FunctionActions.this.node, true);
            }
        }

        private class MoveDown
        extends LoggableAction {
            public MoveDown() {
                super(Messages.getString("Action.move_down"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FunctionExplorer.this.moveNode(FunctionActions.this.node, false);
            }
        }

        private class Help
        extends LoggableAction {
            public Help() {
                super(Messages.getString("Action.help"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                R.receiver().passCommand("help(" + FunctionActions.this.node.getFunction() + ")");
            }
        }

        private class DisplaySource
        extends LoggableAction {
            public DisplaySource() {
                super(Messages.getString("FunctionExplorer.show_source"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                R.receiver().passCommand(FunctionActions.this.node.getFunction() + "\n");
            }
        }

        private class RestoreDefault
        extends LoggableAction {
            public RestoreDefault() {
                super(Messages.getString("Action.restore_default_function_tree"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                try {
                    int n = JOptionPane.showConfirmDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Message.confirm_lost_setting"), Messages.getString("Message.confirm"), 0, 1);
                    if (n == 0) {
                        AppearanceGroupManager.getInstance().clear();
                        FunctionExplorer.this.importFunctionTree(FileResource.getFunctionFile());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Error.read"), Messages.getString("Error.title.error"), 0);
                }
            }
        }
    }
}

