/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.FileNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupFileNode
extends DefaultMutableTreeNode
implements FileNode {
    public GroupFileNode(String string) {
        this.setUserObject(string);
    }

    private GroupFileNode() {
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isFileValid() {
        return true;
    }

    @Override
    public boolean isLinkEntry() {
        return false;
    }

    @Override
    public boolean isFixedNode() {
        return false;
    }

    @Override
    public String getName() {
        return (String)this.getUserObject();
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            string = "";
        }
        this.setUserObject(string);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public List<FileNode> retrieveChildren() {
        return null;
    }

    @Override
    public void setChildren(List<FileNode> list) {
    }

    @Override
    public boolean areChildrenReady() {
        return false;
    }

    @Override
    public void refreshState() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            FileNode fileNode = (FileNode)enumeration.nextElement();
            fileNode.refreshState();
        }
    }

    @Override
    public String getTypeKey() {
        return "group";
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        element.setAttribute("name", this.getUserObject().toString());
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            FileNode fileNode = (FileNode)enumeration.nextElement();
            Element element2 = null;
            element2 = document.createElement(fileNode.getTypeKey());
            element.appendChild(element2);
            fileNode.storeToElement(xmlContext, document, element2);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        String string = element.getAttribute("name");
        if (string != null) {
            this.setUserObject(string);
        }
        List<Element> list = XmlUtility.elements(element);
        Boolean bl = Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
        for (Element element2 : list) {
            FileNode fileNode = null;
            if ("work".equals(element2.getTagName())) {
                File file = WorkingDirectory.getWorkingDirectory();
                if (file == null) {
                    file = Rflow.project().getWorkspaceDir();
                }
                if (!file.equals(Rflow.project().getLocation())) {
                    fileNode = new BasicFileNode(file, bl);
                }
            } else if ("entry".equals(element2.getTagName())) {
                fileNode = new BasicFileNode(bl);
                fileNode.loadElement(element2, xmlContext);
            } else if ("group".equals(element2.getTagName())) {
                fileNode = new GroupFileNode();
                fileNode.loadElement(element2, xmlContext);
            } else if ("output".equals(element2.getTagName())) {
                fileNode = new BasicFileNode(Rflow.project().getOutputDir(), bl);
            } else if ("project_home".equals(element2.getTagName())) {
                // empty if block
            }
            if (fileNode == null || fileNode == null) continue;
            this.add(fileNode);
        }
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("name", this.getUserObject().toString());
        if (this.getChildCount() > 0) {
            ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                FileNode fileNode = (FileNode)enumeration.nextElement();
                arrayList.add(fileNode);
            }
            linkedHashMap.put("node", arrayList);
        }
        return linkedHashMap;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        String string = (String)YamlEx.typeCheck(String.class, map.get("name"));
        this.setUserObject(string);
        if (map.containsKey("node")) {
            List list = (List)YamlEx.typeCheck(List.class, map.get("node"));
            Boolean bl = Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
            for (Object e : list) {
                Map map2 = (Map)YamlEx.typeCheck(Map.class, e);
                String string2 = (String)YamlEx.typeCheck(String.class, map2.get("type"));
                FileNode fileNode = null;
                if ("work".equals(string2)) {
                    File file = WorkingDirectory.getWorkingDirectory();
                    if (file == null) {
                        file = Rflow.project().getWorkspaceDir();
                    }
                    if (!file.equals(Rflow.project().getLocation())) {
                        fileNode = new BasicFileNode(file, bl);
                    }
                } else if ("entry".equals(string2)) {
                    fileNode = new BasicFileNode(bl);
                    fileNode.loadYamlValue(yamlEx, e);
                } else if ("group".equals(string2)) {
                    fileNode = new GroupFileNode();
                    fileNode.loadYamlValue(yamlEx, e);
                } else if ("output".equals(string2)) {
                    fileNode = new BasicFileNode(Rflow.project().getOutputDir(), bl);
                } else if (!"project_home".equals(string2)) continue;
                if (fileNode == null) continue;
                this.add(fileNode);
            }
        }
    }
}

