/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HierarchyNode
implements TreeNode {
    private FlowNode flowNode;
    private FlowNode[] children;
    private HierarchyNode parent;

    public HierarchyNode(ViewLayout viewLayout) {
        this(null, null, viewLayout);
    }

    public HierarchyNode(FlowNode flowNode, HierarchyNode hierarchyNode) {
        this(flowNode, hierarchyNode, null);
    }

    private HierarchyNode(FlowNode flowNode, HierarchyNode hierarchyNode, ViewLayout viewLayout) {
        Object object;
        ViewLayout[] viewLayoutArray;
        this.flowNode = flowNode;
        this.parent = hierarchyNode;
        if (viewLayout != null) {
            viewLayoutArray = new ViewLayout[]{viewLayout};
        } else {
            object = (SubflowNodeModel)flowNode.getModel();
            viewLayoutArray = ((SubflowNodeModel)object).getLayouts();
        }
        object = new ArrayList();
        for (ViewLayout viewLayout2 : viewLayoutArray) {
            for (Object e : viewLayout2.getGraph().getVertices()) {
                FlowNode flowNode2 = (FlowNode)e;
                if (!flowNode2.getModel().isSubflow()) continue;
                object.add(flowNode2);
            }
        }
        this.children = object.toArray(new FlowNode[0]);
        Arrays.sort(this.children, new TitleCompartor());
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TreePath getPath() {
        ArrayDeque<HierarchyNode> arrayDeque = new ArrayDeque<HierarchyNode>();
        for (HierarchyNode hierarchyNode = this; hierarchyNode != null; hierarchyNode = (HierarchyNode)hierarchyNode.getParent()) {
            arrayDeque.addFirst(hierarchyNode);
        }
        return new TreePath(arrayDeque.toArray(new HierarchyNode[0]));
    }

    @Override
    public Enumeration<? extends TreeNode> children() {
        Vector<HierarchyNode> vector = new Vector<HierarchyNode>();
        for (FlowNode flowNode : this.children) {
            vector.add(new HierarchyNode(flowNode, this));
        }
        return vector.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return new HierarchyNode(this.children[n], this);
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        HierarchyNode hierarchyNode = (HierarchyNode)treeNode;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != hierarchyNode.getFlowNode()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int hashCode() {
        return this.flowNode == null ? -1 : this.flowNode.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HierarchyNode)) {
            return false;
        }
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        return Objects.equals(this.flowNode, hierarchyNode.flowNode);
    }

    private static final class TitleCompartor
    implements Comparator<FlowNode> {
        private TitleCompartor() {
        }

        @Override
        public int compare(FlowNode flowNode, FlowNode flowNode2) {
            String string = flowNode.getTitle().toLowerCase();
            String string2 = flowNode2.getTitle().toLowerCase();
            return string.compareTo(string2);
        }
    }
}

