/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowScrollPane;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.HierarchyNode;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.function.Supplier;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;

public class HierarchyView
extends View
implements GraphEventListener,
FlowNodeSelectionEventHandler {
    private RflowTree tree;
    private HierarchyActions hierarchyActions = new HierarchyActions();
    private FlowModel model;
    private Supplier<FlowNode> nodeSupplier;

    public HierarchyView(FlowModel flowModel, Supplier<FlowNode> supplier) {
        this.nodeSupplier = supplier;
        this.setTitle(Messages.getString("Explorer.hierarchy"));
        this.model = flowModel;
        this.tree = new RflowTree(new HierarchyNode(new ViewLayout()));
        this.tree.setEditable(false);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new TreeRenderer()));
        MouseHandler mouseHandler = new MouseHandler();
        this.tree.addMouseListener(mouseHandler);
        this.tree.addMouseMotionListener(mouseHandler);
        this.tree.setExpandsSelectedPaths(true);
        this.hierarchyActions.installActions(this.tree, false, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)new RflowScrollPane(this.tree), "Center");
        this.update();
        this.tree.expandAll();
    }

    public void select(FlowNode flowNode) {
        ArrayDeque<HierarchyNode> arrayDeque = new ArrayDeque<HierarchyNode>();
        while (flowNode != null) {
            if (!flowNode.isRootNode()) {
                arrayDeque.addFirst(new HierarchyNode(flowNode, null));
            }
            flowNode = flowNode.getParentNode();
        }
        arrayDeque.addFirst((HierarchyNode)this.tree.getModel().getRoot());
        TreePath treePath = new TreePath(arrayDeque.toArray(new HierarchyNode[arrayDeque.size()]));
        this.tree.setSelectionPath(treePath);
    }

    public void update() {
        if (this.model == null) {
            return;
        }
        HierarchyNode hierarchyNode = new HierarchyNode(this.model.getRootNode(), null);
        this.tree.setModel(new DefaultTreeModel(hierarchyNode));
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        FlowViewer.addGraphEventListener(this);
        EventManager.getInstance().registerEventHandler(FlowNodeSelectionEvent.class, this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        FlowViewer.removeGraphEventListener(this);
        EventManager.getInstance().removeEventHandler(FlowNodeSelectionEvent.class, this);
    }

    @Override
    public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
        this.tree.repaint();
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        if (flowNode.getModel().isSubflow()) {
            this.update();
        }
    }

    public void vertexAdded(GraphEvent graphEvent) {
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        if (flowNode.getModel().isSubflow()) {
            this.update();
        }
    }

    public void edgeAdded(GraphEvent graphEvent) {
    }

    public void edgeRemoved(GraphEvent graphEvent) {
    }

    private class HierarchyActions
    extends Actions {
        public HierarchyActions() {
            this.put(new RefreshAction());
        }

        public void showPopup(Component component, int n, int n2) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(HierarchyView.this.tree.getActionMap().get("ACTION_COLLAPSE_ALL"));
            jPopupMenu.add(HierarchyView.this.tree.getActionMap().get("ACTION_EXPAND_ALL"));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.get(RefreshAction.class));
            jPopupMenu.show(component, n, n2);
        }

        private class RefreshAction
        extends LoggableAction {
            public RefreshAction() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                HierarchyView.this.update();
            }
        }
    }

    private class TreeRenderer
    extends SubstanceDefaultTreeCellRenderer {
        private TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            HierarchyNode hierarchyNode = (HierarchyNode)object;
            if (hierarchyNode.isRoot()) {
                this.setText(HierarchyView.this.model.getTitle());
                this.setIcon(HierarchyView.this.model.getRootNode().getSmallIcon());
            } else {
                this.setText(hierarchyNode.getFlowNode().getTitle());
                this.setIcon(hierarchyNode.getFlowNode().getSmallIcon());
            }
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        private TreePath getPath(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = jTree.getRowBounds(jTree.getRowCount() - 1);
            if (rectangle.getY() + rectangle.getHeight() < (double)mouseEvent.getY()) {
                return null;
            }
            TreePath treePath = jTree.getClosestPathForLocation((int)point.getX(), (int)point.getY());
            return treePath;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            TreePath treePath = this.getPath(mouseEvent);
            if (treePath == null) {
                jTree.setCursor(Cursor.getDefaultCursor());
            } else {
                jTree.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        private boolean isLocationExpandControl(JTree jTree, TreePath treePath, int n) {
            HierarchyNode hierarchyNode = (HierarchyNode)treePath.getLastPathComponent();
            if (hierarchyNode.isLeaf()) {
                return false;
            }
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 == null) {
                return false;
            }
            int n2 = jTree.getPathBounds((TreePath)treePath2).x;
            int n3 = jTree.getPathBounds((TreePath)treePath).x;
            return n2 <= n && n <= n3;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            TreePath treePath = this.getPath(mouseEvent);
            if (treePath == null) {
                if (UIUtility.isRightMouseButton(mouseEvent)) {
                    HierarchyView.this.hierarchyActions.showPopup(jTree, point.x, point.y);
                }
                return;
            }
            HierarchyNode hierarchyNode = (HierarchyNode)treePath.getLastPathComponent();
            if (mouseEvent.getClickCount() == 1 && UIUtility.isLeftMouseButton(mouseEvent) && !this.isLocationExpandControl(jTree, treePath, point.x)) {
                boolean bl = (mouseEvent.getModifiers() & UIUtility.MENU_KEY_MASK) == UIUtility.MENU_KEY_MASK;
                ViewOpenType viewOpenType = Rflow.mainView().getViewOpenType(hierarchyNode.getFlowNode(), HierarchyView.this.nodeSupplier.get(), bl);
                Rflow.mainView().openViewer(hierarchyNode.getFlowNode(), viewOpenType);
            } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                HierarchyView.this.hierarchyActions.showPopup(jTree, point.x, point.y);
            }
        }
    }
}

