/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemSelectable;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEvent;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.SwingXUtility;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiSplitPane;

public class ItemPreviewView
extends View
implements ItemSelectionEventHandler {
    private SwitchPanel switchPanel;
    private Item item;

    public ItemPreviewView(ItemSelectable itemSelectable) {
        this.setTitle(Messages.getString("View.Preview.title"));
        this.setIcon(Icons.getIcon("16/page_white_magnify.png"));
        this.switchPanel = new SwitchPanel();
        this.add((Component)this.switchPanel, "Center");
        itemSelectable.addItemEventHandler(this);
    }

    public static JXMultiSplitPane createHorizontalSplitPane(JComponent jComponent, ItemSelectable itemSelectable) {
        ItemPreviewView itemPreviewView = new ItemPreviewView(itemSelectable);
        return SwingXUtility.createHorizontalSplitPane(jComponent, itemPreviewView, 0.35);
    }

    public static JXMultiSplitPane createHorizontalSplitPane(JComponent jComponent, ItemSelectable itemSelectable, double d) {
        ItemPreviewView itemPreviewView = new ItemPreviewView(itemSelectable);
        return SwingXUtility.createHorizontalSplitPane(jComponent, itemPreviewView, d);
    }

    public void clearView() {
        this.setView(null);
    }

    private void setView(View view2) {
        Component component = this.switchPanel.get();
        if (component instanceof View) {
            View view3 = (View)component;
            view3.unloadView();
        }
        this.updateTabBusy(false);
        this.switchPanel.set(view2);
    }

    private View createView(Item item) {
        if (item == null) {
            return null;
        }
        return item.createPreviewView();
    }

    private void setItem(Item item) {
        if (Objects.equals(this.item, item)) {
            return;
        }
        this.item = item;
        this.setView(this.createView(item));
    }

    @Override
    public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
        if (!itemSelectionEvent.isAdjusting() && !itemSelectionEvent.isWeakSelection()) {
            this.setItem(itemSelectionEvent.getItem());
        }
    }
}

