/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.file.FileSessionEntry;
import com.ef_prime.rflow.core.app.file.FileViewerSessionEntry;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectViewerSessionEntry;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.ProjectSession;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.SessionEntrySupplier;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.history.HistoryManager;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowGraphEvent;
import com.ef_prime.rflow.core.flow.FlowGraphEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowSessionEntry;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.util.CancelledSaxException;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.node.ui.NewNodeSessionEntry;
import com.ef_prime.rflow.node.ui.OpTabPagesView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.HasApp;
import com.ef_prime.rflow.ui.app.file.FileViewer;
import com.ef_prime.rflow.ui.app.r.RHelpView;
import com.ef_prime.rflow.ui.app.r.object.RObjectExplorer;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.app.r.packages.RPackagesView;
import com.ef_prime.rflow.ui.base.ActiveViewerListener;
import com.ef_prime.rflow.ui.base.LogView;
import com.ef_prime.rflow.ui.base.ProjectView;
import com.ef_prime.rflow.ui.base.WindowSizeSetEvent;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemSelectable;
import com.ef_prime.rflow.ui.common.view.RflowViewTabbedPane;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.feature.backup.BackupView;
import com.ef_prime.rflow.ui.feature.history.HistoryTableView;
import com.ef_prime.rflow.ui.feature.history.HistoryView;
import com.ef_prime.rflow.ui.feature.search.SearchExplorer;
import com.ef_prime.rflow.ui.flow.FlowBrowseView;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.NodeTaskExplorer;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.SwingXUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.BreakpointExplorer;
import com.ef_prime.rflow.ui.view.FXBrowserView;
import com.ef_prime.rflow.ui.view.FileEditView;
import com.ef_prime.rflow.ui.view.FileExplorer;
import com.ef_prime.rflow.ui.view.PreviewRunView;
import com.ef_prime.rflow.ui.view.PreviewView;
import com.ef_prime.rflow.ui.view.ViewPosition;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class MainView
extends JXMultiSplitPane
implements ChangeListener,
PropertyChangeListener,
RflowEventHandler,
FileEditEventHandler,
ChangeEventHandler,
RSessionManager.RSessionEventHandler,
FlowGraphEventHandler,
SimpleEventHandler {
    private static final Logger LOGGER = Logger.getLogger(MainView.class.getName());
    public static final String POS_MAIN = ViewPosition.MAIN.getId();
    public static final String POS_CONTROL_UPPER = ViewPosition.UPPER_LEFT.getId();
    public static final String POS_CONTROL_LOWER = ViewPosition.LOWER_LEFT.getId();
    private FileExplorer fileExplorer;
    private RObjectExplorer objectExplorer;
    private NodeTaskExplorer taskExplorer;
    private BreakpointExplorer breakpointExplorer;
    private SearchExplorer searchExplorer;
    private BackupView backupView;
    private RPackagesView rPackagesView;
    private View activeView;
    private View lastActiveView;
    private ViewTabbedPane activeViewTabbedPane;
    private FileEdit activeFileEdit;
    private FileEditView activeFileEditView;
    private Deque<SubflowNodeView> flowHistory = new ArrayDeque<SubflowNodeView>();
    private List<ActiveViewerListener> activeViewerListenerList = new ArrayList<ActiveViewerListener>();
    private MainViewTabActions actions = new MainViewTabActions();
    private Map<String, View> keyToViewClassMap;
    private List<DevelEntry> develEntries;
    private RHelpView rHelpView;

    public MainView() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        Rflow.getInstance().addRflowEventHandler(this);
        FileEditManager.getInstance().addEventHandler(this);
        FlowViewer.addFlowGraphEventHandler(this);
        R.sessionManager().addEventHandler(this);
        EventManager.getInstance().registerEventHandler(WindowSizeSetEvent.class, this);
        MultiSplitLayout multiSplitLayout = new MultiSplitLayout(true);
        MultiSplitLayout.RowSplit rowSplit = null;
        double d = Rflow.settings().getRatio(Settings.SPLIT_MAIN);
        double d2 = Rflow.settings().getRatio(Settings.SPLIT_CONTROL);
        MultiSplitLayout.Leaf leaf = new MultiSplitLayout.Leaf(POS_CONTROL_UPPER);
        leaf.setWeight(d2);
        MultiSplitLayout.Leaf leaf2 = new MultiSplitLayout.Leaf(POS_CONTROL_LOWER);
        leaf2.setWeight(1.0 - d2);
        MultiSplitLayout.ColSplit colSplit = new MultiSplitLayout.ColSplit(new MultiSplitLayout.Node[]{leaf, new MultiSplitLayout.Divider(), leaf2});
        colSplit.setWeight(d);
        MultiSplitLayout.Leaf leaf3 = new MultiSplitLayout.Leaf(POS_MAIN);
        leaf3.setWeight(1.0 - d);
        rowSplit = new MultiSplitLayout.RowSplit(new MultiSplitLayout.Node[]{colSplit, new MultiSplitLayout.Divider(), leaf3});
        multiSplitLayout.setFloatingDividers(false);
        multiSplitLayout.setLayoutMode(2);
        multiSplitLayout.setModel((MultiSplitLayout.Node)rowSplit);
        this.setLayout((LayoutManager)multiSplitLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setDividerSize(6);
        this.setViewTabbedPane(new RflowViewTabbedPane(), POS_MAIN);
        this.setViewTabbedPane(new RflowViewTabbedPane(), POS_CONTROL_UPPER);
        this.setViewTabbedPane(new RflowViewTabbedPane(), POS_CONTROL_LOWER);
        this.fileExplorer = new FileExplorer(FileManager.getInstance());
        this.objectExplorer = new RObjectExplorer();
        this.taskExplorer = new NodeTaskExplorer();
        this.breakpointExplorer = new BreakpointExplorer();
        this.searchExplorer = new SearchExplorer();
        this.backupView = new BackupView();
        this.rPackagesView = new RPackagesView();
        PreviewRunView previewRunView = new PreviewRunView();
        ViewTabbedPane viewTabbedPane = this.getTabbedPane(POS_CONTROL_UPPER);
        viewTabbedPane.openView(this.fileExplorer);
        viewTabbedPane.openView(this.objectExplorer);
        viewTabbedPane.openView(this.searchExplorer);
        viewTabbedPane.openView(this.backupView);
        viewTabbedPane.openView(previewRunView);
        viewTabbedPane.openView(this.rPackagesView);
        this.keyToViewClassMap = new LinkedHashMap<String, View>();
        this.keyToViewClassMap.put("TAB_TASK", this.taskExplorer);
        this.keyToViewClassMap.put("TAB_BREAKPOINT", this.breakpointExplorer);
        this.refreshViewShowing();
        if (Rflow.isDevel()) {
            ProjectView projectView = new ProjectView(ProjectsManager.getInstance());
            View view2 = (View)Utility.createInstance("com.ef_prime.rflow.ui.object.ObjectTreeView");
            HistoryView historyView = new HistoryView(HistoryManager.getInstance().getTreeModel());
            HistoryView historyView2 = new HistoryView(HistoryManager.getInstance().getOldTreeModel());
            PreviewView previewView = new PreviewView();
            HistoryTableView historyTableView = new HistoryTableView((TreeTableModel)HistoryManager.getInstance().getTreeTableModel());
            LogView logView = new LogView();
            Rflow.develSettings().addChangeEventHandler(this);
            this.develEntries = new ArrayList<DevelEntry>();
            this.develEntries.add(new DevelEntry(projectView, DevelSettings.KEY_PROJECT_VIEW, POS_CONTROL_UPPER));
            if (view2 != null) {
                this.develEntries.add(new DevelEntry(view2, DevelSettings.KEY_VIEW_OBJECT, POS_CONTROL_UPPER));
            }
            this.develEntries.add(new DevelEntry(historyView, DevelSettings.KEY_VIEW_RUN_LOG_CLASSIC, POS_CONTROL_LOWER));
            this.develEntries.add(new DevelEntry(historyView2, DevelSettings.KEY_VIEW_SESSION_LOG, POS_CONTROL_LOWER));
            this.develEntries.add(new DevelEntry(previewView, DevelSettings.KEY_VIEW_PREVIEW, POS_MAIN));
            this.develEntries.add(new DevelEntry(historyTableView, DevelSettings.KEY_VIEW_RUN_LOG, POS_CONTROL_LOWER));
            this.develEntries.add(new DevelEntry(logView, DevelSettings.KEY_VIEW_APP_LOG, POS_CONTROL_LOWER));
            this.refreshDevelViewShowing();
        }
        this.addActiveViewerListener(this.searchExplorer);
        Rflow.settings().addEventHandler(new SettingPropertyChangeListener());
    }

    public FileExplorer getFileExplorer() {
        return this.fileExplorer;
    }

    public NodeTaskExplorer getTaskExplorer() {
        return this.taskExplorer;
    }

    public RObjectExplorer getObjectExplorer() {
        return this.objectExplorer;
    }

    public BreakpointExplorer getBreakpointExplorer() {
        return this.breakpointExplorer;
    }

    public SearchExplorer getSearchExplorer() {
        return this.searchExplorer;
    }

    public RPackagesView getRPackagesView() {
        return this.rPackagesView;
    }

    private void setViewTabbedPane(ViewTabbedPane viewTabbedPane, String string) {
        viewTabbedPane.setFocusable(false);
        viewTabbedPane.setTabLayoutPolicy(0);
        viewTabbedPane.addChangeListener(this);
        this.add(viewTabbedPane, string);
    }

    public ViewTabbedPane getDefaultExplorerPane() {
        return this.getTabbedPane(POS_CONTROL_UPPER);
    }

    public ViewTabbedPane getDefaultObjectPane() {
        return this.getTabbedPane(POS_MAIN);
    }

    public ViewTabbedPane getDefaultFlowPane() {
        return this.getTabbedPane(POS_MAIN);
    }

    public ViewTabbedPane getDefaultConsolePane() {
        return this.getTabbedPane(POS_CONTROL_LOWER);
    }

    public void openViewAtDefaultObjectPane(View view2, ViewOpenType viewOpenType, boolean bl) {
        this.openViewAt(view2, viewOpenType, bl, ViewPosition.MAIN);
    }

    public void openViewAt(View view2, ViewOpenType viewOpenType, boolean bl, ViewPosition viewPosition) {
        View view3 = this.getView(view2.getKey());
        if (view3 != null) {
            view3.toFront();
        } else {
            this.getTabbedPane(viewPosition).openView(view2, viewOpenType, bl);
        }
    }

    public ViewTabbedPane getTabbedPane(ViewPosition viewPosition) {
        return this.getTabbedPane(viewPosition.getId());
    }

    private ViewTabbedPane getTabbedPane(String string) {
        MultiSplitLayout.Node node = this.getMultiSplitLayout().getNodeForName(string);
        if (node == null && (node = this.getMultiSplitLayout().getNodeForName(POS_MAIN)) == null) {
            return null;
        }
        return (ViewTabbedPane)this.getMultiSplitLayout().getComponentForNode(node);
    }

    public ViewPosition getPosition(ViewTabbedPane viewTabbedPane, ViewPosition viewPosition) {
        for (ViewPosition viewPosition2 : ViewPosition.values()) {
            if (this.getTabbedPane(viewPosition2.getId()) != viewTabbedPane) continue;
            return viewPosition2;
        }
        return viewPosition;
    }

    public List<View> getAllViews() {
        ArrayList<View> arrayList = new ArrayList<View>();
        for (Component component : this.getComponents()) {
            if (!(component instanceof ViewTabbedPane)) continue;
            ViewTabbedPane viewTabbedPane = (ViewTabbedPane)component;
            for (int i = 0; i < viewTabbedPane.getTabCount(); ++i) {
                Component component2 = viewTabbedPane.getComponentAt(i);
                if (!(component2 instanceof View)) continue;
                arrayList.add((View)component2);
            }
        }
        return arrayList;
    }

    public List<View> getAllSelectedViews() {
        ArrayList<View> arrayList = new ArrayList<View>();
        for (Component component : this.getComponents()) {
            ViewTabbedPane viewTabbedPane;
            View view2;
            if (!(component instanceof ViewTabbedPane) || (view2 = (viewTabbedPane = (ViewTabbedPane)component).getSelectedView()) == null) continue;
            arrayList.add(view2);
        }
        return arrayList;
    }

    public List<ViewTabbedPane> getAllViewTabbedPanes() {
        ArrayList<ViewTabbedPane> arrayList = new ArrayList<ViewTabbedPane>();
        for (Component component : this.getComponents()) {
            if (!(component instanceof ViewTabbedPane)) continue;
            ViewTabbedPane viewTabbedPane = (ViewTabbedPane)component;
            arrayList.add(viewTabbedPane);
        }
        return arrayList;
    }

    public View getView(Object object) {
        for (ViewTabbedPane viewTabbedPane : this.getAllViewTabbedPanes()) {
            int n = viewTabbedPane.getIndexOfKey(object);
            if (n < 0) continue;
            return viewTabbedPane.getViewAt(n);
        }
        return null;
    }

    public View getActiveView() {
        return this.activeView;
    }

    public View getLastActiveView() {
        return this.lastActiveView;
    }

    public ViewTabbedPane getActiveViewTabbedPane() {
        View view2 = this.getActiveView();
        if (view2 == null) {
            return null;
        }
        return view2.getParentTabbedPane();
    }

    public Item getSelectedItem() {
        Item item = this.getItem(this.getActiveView());
        if (item != null) {
            return item;
        }
        List<View> list = this.getAllSelectedViews();
        for (View view2 : list) {
            item = this.getItem(view2);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private Item getItem(View view2) {
        if (view2 == null || !(view2 instanceof ItemSelectable)) {
            return null;
        }
        return ((ItemSelectable)((Object)view2)).getSelectedItem();
    }

    public App getSelectedApp() {
        App app = this.getApp(this.getActiveView());
        if (app != null) {
            return app;
        }
        List<View> list = this.getAllSelectedViews();
        for (View view2 : list) {
            app = this.getApp(view2);
            if (app == null) continue;
            return app;
        }
        return null;
    }

    private App getApp(View view2) {
        if (view2 == null || !(view2 instanceof HasApp)) {
            return null;
        }
        return ((HasApp)((Object)view2)).getApp();
    }

    public FileEdit getActiveFileEdit() {
        return this.activeFileEdit;
    }

    public FileEditView getActiveFileEditView() {
        return this.activeFileEditView;
    }

    public FlowModel getActiveFlowModel() {
        if (this.getActiveFileEdit() instanceof FlowModel) {
            return (FlowModel)this.getActiveFileEdit();
        }
        return null;
    }

    public MainViewTabActions getActions() {
        return this.actions;
    }

    public void repaintFlow() {
        for (ViewTabbedPane viewTabbedPane : this.getAllViewTabbedPanes()) {
            View view2 = viewTabbedPane.getSelectedView();
            if (!(view2 instanceof FlowBrowseView)) continue;
            view2.repaint();
        }
    }

    public FlowViewer getActiveFlowViewer() {
        if (this.activeView instanceof FlowBrowseView) {
            return ((FlowBrowseView)this.activeView).getActiveViewer();
        }
        return null;
    }

    public FlowViewer getPrimaryFlowViewer() {
        FlowViewer flowViewer = this.getActiveFlowViewer();
        if (flowViewer != null) {
            return flowViewer;
        }
        FlowBrowseView flowBrowseView = null;
        for (ViewTabbedPane viewTabbedPane : this.getAllViewTabbedPanes()) {
            View view2 = viewTabbedPane.getSelectedView();
            if (!(view2 instanceof FlowBrowseView)) continue;
            if (flowBrowseView != null) {
                return null;
            }
            flowBrowseView = (FlowBrowseView)view2;
        }
        if (flowBrowseView == null) {
            return null;
        }
        return flowBrowseView.getActiveViewer();
    }

    public SubflowNodeView getLastActiveFlowView() {
        for (SubflowNodeView subflowNodeView : this.flowHistory) {
            if (!subflowNodeView.isDisplayable()) continue;
            return subflowNodeView;
        }
        return null;
    }

    public void addActiveViewerListener(ActiveViewerListener activeViewerListener) {
        this.activeViewerListenerList.add(activeViewerListener);
    }

    public void removeActiveViewerListener(ActiveViewerListener activeViewerListener) {
        this.activeViewerListenerList.remove(activeViewerListener);
    }

    private List<FlowViewer> getAllFlowViewers() {
        ArrayList<FlowViewer> arrayList = new ArrayList<FlowViewer>();
        for (View view2 : this.getAllViews()) {
            FlowBrowseView flowBrowseView;
            if (!(view2 instanceof FlowBrowseView) || !((flowBrowseView = (FlowBrowseView)view2).getFlowNodeView() instanceof SubflowNodeView)) continue;
            CollectionUtils.addAll(arrayList, (Object[])((SubflowNodeView)flowBrowseView.getFlowNodeView()).getViewers());
        }
        return arrayList;
    }

    public boolean keepRootFlow() {
        if (Rflow.develSettings().getValue(DevelSettings.CUSTOM_OPEN_MODE).booleanValue()) {
            return Rflow.develSettings().getValue(DevelSettings.KEY_KEEP_ROOT_FLOW);
        }
        return false;
    }

    public boolean usePrimaryFlowTab() {
        if (Rflow.develSettings().getValue(DevelSettings.CUSTOM_OPEN_MODE).booleanValue()) {
            return Rflow.develSettings().getValue(DevelSettings.KEY_TAB_TITLE).equals("file");
        }
        return Rflow.settings().isOpenModeCurrentTab();
    }

    public ViewOpenType getViewOpenType(FlowNode flowNode, FlowNode flowNode2, boolean bl) {
        DevelSettings develSettings = Rflow.develSettings();
        ViewOpenType viewOpenType = ViewOpenType.OPEN_NEW;
        boolean bl2 = flowNode2 != null && flowNode2.isRootNode();
        boolean bl3 = develSettings.getValue(DevelSettings.CUSTOM_OPEN_MODE);
        boolean bl4 = Rflow.settings().isOpenModeCurrentTab();
        if (this.keepRootFlow() && (bl2 || flowNode.isRootNode())) {
            return ViewOpenType.OPEN_NEW;
        }
        if (flowNode2 != null && !flowNode2.getModel().isSubflow()) {
            viewOpenType = bl3 ? develSettings.getViewOpenType(DevelSettings.KEY_OPEN_IN_NODE) : (bl4 ? ViewOpenType.OPEN : ViewOpenType.OPEN);
        } else if (!flowNode.getModel().isSubflow()) {
            viewOpenType = bl3 ? develSettings.getViewOpenType(DevelSettings.KEY_OPEN_NODE) : (bl4 ? ViewOpenType.OPEN : ViewOpenType.OPEN_NEW);
        } else if (bl2) {
            viewOpenType = bl3 ? develSettings.getViewOpenType(DevelSettings.KEY_OPEN_BOX_IN_TOP) : (bl4 ? ViewOpenType.OPEN : ViewOpenType.OPEN_NEW);
        } else if (FlowUtil.isFamilyMember(flowNode2, flowNode)) {
            viewOpenType = bl3 ? develSettings.getViewOpenType(DevelSettings.KEY_OPEN_BOX_IN_BOX) : (bl4 ? ViewOpenType.OPEN : ViewOpenType.OPEN);
        } else {
            ViewOpenType viewOpenType2 = viewOpenType = bl4 ? ViewOpenType.OPEN : ViewOpenType.OPEN_NEW;
        }
        if (bl) {
            viewOpenType = viewOpenType == ViewOpenType.OPEN ? ViewOpenType.OPEN_NEW : ViewOpenType.OPEN;
        }
        return viewOpenType;
    }

    public View openViewer(FlowNode flowNode, ViewOpenType viewOpenType) {
        return this.openViewer(flowNode, viewOpenType, null);
    }

    public View openViewer(FlowNode flowNode, ViewOpenType viewOpenType, FlowNodeView flowNodeView) {
        Object object;
        Object object2;
        Object object3;
        if (viewOpenType == ViewOpenType.OPEN && this.activeView != null && this.activeView.getKey() == flowNode) {
            return this.activeView;
        }
        ViewTabbedPane viewTabbedPane = this.getDefaultFlowPane();
        View view2 = viewTabbedPane.getSelectedView();
        if (this.usePrimaryFlowTab() && flowNode.isRootNode() && ((Optional)(object3 = flowNode.getFlowModel())).isPresent()) {
            object2 = (FlowModel)((Optional)object3).get();
            if (view2 instanceof FlowBrowseView && ((FlowModel)object2).getPrimaryView() == view2) {
                ((FlowBrowseView)view2).load(flowNode);
                return view2;
            }
            object = this.getViews((FileEdit)object2).iterator();
            while (object.hasNext()) {
                FileEditView fileEditView = object.next();
                if (!(fileEditView instanceof FlowBrowseView) || ((FlowModel)object2).getPrimaryView() != fileEditView) continue;
                ((FlowBrowseView)fileEditView).load(flowNode);
                viewTabbedPane.setSelectedComponent(fileEditView);
                return fileEditView;
            }
        }
        if (view2 != null && viewOpenType == ViewOpenType.OPEN) {
            if (view2.getKey() == flowNode) {
                return view2;
            }
            if (view2 instanceof FlowBrowseView) {
                ((FlowBrowseView)view2).load(flowNode);
                return view2;
            }
        }
        if (!((View)(object3 = new FlowBrowseView(flowNode))).allowDuplicate()) {
            viewOpenType = ViewOpenType.OPEN_NEW;
        }
        if (viewOpenType == ViewOpenType.OPEN_OR_MOVE && (object2 = this.getView(flowNode)) != null) {
            ((View)object2).toFront();
            if (flowNodeView != null) {
                flowNodeView.closeTab();
            }
            return object2;
        }
        if (viewOpenType == ViewOpenType.OPEN_NEW && (object2 = this.getView(flowNode)) != null) {
            ((View)object2).toFront();
            return object2;
        }
        viewTabbedPane.openView((View)object3, viewOpenType, true);
        if (flowNodeView != null && this.getActiveFlowViewer() != null) {
            object2 = this.getActiveFlowViewer();
            for (object = flowNodeView.getNode(); object != null; object = ((FlowNode)object).getParentNode()) {
                if (!((FlowViewer)object2).getGraph().contains((Vertex)object)) continue;
                ((FlowViewer)object2).getPickedState().setPicked((ArchetypeVertex)object);
                break;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ FlowBrowseView val$nodeView;
            {
                this.val$nodeView = flowBrowseView;
            }

            @Override
            public void run() {
                this.val$nodeView.focus();
            }
        });
        return object3;
    }

    public FlowViewer getViewer(FlowGraph flowGraph) {
        if (flowGraph == null) {
            return null;
        }
        for (FlowViewer flowViewer : this.getAllFlowViewers()) {
            if (flowViewer.getGraph() != flowGraph) continue;
            return flowViewer;
        }
        return null;
    }

    public void openBrowser(String string, boolean bl, boolean bl2) {
        FXBrowserView fXBrowserView;
        if (bl) {
            if (this.rHelpView == null) {
                this.rHelpView = new RHelpView();
                this.rHelpView.setSavePosition(true);
                this.rHelpView.setRBrowser(null);
            }
            fXBrowserView = this.rHelpView;
        } else {
            fXBrowserView = new FXBrowserView();
        }
        fXBrowserView.load(string);
        ViewTabbedPane viewTabbedPane = this.getTabPane(Rflow.settings().getValue(Settings.POSITION_HELP));
        viewTabbedPane.openView(fXBrowserView, ViewOpenType.OPEN_NEW, bl2);
    }

    public void openGraphicDevice(View view2) {
        ViewTabbedPane viewTabbedPane = this.getTabPane(Rflow.settings().getValue(Settings.POSITION_GD));
        viewTabbedPane.openView(view2, ViewOpenType.OPEN_NEW, true);
    }

    private ViewTabbedPane getTabPane(int n) {
        switch (n) {
            case 1: {
                return this.getDefaultExplorerPane();
            }
            case 2: {
                return this.getDefaultConsolePane();
            }
        }
        return this.getDefaultFlowPane();
    }

    public int getSettingsTabPanePosition(ViewTabbedPane viewTabbedPane) {
        if (viewTabbedPane == this.getDefaultExplorerPane()) {
            return 1;
        }
        if (viewTabbedPane == this.getDefaultConsolePane()) {
            return 2;
        }
        return 0;
    }

    public void fireActiveViewerChanged() {
        FlowViewer flowViewer = this.getActiveFlowViewer();
        for (ActiveViewerListener activeViewerListener : this.activeViewerListenerList) {
            activeViewerListener.activeViewerChanged(flowViewer);
        }
    }

    private void setActiveView(ViewTabbedPane viewTabbedPane, View view2) {
        JComponent jComponent;
        this.lastActiveView = this.activeView;
        this.activeView = view2;
        if (this.activeViewTabbedPane != viewTabbedPane) {
            this.activeViewTabbedPane = viewTabbedPane;
            for (JComponent jComponent2 : this.getAllViewTabbedPanes()) {
                if (!(jComponent2 instanceof RflowViewTabbedPane)) continue;
                jComponent.setActive((jComponent = (RflowViewTabbedPane)jComponent2) == this.activeViewTabbedPane);
            }
        }
        Object object = null;
        if (this.activeView instanceof FlowBrowseView) {
            JComponent jComponent2;
            object = ((FlowBrowseView)this.activeView).getNode();
            jComponent2 = ((FlowBrowseView)this.activeView).getFlowNodeView();
            if (jComponent2 instanceof SubflowNodeView) {
                jComponent = (SubflowNodeView)jComponent2;
                this.flowHistory.remove(jComponent);
                this.flowHistory.addFirst((SubflowNodeView)jComponent);
                Iterator<SubflowNodeView> iterator = this.flowHistory.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().isDisplayable()) continue;
                    iterator.remove();
                }
                while (this.flowHistory.size() > 10) {
                    this.flowHistory.removeLast();
                }
            }
        }
        boolean bl = false;
        if (view2 instanceof FileEditView) {
            this.activeFileEditView = (FileEditView)view2;
            bl = this.activeFileEdit != this.activeFileEditView.getFileEdit();
            this.activeFileEdit = this.activeFileEditView.getFileEdit();
        }
        EventManager.getInstance().dispatchEvent(new ActiveViewEvent(this.activeView, this.activeFileEdit, bl, (FlowNode)object));
        this.fireActiveViewerChanged();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ViewTabbedPane viewTabbedPane = (ViewTabbedPane)changeEvent.getSource();
        View view2 = viewTabbedPane.getSelectedView();
        if (this.activeView == view2) {
            return;
        }
        this.setActiveView(viewTabbedPane, view2);
        this.projectSessionChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("focusOwner".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof Component) {
            Component component = (Component)propertyChangeEvent.getNewValue();
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof MainView) {
                    if (!(component instanceof ViewTabbedPane)) break;
                    ViewTabbedPane viewTabbedPane = (ViewTabbedPane)component;
                    View view2 = viewTabbedPane.getSelectedView();
                    if (this.activeView != view2) {
                        this.setActiveView(viewTabbedPane, view2);
                    }
                    if (view2 == null) break;
                    view2.setUnread(false);
                    break;
                }
                component = container;
            }
        }
    }

    public void activeFlowNodeChanged(FlowNode flowNode) {
        EventManager.getInstance().dispatchEvent(new ActiveViewEvent(this.activeView, this.activeFileEdit, false, flowNode));
        this.projectSessionChanged();
    }

    public boolean isTab(Collection<FlowNode> collection) {
        for (FlowNode flowNode : collection) {
            if (!this.isTab(flowNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isTab(FlowNode flowNode) {
        Set<FlowNode> set = FlowUtil.getAllDescendants(flowNode);
        set.add(flowNode);
        for (View view2 : this.getAllViews()) {
            FlowBrowseView flowBrowseView;
            if (!(view2 instanceof FlowBrowseView) || !set.contains((flowBrowseView = (FlowBrowseView)view2).getNode())) continue;
            return true;
        }
        return false;
    }

    public void closeTabs(FlowNode flowNode) {
        Set<FlowNode> set = FlowUtil.getAllDescendants(flowNode);
        set.add(flowNode);
        for (View view2 : this.getAllViews()) {
            FlowBrowseView flowBrowseView;
            if (!(view2 instanceof FlowBrowseView) || !set.contains((flowBrowseView = (FlowBrowseView)view2).getNode()) || this.usePrimaryFlowTab() && flowBrowseView.isPrimary() && flowBrowseView.loadViableParentNode()) continue;
            flowBrowseView.closeTab();
        }
    }

    public Set<FileEditView> getViews(FileEdit fileEdit) {
        HashSet<FileEditView> hashSet = new HashSet<FileEditView>();
        if (fileEdit == null) {
            return hashSet;
        }
        for (View view2 : this.getAllViews()) {
            FileEdit fileEdit2;
            if (!(view2 instanceof FileEditView) || (fileEdit2 = ((FileEditView)view2).getFileEdit()) == null || !fileEdit2.equals(fileEdit)) continue;
            hashSet.add((FileEditView)view2);
        }
        return hashSet;
    }

    @Override
    public void rflowWillShutdown() {
        MultiSplitLayout.Split split = (MultiSplitLayout.Split)this.getMultiSplitLayout().getModel();
        MultiSplitLayout.Split split2 = (MultiSplitLayout.Split)split.getChildren().get(0);
        double d = (double)split2.getBounds().width / (double)split.getBounds().width;
        Rflow.settings().putValue(Settings.SPLIT_MAIN, d);
        MultiSplitLayout.Node node = (MultiSplitLayout.Node)split2.getChildren().get(0);
        double d2 = (double)node.getBounds().height / (double)split2.getBounds().height;
        Rflow.settings().putValue(Settings.SPLIT_CONTROL, d2);
    }

    @Override
    public void rflowProjectDidStart() {
    }

    @Override
    public void rflowProjectWillEnd() {
        List<View> list = this.getAllViews();
        for (View view2 : list) {
            if (view2 == this.rHelpView || !view2.isClosable()) continue;
            view2.closeTab();
        }
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        final FileEdit fileEdit = fileEditEvent.getResource();
        if (fileEditEvent.isDirtyChanged()) {
            Set<FileEditView> set;
            if (fileEdit.autoOpenView() && fileEdit.isDirty() && (set = this.getViews(fileEdit)).isEmpty()) {
                UIUtility.invokeLater(() -> {
                    final View view2 = Rflow.actions().openFileEditView(fileEdit.getFile().toPath(), null, false, -1, ViewPosition.MAIN);
                    if (view2 != null && !view2.isShowing()) {
                        view2.setTabDisabled(true);
                        final FileEditEventHandler fileEditEventHandler = new FileEditEventHandler(){

                            @Override
                            public void fileEditStateChanged(FileEditEvent fileEditEvent) {
                                FileEdit fileEdit = fileEditEvent.getResource();
                                if (fileEditEvent.isDirtyChanged() && !fileEdit.isDirty() && view2.isTabDisabled()) {
                                    view2.closeTab();
                                    fileEdit.removeFileEditEventHandler(this);
                                }
                            }
                        };
                        view2.addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentShown(ComponentEvent componentEvent) {
                                view2.setTabDisabled(false);
                                fileEdit.removeFileEditEventHandler(fileEditEventHandler);
                            }
                        });
                        fileEdit.addFileEditEventHandler(fileEditEventHandler);
                    }
                });
            }
        } else if (fileEditEvent.isUnload()) {
            if (this.activeFileEdit == fileEdit) {
                this.activeFileEdit = null;
                this.activeFileEditView = null;
                EventManager.getInstance().dispatchEvent(new ActiveViewEvent(this.activeView, this.activeFileEdit, true, null));
            }
            SwingUtilities.invokeLater(() -> {
                for (FileEditView fileEditView : this.getViews(fileEdit)) {
                    fileEditView.closeTab(true);
                }
            });
        }
    }

    public void projectWillEnd() {
        this.projectSessionChanged();
    }

    public void projectSessionChanged() {
        FileEditManager.getInstance().setProjectSession(this.getProjectSession());
    }

    private ProjectSession getProjectSession() {
        ArrayList<SessionEntry> arrayList = new ArrayList<SessionEntry>();
        for (ViewPosition viewPosition : ViewPosition.values()) {
            for (View view2 : this.getTabbedPane(viewPosition).getViews()) {
                SessionEntry sessionEntry;
                if (!(view2 instanceof SessionEntrySupplier) || (sessionEntry = ((SessionEntrySupplier)((Object)view2)).getSessionEntry(false)) == null) continue;
                arrayList.add(sessionEntry);
            }
        }
        return new ProjectSession(arrayList);
    }

    public void loadProjectSession(ProjectSession projectSession, Boolean bl) {
        List<SessionEntry> list = projectSession.getEntries();
        int n = -1;
        HashSet<File> hashSet = new HashSet<File>();
        File[] fileArray = list.iterator();
        while (fileArray.hasNext()) {
            File[] fileArray2 = fileArray.next();
            try {
                int n2 = this.openSessionEntry((SessionEntry)fileArray2, bl, hashSet) ? 1 : 0;
                if (n2 == 0 || !fileArray2.isSelected() || fileArray2.getPosition() != ViewPosition.MAIN) continue;
                n = this.getTabbedPane(POS_MAIN).getTabCount() - 1;
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Failed to open session entry.", throwable);
            }
        }
        if (n >= 0) {
            this.getTabbedPane(POS_MAIN).setSelectedIndex(n);
        }
        for (File file : fileArray = FlowModel.searchAndCleanUpNewFlowBackupFiles(Rflow.project())) {
            if (hashSet.contains(file)) continue;
            try {
                Rflow.getInstance().restoreFromBackup(FlowModel.createEmptyFlowModel(), file, !FlowModel.isStateSaveFile(file));
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.SEVERE, "Failed to restore from backup.", throwable);
            }
        }
        if (Rflow.project().isNewProject() && list.isEmpty()) {
            Rflow.getInstance().loadEmptyFlow(false);
        }
    }

    public boolean openSessionEntry(SessionEntry sessionEntry, Boolean bl) {
        return this.openSessionEntry(sessionEntry, bl, null);
    }

    private boolean openSessionEntry(SessionEntry sessionEntry, Boolean bl, Set<File> set) {
        FileViewerSessionEntry fileViewerSessionEntry;
        File file;
        if (sessionEntry instanceof FlowSessionEntry) {
            return this.openFlowSessionEntry((FlowSessionEntry)sessionEntry, bl, set);
        }
        if (sessionEntry instanceof FileSessionEntry) {
            FileSessionEntry fileSessionEntry = (FileSessionEntry)sessionEntry;
            if (fileSessionEntry.isEdit()) {
                Rflow.actions().openFileEditView(Paths.get(fileSessionEntry.getFile(Rflow.project()), new String[0]), fileSessionEntry, true, -1, sessionEntry.getPosition());
                return true;
            }
        } else if (sessionEntry instanceof NewNodeSessionEntry) {
            NewNodeSessionEntry newNodeSessionEntry = (NewNodeSessionEntry)sessionEntry;
            Operation operation = newNodeSessionEntry.getOperation();
            if (operation != null) {
                OpTabPagesView opTabPagesView = new OpTabPagesView(operation, null);
                Rflow.mainView().openViewAt(opTabPagesView, ViewOpenType.OPEN_NEW, true, sessionEntry.getPosition());
                return true;
            }
        } else if (sessionEntry instanceof RObjectViewerSessionEntry) {
            RObjectViewerSessionEntry rObjectViewerSessionEntry = (RObjectViewerSessionEntry)sessionEntry;
            RObject rObject = rObjectViewerSessionEntry.getRObject();
            if (rObject != null) {
                RObjectViewer rObjectViewer = new RObjectViewer(R.getInterface(), rObject);
                Rflow.mainView().openViewAt(rObjectViewer, ViewOpenType.OPEN_NEW, true, sessionEntry.getPosition());
                return true;
            }
        } else if (sessionEntry instanceof FileViewerSessionEntry && (file = new File((fileViewerSessionEntry = (FileViewerSessionEntry)sessionEntry).getFile(Rflow.project()))).exists()) {
            FileViewer fileViewer = new FileViewer();
            fileViewer.setFile(file);
            Rflow.mainView().openViewAt(fileViewer, ViewOpenType.OPEN_NEW, true, sessionEntry.getPosition());
            return true;
        }
        return false;
    }

    private boolean openFlowSessionEntry(FlowSessionEntry flowSessionEntry, Boolean bl, Set<File> set) {
        if (flowSessionEntry.isNewFlow()) {
            Optional<FlowModel> optional;
            if (bl != null && !bl.booleanValue()) {
                return false;
            }
            File file = new File(Rflow.project().getTempDir(), flowSessionEntry.getNewFlow());
            File file2 = FlowModel.getRecoveryFile(file);
            if (set != null) {
                set.add(file2);
            }
            if (!(optional = FileEditManager.getInstance().getFlowModels().stream().filter(flowModel -> file2.equals(flowModel.getOriginalFile()) || flowModel.getFlowDataDir().getName().equals(flowSessionEntry.getNewFlow())).findFirst()).isPresent()) {
                if (file2.exists()) {
                    Rflow.getInstance().restoreFromBackup(FlowModel.createEmptyFlowModel(), file2, bl == null && !FlowModel.isStateSaveFile(file2));
                } else {
                    Rflow.getInstance().loadEmptyFlow(true);
                }
            } else if (flowSessionEntry.isNode()) {
                optional.get().getFlowNode(flowSessionEntry.getNode()).ifPresent(flowNode -> this.openViewer((FlowNode)flowNode, ViewOpenType.OPEN_NEW));
            }
            return true;
        }
        File file = new File(flowSessionEntry.getFile(Rflow.project()));
        if (!file.exists()) {
            return false;
        }
        try {
            Optional<FlowModel> optional = FileEditManager.getInstance().getFlowModels().stream().filter(flowModel -> file.equals(flowModel.getOriginalFile()) || file.equals(flowModel.getFile())).findFirst();
            if (!optional.isPresent()) {
                Optional<FlowNode> optional2;
                FlowModel flowModel2 = Rflow.actions().openFlowFile(file, file, false, null, bl);
                if (flowSessionEntry.isNode() && (optional2 = flowModel2.getFlowNode(flowSessionEntry.getNode())).isPresent()) {
                    List<View> list = this.getAllViews();
                    for (View view2 : list) {
                        FlowBrowseView flowBrowseView;
                        if (!(view2 instanceof FlowBrowseView) || (flowBrowseView = (FlowBrowseView)view2).getFlowModel().orElse(null) != flowModel2) continue;
                        flowBrowseView.load(optional2.get());
                        flowBrowseView.clearHistory();
                        break;
                    }
                }
                return true;
            }
            if (optional.isPresent()) {
                FlowModel flowModel3 = optional.get();
                Optional<FlowNode> optional3 = flowSessionEntry.isNode() ? flowModel3.getFlowNode(flowSessionEntry.getNode()) : Optional.of(flowModel3.getRootNode());
                if (optional3.isPresent()) {
                    if (flowSessionEntry.isPrimary()) {
                        flowModel3.setPrimaryView(null);
                    }
                    View view3 = this.openViewer(optional3.get(), ViewOpenType.OPEN_NEW);
                    if (flowSessionEntry.isPrimary()) {
                        flowModel3.setPrimaryView(view3);
                    }
                }
            }
            return true;
        }
        catch (ReadException | IOException exception) {
            if (exception.getCause() instanceof CancelledSaxException) {
                return false;
            }
            LOGGER.log(Level.WARNING, "Failed to load flow file", exception);
            return false;
        }
    }

    private void refreshViewShowing() {
        List list = (List)((Object)Rflow.settings().getValue(Settings.INVISIBLE_TABS));
        List<View> list2 = this.getAllViews();
        for (Map.Entry<String, View> entry : this.keyToViewClassMap.entrySet()) {
            boolean bl;
            boolean bl2 = !list.contains(entry.getKey());
            if (bl2 == (bl = list2.contains(entry.getValue()))) continue;
            if (bl2) {
                this.getTabbedPane(POS_CONTROL_UPPER).openView(entry.getValue(), ViewOpenType.OPEN_NEW, false);
                continue;
            }
            entry.getValue().closeTab(true);
        }
    }

    private void refreshDevelViewShowing() {
        for (DevelEntry develEntry : this.develEntries) {
            if (Rflow.develSettings().getValue(develEntry.getKey()).booleanValue()) {
                if (develEntry.getView().isDisplayable()) continue;
                this.getTabbedPane(develEntry.getPosition()).openView(develEntry.getView(), ViewOpenType.OPEN_NEW, false);
                continue;
            }
            if (!develEntry.getView().isDisplayable()) continue;
            develEntry.getView().closeTab(true);
        }
    }

    @Override
    public void handleChanged(com.ef_prime.rflow.ui.common.event.ChangeEvent changeEvent) {
        this.refreshDevelViewShowing();
    }

    @Override
    public void onRSessionEvent(RSessionManager.RSessionEvent rSessionEvent) {
        switch (rSessionEvent.getType()) {
            case 0: {
                SwingUtilities.invokeLater(() -> this.openBrowser(null, true, false));
                break;
            }
            case 2: 
            case 3: {
                if (this.rHelpView == null) break;
                SwingUtilities.invokeLater(() -> {
                    if (this.rHelpView != null) {
                        this.rHelpView.closeTab();
                    }
                    this.rHelpView = null;
                });
                break;
            }
            case 5: {
                SwingUtilities.invokeLater(() -> Rflow.actions().showSettingRWorkingDirFailedMessage(true));
            }
        }
    }

    @Override
    public void nodeWillBeRemoved(FlowGraphEvent flowGraphEvent) {
        this.closeTabs(flowGraphEvent.getNode());
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(WindowSizeSetEvent.class)) {
            double d = Rflow.settings().getValue(Settings.SPLIT_MAIN);
            double d2 = Rflow.settings().getValue(Settings.SPLIT_CONTROL);
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)this.getMultiSplitLayout().getModel();
            SwingXUtility.setSplit(split, d, true);
            MultiSplitLayout.Split split2 = (MultiSplitLayout.Split)SwingXUtility.getFirstChild((MultiSplitLayout.Node)split);
            SwingXUtility.setSplit(split2, d2, false);
            this.getMultiSplitLayout().setLayoutByWeight(false);
            this.revalidate();
            this.repaint();
        }
    }

    public class MainViewTabActions
    extends Actions {
        public static final String FILE = "FILE";
        public static final String OBJECT = "OBJECT";

        public MainViewTabActions() {
            this.put(FILE, new SelectFile());
            this.put(OBJECT, new SelectObject());
            this.putActivePaneAction("ViewTabbedPane.CLOSE", Messages.getString("Action.close_tab"), KeyStroke.getKeyStroke(87, UIUtility.MENU_KEY_MASK));
            this.putActivePaneAction("ViewTabbedPane.PREVIOUS_TAB", Messages.getString("Action.previous_tab"), KeyStroke.getKeyStroke(37, PlatformUtility.getAltMask()));
            this.putActivePaneAction("ViewTabbedPane.NEXT_TAB", Messages.getString("Action.next_tab"), KeyStroke.getKeyStroke(39, PlatformUtility.getAltMask()));
            this.putActivePaneAction("OPEN_GD", Messages.getString("Action.new_graphics"), null);
        }

        private void putActivePaneAction(Object object, String string, KeyStroke keyStroke) {
            ActivePaneAction activePaneAction = new ActivePaneAction(object);
            activePaneAction.putValue("Name", string);
            if (keyStroke != null) {
                activePaneAction.putValue("AcceleratorKey", keyStroke);
            }
            this.put(object, activePaneAction);
        }

        private void selectView(Class<? extends View> clazz) {
            List<View> list = MainView.this.getAllViews();
            for (View view2 : list) {
                if (!clazz.equals(view2.getClass())) continue;
                view2.toFront();
            }
        }

        private class SelectFile
        extends LoggableAction {
            public SelectFile() {
                this.putValue("Name", Messages.getString("Explorer.file"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(49, PlatformUtility.getAltMask()));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                MainViewTabActions.this.selectView(FileExplorer.class);
            }
        }

        private class SelectObject
        extends LoggableAction {
            public SelectObject() {
                this.putValue("Name", Messages.getString("Explorer.objects"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(50, PlatformUtility.getAltMask()));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                MainViewTabActions.this.selectView(RObjectExplorer.class);
            }
        }

        private class ActivePaneAction
        extends AbstractAction {
            private Object key;

            public ActivePaneAction(Object object) {
                this.key = object;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewTabbedPane viewTabbedPane = MainView.this.getActiveViewTabbedPane();
                if (viewTabbedPane != null) {
                    viewTabbedPane.getActions().doAction(this.key);
                }
            }
        }
    }

    private static class DevelEntry {
        private View view;
        private BoolKey key;
        private String position;

        public DevelEntry(View view2, BoolKey boolKey, String string) {
            this.view = view2;
            this.key = boolKey;
            this.position = string;
        }

        public View getView() {
            return this.view;
        }

        public BoolKey getKey() {
            return this.key;
        }

        public String getPosition() {
            return this.position;
        }
    }

    private class SettingPropertyChangeListener
    implements ValueChangeEventHandler {
        private SettingPropertyChangeListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.INVISIBLE_TABS.equals(valueChangeEvent.getKey())) {
                MainView.this.refreshViewShowing();
            }
        }
    }
}

