/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.RCodingScrollPane;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaEx;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingStatusBar;
import com.ef_prime.rflow.ui.common.component.LabelArea;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.view.DiffView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;

public class NodeUpdateView
extends LazyLoadView {
    private FlowNode node;
    private ViewTabbedPane tabPane;
    private List<View> views = new ArrayList<View>(4);

    public NodeUpdateView(FlowNode flowNode) {
        this.node = flowNode;
        this.views.add(new NodeUpdateDiffView());
        this.views.add(new RScriptView());
    }

    public void addView(View view2) {
        if (this.tabPane != null) {
            this.tabPane.openView(view2);
        }
        this.views.add(view2);
    }

    public View getScriptView() {
        return this.views.get(1);
    }

    @Override
    protected void loadContent() {
        this.tabPane = new ViewTabbedPane(false);
        for (View view2 : this.views) {
            this.tabPane.openView(view2);
        }
        this.add(this.tabPane);
        this.refreshWarning();
    }

    private void refreshWarning() {
        if (this.node.getModel().getNodeMode() == NodeModel.NodeMode.UPDATE) {
            this.tabPane.setValueError(0, new BasicValueError(3, Messages.getString("Message.node_update"), null));
        } else {
            this.tabPane.setValueError(0, null);
        }
    }

    private class NodeUpdateDiffView
    extends LazyLoadView
    implements ActionListener,
    ItemListener {
        public NodeUpdateDiffView() {
            this.setTitle(Messages.getString("Message.node_update"));
            this.setIcon(Icons.getIcon("16/update.png"));
            this.setIconOnly(true);
        }

        @Override
        protected void loadContent() {
            DiffView diffView = new DiffView();
            NodeModel nodeModel = NodeUpdateView.this.node.getModel();
            diffView.load(Messages.getString("View.NodeUpdate.current_script"), nodeModel.getSavedCommand(), Messages.getString("View.NodeUpdate.new_script"), nodeModel.getCommandImpl(false, null));
            this.add((Component)diffView, "Center");
            JButton jButton = new JButton(Messages.getString("View.NodeUpdate.update_node"));
            jButton.addActionListener(this);
            JCheckBox jCheckBox = new JCheckBox(Messages.getString("View.NodeUpdate.hide_warning"), nodeModel.getNodeMode() == NodeModel.NodeMode.PRESERVED);
            jCheckBox.addItemListener(this);
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("10 0 10 0").fill(), new AC().grow()));
            jPanel.add((Component)new LabelArea(Messages.getString("Message.old_node_warning")), new CC().growX().wrap());
            jPanel.add((Component)jButton, new CC().wrap());
            jPanel.add(jCheckBox);
            this.add((Component)jPanel, "North");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NodeUpdateView.this.node.getModel().setNodeMode(NodeModel.NodeMode.NORMAL);
            FlowNode.fireNodeModelChanged(NodeUpdateView.this.node);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                NodeUpdateView.this.node.getModel().setNodeMode(NodeModel.NodeMode.PRESERVED);
            } else {
                NodeUpdateView.this.node.getModel().setNodeMode(NodeModel.NodeMode.UPDATE);
            }
            NodeUpdateView.this.refreshWarning();
            FlowNode.fireNodeModelChanged(NodeUpdateView.this.node);
        }
    }

    private class RScriptView
    extends LazyLoadView {
        public RScriptView() {
            this.setIcon(Icons.getIcon("16/script.png"));
            this.setIconOnly(true);
            this.setTitle(Messages.getString("Widget.R.script"));
        }

        @Override
        protected void loadContent() {
            RCodingTextAreaEx rCodingTextAreaEx = new RCodingTextAreaEx(NodeUpdateView.this.node.getModel().getSavedCommand());
            rCodingTextAreaEx.setEditable(false);
            rCodingTextAreaEx.setCodeFoldingEnabled(true);
            rCodingTextAreaEx.setUneditableBackgroundColor();
            RCodingScrollPane rCodingScrollPane = new RCodingScrollPane(rCodingTextAreaEx, null);
            ErrorStrip errorStrip = RScriptUtility.createErrorStrip(rCodingTextAreaEx);
            CodingStatusBar codingStatusBar = new CodingStatusBar(rCodingTextAreaEx);
            CodingSearchBar codingSearchBar = new CodingSearchBar(rCodingTextAreaEx);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)((Object)rCodingScrollPane), "Center");
            jPanel.add((Component)codingSearchBar, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "Center");
            jPanel2.add((Component)errorStrip, "East");
            jPanel2.add((Component)codingStatusBar, "South");
            this.add((Component)jPanel2, "Center");
        }
    }
}

